/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.document;

import net.jxta.document.Advertisement;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;

public abstract class ExtendableAdvertisement
extends Advertisement {
    private transient boolean formatted;

    protected ExtendableAdvertisement() {
        this(false);
    }

    protected ExtendableAdvertisement(boolean formatted) {
        this.formatted = formatted;
    }

    public abstract String getBaseAdvType();

    protected boolean handleElement(Element elem) {
        return false;
    }

    protected boolean handleAttribute(Attribute attrib) {
        if ("xmlns:jxta".equals(attrib.getName())) {
            return true;
        }
        if ("xml:space".equals(attrib.getName())) {
            return true;
        }
        return "type".equals(attrib.getName());
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument adv = StructuredDocumentFactory.newStructuredDocument(encodeAs, this.getBaseAdvType());
        if (!(adv instanceof Attributable)) {
            throw new IllegalArgumentException("Advertisements require document type with attribute support.");
        }
        if (adv instanceof XMLDocument) {
            XMLDocument xmlAdv = (XMLDocument)adv;
            xmlAdv.addAttribute("xmlns:jxta", "http://jxta.org");
            if (!this.formatted) {
                xmlAdv.addAttribute("xml:space", "preserve");
            }
        }
        if (!this.getBaseAdvType().equals(this.getAdvType())) {
            ((Attributable)((Object)adv)).addAttribute("type", this.getAdvType());
        }
        return adv;
    }
}

