/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.document;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;

public class FileDocument
implements Document {
    private static final int BUFFER_SIZE = 4096;
    private final File file;
    private final MimeMediaType type;

    public FileDocument(File file) {
        this(file, StructuredDocumentFactory.getMimeTypeForFileExtension(FileDocument.getFileExtension(file)));
    }

    public FileDocument(File file, MimeMediaType type) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File cannot be a directory");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File must exist");
        }
        this.file = file;
        this.type = type.intern();
    }

    public String getFileExtension() {
        return FileDocument.getFileExtension(this.file);
    }

    private static String getFileExtension(File file) {
        String fileName = file.getName();
        int idx = fileName.lastIndexOf(46);
        if (idx < 0 || idx == fileName.length()) {
            return "";
        }
        return fileName.substring(idx + 1);
    }

    public MimeMediaType getMimeType() {
        return this.type;
    }

    public InputStream getStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public void sendToStream(OutputStream sink) throws IOException {
        int c;
        InputStream source = this.getStream();
        byte[] buf = new byte[4096];
        while (-1 != (c = source.read(buf))) {
            sink.write(buf, 0, c);
        }
    }
}

