/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.MessageElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputStreamMessageElement
extends MessageElement {
    protected final List<byte[]> databytes;
    protected final long length;
    protected transient int cachedHashCode = 0;

    public InputStreamMessageElement(String name, MimeMediaType type, InputStream in, MessageElement sig) throws IOException {
        this(name, type, in, Long.MAX_VALUE, sig);
    }

    public InputStreamMessageElement(String name, MimeMediaType type, InputStream in, long len, MessageElement sig) throws IOException {
        super(name, type, sig);
        if (len < 0L) {
            throw new IllegalArgumentException("len must be >= 0");
        }
        this.databytes = this.CopyToDataBytes(in, len);
        long buffersSum = 0L;
        for (byte[] aBuffer : this.databytes) {
            buffersSum += (long)aBuffer.length;
        }
        this.length = buffersSum;
        if (len != Long.MAX_VALUE && len != this.length) {
            throw new IllegalArgumentException("Stream was shorter than promised length.");
        }
    }

    @Override
    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof MessageElement) {
            if (!super.equals(target)) {
                return false;
            }
            if (target instanceof InputStreamMessageElement) {
                MessageElement likeMe = (MessageElement)target;
                try {
                    int its;
                    int mine;
                    InputStream myStream = this.getStream();
                    InputStream itsStream = likeMe.getStream();
                    do {
                        if ((mine = myStream.read()) == (its = itsStream.read())) continue;
                        return false;
                    } while (-1 != mine && -1 != its);
                    return -1 == mine && -1 == its;
                }
                catch (IOException fatal) {
                    throw new IllegalStateException("MessageElements could not be compared." + fatal);
                }
            }
        }
        return false;
    }

    @Override
    public synchronized int hashCode() {
        if (0 == this.cachedHashCode) {
            CRC32 crc = new CRC32();
            for (byte[] aBuffer : this.databytes) {
                crc.update(aBuffer, 0, aBuffer.length);
            }
            int result = super.hashCode() + (int)crc.getValue() * 6037;
            this.cachedHashCode = 0 != result ? result : 1;
        }
        return this.cachedHashCode;
    }

    @Override
    public long getByteLength() {
        return this.length;
    }

    @Override
    public InputStream getStream() throws IOException {
        ArrayList<ByteArrayInputStream> buffers = new ArrayList<ByteArrayInputStream>();
        for (byte[] aBuffer : this.databytes) {
            buffers.add(new ByteArrayInputStream(aBuffer));
        }
        return new SequenceInputStream(Collections.enumeration(buffers));
    }

    @Override
    public void sendToStream(OutputStream sendTo) throws IOException {
        for (byte[] aBuffer : this.databytes) {
            sendTo.write(aBuffer);
        }
    }

    protected List<byte[]> CopyToDataBytes(InputStream in, long limit) throws IOException {
        long INITIAL_INTERMEDIATE_BUFFERSIZE = 6L;
        long MAXIMUM_INTERMEDIATE_BUFFERSIZE = 18L;
        ArrayList<byte[]> buffs = new ArrayList<byte[]>();
        boolean atEOF = false;
        long read = 0L;
        long currentIntermediateBufferSize = 6L;
        do {
            int readLength;
            long readRequest = limit - read;
            if (Long.MAX_VALUE == limit) {
                readRequest = Math.min(readRequest, 1L << (int)currentIntermediateBufferSize);
            }
            readRequest = Math.min(readRequest, Integer.MAX_VALUE);
            byte[] nextBuffer = new byte[(int)readRequest];
            int offsetInThisBuffer = 0;
            do {
                if ((readLength = in.read(nextBuffer, offsetInThisBuffer, nextBuffer.length - offsetInThisBuffer)) != -1) continue;
                atEOF = true;
                break;
            } while ((offsetInThisBuffer += readLength) < nextBuffer.length);
            if (atEOF) {
                byte[] anotherBuffer = new byte[offsetInThisBuffer];
                System.arraycopy(nextBuffer, 0, anotherBuffer, 0, offsetInThisBuffer);
                nextBuffer = anotherBuffer;
            }
            read += (long)nextBuffer.length;
            buffs.add(nextBuffer);
            if (currentIntermediateBufferSize >= 18L) continue;
            ++currentIntermediateBufferSize;
        } while (!atEOF && read < limit);
        if (atEOF) {
            in.close();
            in = null;
        }
        return buffs;
    }
}

