/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.WireFormatMessage;
import net.jxta.endpoint.WireFormatMessageFactory;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;
import net.jxta.logging.Logging;
import net.jxta.util.AbstractSimpleSelectable;
import net.jxta.util.SimpleSelectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
extends AbstractSimpleSelectable
implements Serializable {
    private static final transient Logger LOG = Logger.getLogger(Message.class.getName());
    private static final long serialVersionUID = 3418026921074097757L;
    protected static final boolean LOG_MODIFICATIONS = false;
    protected static final boolean GLOBAL_TRACKING_ELEMENT = Boolean.getBoolean(Message.class.getName() + ".globalTracking");
    private static transient AtomicInteger messagenumber = new AtomicInteger(1);
    protected final String defaultNamespace;
    protected transient Map<String, List<MessageElement>> namespaces = new HashMap<String, List<MessageElement>>();
    protected transient List<element> elements = new ArrayList<element>();
    protected transient Map<Object, Object> properties = Collections.synchronizedMap(new HashMap());
    protected transient List<Integer> lineage = new ArrayList<Integer>();
    protected volatile transient int modCount = 0;
    protected transient long cachedByteLength = 0L;
    protected transient int cachedByteLengthModCount = -1;
    @Deprecated
    public boolean modifiable = true;
    protected transient List<Throwable> modHistory;

    public Message() {
        this("", false);
    }

    protected Message(String defaultNamespace) {
        this(defaultNamespace, false);
    }

    private Message(String defaultNamespace, boolean clone) {
        this.defaultNamespace = defaultNamespace;
        this.lineage.add(messagenumber.getAndIncrement());
        if (!clone && GLOBAL_TRACKING_ELEMENT) {
            UUID tracking = UUIDFactory.newSeqUUID();
            StringMessageElement trackingElement = new StringMessageElement("Tracking UUID", tracking.toString(), null);
            this.addMessageElement("jxta", trackingElement);
        }
    }

    public Message clone() {
        Message clone = new Message(this.getDefaultNamespace(), true);
        clone.lineage.addAll(this.lineage);
        clone.elements.addAll(this.elements);
        for (String aNamespace : this.namespaces.keySet()) {
            List<MessageElement> namespaceElements = this.namespaces.get(aNamespace);
            ArrayList<MessageElement> newNamespaceElements = new ArrayList<MessageElement>(namespaceElements.size());
            newNamespaceElements.addAll(namespaceElements);
            clone.namespaces.put(aNamespace, newNamespaceElements);
        }
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Created clone " + clone + " of " + this);
        }
        return clone;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof Message) {
            Message likeMe = (Message)target;
            ElementIterator myElements = this.getMessageElements();
            ElementIterator itsElements = likeMe.getMessageElements();
            while (myElements.hasNext()) {
                if (!itsElements.hasNext()) {
                    return false;
                }
                MessageElement mine = myElements.next();
                MessageElement its = itsElements.next();
                if (!myElements.getNamespace().equals(itsElements.getNamespace())) {
                    return false;
                }
                if (mine.equals(its)) continue;
                return false;
            }
            return !itsElements.hasNext();
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        ElementIterator eachElement = this.getMessageElements();
        while (eachElement.hasNext()) {
            MessageElement anElement = (MessageElement)eachElement.next();
            result += anElement.hashCode();
            result *= 6037;
        }
        if (0 == result) {
            result = 1;
        }
        return result;
    }

    public String toString() {
        StringBuilder toString = new StringBuilder(128);
        toString.append(this.getClass().getName());
        toString.append('@');
        toString.append(super.hashCode());
        toString.append('(');
        toString.append(this.modCount);
        toString.append("){");
        Iterator<Integer> allLineage = this.getMessageLineage();
        while (allLineage.hasNext()) {
            toString.append(((Object)allLineage.next()).toString());
            if (!allLineage.hasNext()) continue;
            toString.append(',');
        }
        toString.append('}');
        if (GLOBAL_TRACKING_ELEMENT) {
            toString.append("[");
            ElementIterator eachUUID = this.getMessageElements("jxta", "Tracking UUID");
            while (eachUUID.hasNext()) {
                toString.append("[");
                toString.append(eachUUID.next().toString());
                toString.append("]");
                if (!eachUUID.hasNext()) continue;
                toString.append(',');
            }
            toString.append("]");
        }
        return toString.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        MimeMediaType readType = new MimeMediaType(s.readUTF());
        Message readMessage = WireFormatMessageFactory.fromWire(s, readType, null);
        this.namespaces = readMessage.namespaces;
        this.elements = readMessage.elements;
        if (!this.namespaces.containsKey(this.defaultNamespace)) {
            throw new IOException("Corrupted Object--does not contain required namespace.");
        }
        this.properties = new HashMap<Object, Object>();
        this.lineage = new ArrayList<Integer>();
        this.lineage.add(messagenumber.getAndIncrement());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        MimeMediaType writeType = WireFormatMessageFactory.DEFAULT_WIRE_MIME;
        s.writeUTF(writeType.toString());
        WireFormatMessage serialed = WireFormatMessageFactory.toWire(this, writeType, null);
        serialed.sendToStream(s);
    }

    protected String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void addMessageElement(MessageElement add) {
        this.addMessageElement(null, add);
    }

    public void addMessageElement(String namespace, MessageElement add) {
        this.addMessageElement(namespace, add, null);
    }

    public void addMessageElement(String namespace, MessageElement add, MessageElement signature) {
        if (null == namespace) {
            namespace = this.getDefaultNamespace();
        }
        if (null == add) {
            throw new IllegalArgumentException("Message Element must be non-null");
        }
        this.elements.add(new element(namespace, add, signature));
        List<MessageElement> namespaceElements = this.namespaces.get(namespace);
        if (null == namespaceElements) {
            namespaceElements = new ArrayList<MessageElement>();
            this.namespaces.put(namespace, namespaceElements);
        }
        namespaceElements.add(add);
        this.incMessageModCount();
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Added " + namespace + "::" + add.getElementName() + "/" + add.getClass().getName() + "@" + add.hashCode() + " to " + this);
        }
    }

    public MessageElement replaceMessageElement(MessageElement replacement) {
        return this.replaceMessageElement(null, replacement);
    }

    public MessageElement replaceMessageElement(String namespace, MessageElement replacement) {
        if (null == namespace) {
            namespace = this.getDefaultNamespace();
        }
        if (null == replacement) {
            throw new IllegalArgumentException("Message Element must be non-null");
        }
        MessageElement removed = null;
        ElementIterator allMatching = this.getMessageElements(namespace, replacement.getElementName());
        while (allMatching.hasNext()) {
            MessageElement anElement = (MessageElement)allMatching.next();
            allMatching.remove();
            removed = anElement;
        }
        this.addMessageElement(namespace, replacement);
        return removed;
    }

    public Iterator<String> getMessageNamespaces() {
        return Collections.unmodifiableMap(this.namespaces).keySet().iterator();
    }

    public MessageElement getMessageElement(String name) {
        ListIterator<element> eachElement = this.elements.listIterator();
        while (eachElement.hasNext()) {
            element anElement = (element)eachElement.next();
            if (!name.equals(anElement.element.getElementName())) continue;
            return anElement.element;
        }
        return null;
    }

    public MessageElement getMessageElement(String namespace, String name) {
        List<MessageElement> namespaceElements;
        if (null == namespace) {
            namespace = this.getDefaultNamespace();
        }
        if (null == (namespaceElements = this.namespaces.get(namespace))) {
            return null;
        }
        ListIterator<MessageElement> eachElement = namespaceElements.listIterator();
        while (eachElement.hasNext()) {
            MessageElement anElement = (MessageElement)eachElement.next();
            if (!name.equals(anElement.getElementName())) continue;
            return anElement;
        }
        return null;
    }

    public ElementIterator getMessageElements() {
        ArrayList<element> theMsgElements = new ArrayList<element>(this.elements);
        return new ElementIterator(theMsgElements.listIterator());
    }

    public ElementIterator getMessageElements(String name) {
        ArrayList<element> theMsgElements = new ArrayList<element>(this.elements.size());
        for (element anElement : this.elements) {
            if (!name.equals(anElement.element.getElementName())) continue;
            theMsgElements.add(anElement);
        }
        return new ElementIterator(theMsgElements.listIterator());
    }

    public ElementIterator getMessageElementsOfNamespace(String namespace) {
        ArrayList<element> theMsgElements = new ArrayList<element>(this.elements.size());
        if (null == namespace) {
            namespace = this.getDefaultNamespace();
        }
        for (element anElement : this.elements) {
            if (!namespace.equals(anElement.namespace)) continue;
            theMsgElements.add(anElement);
        }
        return new ElementIterator(theMsgElements.listIterator());
    }

    public ElementIterator getMessageElements(String namespace, String name) {
        ArrayList<element> theMsgElements = new ArrayList<element>(this.elements.size());
        if (null == namespace) {
            namespace = this.getDefaultNamespace();
        }
        for (element anElement : this.elements) {
            if (!namespace.equals(anElement.namespace) || !name.equals(anElement.element.getElementName())) continue;
            theMsgElements.add(anElement);
        }
        return new ElementIterator(theMsgElements.listIterator());
    }

    public ElementIterator getMessageElements(MimeMediaType type) {
        ArrayList<element> theMsgElements = new ArrayList<element>(this.elements.size());
        ListIterator<element> eachElement = this.elements.listIterator();
        while (eachElement.hasNext()) {
            element anElement = eachElement.next();
            if (!type.equals(anElement.element.getMimeType())) continue;
            theMsgElements.add(anElement);
        }
        return new ElementIterator(theMsgElements.listIterator());
    }

    public ElementIterator getMessageElements(String namespace, MimeMediaType type) {
        ArrayList<element> theMsgElements = new ArrayList<element>(this.elements.size());
        if (null == namespace) {
            namespace = this.getDefaultNamespace();
        }
        for (element anElement : this.elements) {
            if (!namespace.equals(anElement.namespace) || !type.equals(anElement.element.getMimeType())) continue;
            theMsgElements.add(anElement);
        }
        return new ElementIterator(theMsgElements.listIterator());
    }

    public boolean removeMessageElement(MessageElement remove) {
        ElementIterator eachElement = this.getMessageElements();
        while (eachElement.hasNext()) {
            MessageElement anElement = (MessageElement)eachElement.next();
            if (remove != anElement) continue;
            eachElement.remove();
            return true;
        }
        return false;
    }

    public boolean removeMessageElement(String namespace, MessageElement remove) {
        ElementIterator eachElement = this.getMessageElementsOfNamespace(namespace);
        while (eachElement.hasNext()) {
            MessageElement anElement = (MessageElement)eachElement.next();
            if (remove != anElement) continue;
            eachElement.remove();
            return true;
        }
        return false;
    }

    public void clear() {
        this.elements.clear();
        this.namespaces.clear();
        this.properties.clear();
        this.lineage.retainAll(Collections.singletonList(this.lineage.get(0)));
        this.incMessageModCount();
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Cleared " + this);
        }
    }

    public synchronized long getByteLength() {
        if (this.modCount != this.cachedByteLengthModCount) {
            this.cachedByteLength = 0L;
            ElementIterator eachElement = this.getMessageElements();
            while (eachElement.hasNext()) {
                MessageElement anElement = (MessageElement)eachElement.next();
                this.cachedByteLength += anElement.getByteLength();
            }
            this.cachedByteLengthModCount = this.modCount;
        }
        return this.cachedByteLength;
    }

    public int getMessageModCount() {
        return this.modCount;
    }

    protected synchronized int incMessageModCount() {
        ++this.modCount;
        if (!this.modifiable) {
            IllegalStateException failure = new IllegalStateException("Unmodifiable message should not have been modified");
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, failure.getMessage(), failure);
            }
            throw failure;
        }
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Modification to " + this);
        }
        return this.modCount;
    }

    public synchronized String getMessageModHistory() {
        return "Modification history tracking is disabled";
    }

    public int getMessageNumber() {
        return this.lineage.get(0);
    }

    public Iterator<Integer> getMessageLineage() {
        return Collections.unmodifiableList(this.lineage).iterator();
    }

    public Object setMessageProperty(Object key, Object value) {
        Object res = this.properties.put(key, value);
        if (res != null || value != null) {
            this.notifyChange();
        }
        return res;
    }

    public Object getMessageProperty(Object key) {
        return this.properties.get(key);
    }

    @Override
    public void itemChanged(SimpleSelectable o) {
    }

    protected static class element {
        final String namespace;
        final MessageElement element;
        final MessageElement signature;

        element(String namespace, MessageElement element2, MessageElement signature) {
            this.namespace = namespace;
            this.element = element2;
            this.signature = signature;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ElementIterator
    implements ListIterator<MessageElement> {
        ListIterator<element> list;
        element current = null;
        transient int origModCount;

        ElementIterator(ListIterator<element> list) {
            this.origModCount = Message.this.getMessageModCount();
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            if (this.origModCount != Message.this.getMessageModCount()) {
                ConcurrentModificationException failure = new ConcurrentModificationException(Message.this + " concurrently modified. Iterator was made at mod " + this.origModCount);
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, Message.this + " concurrently modified. iterator mod=" + this.origModCount + " current mod=" + Message.this.getMessageModCount() + "\n" + Message.this.getMessageModHistory(), failure);
                }
                throw failure;
            }
            return this.list.hasNext();
        }

        @Override
        public MessageElement next() {
            if (this.origModCount != Message.this.getMessageModCount()) {
                ConcurrentModificationException failure = new ConcurrentModificationException(Message.this + " concurrently modified. Iterator was made at mod " + this.origModCount);
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, Message.this + " concurrently modified. iterator mod=" + this.origModCount + " current mod=" + Message.this.getMessageModCount() + "\n" + Message.this.getMessageModHistory(), failure);
                }
                throw failure;
            }
            this.current = this.list.next();
            return this.current.element;
        }

        @Override
        public int nextIndex() {
            return this.list.nextIndex();
        }

        @Override
        public boolean hasPrevious() {
            if (this.origModCount != Message.this.getMessageModCount()) {
                ConcurrentModificationException failure = new ConcurrentModificationException(Message.this + " concurrently modified. Iterator was made at mod " + this.origModCount);
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, Message.this + " concurrently modified. iterator mod=" + this.origModCount + " current mod=" + Message.this.getMessageModCount() + "\n" + Message.this.getMessageModHistory(), failure);
                }
                throw failure;
            }
            return this.list.hasPrevious();
        }

        @Override
        public MessageElement previous() {
            if (this.origModCount != Message.this.getMessageModCount()) {
                ConcurrentModificationException failure = new ConcurrentModificationException(Message.this + " concurrently modified. Iterator was made at mod " + this.origModCount);
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, Message.this + " concurrently modified. iterator mod=" + this.origModCount + " current mod=" + Message.this.getMessageModCount() + "\n" + Message.this.getMessageModHistory(), failure);
                }
                throw failure;
            }
            this.current = this.list.previous();
            return this.current.element;
        }

        @Override
        public int previousIndex() {
            return this.list.previousIndex();
        }

        @Override
        public void add(MessageElement obj) {
            throw new UnsupportedOperationException("add() not supported");
        }

        @Override
        public void remove() {
            if (this.origModCount != Message.this.getMessageModCount()) {
                ConcurrentModificationException failure = new ConcurrentModificationException(Message.this + " concurrently modified. Iterator was made at mod " + this.origModCount);
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, Message.this + " concurrently modified. iterator mod=" + this.origModCount + " current mod=" + Message.this.getMessageModCount() + "\n" + Message.this.getMessageModHistory(), failure);
                }
                throw failure;
            }
            if (null == this.current) {
                throw new IllegalStateException("no current element, call next() or previous()");
            }
            ListIterator<element> elsPosition = Message.this.elements.listIterator();
            ListIterator<MessageElement> nsPosition = Message.this.namespaces.get(this.current.namespace).listIterator();
            int currentPrevious = this.list.previousIndex();
            while (this.list.previousIndex() >= 0) {
                this.list.previous();
            }
            while (this.list.previousIndex() < currentPrevious) {
                element anElement = this.list.next();
                try {
                    MessageElement anNsElement;
                    element anElsElement;
                    while (anElement != (anElsElement = elsPosition.next())) {
                    }
                    if (!this.current.namespace.equals(anElement.namespace)) continue;
                    while (anElement.element != (anNsElement = nsPosition.next())) {
                    }
                }
                catch (NoSuchElementException ranOut) {
                    ConcurrentModificationException failure = new ConcurrentModificationException(Message.this + " concurrently modified. Iterator was made at mod " + this.origModCount);
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, Message.this + " concurrently modified. iterator mod=" + this.origModCount + " current mod=" + Message.this.getMessageModCount() + "\n" + Message.this.getMessageModHistory(), failure);
                    }
                    throw failure;
                }
            }
            elsPosition.remove();
            nsPosition.remove();
            this.list.remove();
            this.origModCount = Message.this.incMessageModCount();
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("Removed " + this.current.namespace + "::" + this.current.element.getElementName() + "/" + this.current.element.getClass().getName() + "@" + this.current.element.hashCode() + " from " + Message.this);
            }
            this.current = null;
        }

        @Override
        public void set(MessageElement obj) {
            if (this.origModCount != Message.this.getMessageModCount()) {
                ConcurrentModificationException failure = new ConcurrentModificationException(Message.this + " concurrently modified. ");
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, Message.this + " concurrently modified. iterator mod=" + this.origModCount + " current mod=" + Message.this.getMessageModCount() + "\n" + Message.this.getMessageModHistory(), failure);
                }
                throw failure;
            }
            if (null == this.current) {
                throw new IllegalStateException("no current element, call next() or previous()");
            }
            ListIterator<element> elsPosition = Message.this.elements.listIterator();
            ListIterator<MessageElement> nsPosition = Message.this.namespaces.get(this.current.namespace).listIterator();
            int currentPrevious = this.list.previousIndex();
            while (this.list.previousIndex() >= 0) {
                this.list.previous();
            }
            while (this.list.previousIndex() < currentPrevious) {
                element anElement = this.list.next();
                try {
                    MessageElement anNsElement;
                    element anElsElement;
                    while (anElement != (anElsElement = elsPosition.next())) {
                    }
                    if (!this.current.namespace.equals(anElement.namespace)) continue;
                    while (anElement.element != (anNsElement = nsPosition.next())) {
                    }
                }
                catch (NoSuchElementException ranOut) {
                    ConcurrentModificationException failure = new ConcurrentModificationException(Message.this + " concurrently modified. Iterator was made at mod " + this.origModCount);
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, Message.this + " concurrently modified. iterator mod=" + this.origModCount + " current mod=" + Message.this.getMessageModCount() + "\n" + Message.this.getMessageModHistory(), failure);
                    }
                    throw failure;
                }
            }
            element newCurrent = new element(this.current.namespace, obj, null);
            elsPosition.set(newCurrent);
            nsPosition.set(obj);
            this.list.set(newCurrent);
            this.origModCount = Message.this.incMessageModCount();
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("Replaced " + this.current.namespace + "::" + this.current.element.getElementName() + "/" + this.current.element.getClass().getName() + "@" + this.current.element.hashCode() + " with " + newCurrent.namespace + "::" + newCurrent.element.getElementName() + "/" + newCurrent.element.getClass().getName() + "@" + newCurrent.element.hashCode() + " in " + Message.this);
            }
            this.current = newCurrent;
        }

        public String getNamespace() {
            if (null == this.current) {
                throw new IllegalStateException("no current element, call next() or previous()");
            }
            return this.current.namespace;
        }

        public MessageElement getSignature() {
            if (null == this.current) {
                throw new IllegalStateException("no current element, call next() or previous()");
            }
            return null != this.current.signature ? this.current.signature : this.current.element.getSignature();
        }
    }
}

