/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.endpointMeter;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.endpointMeter.OutboundMeter;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class OutboundMetric
implements DocumentSerializable {
    private EndpointAddress endpointAddress;
    private int numOutboundQueued;
    private int numOutboundDropped;
    private long timeToDropOutbound;
    private int numOutboundDeQueued;
    private long timeInOutboundQueue;
    private int numOutboundProcessed;
    private long timeToProcessOutbound;
    private int numOutboundFailed;
    private long timeOutboundToFail;

    public OutboundMetric(OutboundMeter outboundMeter) {
        this.endpointAddress = outboundMeter.getEndpointAddress();
    }

    public OutboundMetric(OutboundMetric prototype) {
        this.endpointAddress = prototype.getEndpointAddress();
    }

    public OutboundMetric() {
    }

    public EndpointAddress getEndpointAddress() {
        return this.endpointAddress;
    }

    public int getNumOutboundQueued() {
        return this.numOutboundQueued;
    }

    public int getNumOutboundDropped() {
        return this.numOutboundDropped;
    }

    public long getTimeToDropOutbound() {
        return this.timeToDropOutbound;
    }

    public int getNumOutboundDeQueued() {
        return this.numOutboundDeQueued;
    }

    public long getTimeInOutboundQueue() {
        return this.timeInOutboundQueue;
    }

    public int getNumOutboundProcessed() {
        return this.numOutboundProcessed;
    }

    public long getTimeToProcessOutbound() {
        return this.timeToProcessOutbound;
    }

    public int getNumOutboundFailed() {
        return this.numOutboundFailed;
    }

    public long getTimeOutboundToFail() {
        return this.timeOutboundToFail;
    }

    public long getAverageTimeInOutboundQueue() {
        return this.numOutboundDeQueued == 0 ? 0L : this.timeInOutboundQueue / (long)this.numOutboundDeQueued;
    }

    public long getAverageOutboundDropTime() {
        return this.numOutboundDropped == 0 ? 0L : this.timeToDropOutbound / (long)this.numOutboundDropped;
    }

    public long getAverageOutboundProcessTime() {
        return this.numOutboundProcessed == 0 ? 0L : this.timeToProcessOutbound / (long)this.numOutboundProcessed;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OutboundMetric) {
            OutboundMetric other = (OutboundMetric)obj;
            return this.endpointAddress.equals(other.endpointAddress);
        }
        return false;
    }

    public boolean matches(EndpointAddress otherAddress) {
        return this.getEndpointAddress().equals(otherAddress);
    }

    public int hashCode() {
        return this.endpointAddress.hashCode();
    }

    void outboundMessageQueued(Message message) {
        ++this.numOutboundQueued;
    }

    void outboundMessageDropped(Message message, long time) {
        ++this.numOutboundDropped;
        this.timeToDropOutbound += time;
    }

    void outboundMessageFailed(Message message, long time) {
        ++this.numOutboundFailed;
        this.timeOutboundToFail += time;
    }

    void outboundMessageDeQueued(Message message, long time) {
        ++this.numOutboundDeQueued;
        this.timeInOutboundQueue += time;
    }

    void outboundMessageProcessed(Message message, long time) {
        ++this.numOutboundProcessed;
        this.timeToProcessOutbound += time;
    }

    public void mergeMetrics(OutboundMetric other) {
        this.numOutboundQueued += other.numOutboundQueued;
        this.numOutboundDropped += other.numOutboundDropped;
        this.timeToDropOutbound += other.timeToDropOutbound;
        this.numOutboundDeQueued += other.numOutboundDeQueued;
        this.timeInOutboundQueue += other.timeInOutboundQueue;
        this.numOutboundProcessed += other.numOutboundProcessed;
        this.timeToProcessOutbound += other.timeToProcessOutbound;
        this.numOutboundFailed += other.numOutboundFailed;
        this.timeOutboundToFail += other.timeOutboundToFail;
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        DocumentSerializableUtilities.addString(element2, "endpointAddress", this.endpointAddress.toString());
        if (this.numOutboundQueued != 0) {
            DocumentSerializableUtilities.addInt(element2, "numOutboundQueued", this.numOutboundQueued);
        }
        if (this.numOutboundDropped != 0) {
            DocumentSerializableUtilities.addInt(element2, "numOutboundDropped", this.numOutboundDropped);
        }
        if (this.timeToDropOutbound != 0L) {
            DocumentSerializableUtilities.addLong(element2, "timeToDropOutbound", this.timeToDropOutbound);
        }
        if (this.numOutboundDeQueued != 0) {
            DocumentSerializableUtilities.addInt(element2, "numOutboundDeQueued", this.numOutboundDeQueued);
        }
        if (this.timeInOutboundQueue != 0L) {
            DocumentSerializableUtilities.addLong(element2, "timeInOutboundQueue", this.timeInOutboundQueue);
        }
        if (this.numOutboundProcessed != 0) {
            DocumentSerializableUtilities.addInt(element2, "numOutboundProcessed", this.numOutboundProcessed);
        }
        if (this.timeToProcessOutbound != 0L) {
            DocumentSerializableUtilities.addLong(element2, "timeToProcessOutbound", this.timeToProcessOutbound);
        }
        if (this.numOutboundFailed != 0) {
            DocumentSerializableUtilities.addInt(element2, "numOutboundFailed", this.numOutboundFailed);
        }
        if (this.timeOutboundToFail != 0L) {
            DocumentSerializableUtilities.addLong(element2, "timeOutboundToFail", this.timeOutboundToFail);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("endpointAddress")) {
                String endpointAddressString = DocumentSerializableUtilities.getString(childElement);
                this.endpointAddress = new EndpointAddress(endpointAddressString);
                continue;
            }
            if (tagName.equals("numOutboundQueued")) {
                this.numOutboundQueued = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numOutboundDropped")) {
                this.numOutboundDropped = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("timeToDropOutbound")) {
                this.timeToDropOutbound = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("numOutboundDeQueued")) {
                this.numOutboundDeQueued = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("timeInOutboundQueue")) {
                this.timeInOutboundQueue = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("numOutboundProcessed")) {
                this.numOutboundProcessed = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("timeToProcessOutbound")) {
                this.timeToProcessOutbound = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("numOutboundFailed")) {
                this.numOutboundFailed = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (!tagName.equals("timeOutboundToFail")) continue;
            this.timeOutboundToFail = DocumentSerializableUtilities.getLong(childElement);
        }
    }
}

