/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.msgframing;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagePackageHeader {
    private static final transient Logger LOG = Logger.getLogger(MessagePackageHeader.class.getName());
    private static final String CONTENT_LENGTH = "content-length";
    private static final String CONTENT_TYPE = "content-type";
    private static final int MAX_HEADER_LEN = 1024;
    private final List<Header> headers = new ArrayList<Header>();

    public MessagePackageHeader() {
    }

    public MessagePackageHeader(InputStream in) throws IOException {
        boolean sawEmpty = false;
        boolean sawLength = false;
        boolean sawType = false;
        DataInputStream di = new DataInputStream(in);
        do {
            byte headerNameLength;
            if (0 == (headerNameLength = di.readByte())) {
                sawEmpty = true;
                continue;
            }
            byte[] headerNameBytes = new byte[headerNameLength];
            di.readFully(headerNameBytes);
            String headerNameString = new String(headerNameBytes, "UTF-8");
            if (headerNameString.equalsIgnoreCase(CONTENT_LENGTH)) {
                if (sawLength) {
                    throw new IOException("Duplicate content-length header");
                }
                sawLength = true;
            }
            if (headerNameString.equalsIgnoreCase(CONTENT_TYPE)) {
                if (sawType) {
                    throw new IOException("Duplicate content-type header");
                }
                sawType = true;
            }
            int headerValueLength = di.readUnsignedShort();
            byte[] headerValueBytes = new byte[headerValueLength];
            di.readFully(headerValueBytes);
            this.headers.add(new Header(headerNameString, headerValueBytes));
        } while (!sawEmpty);
        if (!sawLength) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Content Length header was missing");
            }
            throw new IOException("Content Length header was missing");
        }
        if (!sawType) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Content Type header was missing");
            }
            throw new IOException("Content Type header was missing");
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('[');
        ListIterator<Header> eachHeader = this.getHeaders();
        while (eachHeader.hasNext()) {
            Header aHeader = (Header)eachHeader.next();
            result.append(" {");
            result.append(aHeader);
            result.append('}');
            if (!eachHeader.hasNext()) continue;
            result.append(',');
        }
        result.append(']');
        return result.toString();
    }

    private int getHeaderCount(ByteBuffer buffer) {
        int pos = buffer.position();
        int limit = buffer.limit();
        int headerCount = 0;
        boolean sawZero = false;
        while (pos < limit) {
            int len = buffer.get(pos) & 0xFF;
            ++pos;
            if (0 == len) {
                sawZero = true;
                break;
            }
            if ((pos += len) + 2 >= limit) break;
            len = buffer.getShort(pos) & 0xFFFF;
            pos += 2;
            pos += len;
            ++headerCount;
        }
        return sawZero ? headerCount : -1;
    }

    public boolean readHeader(ByteBuffer buffer) throws IOException {
        int count;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine(MessageFormat.format("Parsing Package Header from byte buffer :{0}", buffer.toString()));
        }
        if ((count = this.getHeaderCount(buffer)) < 0) {
            return false;
        }
        for (int i = 1; i <= count; ++i) {
            byte headerNameLength = buffer.get();
            byte[] headerNameBytes = new byte[headerNameLength];
            buffer.get(headerNameBytes);
            String headerNameString = new String(headerNameBytes, "UTF-8");
            int headerValueLength = buffer.getShort() & 0xFFFF;
            byte[] headerValueBytes = new byte[headerValueLength];
            buffer.get(headerValueBytes);
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer(MessageFormat.format("Adding Name {0}: {1}", headerNameString, headerValueBytes));
            }
            this.headers.add(new Header(headerNameString, headerValueBytes));
        }
        buffer.get();
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer(MessageFormat.format("Parsed {0} header elements, buffer stats :{1}", count, buffer.toString()));
        }
        return true;
    }

    public void addHeader(String name, byte[] value) {
        if (name.length() > 255) {
            throw new IllegalArgumentException("name may not exceed 255 bytes in length.");
        }
        if (value.length > 65535) {
            throw new IllegalArgumentException("value may not exceed 65535 bytes in length.");
        }
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Add header :" + name + "(" + name.length() + ") with " + value.length + " bytes of value");
        }
        this.headers.add(new Header(name, value));
    }

    public void addHeader(String name, String value) {
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Add header :" + name + "(" + name.length() + ") with " + value.length() + " chars of value");
        }
        try {
            this.addHeader(name, value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException never) {
            throw new IllegalStateException("UTF-8 encoding support missing!");
        }
    }

    public void replaceHeader(String name, byte[] value) {
        if (name.length() > 255) {
            throw new IllegalArgumentException("name may not exceed 255 bytes in length.");
        }
        if (value.length > 65535) {
            throw new IllegalArgumentException("value may not exceed 65535 bytes in length.");
        }
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Replace header :" + name + "(" + name.length() + ") with " + value.length + " bytes of value");
        }
        Header newHeader = new Header(name, value);
        ListIterator<Header> eachHeader = this.getHeaders();
        boolean replaced = false;
        while (eachHeader.hasNext()) {
            Header aHeader = eachHeader.next();
            if (!aHeader.getName().equalsIgnoreCase(name)) continue;
            eachHeader.set(newHeader);
            replaced = true;
        }
        if (!replaced) {
            this.headers.add(newHeader);
        }
    }

    public void replaceHeader(String name, String value) {
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Replace header :" + name + "(" + name.length() + ") with " + value.length() + " chars of value");
        }
        try {
            this.replaceHeader(name, value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException never) {
            throw new IllegalStateException("UTF-8 encoding support missing!");
        }
    }

    public ListIterator<Header> getHeaders() {
        return this.headers.listIterator();
    }

    public Iterator<Header> getHeader(String name) {
        ArrayList<Header> matchingHeaders = new ArrayList<Header>();
        for (Header aHeader : this.headers) {
            if (!name.equals(aHeader.getName())) continue;
            matchingHeaders.add(aHeader);
        }
        return matchingHeaders.iterator();
    }

    public void sendToStream(OutputStream out) throws IOException {
        ListIterator<Header> eachHeader = this.getHeaders();
        DataOutputStream dos = new DataOutputStream(out);
        while (eachHeader.hasNext()) {
            Header aHeader = (Header)eachHeader.next();
            byte[] nameBytes = aHeader.getName().getBytes("UTF-8");
            byte[] value = aHeader.getValue();
            assert (nameBytes.length <= 255);
            assert (value.length <= 65535);
            dos.write(nameBytes.length);
            dos.write(nameBytes);
            dos.writeShort(value.length);
            dos.write(value);
        }
        dos.write(0);
    }

    public ByteBuffer getByteBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        for (Header header : this.headers) {
            byte[] name;
            try {
                name = header.getName().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException never) {
                throw new Error("Required UTF-8 encoding not available.");
            }
            byte[] value = header.getValue();
            assert (name.length <= 255);
            assert (value.length <= 65535);
            buffer.put((byte)name.length);
            buffer.put(name);
            buffer.putShort((short)value.length);
            buffer.put(value);
        }
        buffer.put((byte)0);
        buffer.flip();
        return buffer;
    }

    public void setContentLengthHeader(long length) {
        byte[] lengthAsBytes = new byte[8];
        for (int eachByte = 0; eachByte < 8; ++eachByte) {
            lengthAsBytes[eachByte] = (byte)(length >> (int)((long)(7 - eachByte) * 8L));
        }
        this.replaceHeader(CONTENT_LENGTH, lengthAsBytes);
    }

    public long getContentLengthHeader() {
        Iterator<Header> it = this.getHeader(CONTENT_LENGTH);
        if (!it.hasNext()) {
            return -1L;
        }
        Header header = it.next();
        byte[] lengthAsBytes = header.getValue();
        long lengthAsLong = 0L;
        for (int eachByte = 0; eachByte < 8; ++eachByte) {
            lengthAsLong |= (long)(lengthAsBytes[eachByte] & 0xFF) << (int)((long)(7 - eachByte) * 8L);
        }
        return lengthAsLong;
    }

    public void setContentTypeHeader(MimeMediaType type) {
        this.replaceHeader(CONTENT_TYPE, type.toString());
    }

    public MimeMediaType getContentTypeHeader() {
        Iterator<Header> it = this.getHeader(CONTENT_TYPE);
        if (!it.hasNext()) {
            return MimeMediaType.AOS;
        }
        Header header = it.next();
        return MimeMediaType.valueOf(header.getValueString());
    }

    public static class Header {
        final String name;
        final byte[] value;

        public Header(String name, byte[] value) {
            this.name = name;
            assert (value.length <= 65535);
            this.value = value;
        }

        public String toString() {
            return MessageFormat.format("{0} := {1}", this.name, this.value);
        }

        public String getName() {
            return this.name;
        }

        public byte[] getValue() {
            return this.value;
        }

        public String getValueString() {
            try {
                return new String(this.value, "UTF-8");
            }
            catch (UnsupportedEncodingException never) {
                throw new Error("UTF-8 encoding support missing!");
            }
        }
    }
}

