/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Messenger;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Destinations {
    private static final transient Logger LOG = Logger.getLogger(Destinations.class.getName());
    private static final transient Timer cleanup = new Timer("Endpoint Destinations GC", true);
    private final Map<EndpointAddress, Wisdom> wisdoms = new HashMap<EndpointAddress, Wisdom>(64);
    private volatile boolean stopped = false;
    private final EndpointService endpoint;
    private final WisdomGCTask wisdomGC;

    private Wisdom getWisdom(EndpointAddress destination) {
        if (destination.getServiceName() != null) {
            destination = new EndpointAddress(destination, null, null);
        }
        return this.wisdoms.get(destination);
    }

    private void addWisdom(EndpointAddress destination, Wisdom wisdom) {
        destination = new EndpointAddress(destination, null, null);
        this.wisdoms.put(destination, wisdom);
    }

    public Destinations(EndpointService endpoint) {
        this.endpoint = endpoint;
        this.wisdomGC = new WisdomGCTask();
        cleanup.schedule((TimerTask)this.wisdomGC, 60000L, 60000L);
    }

    public synchronized void close() {
        this.stopped = true;
        this.wisdoms.clear();
        this.wisdomGC.cancel();
    }

    public synchronized Collection<EndpointAddress> allDestinations() {
        Set<EndpointAddress> allKeys = this.wisdoms.keySet();
        ArrayList<EndpointAddress> res = new ArrayList<EndpointAddress>(allKeys);
        return res;
    }

    public synchronized Messenger getCurrentMessenger(EndpointAddress destination) {
        Wisdom wisdom = this.getWisdom(destination);
        if (wisdom == null) {
            return null;
        }
        return wisdom.getCurrentMessenger();
    }

    public synchronized boolean isNormallyReachable(EndpointAddress destination) {
        Wisdom wisdom = this.getWisdom(destination);
        return wisdom != null && wisdom.isNormallyReachable();
    }

    public synchronized boolean isCurrentlyReachable(EndpointAddress destination) {
        Wisdom wisdom = this.getWisdom(destination);
        return wisdom != null && wisdom.isCurrentlyReachable();
    }

    public synchronized boolean isWelcomeNeeded(EndpointAddress destination) {
        Wisdom wisdom = this.getWisdom(destination);
        return wisdom != null && wisdom.isWelcomeNeeded();
    }

    public synchronized boolean addOutgoingMessenger(EndpointAddress destination, Messenger messenger) {
        Wisdom wisdom = this.getWisdom(destination);
        if (wisdom != null) {
            return wisdom.addOutgoingMessenger(messenger);
        }
        this.addWisdom(destination, new Wisdom(messenger, false));
        return true;
    }

    public synchronized boolean addIncomingMessenger(EndpointAddress destination, Messenger messenger) {
        Wisdom wisdom = this.getWisdom(destination);
        if (wisdom != null) {
            return wisdom.addIncomingMessenger(messenger);
        }
        this.addWisdom(destination, new Wisdom(messenger, true));
        return true;
    }

    public synchronized void noOutgoingMessenger(EndpointAddress destination) {
        Wisdom wisdom = this.getWisdom(destination);
        if (wisdom != null) {
            wisdom.noOutgoingMessenger();
        }
    }

    class WisdomGCTask
    extends TimerTask {
        WisdomGCTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block6: {
                try {
                    Destinations destinations = Destinations.this;
                    synchronized (destinations) {
                        Iterator eachWisdom = Destinations.this.wisdoms.values().iterator();
                        while (eachWisdom.hasNext()) {
                            Wisdom w = (Wisdom)eachWisdom.next();
                            if (!w.isExpired()) continue;
                            eachWisdom.remove();
                        }
                    }
                }
                catch (Throwable all) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block6;
                    LOG.log(Level.SEVERE, "Uncaught Throwable in TimerTask :" + Thread.currentThread().getName(), all);
                }
            }
        }
    }

    final class Wisdom {
        static final long EXPIRATION = 600000L;
        private Reference<Messenger> outgoingMessenger;
        private Messenger incomingMessenger;
        private EndpointAddress xportDest;
        private long expiresAt = 0L;
        private boolean welcomeNeeded = true;

        Wisdom(Messenger messenger, boolean incoming) {
            if (incoming) {
                this.addIncomingMessenger(messenger);
            } else {
                this.addOutgoingMessenger(messenger);
            }
        }

        synchronized boolean isWelcomeNeeded() {
            boolean res = this.welcomeNeeded;
            this.welcomeNeeded = false;
            return res;
        }

        boolean addIncomingMessenger(Messenger m) {
            boolean currentReachable;
            Messenger currentIncoming = this.getIncoming();
            if (currentIncoming == null) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Accepted new incoming messenger for " + m.getDestinationAddress());
                }
                this.incomingMessenger = m;
                return true;
            }
            String originAddr = m.getDestinationAddress().getProtocolAddress();
            int index = originAddr.lastIndexOf(58);
            int srcPort = index != -1 ? Integer.parseInt(originAddr.substring(index + 1)) : 0;
            boolean reachable = srcPort != 0;
            originAddr = currentIncoming.getDestinationAddress().getProtocolAddress();
            index = originAddr.lastIndexOf(58);
            srcPort = index != -1 ? Integer.parseInt(originAddr.substring(index + 1)) : 0;
            boolean bl = currentReachable = srcPort != 0;
            if (currentReachable && !reachable) {
                return false;
            }
            this.incomingMessenger = m;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Accepted new incoming messenger for " + m.getDestinationAddress());
            }
            return true;
        }

        boolean addOutgoingMessenger(Messenger m) {
            if (this.getOutgoing() != null) {
                return false;
            }
            this.outgoingMessenger = new SoftReference<Messenger>(m);
            this.xportDest = m.getDestinationAddress();
            this.expiresAt = TimeUtils.toAbsoluteTimeMillis(600000L);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Accepted new outgoing messenger for " + this.xportDest);
            }
            return true;
        }

        void noOutgoingMessenger() {
            this.outgoingMessenger = null;
            this.xportDest = null;
            this.expiresAt = 0L;
        }

        private Messenger getIncoming() {
            if (this.incomingMessenger != null) {
                if ((this.incomingMessenger.getState() & 0x3FF) != 0) {
                    return this.incomingMessenger;
                }
                this.incomingMessenger = null;
            }
            return null;
        }

        private Messenger getOutgoing() {
            if (this.outgoingMessenger == null) {
                return null;
            }
            Messenger messenger = this.outgoingMessenger.get();
            if (messenger == null || (messenger.getState() & 0x3FF) == 0) {
                messenger = Destinations.this.endpoint.getMessengerImmediate(this.xportDest, null);
                if (messenger == null) {
                    this.outgoingMessenger = null;
                    this.xportDest = null;
                    this.expiresAt = 0L;
                    return null;
                }
                this.outgoingMessenger = new SoftReference<Messenger>(messenger);
            }
            if ((messenger.getState() & 0x3CC) == 0) {
                this.outgoingMessenger = null;
                this.xportDest = null;
                return null;
            }
            this.expiresAt = TimeUtils.toAbsoluteTimeMillis(600000L);
            return messenger;
        }

        Messenger getCurrentMessenger() {
            Messenger res = this.getIncoming();
            if (res != null) {
                return res;
            }
            return this.getOutgoing();
        }

        boolean isNormallyReachable() {
            return this.getOutgoing() != null || TimeUtils.toRelativeTimeMillis(this.expiresAt) >= 0L;
        }

        boolean isCurrentlyReachable() {
            return this.getIncoming() != null || this.getOutgoing() != null || TimeUtils.toRelativeTimeMillis(this.expiresAt) >= 0L;
        }

        boolean isExpired() {
            return !this.isCurrentlyReachable();
        }
    }
}

