/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.impl.pipe.WireHeader;
import net.jxta.impl.pipe.WirePipe;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.OutputPipe;
import net.jxta.protocol.PipeAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NonBlockingWireOutputPipe
implements OutputPipe {
    private static final Logger LOG = Logger.getLogger(NonBlockingWireOutputPipe.class.getName());
    private volatile boolean closed = false;
    private final PeerGroup peerGroup;
    private final WirePipe wire;
    private final PipeAdvertisement pAdv;
    private final Set<? extends ID> destPeers;

    public NonBlockingWireOutputPipe(PeerGroup group, WirePipe wire, PipeAdvertisement pAdv, Set<? extends ID> peers) {
        this.peerGroup = group;
        this.wire = wire;
        this.destPeers = new HashSet<ID>(peers);
        this.pAdv = pAdv;
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Constructing for " + this.getPipeID());
        }
    }

    @Override
    public synchronized void close() {
        if (!this.closed && Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Closing queue for " + this.getPipeID());
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public final String getType() {
        return this.pAdv.getType();
    }

    @Override
    public final ID getPipeID() {
        return this.pAdv.getPipeID();
    }

    @Override
    public final String getName() {
        return this.pAdv.getName();
    }

    @Override
    public final PipeAdvertisement getAdvertisement() {
        return this.pAdv;
    }

    @Override
    public boolean send(Message message) throws IOException {
        if (this.closed) {
            throw new IOException("Pipe closed");
        }
        WireHeader header = new WireHeader();
        header.setPipeID(this.getPipeID());
        header.setSrcPeer(this.peerGroup.getPeerID());
        header.setTTL(this.destPeers.isEmpty() ? 200 : 1);
        header.setMsgId(WirePipe.createMsgId());
        XMLDocument asDoc = (XMLDocument)header.getDocument(MimeMediaType.XMLUTF8);
        TextDocumentMessageElement elem = new TextDocumentMessageElement("JxtaWireHeader", asDoc, null);
        Message msg = message.clone();
        msg.replaceMessageElement("jxta", elem);
        return this.sendUnModified(msg, header);
    }

    boolean sendUnModified(Message msg, WireHeader header) throws IOException {
        if (this.closed) {
            throw new IOException("Pipe closed");
        }
        this.wire.sendMessage(msg, this.destPeers, header);
        return true;
    }
}

