/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.pipe.BlockingWireOutputPipe;
import net.jxta.impl.pipe.InputPipeImpl;
import net.jxta.impl.pipe.NonBlockingOutputPipe;
import net.jxta.impl.pipe.PipeResolver;
import net.jxta.impl.pipe.PipeServiceInterface;
import net.jxta.impl.pipe.SecureInputPipeImpl;
import net.jxta.impl.pipe.SecureOutputPipe;
import net.jxta.impl.pipe.WirePipeImpl;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.OutputPipeEvent;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipeServiceImpl
implements PipeService,
PipeResolver.Listener {
    private static final Logger LOG = Logger.getLogger(PipeServiceImpl.class.getName());
    static final long VERIFYINTERVAL = 1200000L;
    private PeerGroup group = null;
    private PipeResolver pipeResolver = null;
    private WirePipeImpl wirePipe = null;
    private PipeService myInterface = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private final Map<PipeID, Map<Integer, OutputPipeHolder>> outputPipeListeners = new HashMap<PipeID, Map<Integer, OutputPipeHolder>>();
    private volatile boolean started = false;

    @Override
    public synchronized PipeService getInterface() {
        if (null == this.myInterface) {
            this.myInterface = new PipeServiceInterface(this);
        }
        return this.myInterface;
    }

    @Override
    public ModuleImplAdvertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    @Override
    public synchronized void init(PeerGroup group, ID assignedID, Advertisement impl) {
        this.group = group;
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring Pipe Service : " + assignedID);
            if (this.implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: ").append(this.implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : ").append(this.implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : ").append(this.implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : ").append(this.implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : ").append(group);
            configInfo.append("\n\t\tPeer ID : ").append(group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tVerify Interval : 1200000ms");
            LOG.config(configInfo.toString());
        }
    }

    @Override
    public synchronized int startApp(String[] args) {
        Service needed = this.group.getEndpointService();
        if (null == needed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is an endpoint service");
            }
            return 2;
        }
        needed = this.group.getResolverService();
        if (null == needed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a resolver service");
            }
            return 2;
        }
        needed = this.group.getMembershipService();
        if (null == needed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a membership service");
            }
            return 2;
        }
        needed = this.group.getRendezVousService();
        if (null == needed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a rendezvous service");
            }
            return 2;
        }
        this.pipeResolver = new PipeResolver(this.group);
        this.wirePipe = new WirePipeImpl(this.group, this.pipeResolver);
        this.wirePipe.startApp(args);
        this.started = true;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopApp() {
        this.started = false;
        try {
            if (this.wirePipe != null) {
                this.wirePipe.stopApp();
            }
        }
        catch (Throwable failed) {
            LOG.log(Level.SEVERE, "Failed to stop wire pipe", failed);
        }
        finally {
            this.wirePipe = null;
        }
        try {
            if (this.pipeResolver != null) {
                this.pipeResolver.stop();
            }
        }
        catch (Throwable failed) {
            LOG.log(Level.SEVERE, "Failed to stop pipe resolver", failed);
        }
        finally {
            this.pipeResolver = null;
        }
        this.group = null;
        this.myInterface = null;
        Collection<Map<Integer, OutputPipeHolder>> values = this.outputPipeListeners.values();
        for (Map<Integer, OutputPipeHolder> value : values) {
            value.clear();
        }
        this.outputPipeListeners.clear();
    }

    @Override
    public InputPipe createInputPipe(PipeAdvertisement adv) throws IOException {
        return this.createInputPipe(adv, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InputPipe createInputPipe(PipeAdvertisement adv, PipeMsgListener listener) throws IOException {
        void var5_8;
        if (!this.started) {
            throw new IllegalStateException("Pipe Service has not been started or has been stopped");
        }
        String type = adv.getType();
        if (type == null) {
            throw new IllegalArgumentException("PipeAdvertisement type may not be null");
        }
        PipeID pipeId = (PipeID)adv.getPipeID();
        if (pipeId == null) {
            throw new IllegalArgumentException("PipeAdvertisement PipeID may not be null");
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Create " + type + " InputPipe for " + pipeId);
        }
        if (type.equals("JxtaUnicast")) {
            InputPipeImpl inputPipeImpl = new InputPipeImpl(this.pipeResolver, adv, listener);
            return var5_8;
        } else if (type.equals("JxtaUnicastSecure")) {
            SecureInputPipeImpl secureInputPipeImpl = new SecureInputPipeImpl(this.pipeResolver, adv, listener);
            return var5_8;
        } else if (type.equals("JxtaPropagate")) {
            if (this.wirePipe == null) throw new IOException("No propagated pipe servive available");
            InputPipe inputPipe = this.wirePipe.createInputPipe(adv, listener);
            return var5_8;
        } else {
            if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) throw new IOException("Cannot create pipe for unknown type : " + type);
            LOG.severe("Cannot create pipe for unknown type : " + type);
            throw new IOException("Cannot create pipe for unknown type : " + type);
        }
    }

    @Override
    public OutputPipe createOutputPipe(PipeAdvertisement pipeAdv, long timeout) throws IOException {
        return this.createOutputPipe(pipeAdv, Collections.emptySet(), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputPipe createOutputPipe(PipeAdvertisement adv, Set<? extends ID> resolvablePeers, long timeout) throws IOException {
        if (0L == timeout) {
            timeout = Long.MAX_VALUE;
        }
        long absoluteTimeOut = TimeUtils.toAbsoluteTimeMillis(timeout);
        syncListener localListener = new syncListener();
        int queryid = PipeResolver.getNextQueryID();
        this.createOutputPipe(adv, resolvablePeers, localListener, queryid);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Waiting synchronously for " + timeout + "ms to resolve OutputPipe for " + adv.getPipeID());
        }
        try {
            syncListener syncListener2 = localListener;
            synchronized (syncListener2) {
                while (null == localListener.event && TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), absoluteTimeOut) < 0L) {
                    try {
                        localListener.wait(1000L);
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                    }
                }
            }
        }
        finally {
            this.removeOutputPipeListener(adv.getPipeID().toString(), queryid);
        }
        if (null != localListener.event) {
            return localListener.event.getOutputPipe();
        }
        throw new IOException("Output Pipe could not be resolved after " + timeout + "ms.");
    }

    @Override
    public void createOutputPipe(PipeAdvertisement pipeAdv, OutputPipeListener listener) throws IOException {
        this.createOutputPipe(pipeAdv, Collections.emptySet(), listener);
    }

    @Override
    public void createOutputPipe(PipeAdvertisement pipeAdv, Set<? extends ID> resolvablePeers, OutputPipeListener listener) throws IOException {
        this.createOutputPipe(pipeAdv, resolvablePeers, listener, PipeResolver.getNextQueryID());
    }

    private void createOutputPipe(PipeAdvertisement pipeAdv, Set<? extends ID> resolvablePeers, OutputPipeListener listener, int queryid) throws IOException {
        if (!this.started) {
            throw new IOException("Pipe Service has not been started or has been stopped");
        }
        PipeID pipeId = (PipeID)pipeAdv.getPipeID();
        String type = pipeAdv.getType();
        if (null == type) {
            IllegalArgumentException failed = new IllegalArgumentException("Pipe type was not set");
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, failed.getMessage(), failed);
            }
            throw failed;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Create " + type + " OutputPipe for " + pipeId);
        }
        if ("JxtaPropagate".equals(type)) {
            OutputPipe op;
            if (resolvablePeers.size() == 1) {
                op = new BlockingWireOutputPipe(this.group, pipeAdv, (PeerID)resolvablePeers.iterator().next());
            } else if (this.wirePipe != null) {
                op = this.wirePipe.createOutputPipe(pipeAdv, resolvablePeers);
            } else {
                throw new IOException("No propagated pipe service available");
            }
            if (null != op) {
                OutputPipeEvent newevent = new OutputPipeEvent(this.getInterface(), op, pipeId.toString(), 0);
                try {
                    listener.outputPipeEvent(newevent);
                }
                catch (Throwable ignored) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Uncaught Throwable in listener for " + pipeId + " (" + listener.getClass().getName() + ")", ignored);
                    }
                }
            }
        } else if ("JxtaUnicast".equals(type) || "JxtaUnicastSecure".equals(type)) {
            InputPipe local;
            this.addOutputPipeListener(pipeId, new OutputPipeHolder(pipeAdv, resolvablePeers, listener, queryid));
            this.pipeResolver.addListener(pipeId, this, queryid);
            this.pipeResolver.sendPipeQuery(pipeAdv, resolvablePeers, queryid);
            if ((resolvablePeers.isEmpty() || resolvablePeers.contains(this.group.getPeerID())) && null != (local = this.pipeResolver.findLocal(pipeId))) {
                if (local.getType().equals(pipeAdv.getType())) {
                    this.pipeResolver.callListener(queryid, pipeId, local.getType(), this.group.getPeerID(), false);
                } else if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning(MessageFormat.format("rejecting local pipe ({0}) because type is not ({1})", local.getType(), pipeAdv.getType()));
                }
            }
        } else {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("createOutputPipe: cannot create pipe for unknown type : " + type);
            }
            throw new IOException("cannot create pipe for unknown type : " + type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOutputPipeListener(PipeID pipeId, OutputPipeHolder pipeHolder) {
        Map<PipeID, Map<Integer, OutputPipeHolder>> map = this.outputPipeListeners;
        synchronized (map) {
            Map<Integer, OutputPipeHolder> perpipelisteners = this.outputPipeListeners.get(pipeId);
            if (perpipelisteners == null) {
                perpipelisteners = new HashMap<Integer, OutputPipeHolder>();
                this.outputPipeListeners.put(pipeId, perpipelisteners);
            }
            if (perpipelisteners.get(pipeHolder.queryid) != null) {
                LOG.warning("Clobbering output pipe listener for query " + pipeHolder.queryid);
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Adding pipe listener for pipe " + pipeId + " and query " + pipeHolder.queryid);
            }
            perpipelisteners.put(pipeHolder.queryid, pipeHolder);
        }
    }

    @Override
    public OutputPipeListener removeOutputPipeListener(String pipeID, OutputPipeListener listener) {
        throw new UnsupportedOperationException("Legacy method not supported. Use interface object if you need this method.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputPipeListener removeOutputPipeListener(ID pipeID, OutputPipeListener listener) {
        if (this.pipeResolver == null) {
            return null;
        }
        if (!(pipeID instanceof PipeID)) {
            throw new IllegalArgumentException("pipeID must be a PipeID.");
        }
        Map<PipeID, Map<Integer, OutputPipeHolder>> map = this.outputPipeListeners;
        synchronized (map) {
            Map<Integer, OutputPipeHolder> perpipelisteners = this.outputPipeListeners.get(pipeID);
            if (perpipelisteners != null) {
                Set<Map.Entry<Integer, OutputPipeHolder>> entries = perpipelisteners.entrySet();
                for (Map.Entry<Integer, OutputPipeHolder> entry : entries) {
                    OutputPipeHolder pl = entry.getValue();
                    if (pl.listener != listener) continue;
                    this.pipeResolver.removeListener((PipeID)pipeID, pl.queryid);
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Removing listener for query " + pl.queryid);
                    }
                    perpipelisteners.remove(entry.getKey());
                }
                if (perpipelisteners.isEmpty()) {
                    this.outputPipeListeners.remove(pipeID);
                }
            }
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputPipeListener removeOutputPipeListener(String opID, int queryID) {
        PipeID pipeID;
        if (this.pipeResolver == null) {
            return null;
        }
        try {
            URI aPipeID = new URI(opID);
            pipeID = (PipeID)IDFactory.fromURI(aPipeID);
        }
        catch (URISyntaxException badID) {
            throw new IllegalArgumentException("Bad pipe ID: " + opID);
        }
        catch (ClassCastException badID) {
            throw new IllegalArgumentException("id was not a pipe id: " + opID);
        }
        Map<PipeID, Map<Integer, OutputPipeHolder>> map = this.outputPipeListeners;
        synchronized (map) {
            Map<Integer, OutputPipeHolder> perpipelisteners = this.outputPipeListeners.get(pipeID);
            if (perpipelisteners != null) {
                OutputPipeHolder pipeHolder = perpipelisteners.get(queryID);
                perpipelisteners.remove(queryID);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Removing listener for query " + queryID);
                }
                if (perpipelisteners.isEmpty()) {
                    this.outputPipeListeners.remove(pipeID);
                }
                this.pipeResolver.removeListener(pipeID, queryID);
                if (pipeHolder != null) {
                    return pipeHolder.listener;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pipeResolveEvent(PipeResolver.Event event) {
        try {
            int queryID;
            ID pipeID;
            block20: {
                NonBlockingOutputPipe op;
                OutputPipeHolder pipeHolder;
                ID peerID = event.getPeerID();
                pipeID = event.getPipeID();
                queryID = event.getQueryID();
                Map<PipeID, Map<Integer, OutputPipeHolder>> map = this.outputPipeListeners;
                synchronized (map) {
                    Map<Integer, OutputPipeHolder> perpipelisteners = this.outputPipeListeners.get(pipeID);
                    if (perpipelisteners == null) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("No listener for event for pipe " + pipeID);
                        }
                        return false;
                    }
                    pipeHolder = perpipelisteners.get(queryID);
                    if (pipeHolder == null) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("No listener for event for query " + queryID);
                        }
                        return false;
                    }
                }
                if (!pipeHolder.peers.isEmpty() && !pipeHolder.peers.contains(peerID)) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("Event was for wrong peer '" + peerID + "'. Discarding.");
                    }
                    return false;
                }
                String type = pipeHolder.adv.getType();
                if ("JxtaUnicast".equals(type)) {
                    op = new NonBlockingOutputPipe(this.group, this.pipeResolver, pipeHolder.adv, peerID, pipeHolder.peers);
                } else if ("JxtaUnicastSecure".equals(type)) {
                    op = new SecureOutputPipe(this.group, this.pipeResolver, pipeHolder.adv, peerID, pipeHolder.peers);
                } else {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("Could not create output pipe of type '" + type + "'. Discarding.");
                    }
                    return false;
                }
                OutputPipeEvent newevent = new OutputPipeEvent(this.getInterface(), op, pipeID.toString(), queryID);
                try {
                    pipeHolder.listener.outputPipeEvent(newevent);
                }
                catch (Throwable ignored) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block20;
                    LOG.log(Level.SEVERE, "Uncaught Throwable in listener for " + pipeID + "(" + pipeHolder.getClass().getName() + ")", ignored);
                }
            }
            this.removeOutputPipeListener(pipeID.toString(), queryID);
            return true;
        }
        catch (IOException ie) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Error creating output pipe " + event.getPipeID(), ie);
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("No listener for event for " + event.getPipeID());
            }
            return false;
        }
    }

    @Override
    public boolean pipeNAKEvent(PipeResolver.Event event) {
        return false;
    }

    private static class syncListener
    implements OutputPipeListener {
        volatile OutputPipeEvent event = null;

        syncListener() {
        }

        public synchronized void outputPipeEvent(OutputPipeEvent event) {
            if (null == this.event) {
                this.event = event;
                this.notifyAll();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputPipeHolder {
        final PipeAdvertisement adv;
        final Set<? extends ID> peers;
        final OutputPipeListener listener;
        final int queryid;

        OutputPipeHolder(PipeAdvertisement adv, Set<? extends ID> peers, OutputPipeListener listener, int queryid) {
            this.adv = adv;
            this.peers = peers;
            this.listener = listener;
            this.queryid = queryid;
        }
    }
}

