/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.AccessPointAdvertisement;

public class AccessPointAdv
extends AccessPointAdvertisement
implements Cloneable {
    private static final Logger LOG = Logger.getLogger(AccessPointAdv.class.getName());
    private static final String PID_TAG = "PID";
    private static final String EA_TAG = "EA";
    private static final String[] INDEXFIELDS = new String[]{"PID"};

    public static String getAdvertisementType() {
        return "jxta:APA";
    }

    private AccessPointAdv() {
    }

    private AccessPointAdv(Element root) {
        if (!(root instanceof XMLElement)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(AccessPointAdv.getAdvertisementType()) && !AccessPointAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element: " + elem.toString());
        }
    }

    public AccessPointAdv clone() {
        return (AccessPointAdv)super.clone();
    }

    public String[] getIndexFields() {
        return INDEXFIELDS;
    }

    public String getAdvType() {
        return AccessPointAdv.getAdvertisementType();
    }

    public ID getID() {
        PeerID pid = this.getPeerID();
        if (null == pid) {
            throw new IllegalStateException("cannot build ID: no peer id");
        }
        try {
            String seed = this.getAdvType() + this.getPeerID().toString();
            ByteArrayInputStream in = new ByteArrayInputStream(seed.getBytes());
            return IDFactory.newCodatID(PeerGroupID.worldPeerGroupID, seed.getBytes(), in);
        }
        catch (Exception ez) {
            IllegalStateException failed = new IllegalStateException("cannot build ID");
            failed.initCause(ez);
            throw failed;
        }
    }

    protected boolean handleElement(Element raw) {
        String epa;
        String uri;
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (PID_TAG.equals(elem.getName()) && null != (uri = elem.getTextValue())) {
            try {
                URI pID = new URI(uri.trim());
                this.setPeerID((PeerID)IDFactory.fromURI(pID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad PeerID ID in advertisement");
            }
            catch (ClassCastException notPID) {
                throw new IllegalArgumentException("Not a Peer ID");
            }
            return true;
        }
        if (EA_TAG.equals(elem.getName()) && null != (epa = elem.getTextValue())) {
            this.addEndpointAddress(epa.trim());
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        if (this.getPeerID() != null) {
            Object e = adv.createElement(PID_TAG, this.getPeerID().toString());
            adv.appendChild(e);
        }
        Enumeration<String> each = this.getEndpointAddresses();
        while (each.hasMoreElements()) {
            Object e2 = adv.createElement(EA_TAG, each.nextElement().toString());
            adv.appendChild(e2);
        }
        return adv;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return AccessPointAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new AccessPointAdv();
        }

        public Advertisement newInstance(Element root) {
            return new AccessPointAdv(root);
        }
    }
}

