/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.logging.Logging;
import net.jxta.protocol.ConfigParams;

public class GroupConfig
extends ConfigParams
implements Cloneable {
    private static final Logger LOG = Logger.getLogger(GroupConfig.class.getName());
    private static final String advType = "jxta:GroupConfig";

    GroupConfig() {
    }

    GroupConfig(XMLElement doc) {
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(GroupConfig.getAdvertisementType()) && !GroupConfig.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            Element elem = (Element)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element: " + elem.toString());
        }
    }

    public GroupConfig clone() {
        GroupConfig result = (GroupConfig)super.clone();
        return result;
    }

    public static String getAdvertisementType() {
        return advType;
    }

    public String getAdvType() {
        return GroupConfig.getAdvertisementType();
    }

    public StructuredDocument getDocument(MimeMediaType encodeAs) {
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        this.addDocumentElements(adv);
        return adv;
    }

    public String[] getIndexFields() {
        return new String[0];
    }

    public ID getID() {
        return null;
    }

    public static final class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return GroupConfig.advType;
        }

        public Advertisement newInstance() {
            return new GroupConfig();
        }

        public Advertisement newInstance(Element root) {
            if (!XMLElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
            }
            return new GroupConfig((XMLElement)root);
        }
    }
}

