/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.protocol.GroupConfig;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;

public final class PlatformConfig
extends GroupConfig
implements Cloneable {
    private static final String advType = "jxta:PlatformConfig";
    private static final Logger LOG = Logger.getLogger(PlatformConfig.class.getName());
    private static final String PID_TAG = "PID";
    private static final String NAME_TAG = "Name";
    private static final String DESC_TAG = "Desc";
    private PeerID pid = null;
    private String name = null;
    private Element description = null;

    PlatformConfig() {
    }

    PlatformConfig(XMLElement doc) {
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(PlatformConfig.getAdvertisementType()) && !PlatformConfig.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element: " + elem.toString());
        }
    }

    public PlatformConfig clone() {
        PlatformConfig result = (PlatformConfig)super.clone();
        result.setPeerID(this.getPeerID());
        result.setName(this.getName());
        result.setDesc(this.getDesc());
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PlatformConfig) {
            PlatformConfig likeMe = (PlatformConfig)other;
            boolean se = super.equals(likeMe);
            boolean ne = null == this.name && null == likeMe.name || null != this.name && this.name.equals(likeMe.name);
            boolean ie = null == this.pid && null == likeMe.pid || null != this.pid && this.pid.equals(likeMe.pid);
            boolean de = null == this.description && null == likeMe.description || null != this.description && this.description.equals(likeMe.description);
            return se && ne && ie && de;
        }
        return false;
    }

    public static String getAdvertisementType() {
        return advType;
    }

    public String getAdvType() {
        return PlatformConfig.getAdvertisementType();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PeerID getPeerID() {
        return this.pid;
    }

    public void setPeerID(PeerID pid) {
        this.pid = pid;
    }

    public ID getID() {
        return this.pid;
    }

    public String getDescription() {
        return null == this.description ? null : (String)this.description.getValue();
    }

    public void setDescription(String description) {
        StructuredDocument newdoc = null;
        if (null != description) {
            newdoc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, DESC_TAG, description);
        }
        this.setDesc(newdoc);
    }

    public StructuredDocument getDesc() {
        StructuredDocument newDoc = null;
        if (null != this.description) {
            newDoc = StructuredDocumentUtils.copyAsDocument(this.description);
        }
        return newDoc;
    }

    public void setDesc(Element desc) {
        this.description = null != desc ? StructuredDocumentUtils.copyAsDocument(desc) : null;
    }

    @Deprecated
    public String getDebugLevel() {
        return "user default";
    }

    @Deprecated
    public void setDebugLevel(String debugLevel) {
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        String elName = elem.getName();
        if (DESC_TAG.equals(elName)) {
            this.setDesc(elem);
            return true;
        }
        String value = elem.getTextValue();
        if (null == value) {
            return false;
        }
        if (0 == (value = value.trim()).length()) {
            return false;
        }
        if (PID_TAG.equals(elName)) {
            try {
                URI asURI = new URI(value);
                PeerID pID = (PeerID)IDFactory.fromURI(asURI);
                this.setPeerID(pID);
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Invalid PeerID in advertisement: " + value);
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Invalid PeerID: " + value);
            }
            return true;
        }
        if (NAME_TAG.equals(elName)) {
            this.setName(value);
            return true;
        }
        return false;
    }

    public boolean addDocumentElements(StructuredDocument adv) {
        StructuredDocument desc;
        Object e;
        PeerID peerID = this.getPeerID();
        if (null != peerID && !ID.nullID.equals(peerID)) {
            e = adv.createElement(PID_TAG, peerID.toString());
            adv.appendChild(e);
        }
        if (this.getName() != null) {
            e = adv.createElement(NAME_TAG, this.getName());
            adv.appendChild(e);
        }
        if ((desc = this.getDesc()) != null) {
            StructuredDocumentUtils.copyElements(adv, adv, desc);
        }
        super.addDocumentElements(adv);
        return true;
    }

    public static final class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return PlatformConfig.advType;
        }

        public Advertisement newInstance() {
            return new PlatformConfig();
        }

        public Advertisement newInstance(Element root) {
            if (!XMLElement.class.isInstance(root)) {
                throw new IllegalArgumentException("jxta:PlatformConfig only supports XLMElement");
            }
            return new PlatformConfig((XMLElement)root);
        }
    }
}

