/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.util.Enumeration;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.protocol.RouteResponseMsg;

public class RouteResponse
extends RouteResponseMsg {
    private static final String destRouteTag = "Dst";
    private static final String srcRouteTag = "Src";

    public RouteResponse() {
    }

    public RouteResponse(XMLElement doc) {
        String doctype = doc.getName();
        if (!doctype.equals(RouteResponse.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + " from doc containing a " + doctype);
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            RouteAdvertisement route;
            XMLElement aXpt;
            Enumeration eachXpt;
            XMLElement elem = (XMLElement)elements.nextElement();
            if (elem.getName().equals(destRouteTag)) {
                eachXpt = elem.getChildren();
                while (eachXpt.hasMoreElements()) {
                    aXpt = (XMLElement)eachXpt.nextElement();
                    route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                    this.setDestRoute(route);
                }
                continue;
            }
            if (!elem.getName().equals(srcRouteTag)) continue;
            eachXpt = elem.getChildren();
            while (eachXpt.hasMoreElements()) {
                aXpt = (XMLElement)eachXpt.nextElement();
                route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                this.setSrcRoute(route);
            }
        }
        if (null == this.getSrcRoute()) {
            throw new IllegalArgumentException("Missing source route.");
        }
        if (null == this.getDestRoute()) {
            throw new IllegalArgumentException("Missing destination route.");
        }
        if (null == this.getSrcRoute().getDestPeerID()) {
            throw new IllegalArgumentException("Bad source route.");
        }
        if (null == this.getDestRoute().getDestPeerID()) {
            throw new IllegalArgumentException("Bad destination route.");
        }
    }

    public Document getDocument(MimeMediaType asMimeType) {
        StructuredTextDocument xptDoc;
        Object e;
        RouteAdvertisement route;
        if (null == this.getSrcRoute()) {
            throw new IllegalStateException("Missing source route.");
        }
        if (null == this.getDestRoute()) {
            throw new IllegalStateException("Missing destination route.");
        }
        if (null == this.getSrcRoute().getDestPeerID()) {
            throw new IllegalStateException("Bad source route.");
        }
        if (null == this.getDestRoute().getDestPeerID()) {
            throw new IllegalStateException("Bad destination route.");
        }
        StructuredDocument adv = StructuredDocumentFactory.newStructuredDocument(asMimeType, RouteResponse.getAdvertisementType());
        if (adv instanceof XMLDocument) {
            ((XMLDocument)adv).addAttribute("xmlns:jxta", "http://jxta.org");
            ((XMLDocument)adv).addAttribute("xml:space", "preserve");
        }
        if ((route = this.getDestRoute()) != null) {
            e = adv.createElement(destRouteTag);
            adv.appendChild(e);
            xptDoc = (StructuredTextDocument)route.getDocument(asMimeType);
            StructuredDocumentUtils.copyElements(adv, e, xptDoc);
        }
        if ((route = this.getSrcRoute()) != null) {
            e = adv.createElement(srcRouteTag);
            adv.appendChild(e);
            xptDoc = (StructuredTextDocument)route.getDocument(asMimeType);
            StructuredDocumentUtils.copyElements(adv, e, xptDoc);
        }
        return adv;
    }

    public String toString() {
        XMLDocument doc = (XMLDocument)this.getDocument(MimeMediaType.XMLUTF8);
        doc.addAttribute("xml:space", "default");
        return doc.toString();
    }
}

