/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.proxy;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.discovery.DiscoveryEvent;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.proxy.Requestor;
import net.jxta.impl.util.Cache;
import net.jxta.impl.util.CacheEntry;
import net.jxta.impl.util.CacheEntryListener;
import net.jxta.impl.util.LRUCache;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.OutputPipeEvent;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.DiscoveryResponseMsg;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.service.Service;

public class ProxyService
implements Service,
EndpointListener,
PipeMsgListener,
OutputPipeListener,
CacheEntryListener {
    private static final Logger LOG = Logger.getLogger(ProxyService.class.getName());
    public static final int DEFAULT_THRESHOLD = 2;
    public static final int DEFAULT_LIFETIME = 1800000;
    public static final String REQUEST_TAG = "request";
    public static final String RESPONSE_TAG = "response";
    static final String REQUESTID_TAG = "requestId";
    static final String TYPE_TAG = "type";
    static final String NAME_TAG = "name";
    static final String ID_TAG = "id";
    static final String ARG_TAG = "arg";
    static final String ATTRIBUTE_TAG = "attr";
    static final String VALUE_TAG = "value";
    static final String THRESHOLD_TAG = "threshold";
    static final String ERROR_MESSAGE_TAG = "error";
    static final String PROXYNS = "proxy";
    public static final String REQUEST_JOIN = "join";
    public static final String REQUEST_CREATE = "create";
    public static final String REQUEST_SEARCH = "search";
    public static final String REQUEST_LISTEN = "listen";
    public static final String REQUEST_CLOSE = "close";
    public static final String REQUEST_SEND = "send";
    public static final String RESPONSE_SUCCESS = "success";
    public static final String RESPONSE_ERROR = "error";
    public static final String RESPONSE_INFO = "info";
    public static final String RESPONSE_RESULT = "result";
    public static final String RESPONSE_MESSAGE = "data";
    public static final String TYPE_PEER = "PEER";
    public static final String TYPE_GROUP = "GROUP";
    public static final String TYPE_PIPE = "PIPE";
    private PeerGroup group = null;
    private ID assignedID = null;
    private String serviceName = null;
    private String serviceParameter = null;
    private EndpointService endpoint = null;
    private DiscoveryService discovery = null;
    private PipeService pipe = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private final LRUCache searchRequests = new LRUCache(25);
    private final Map<String, PipeListenerList> pipeListeners = new TreeMap<String, PipeListenerList>();
    private final Cache pendingPipes = new Cache(200L, null);
    private Cache resolvedPipes;
    private static Map<String, PeerGroup> proxiedGroups = new HashMap<String, PeerGroup>(16);
    private static Map<String, String> passwords = new HashMap<String, String>(16);

    public void init(PeerGroup group, ID assignedID, Advertisement implAdv) throws PeerGroupException {
        this.group = group;
        this.assignedID = assignedID;
        this.serviceName = assignedID.toString();
        this.implAdvertisement = (ModuleImplAdvertisement)implAdv;
        this.serviceParameter = group.getPeerGroupID().toString();
        this.resolvedPipes = new Cache(200L, this);
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring JXME Proxy Service : " + assignedID);
            configInfo.append("\n\tImplementation :");
            configInfo.append("\n\t\tModule Spec ID: " + this.implAdvertisement.getModuleSpecID());
            configInfo.append("\n\t\tImpl Description : " + this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID : " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID : " + group.getPeerID());
            LOG.config(configInfo.toString());
        }
    }

    public int startApp(String[] args) {
        Service needed = this.group.getEndpointService();
        if (null == needed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a endpoint service");
            }
            return 2;
        }
        needed = this.group.getDiscoveryService();
        if (null == needed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a discovery service");
            }
            return 2;
        }
        needed = this.group.getPipeService();
        if (null == needed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a pipe service");
            }
            return 2;
        }
        this.endpoint = this.group.getEndpointService();
        this.discovery = this.group.getDiscoveryService();
        this.pipe = this.group.getPipeService();
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("addListener " + this.serviceName + this.serviceParameter);
        }
        this.endpoint.addIncomingMessageListener(this, this.serviceName, this.serviceParameter);
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("JXME Proxy Service started.");
        }
        return 0;
    }

    public void stopApp() {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("removeListener " + this.serviceName + this.serviceParameter);
        }
        this.endpoint.removeIncomingMessageListener(this.serviceName, this.serviceParameter);
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("JXME Proxy Service stopped.");
        }
    }

    public ModuleImplAdvertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public ProxyService getInterface() {
        return this;
    }

    public synchronized void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        Requestor requestor;
        block15: {
            ProxyService.logMessage(message, LOG);
            requestor = null;
            try {
                EndpointAddress relayAddr = new EndpointAddress("relay", srcAddr.getProtocolAddress(), srcAddr.getServiceName(), srcAddr.getServiceParameter());
                requestor = Requestor.createRequestor(this.group, message, relayAddr, 0);
            }
            catch (IOException e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block15;
                LOG.log(Level.WARNING, "could not create requestor", e);
            }
        }
        String request = ProxyService.popString(REQUEST_TAG, message);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("request = " + request + " requestor " + requestor);
        }
        if (request != null && requestor != null) {
            if (REQUEST_JOIN.equals(request)) {
                this.handleJoinRequest(requestor, ProxyService.popString(ID_TAG, message), ProxyService.popString(ARG_TAG, message));
            } else if (REQUEST_CREATE.equals(request)) {
                this.handleCreateRequest(requestor, ProxyService.popString(TYPE_TAG, message), ProxyService.popString(NAME_TAG, message), ProxyService.popString(ID_TAG, message), ProxyService.popString(ARG_TAG, message));
            } else if (REQUEST_SEARCH.equals(request)) {
                this.handleSearchRequest(requestor, ProxyService.popString(TYPE_TAG, message), ProxyService.popString(ATTRIBUTE_TAG, message), ProxyService.popString(VALUE_TAG, message), ProxyService.popString(THRESHOLD_TAG, message));
            } else if (REQUEST_LISTEN.equals(request)) {
                this.handleListenRequest(requestor, ProxyService.popString(ID_TAG, message));
            } else if (REQUEST_CLOSE.equals(request)) {
                this.handleCloseRequest(requestor, ProxyService.popString(ID_TAG, message));
            } else if (REQUEST_SEND.equals(request)) {
                this.handleSendRequest(requestor, ProxyService.popString(ID_TAG, message), message);
            }
        }
    }

    private synchronized void handleJoinRequest(Requestor requestor, String grpId, String passwd) {
        PeerGroup g = proxiedGroups.get(grpId);
        if (g != null) {
            if (g == this.group) {
                requestor.notifyError("Same group");
            } else if (!passwords.get(grpId).equals(passwd)) {
                requestor.notifyError("Incorrect password");
            } else {
                requestor.notifySuccess();
            }
            return;
        }
        try {
            g = this.group.newGroup((PeerGroupID)IDFactory.fromURI(new URI(grpId)));
            g.getRendezVousService().startRendezVous();
        }
        catch (Exception ge) {
            requestor.notifyError(ge.getMessage());
            return;
        }
        try {
            ProxyService p = new ProxyService();
            p.init(g, this.assignedID, this.implAdvertisement);
            p.startApp(null);
        }
        catch (Exception e) {
            requestor.notifyError(e.getMessage());
            return;
        }
        passwords.put(grpId, passwd);
        proxiedGroups.put(grpId, g);
        requestor.notifySuccess();
    }

    private void handleCreateRequest(Requestor requestor, String type, String name, String id, String arg) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("handleCreateRequest type=" + type + " name=" + name + " id=" + id + " arg=" + arg);
        }
        if (name == null) {
            name = "";
        }
        if (TYPE_PEER.equals(type)) {
            PeerAdvertisement adv = this.createPeerAdvertisement(name, id);
            if (adv != null) {
                block19: {
                    try {
                        this.discovery.publish(adv);
                    }
                    catch (Exception e) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block19;
                        LOG.log(Level.WARNING, "Could not publish peer advertisement", e);
                    }
                }
                requestor.send(adv, RESPONSE_SUCCESS);
            } else {
                requestor.notifyError("could not create advertisement");
            }
        } else if (TYPE_GROUP.equals(type)) {
            PeerGroupAdvertisement adv = this.createGroupAdvertisement(name, id);
            if (adv != null) {
                requestor.send(adv, RESPONSE_SUCCESS);
            } else {
                requestor.notifyError("could not create advertisement");
            }
        } else if (TYPE_PIPE.equals(type)) {
            PipeAdvertisement adv;
            if (arg == null) {
                arg = "JxtaUnicast";
            }
            if ((adv = this.createPipeAdvertisement(name, id, arg)) != null) {
                block20: {
                    try {
                        this.discovery.publish(adv);
                    }
                    catch (Exception e) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block20;
                        LOG.log(Level.WARNING, "Could not publish pipe advertisement", e);
                    }
                }
                requestor.send(adv, RESPONSE_SUCCESS);
            } else {
                requestor.notifyError("could not create advertisement");
            }
        } else {
            requestor.notifyError("unsupported type");
        }
    }

    private void handleSearchRequest(Requestor requestor, String type, String attribute, String value, String threshold) {
        int thr;
        block6: {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("handleSearchRequest type=" + type + " attribute=" + attribute + " value=" + value + " threshold=" + threshold);
            }
            thr = 2;
            try {
                thr = Integer.parseInt(threshold);
            }
            catch (NumberFormatException nex) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block6;
                LOG.warning("handleSearchRequest failed to parse threshold " + threshold + ", using default " + 2);
            }
        }
        requestor.setThreshold(thr);
        int discoveryType = TYPE_PEER.equals(type) ? 0 : (TYPE_GROUP.equals(type) ? 1 : 2);
        Enumeration<Advertisement> each = null;
        try {
            each = this.discovery.getLocalAdvertisements(discoveryType, attribute, value);
        }
        catch (IOException e) {
            requestor.notifyError("could not search locally");
        }
        for (int i = 0; each.hasMoreElements() && i < thr; ++i) {
            Advertisement adv = each.nextElement();
            requestor.send(adv, RESPONSE_RESULT);
        }
        int queryId = this.discovery.getRemoteAdvertisements(null, discoveryType, attribute, value, thr);
        this.searchRequests.put(queryId, requestor);
    }

    private void handleListenRequest(Requestor requestor, String id) {
        block13: {
            PipeListenerList list;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("handleListenRequest id=" + id);
            }
            if (id == null) {
                requestor.notifyError("Pipe ID not specified");
                return;
            }
            PipeAdvertisement pipeAdv = this.findPipeAdvertisement(null, id, null);
            if (pipeAdv == null) {
                requestor.notifyError("Pipe Advertisement not found");
                return;
            }
            String pipeId = pipeAdv.getPipeID().toString();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("listen to pipe name=" + pipeAdv.getName() + " id=" + pipeAdv.getPipeID() + " type=" + pipeAdv.getType());
            }
            if ((list = this.pipeListeners.get(pipeId)) == null) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("first listener, create input pipe");
                }
                try {
                    list = new PipeListenerList(this.pipe.createInputPipe(pipeAdv, this), this.pipeListeners, pipeId);
                }
                catch (IOException e) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "could not listen to pipe", e);
                    }
                    requestor.notifyError("could not listen to pipe");
                    return;
                }
                this.pipeListeners.put(pipeId, list);
            }
            list.add(requestor);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("add requestor=" + requestor + " id=" + pipeId + " list=" + list);
                LOG.fine("publish PipeAdvertisement");
            }
            try {
                this.discovery.publish(pipeAdv);
            }
            catch (IOException e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block13;
                LOG.log(Level.WARNING, "Could not publish pipe advertisement", e);
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("done with listen request");
        }
        requestor.notifySuccess();
    }

    private void handleCloseRequest(Requestor requestor, String id) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("handleCloseRequest id=" + id);
        }
        PipeListenerList list = this.pipeListeners.get(id);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("handleCloseRequest list = " + list);
        }
        if (list != null) {
            list.remove(requestor);
            if (list.size() == 0) {
                this.pipeListeners.remove(id);
            }
        }
        requestor.notifySuccess();
    }

    private void sendToPipe(Requestor req, Message mess, OutputPipe out) {
        block3: {
            try {
                out.send(mess);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("output pipe send end");
                }
                req.notifySuccess();
            }
            catch (IOException e) {
                req.notifyError("could not send to pipe");
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block3;
                LOG.log(Level.FINE, "could not send to pipe", e);
            }
        }
    }

    private void handleSendRequest(Requestor requestor, String id, Message message) {
        OutputPipe out;
        PipeAdvertisement pipeAdv;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("handleSendRequest id=" + id);
        }
        if ((pipeAdv = this.findPipeAdvertisement(null, id, null)) == null) {
            requestor.notifyError("Could not find pipe");
            return;
        }
        String pipeId = pipeAdv.getPipeID().toString();
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("send to pipe name=" + pipeAdv.getName() + " id=" + pipeAdv.getPipeID().toString() + " arg=" + pipeAdv.getType());
        }
        PipeListenerList list = this.pipeListeners.get(pipeId);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("local listener list " + list);
        }
        if (list != null && "JxtaUnicast".equals(pipeAdv.getType())) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("start sending to each requestor");
            }
            list.send(message, pipeId);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("end sending to each requestor");
            }
            requestor.notifySuccess();
            return;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("output pipe creation begin");
        }
        if ((out = (OutputPipe)this.resolvedPipes.get(pipeId)) != null) {
            this.sendToPipe(requestor, message, out);
            return;
        }
        PendingPipe p = (PendingPipe)this.pendingPipes.get(pipeId);
        if (p != null) {
            p.enqueue(requestor, message);
            return;
        }
        try {
            p = new PendingPipe();
            p.enqueue(requestor, message);
            this.pendingPipes.put(pipeId, p);
            this.pipe.createOutputPipe(pipeAdv, this);
        }
        catch (IOException e) {
            this.pendingPipes.remove(pipeId);
            requestor.notifyError("could not create output pipe");
        }
    }

    private PeerAdvertisement createPeerAdvertisement(String name, String id) {
        PeerAdvertisement adv;
        block10: {
            PeerID pid;
            block9: {
                adv = null;
                pid = null;
                if (id != null) {
                    try {
                        ID tempId = IDFactory.fromURI(new URI(id));
                        pid = (PeerID)tempId;
                    }
                    catch (URISyntaxException e) {
                        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                            LOG.log(Level.WARNING, "Could not parse peerId from url", e);
                        }
                    }
                    catch (ClassCastException e) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block9;
                        LOG.log(Level.WARNING, "id was not a peerid", e);
                    }
                }
            }
            if (pid == null) {
                pid = IDFactory.newPeerID(this.group.getPeerGroupID());
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("newPeerAdvertisement name=" + name + " id=" + pid.toString());
            }
            try {
                adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(PeerAdvertisement.getAdvertisementType());
                adv.setPeerID(pid);
                adv.setPeerGroupID(this.group.getPeerGroupID());
                adv.setName(name);
                adv.setDescription("Peer Advertisement created for a jxme device");
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block10;
                LOG.log(Level.WARNING, "newPeerAdvertisement Exception", e);
            }
        }
        return adv;
    }

    private PeerGroupAdvertisement createGroupAdvertisement(String name, String id) {
        PeerGroupAdvertisement adv;
        block10: {
            PeerGroupID gid;
            block9: {
                gid = null;
                if (id != null) {
                    try {
                        ID tempId = IDFactory.fromURI(new URI(id));
                        gid = (PeerGroupID)tempId;
                    }
                    catch (URISyntaxException e) {
                        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                            LOG.log(Level.WARNING, "Invalid peergroupId", e);
                        }
                    }
                    catch (ClassCastException e) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block9;
                        LOG.log(Level.WARNING, "id was not a peergroup id", e);
                    }
                }
            }
            if (gid == null) {
                gid = IDFactory.newPeerGroupID();
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("newPeerGroupAdvertisement name=" + name + " id=" + gid.toString());
            }
            adv = this.group.getPeerGroupAdvertisement().clone();
            try {
                adv = (PeerGroupAdvertisement)AdvertisementFactory.newAdvertisement(PeerGroupAdvertisement.getAdvertisementType());
                adv.setName(name);
                adv.setPeerGroupID(gid);
                adv.setModuleSpecID(PeerGroup.allPurposePeerGroupSpecID);
                adv.setDescription("PeerGroup Advertisement created for a jxme device");
                ModuleImplAdvertisement groupImplAdv = this.group.getAllPurposePeerGroupImplAdvertisement();
                this.discovery.publish(groupImplAdv);
                this.discovery.publish(adv);
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block10;
                LOG.log(Level.WARNING, "newPeerGroupAdvertisement Exception", e);
            }
        }
        return adv;
    }

    private PipeAdvertisement createPipeAdvertisement(String pipeName, String pipeId, String pipeType) {
        PipeAdvertisement adv;
        block5: {
            adv = null;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("newPipeAdvertisement name=" + pipeName + " pipeId=" + pipeId + " pipeType=" + pipeType);
            }
            if (pipeType == null || pipeType.length() == 0) {
                pipeType = "JxtaUnicast";
            }
            if (pipeId == null) {
                pipeId = IDFactory.newPipeID(this.group.getPeerGroupID()).toString();
            }
            try {
                adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
                adv.setName(pipeName);
                adv.setPipeID(IDFactory.fromURI(new URI(pipeId)));
                adv.setType(pipeType);
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block5;
                LOG.log(Level.WARNING, "newPipeAdvertisement Exception", e);
            }
        }
        return adv;
    }

    private PipeAdvertisement findPipeAdvertisement(String name, String id, String arg) {
        Enumeration<Advertisement> each;
        String value;
        String attribute;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("findPipeAdvertisement name=" + name + " id=" + id + " arg=" + arg);
        }
        if (id != null) {
            attribute = "Id";
            value = id;
        } else if (name != null) {
            attribute = "Name";
            value = name;
        } else {
            return null;
        }
        try {
            each = this.discovery.getLocalAdvertisements(2, attribute, value);
        }
        catch (IOException e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "IOException in getLocalAdvertisements()", e);
            }
            return null;
        }
        PipeAdvertisement pipeAdv = null;
        while (each.hasMoreElements()) {
            Advertisement adv = each.nextElement();
            if (!(adv instanceof PipeAdvertisement)) continue;
            pipeAdv = (PipeAdvertisement)adv;
            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break;
            LOG.fine("found PipeAdvertisement = " + pipeAdv);
            break;
        }
        return pipeAdv;
    }

    public synchronized void discoveryEvent(DiscoveryEvent event) {
        Requestor requestor;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("discoveryEvent " + event);
        }
        if ((requestor = (Requestor)this.searchRequests.get(event.getQueryID())) == null) {
            return;
        }
        DiscoveryResponseMsg response = event.getResponse();
        if (response == null) {
            return;
        }
        Enumeration<String> each = response.getResponses();
        if (each == null || !each.hasMoreElements()) {
            return;
        }
        this.searchRequests.remove(event.getQueryID());
        int i = 0;
        while (each.hasMoreElements() && i < requestor.getThreshold()) {
            try {
                String str = each.nextElement();
                Advertisement adv = AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, new StringReader(str));
                requestor.send(adv, RESPONSE_RESULT);
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Bad result returned by DiscoveryService", e);
            }
        }
    }

    public synchronized void pipeMsgEvent(PipeMsgEvent event) {
        String id;
        PipeListenerList list;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("pipeMsgEvent " + event.getPipeID());
        }
        if ((list = this.pipeListeners.get(id = event.getPipeID().toString())) != null) {
            Message message = event.getMessage();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("pipeMsgEvent: start sending to each requestor");
            }
            list.send(message.clone(), id);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("pipeMsgEvent: end sending to each requestor");
            }
        } else {
            ((InputPipe)event.getSource()).close();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("close pipe id=" + id);
            }
        }
    }

    public synchronized void outputPipeEvent(OutputPipeEvent event) {
        PendingPipe p;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("outputPipeEvent " + event);
        }
        if ((p = (PendingPipe)this.pendingPipes.remove(event.getPipeID())) == null) {
            event.getOutputPipe().close();
            return;
        }
        this.resolvedPipes.put(event.getPipeID(), event.getOutputPipe());
        p.sendPending(event.getOutputPipe());
    }

    private static String popString(String name, Message message) {
        MessageElement el = message.getMessageElement(PROXYNS, name);
        if (el != null) {
            message.removeMessageElement(el);
            return el.toString();
        }
        return null;
    }

    protected static void logMessage(Message message, Logger log) {
        if (!Logging.SHOW_FINER || !log.isLoggable(Level.FINER)) {
            return;
        }
        StringBuilder out = new StringBuilder("\n**************** begin ****************\n");
        Message.ElementIterator elements = message.getMessageElements();
        while (elements.hasNext()) {
            MessageElement element2 = elements.next();
            out.append("[").append(elements.getNamespace()).append(",").append(element2.getElementName()).append("]=").append(element2.toString()).append("\n");
        }
        out.append("****************  end  ****************\n");
        log.finer(out.toString());
    }

    public void purged(CacheEntry ce) {
        ((OutputPipe)ce.getValue()).close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PipeListenerList {
        LinkedList<Requestor> list = new LinkedList();
        InputPipe inputPipe = null;
        Map<String, PipeListenerList> pipeListeners = null;
        String id = null;
        private static StringMessageElement sme = new StringMessageElement("response", "data", null);

        PipeListenerList(InputPipe inputPipe, Map<String, PipeListenerList> pipeListeners, String id) {
            this.inputPipe = inputPipe;
            this.pipeListeners = pipeListeners;
            this.id = id;
            if (pipeListeners != null && Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                LOG.config("number of pipeListeners = " + pipeListeners.size());
            }
        }

        void add(Requestor requestor) {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("add " + requestor + " from " + this.toString());
            }
            if (!this.list.contains(requestor)) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("requestor add");
                }
                this.list.add(requestor);
            } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("requestor exits already");
            }
        }

        void remove(Requestor requestor) {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("remove " + requestor + " from " + this.toString());
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("removed = " + this.list.remove(requestor));
            }
            if (this.list.size() == 0) {
                if (this.inputPipe != null) {
                    this.inputPipe.close();
                }
                if (this.id != null && this.pipeListeners != null) {
                    this.pipeListeners.remove(this.id);
                }
            }
        }

        int size() {
            int size = this.list.size();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("size " + size);
            }
            return size;
        }

        void send(Message message, String id) {
            block15: {
                LOG.fine("send list.size = " + this.list.size());
                message.addMessageElement(ProxyService.PROXYNS, sme);
                message.addMessageElement(ProxyService.PROXYNS, new StringMessageElement(ProxyService.ID_TAG, id, null));
                Message.ElementIterator elements = message.getMessageElements();
                while (elements.hasNext()) {
                    MessageElement el = (MessageElement)elements.next();
                    String name = el.getElementName();
                    if (name.startsWith("RendezVousPropagate")) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("removeMessageElement " + name);
                        }
                        elements.remove();
                        continue;
                    }
                    if (name.startsWith("JxtaWireHeader")) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("removeMessageElement " + name);
                        }
                        elements.remove();
                        continue;
                    }
                    if (name.startsWith("RdvIncarnjxta")) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("removeMessageElement " + name);
                        }
                        elements.remove();
                        continue;
                    }
                    if (name.startsWith("JxtaEndpointRouter")) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("removeMessageElement " + name);
                        }
                        elements.remove();
                        continue;
                    }
                    if (name.startsWith("EndpointRouterMsg")) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("removeMessageElement " + name);
                        }
                        elements.remove();
                        continue;
                    }
                    if (!name.startsWith("EndpointHeaderSrcPeer")) continue;
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("removeMessageElement " + name);
                    }
                    elements.remove();
                }
                Iterator iterator = this.list.iterator();
                try {
                    while (iterator.hasNext()) {
                        Requestor requestor = (Requestor)iterator.next();
                        if (requestor.send(message.clone())) continue;
                        this.remove(requestor);
                    }
                }
                catch (Exception ex) {
                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block15;
                    LOG.fine("Error sending" + ex);
                }
            }
        }

        public String toString() {
            String str = "PipeListenerList size=" + this.list.size();
            return str;
        }
    }

    class PendingPipe {
        private ClientMessage pending = null;

        public void sendPending(OutputPipe out) {
            this.pending.send(out);
            this.pending = null;
        }

        public void enqueue(Requestor req, Message mess) {
            if (this.pending != null) {
                return;
            }
            this.pending = new ClientMessage(req, mess);
        }
    }

    class ClientMessage {
        private Requestor requestor;
        private Message message;

        public ClientMessage(Requestor req, Message mess) {
            this.requestor = req;
            this.message = mess;
        }

        public void send(OutputPipe out) {
            ProxyService.this.sendToPipe(this.requestor, this.message, out);
        }
    }
}

