/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rendezvousMeter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
import net.jxta.impl.rendezvous.rendezvousMeter.ClientConnectionMetric;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousConnectionMetric;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousMetric;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousServiceMonitorFilter;
import net.jxta.meter.MonitorResources;
import net.jxta.meter.ServiceMetric;
import net.jxta.peer.PeerID;
import net.jxta.platform.ModuleClassID;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class RendezvousServiceMetric
implements ServiceMetric {
    private RendezvousMetric rendezvousMetric;
    private LinkedList rendezvousConnectionMetrics = new LinkedList();
    private LinkedList clientConnectionMetrics = new LinkedList();
    private ModuleClassID moduleClassID = MonitorResources.rendezvousServiceMonitorClassID;

    public RendezvousServiceMetric() {
    }

    private RendezvousServiceMetric(ModuleClassID moduleClassID) {
        this.init(moduleClassID);
    }

    public void init(ModuleClassID moduleClassID) {
        this.moduleClassID = moduleClassID;
    }

    public ModuleClassID getModuleClassID() {
        return this.moduleClassID;
    }

    public RendezvousMetric getRendezvousMetric() {
        return this.rendezvousMetric;
    }

    void setRendezvousMetric(RendezvousMetric rendezvousMetric) {
        this.rendezvousMetric = rendezvousMetric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientConnectionMetric(ClientConnectionMetric clientConnectionMetric) {
        LinkedList linkedList = this.clientConnectionMetrics;
        synchronized (linkedList) {
            this.clientConnectionMetrics.add(clientConnectionMetric);
        }
    }

    public Iterator getClientConnectionMetrics() {
        return this.clientConnectionMetrics.iterator();
    }

    void clearClientConnectionMetrics() {
        this.clientConnectionMetrics.clear();
    }

    public ClientConnectionMetric getClientConnectionMetric(PeerID peerId) {
        for (ClientConnectionMetric clientConnectionMetric : this.clientConnectionMetrics) {
            if (!peerId.equals(clientConnectionMetric.getPeerID())) continue;
            return clientConnectionMetric;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRendezvousConnectionMetric(RendezvousConnectionMetric rendezvousConnectionMetric) {
        LinkedList linkedList = this.rendezvousConnectionMetrics;
        synchronized (linkedList) {
            this.rendezvousConnectionMetrics.add(rendezvousConnectionMetric);
        }
    }

    public Iterator getRendezvousConnectionMetrics() {
        return this.rendezvousConnectionMetrics.iterator();
    }

    void clearRendezvousConnectionMetrics() {
        this.rendezvousConnectionMetrics.clear();
    }

    public RendezvousConnectionMetric getRendezvousConnectionMetric(PeerID peerID) {
        for (RendezvousConnectionMetric rendezvousConnectionMetric : this.rendezvousConnectionMetrics) {
            if (!peerID.equals(rendezvousConnectionMetric.getPeerID())) continue;
            return rendezvousConnectionMetric;
        }
        return null;
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        if (this.rendezvousMetric != null) {
            DocumentSerializableUtilities.addDocumentSerializable(element2, "rendezvousMetric", this.rendezvousMetric);
        }
        for (ClientConnectionMetric clientConnectionMetric : this.clientConnectionMetrics) {
            DocumentSerializableUtilities.addDocumentSerializable(element2, "clientConnectionMetric", clientConnectionMetric);
        }
        for (RendezvousConnectionMetric rendezvousConnectionMetric : this.rendezvousConnectionMetrics) {
            DocumentSerializableUtilities.addDocumentSerializable(element2, "rendezvousConnectionMetric", rendezvousConnectionMetric);
        }
        if (this.moduleClassID != null) {
            DocumentSerializableUtilities.addString(element2, "moduleClassID", this.moduleClassID.toString());
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("clientConnectionMetric")) {
                ClientConnectionMetric clientConnectionMetric = (ClientConnectionMetric)DocumentSerializableUtilities.getDocumentSerializable((Element)childElement, ClientConnectionMetric.class);
                this.clientConnectionMetrics.add(clientConnectionMetric);
            } else if (tagName.equals("rendezvousConnectionMetric")) {
                RendezvousConnectionMetric rendezvousConnectionMetric = (RendezvousConnectionMetric)DocumentSerializableUtilities.getDocumentSerializable((Element)childElement, RendezvousConnectionMetric.class);
                this.rendezvousConnectionMetrics.add(rendezvousConnectionMetric);
            } else if (tagName.equals("rendezvousMetric")) {
                this.rendezvousMetric = (RendezvousMetric)DocumentSerializableUtilities.getDocumentSerializable((Element)childElement, RendezvousMetric.class);
            }
            if (!tagName.equals("moduleClassID")) continue;
            try {
                this.moduleClassID = (ModuleClassID)IDFactory.fromURI(new URI(DocumentSerializableUtilities.getString(childElement)));
            }
            catch (URISyntaxException jex) {
                throw new DocumentSerializationException("Can't read moduleClassID", jex);
            }
        }
    }

    public void mergeMetrics(ServiceMetric otherServiceMetric) {
        this.mergeMetrics(otherServiceMetric, true, true, true);
    }

    public RendezvousServiceMetric deepCopy(RendezvousServiceMonitorFilter rendezvousServiceMonitorFilter) {
        RendezvousServiceMetric serviceMetric = new RendezvousServiceMetric();
        serviceMetric.moduleClassID = this.moduleClassID;
        serviceMetric.mergeMetrics(this, true, rendezvousServiceMonitorFilter.isIncludeClientConnectionMetrics(), rendezvousServiceMonitorFilter.isIncludeRendezvousConnectionMetrics());
        return serviceMetric;
    }

    public void mergeMetrics(ServiceMetric otherServiceMetric, boolean includeRendezvousMetric, boolean includeClientConnectionMetrics, boolean includeRendezvousConnectionMetrics) {
        Iterator i;
        RendezvousServiceMetric otherRendezvousServiceMetric = (RendezvousServiceMetric)otherServiceMetric;
        if (includeRendezvousMetric) {
            RendezvousMetric otherRendezvousMetric = otherRendezvousServiceMetric.getRendezvousMetric();
            if (this.rendezvousMetric == null && otherRendezvousMetric != null) {
                this.rendezvousMetric = new RendezvousMetric(otherRendezvousMetric);
            }
            if (otherRendezvousMetric != null) {
                this.rendezvousMetric.mergeMetrics(otherRendezvousMetric);
            }
        }
        if (includeClientConnectionMetrics) {
            i = otherRendezvousServiceMetric.getClientConnectionMetrics();
            while (i.hasNext()) {
                ClientConnectionMetric otherClientConnectionMetric = (ClientConnectionMetric)i.next();
                ClientConnectionMetric clientConnectionMetric = this.getClientConnectionMetric(otherClientConnectionMetric.getPeerID());
                if (clientConnectionMetric == null) {
                    clientConnectionMetric = new ClientConnectionMetric(otherClientConnectionMetric);
                    this.addClientConnectionMetric(clientConnectionMetric);
                }
                clientConnectionMetric.mergeMetrics(otherClientConnectionMetric);
            }
        }
        if (includeRendezvousConnectionMetrics) {
            i = otherRendezvousServiceMetric.getRendezvousConnectionMetrics();
            while (i.hasNext()) {
                RendezvousConnectionMetric otherRendezvousConnectionMetric = (RendezvousConnectionMetric)i.next();
                RendezvousConnectionMetric rendezvousConnectionMetric = this.getRendezvousConnectionMetric(otherRendezvousConnectionMetric.getPeerID());
                if (rendezvousConnectionMetric == null) {
                    rendezvousConnectionMetric = new RendezvousConnectionMetric(otherRendezvousConnectionMetric);
                    this.addRendezvousConnectionMetric(rendezvousConnectionMetric);
                }
                rendezvousConnectionMetric.mergeMetrics(otherRendezvousConnectionMetric);
            }
        }
    }

    public void diffMetrics(ServiceMetric otherOne) {
        throw new RuntimeException("Not Supported");
    }

    public RendezvousServiceMetric shallowCopy(RendezvousServiceMonitorFilter rendezvousServiceMonitorFilter) {
        Iterator i;
        RendezvousServiceMetric rendezvousServiceMetric = new RendezvousServiceMetric(this.moduleClassID);
        rendezvousServiceMetric.rendezvousMetric = this.rendezvousMetric;
        if (rendezvousServiceMonitorFilter.isIncludeClientConnectionMetrics()) {
            i = this.getClientConnectionMetrics();
            while (i.hasNext()) {
                ClientConnectionMetric clientConnectionMetric = (ClientConnectionMetric)i.next();
                rendezvousServiceMetric.addClientConnectionMetric(clientConnectionMetric);
            }
        }
        if (rendezvousServiceMonitorFilter.isIncludeRendezvousConnectionMetrics()) {
            i = this.getRendezvousConnectionMetrics();
            while (i.hasNext()) {
                RendezvousConnectionMetric rendezvousConnectionMetric = (RendezvousConnectionMetric)i.next();
                rendezvousServiceMetric.addRendezvousConnectionMetric(rendezvousConnectionMetric);
            }
        }
        return rendezvousServiceMetric;
    }
}

