/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rendezvousMeter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
import net.jxta.meter.MonitorResources;
import net.jxta.meter.ServiceMonitorFilter;
import net.jxta.platform.ModuleClassID;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class RendezvousServiceMonitorFilter
implements ServiceMonitorFilter {
    private boolean includeClientConnectionMetrics = true;
    private boolean includeRendezvousConnectionMetrics = true;
    private ModuleClassID moduleClassID = MonitorResources.rendezvousServiceMonitorClassID;

    public ModuleClassID getModuleClassID() {
        return this.moduleClassID;
    }

    public void init(ModuleClassID moduleClassID) {
        this.moduleClassID = moduleClassID;
    }

    public boolean isIncludeClientConnectionMetrics() {
        return this.includeClientConnectionMetrics;
    }

    public boolean isIncludeRendezvousConnectionMetrics() {
        return this.includeRendezvousConnectionMetrics;
    }

    public void setIncludeClientConnectionMetrics(boolean includeClientConnectionMetrics) {
        this.includeClientConnectionMetrics = includeClientConnectionMetrics;
    }

    public void setIncludeRendezvousConnectionMetrics(boolean includeClientConnectionMetrics) {
        this.includeRendezvousConnectionMetrics = includeClientConnectionMetrics;
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        DocumentSerializableUtilities.addBoolean(element2, "includeClientConnectionMetrics", this.includeClientConnectionMetrics);
        DocumentSerializableUtilities.addBoolean(element2, "includeRendezvousConnectionMetrics", this.includeRendezvousConnectionMetrics);
        if (this.moduleClassID != null) {
            DocumentSerializableUtilities.addString(element2, "moduleClassID", this.moduleClassID.toString());
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("includeClientConnectionMetrics")) {
                this.includeClientConnectionMetrics = DocumentSerializableUtilities.getBoolean(childElement);
                continue;
            }
            if (tagName.equals("includeRendezvousConnectionMetrics")) {
                this.includeRendezvousConnectionMetrics = DocumentSerializableUtilities.getBoolean(childElement);
                continue;
            }
            if (!tagName.equals("moduleClassID")) continue;
            try {
                this.moduleClassID = (ModuleClassID)IDFactory.fromURI(new URI(DocumentSerializableUtilities.getString(childElement)));
            }
            catch (URISyntaxException jex) {
                throw new DocumentSerializationException("Can't read moduleClassID", jex);
            }
        }
    }
}

