/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.util.HashMap;
import java.util.Map;
import net.jxta.impl.util.CacheEntry;
import net.jxta.impl.util.CacheEntryListener;
import net.jxta.impl.util.Dlink;
import net.jxta.impl.util.Dlist;

public class Cache {
    private final long maxSize;
    private long size;
    private final Map map = new HashMap();
    private final Dlist lru = new Dlist();
    private final CacheEntryListener listener;

    public Cache(long maxSize, CacheEntryListener listener) {
        this.maxSize = maxSize;
        this.size = 0L;
        this.listener = listener;
    }

    public void clear() {
        this.lru.clear();
        this.map.clear();
    }

    public void purge(int fraction) {
        long nbToPurge;
        if (this.size == 0L) {
            return;
        }
        if (fraction == 0) {
            fraction = 1;
        }
        if ((nbToPurge = this.size / (long)fraction) == 0L) {
            nbToPurge = 1L;
        }
        while (nbToPurge-- > 0L) {
            CacheEntryImpl toRm = (CacheEntryImpl)this.lru.next();
            this.map.remove(toRm.getKey());
            toRm.unlink();
            --this.size;
            if (this.listener == null) continue;
            this.listener.purged(toRm);
        }
    }

    protected CacheEntry putCacheEntry(Object key, CacheEntry value) {
        if (this.size == this.maxSize) {
            CacheEntryImpl toRm = (CacheEntryImpl)this.lru.next();
            this.map.remove(toRm.getKey());
            toRm.unlink();
            --this.size;
            if (this.listener != null) {
                this.listener.purged(toRm);
            }
        }
        this.lru.putLast((CacheEntryImpl)value);
        ++this.size;
        CacheEntryImpl oldEntry = (CacheEntryImpl)this.map.put(key, value);
        if (oldEntry == null) {
            return null;
        }
        if (oldEntry.isLinked()) {
            oldEntry.unlink();
            --this.size;
        }
        return oldEntry;
    }

    public Object put(Object key, Object value) {
        CacheEntry oldEntry = this.putCacheEntry(key, new CacheEntryImpl(key, value));
        if (oldEntry == null) {
            return null;
        }
        return oldEntry.getValue();
    }

    protected CacheEntry removeCacheEntry(Object key) {
        CacheEntryImpl oldEntry = (CacheEntryImpl)this.map.remove(key);
        if (oldEntry == null) {
            return null;
        }
        if (oldEntry.isLinked()) {
            oldEntry.unlink();
            --this.size;
        }
        return oldEntry;
    }

    public Object remove(Object key) {
        CacheEntry oldEntry = this.removeCacheEntry(key);
        if (oldEntry == null) {
            return null;
        }
        return oldEntry.getValue();
    }

    public CacheEntry getCacheEntry(Object key) {
        CacheEntryImpl foundEntry = (CacheEntryImpl)this.map.get(key);
        if (foundEntry == null) {
            return null;
        }
        if (foundEntry.isLinked()) {
            this.lru.putLast(foundEntry);
        }
        return foundEntry;
    }

    public Object get(Object key) {
        CacheEntry foundEntry = this.getCacheEntry(key);
        if (foundEntry == null) {
            return null;
        }
        return foundEntry.getValue();
    }

    public void stickyCacheEntry(CacheEntry ce, boolean sticky) {
        CacheEntryImpl target = (CacheEntryImpl)ce;
        if (sticky) {
            if (!target.isLinked()) {
                return;
            }
            target.unlink();
            --this.size;
        } else {
            if (target.isLinked()) {
                return;
            }
            if (this.size == this.maxSize) {
                CacheEntryImpl toRm = (CacheEntryImpl)this.lru.next();
                this.map.remove(toRm.getKey());
                toRm.unlink();
                if (this.listener != null) {
                    this.listener.purged(toRm);
                }
                --this.size;
            }
            this.lru.putLast(target);
            ++this.size;
        }
    }

    public void sticky(Object key, boolean sticky) {
        CacheEntry foundEntry = (CacheEntry)this.map.get(key);
        if (foundEntry == null) {
            return;
        }
        this.stickyCacheEntry(foundEntry, sticky);
    }

    class CacheEntryImpl
    extends Dlink
    implements CacheEntry {
        private final Object value;
        private final Object key;

        public CacheEntryImpl(Object k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

