/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.id.ID;
import net.jxta.peer.PeerID;
import net.jxta.pipe.PipeID;
import net.jxta.protocol.PeerAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PipeResolverMessage {
    private MessageType msgType = null;
    private ID pipeid = ID.nullID;
    private String pipeType = null;
    private Set<ID> peerids = new HashSet<ID>();
    private boolean found = true;
    private PeerAdvertisement inputPeerAdv = null;

    public static String getMessageType() {
        return "jxta:PipeResolver";
    }

    public abstract Document getDocument(MimeMediaType var1);

    public MessageType getMsgType() {
        return this.msgType;
    }

    public void setMsgType(MessageType type) {
        this.msgType = type;
    }

    public ID getPipeID() {
        return this.pipeid;
    }

    public void setPipeID(ID id) {
        if (!(id instanceof PipeID)) {
            throw new IllegalArgumentException("can only set to pipe ids.");
        }
        this.pipeid = id;
    }

    public String getPipeType() {
        return this.pipeType;
    }

    public void setPipeType(String type) {
        this.pipeType = type;
    }

    public Set<ID> getPeerIDs() {
        return Collections.unmodifiableSet(this.peerids);
    }

    public void addPeerID(ID id) {
        if (!(id instanceof PeerID)) {
            throw new IllegalArgumentException("can only add peer ids");
        }
        this.peerids.add(id);
    }

    public boolean isFound() {
        return this.found;
    }

    public void setFound(boolean isFound) {
        this.found = isFound;
    }

    public PeerAdvertisement getInputPeerAdv() {
        return this.inputPeerAdv;
    }

    public void setInputPeerAdv(PeerAdvertisement peerAdv) {
        this.inputPeerAdv = peerAdv;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageType {
        QUERY,
        ANSWER;

    }
}

