/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassFactory<K, I> {
    private static final transient Logger LOG = Logger.getLogger(ClassFactory.class.getName());

    protected ClassFactory() {
    }

    protected abstract Map<K, I> getAssocTable();

    protected abstract Class<K> getClassForKey();

    public Iterator<K> getAvailableKeys() {
        return Collections.unmodifiableSet(this.getAssocTable().keySet()).iterator();
    }

    public Set<Map.Entry<K, I>> getEntrySet() {
        return Collections.unmodifiableSet(this.getAssocTable().entrySet());
    }

    protected abstract Class<I> getClassOfInstantiators();

    protected boolean registerFromResources(String resourceName, String propertyName) throws MissingResourceException {
        ResourceBundle jxtaRsrcs = ResourceBundle.getBundle(resourceName);
        String fromProps = jxtaRsrcs.getString(propertyName).trim();
        return this.registerFromString(fromProps);
    }

    protected boolean registerFromString(String classNamesString) {
        boolean registeredSomething = false;
        if (null == classNamesString || 0 == classNamesString.length()) {
            return false;
        }
        List<String> instanceClasses = Arrays.asList(classNamesString.split("\\s"));
        for (String eachInstanceClass : instanceClasses) {
            try {
                registeredSomething |= this.registerAssoc(eachInstanceClass);
            }
            catch (Exception allElse) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Failed to register '" + eachInstanceClass + "'", allElse);
            }
        }
        return registeredSomething;
    }

    protected boolean registerProviders(String interfaceName) {
        boolean registeredSomething;
        block5: {
            ClassLoader loader = this.getClass().getClassLoader();
            registeredSomething = false;
            try {
                Enumeration<URL> providerLists = loader.getResources("META-INF/services/" + interfaceName);
                while (providerLists.hasMoreElements()) {
                    try {
                        URI providerList = providerLists.nextElement().toURI();
                        registeredSomething |= this.registerFromFile(providerList);
                    }
                    catch (URISyntaxException badURI) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                        LOG.log(Level.WARNING, "Failed to convert service URI", badURI);
                    }
                }
            }
            catch (IOException ex) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block5;
                LOG.log(Level.WARNING, "Failed to locate provider lists", ex);
            }
        }
        return registeredSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean registerFromFile(URI providerList) {
        boolean registeredSomething = false;
        InputStream urlStream = null;
        try {
            String provider;
            urlStream = providerList.toURL().openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlStream, "UTF-8"));
            while ((provider = reader.readLine()) != null) {
                int comment = provider.indexOf(35);
                if (comment != -1) {
                    provider = provider.substring(0, comment);
                }
                if ((provider = provider.trim()).length() <= 0) continue;
                try {
                    registeredSomething |= this.registerAssoc(provider);
                }
                catch (Exception allElse) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Failed to register '" + provider + "'", allElse);
                }
            }
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Failed to read provider list " + providerList, ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != urlStream) {
                try {
                    urlStream.close();
                }
                catch (IOException ignored) {}
            }
        }
        return registeredSomething;
    }

    protected boolean registerAssoc(String className) throws Exception {
        boolean registeredSomething;
        block4: {
            registeredSomething = false;
            try {
                Class<?> ignored = Class.forName(className);
                registeredSomething = true;
            }
            catch (ClassNotFoundException ignored) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Failed to locate '" + className + "'");
                }
            }
            catch (NoClassDefFoundError ignored) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block4;
                LOG.warning("Failed to locate '" + className + "'");
            }
        }
        return registeredSomething;
    }

    protected boolean registerAssoc(K key, I instantiator) {
        if (null != this.getAssocTable().get(key)) {
            return false;
        }
        this.getAssocTable().put(key, instantiator);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Factory : " + this.getClass().getName() + " Registered instantiator '" + instantiator + "' for '" + key + "'");
        }
        return true;
    }

    protected I getInstantiator(K key) throws NoSuchElementException {
        I instantiator = this.getAssocTable().get(key);
        if (null == instantiator) {
            throw new NoSuchElementException("key '" + key + "' not registered.");
        }
        return instantiator;
    }
}

