/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.logging.Logging;

public class LimitInputStream
extends FilterInputStream {
    private static final Logger LOG = Logger.getLogger(LimitInputStream.class.getName());
    private transient long limit;
    private transient long read;
    private transient long mark;
    private transient boolean fatalUnderflow;
    private transient boolean alreadycounting;

    public LimitInputStream(InputStream in, long limit) {
        this(in, limit, false);
    }

    public LimitInputStream(InputStream in, long limit, boolean underflowThrows) {
        super(in);
        this.limit = limit;
        this.mark = -1L;
        this.read = 0L;
        this.fatalUnderflow = underflowThrows;
        this.alreadycounting = false;
    }

    public String toString() {
        if (null == this.in) {
            return "closed/" + super.toString();
        }
        if (this.in instanceof ByteArrayInputStream) {
            return this.in.getClass().getName() + "@" + System.identityHashCode(this.in) + "/" + super.toString() + ":" + this.read + "-" + this.limit;
        }
        return this.in.toString() + "/" + super.toString() + ":" + this.read + "-" + this.limit;
    }

    public void close() throws IOException {
        this.in = null;
    }

    public int available() throws IOException {
        if (null == this.in) {
            throw new IOException("Stream has been closed.");
        }
        return (int)Math.min((long)super.available(), this.limit - this.read);
    }

    public void mark(int readlimit) {
        if (null == this.in) {
            return;
        }
        super.mark(readlimit);
        this.mark = this.read;
    }

    public void reset() throws IOException {
        if (null == this.in) {
            throw new IOException("Stream has been closed.");
        }
        if (-1L == this.mark) {
            throw new IOException("reset() without mark(), or I dont know where mark is");
        }
        super.reset();
        this.read = this.mark;
    }

    public synchronized long skip(long n) throws IOException {
        if (null == this.in) {
            throw new IOException("Stream has been closed.");
        }
        long skipLen = Math.min(n, this.limit - this.read);
        boolean wascounting = this.alreadycounting;
        this.alreadycounting = true;
        long result = super.skip(skipLen);
        this.alreadycounting = wascounting;
        if (-1L != result && !this.alreadycounting) {
            this.read += result;
        }
        return result;
    }

    public synchronized int read() throws IOException {
        if (null == this.in) {
            throw new IOException("Stream has been closed.");
        }
        if (this.read >= this.limit) {
            return -1;
        }
        boolean wascounting = this.alreadycounting;
        this.alreadycounting = true;
        int result = super.read();
        this.alreadycounting = wascounting;
        if (!this.alreadycounting) {
            if (-1 != result) {
                ++this.read;
            } else if (this.fatalUnderflow && this.read != this.limit) {
                IOException failed = new IOException("Underflow in read, stream EOFed at " + this.read + " before limit of " + this.limit);
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, failed.getMessage(), failed);
                }
                throw failed;
            }
        }
        return result;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (null == this.in) {
            throw new IOException("Stream has been closed.");
        }
        if (this.read >= this.limit) {
            return -1;
        }
        int readLen = (int)Math.min((long)len, this.limit - this.read);
        boolean wascounting = this.alreadycounting;
        this.alreadycounting = true;
        int result = super.read(b, off, readLen);
        this.alreadycounting = wascounting;
        if (!this.alreadycounting) {
            if (-1 != result) {
                this.read += (long)result;
            } else if (this.fatalUnderflow && this.read != this.limit) {
                IOException failed = new IOException("Underflow while tring to read " + readLen + ", stream EOFed at " + this.read + " before limit of " + this.limit);
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, failed.getMessage(), failed);
                }
                throw failed;
            }
        }
        return result;
    }
}

