/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.net.URI;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.exception.JxtaException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.PipeID;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.util.DocumentUtilities;

public final class PipeUtilities {
    private PipeUtilities() {
    }

    public static PipeAdvertisement createPipeAdvertisement() {
        return (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
    }

    public static PipeAdvertisement createPipeAdvertisement(PipeID pipeId, String pipeType) {
        PipeAdvertisement pipeAdvertisement = PipeUtilities.createPipeAdvertisement();
        pipeAdvertisement.setPipeID(pipeId);
        pipeAdvertisement.setType(pipeType);
        return pipeAdvertisement;
    }

    public static PipeAdvertisement createPipeAdvertisement(String pipeIdText, String pipeType) throws JxtaException {
        PipeID pipeId = (PipeID)ID.create(URI.create(pipeIdText));
        PipeAdvertisement pipeAdvertisement = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        pipeAdvertisement.setPipeID(pipeId);
        pipeAdvertisement.setType(pipeType);
        return pipeAdvertisement;
    }

    public static PipeAdvertisement createPipeAdvertisement(Element root) {
        TextElement pipeAdvElement = (TextElement)DocumentUtilities.getChild(root, PipeAdvertisement.getAdvertisementType());
        if (pipeAdvElement == null) {
            return null;
        }
        return (PipeAdvertisement)AdvertisementFactory.newAdvertisement(pipeAdvElement);
    }

    public static PipeAdvertisement createNewPipeAdvertisement(PeerGroup peerGroup, String pipeType) {
        PipeAdvertisement pipeAdvertisement = PipeUtilities.createPipeAdvertisement();
        PipeID pipeID = IDFactory.newPipeID(peerGroup.getPeerGroupID());
        pipeAdvertisement.setPipeID(pipeID);
        pipeAdvertisement.setType(pipeType);
        return pipeAdvertisement;
    }
}

