/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.ServiceLifecycle;
import com.sun.jbi.ServiceUnitRegistration;
import com.sun.jbi.framework.Component;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.FrameworkStatistics;
import com.sun.jbi.framework.ServiceUnit;
import com.sun.jbi.framework.SharedLibrary;
import com.sun.jbi.framework.StringTranslator;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.Updater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.jbi.JBIException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRegistry
implements ServiceLifecycle,
ServiceUnitRegistration {
    private EnvironmentContext mContext;
    private Boolean mStarted = null;
    private HashMap mComponentCache;
    private HashMap mSharedLibraryCache;
    private Logger mLog;
    private FrameworkStatistics mStats;
    private StringTranslator mTranslator;
    private ComponentQuery mComponentQuery;
    private Updater mRegistryUpdater;

    @Override
    public void initService(com.sun.jbi.EnvironmentContext context) throws JBIException {
        this.mContext = (EnvironmentContext)context;
        this.mTranslator = (StringTranslator)context.getStringTranslatorFor(this);
        if (null != this.mStarted) {
            throw new IllegalStateException(this.mTranslator.getString("SERVICE_ALREADY_INITIALIZED", this.mTranslator.getString("CR_NAME")));
        }
        this.mStarted = Boolean.FALSE;
        this.mComponentCache = new HashMap();
        this.mSharedLibraryCache = new HashMap();
        this.mStats = this.mContext.getFrameworkStatistics();
        this.mLog = this.mContext.getLogger();
        this.mLog.fine(this.mTranslator.getString("SERVICE_INITIALIZED", this.mTranslator.getString("CR_NAME")));
    }

    @Override
    public void startService() throws JBIException {
        if (this.mStarted.booleanValue()) {
            throw new IllegalStateException(this.mTranslator.getString("SERVICE_ALREADY_STARTED", this.mTranslator.getString("CR_NAME")));
        }
        this.mComponentQuery = ((Registry)this.mContext.getJustRegistry()).getComponentQuery();
        this.mRegistryUpdater = ((Registry)this.mContext.getJustRegistry()).getUpdater();
        this.reloadRegistry();
        this.mStarted = Boolean.TRUE;
        this.mLog.fine(this.mTranslator.getString("SERVICE_STARTED", this.mTranslator.getString("CR_NAME")));
    }

    @Override
    public void stopService() throws JBIException {
        if (!this.mStarted.booleanValue()) {
            throw new IllegalStateException(this.mTranslator.getString("SERVICE_ALREADY_STOPPED", this.mTranslator.getString("CR_NAME")));
        }
        this.mStarted = null;
        this.mContext = null;
        this.mComponentCache = null;
        this.mSharedLibraryCache = null;
        this.mStats = null;
        this.mComponentQuery = null;
        this.mRegistryUpdater = null;
        this.mLog.fine(this.mTranslator.getString("SERVICE_STOPPED", this.mTranslator.getString("CR_NAME")));
        this.mLog = null;
        this.mTranslator = null;
    }

    @Override
    public boolean isServiceUnitRegistered(String componentName, String serviceUnitName) throws JBIException {
        if (null == serviceUnitName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceUnitName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (null == componentName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "componentName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        Component comp = this.getComponent(componentName);
        if (null != comp) {
            return comp.isServiceUnitRegistered(serviceUnitName);
        }
        String msg = this.mTranslator.getString("CR_COMPONENT_NOT_REGISTERED", componentName);
        this.mLog.warning(msg);
        throw new JBIException(msg);
    }

    @Override
    public synchronized void registerServiceUnit(String componentName, String serviceAssemblyName, String serviceUnitName, String serviceUnitFilePath) throws JBIException {
        if (null == componentName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "componentName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (null == serviceAssemblyName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceAssemblyName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (null == serviceUnitName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceUnitName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (null == serviceUnitFilePath) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceUnitFilePath");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        Component comp = this.getComponent(componentName);
        if (null == comp) {
            String msg = this.mTranslator.getString("CR_COMPONENT_NOT_REGISTERED", componentName);
            this.mLog.warning(msg);
            throw new JBIException(msg);
        }
        ServiceUnit su = new ServiceUnit(serviceAssemblyName, serviceUnitName, serviceUnitFilePath, componentName);
        this.mRegistryUpdater.addServiceUnitToComponent(componentName, su);
        comp.addServiceUnit(su);
    }

    @Override
    public void unregisterServiceUnit(String componentName, String serviceUnitName) throws JBIException {
        if (null == componentName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "componentName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (null == serviceUnitName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "serviceUnitName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        Component comp = this.getComponent(componentName);
        if (null == comp) {
            String msg = this.mTranslator.getString("CR_COMPONENT_NOT_REGISTERED", componentName);
            this.mLog.warning(msg);
            throw new JBIException(msg);
        }
        this.mRegistryUpdater.removeServiceUnitFromComponent(componentName, serviceUnitName);
        comp.removeServiceUnit(serviceUnitName);
    }

    void commitComponent(String componentName) throws JBIException {
        if (null == componentName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "componentName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.mLog.finer("Permanently registering component " + componentName);
        Component component = this.getComponent(componentName);
        if (null == component) {
            String msg = this.mTranslator.getString("CR_PERMANENT_REGISTRATION_NOT_FOUND", componentName);
            this.mLog.warning(msg);
            throw new JBIException(msg);
        }
        List registeredComps = this.mComponentQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        if (registeredComps.contains(component.getName())) {
            String msg = this.mTranslator.getString("CR_COMPONENT_ALREADY_REGISTERED", component.getName());
            this.mLog.warning(msg);
            throw new JBIException(msg);
        }
        this.mRegistryUpdater.addComponent(component);
        this.mLog.fine("Component " + component.getName() + " registered");
    }

    List getAllComponents() {
        return new ArrayList(this.mComponentCache.values());
    }

    List getAllSharedLibraries() {
        return new ArrayList(this.mSharedLibraryCache.values());
    }

    Component getComponent(String componentName) {
        if (null == componentName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "componentName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.mLog.finest("Looking up component " + componentName + " in cache");
        Component theComponent = (Component)this.mComponentCache.get(componentName);
        if (null != theComponent) {
            this.mLog.finest("Component " + componentName + " found in cache");
        } else {
            this.mLog.finest("Component " + componentName + " not found in cache");
        }
        return theComponent;
    }

    List<String> getComponentIdsFromCache(ComponentType type, ComponentState status) {
        Collection values;
        ArrayList<String> ids = new ArrayList<String>();
        if (ComponentType.SHARED_LIBRARY != type) {
            values = this.mComponentCache.values();
            block5: for (Component comp : values) {
                ComponentType ct = comp.getComponentType();
                switch (type) {
                    case ALL: {
                        break;
                    }
                    case BINDINGS_AND_ENGINES: {
                        if (ct == ComponentType.BINDING || ct == ComponentType.ENGINE) break;
                        continue block5;
                    }
                    case BINDING: 
                    case ENGINE: {
                        if (ct == type) break;
                        continue block5;
                    }
                }
                if (null != status && status != comp.getStatus()) continue;
                ids.add(comp.getName());
            }
        }
        if (ComponentType.ALL == type || ComponentType.SHARED_LIBRARY == type) {
            values = this.mSharedLibraryCache.values();
            for (SharedLibrary sl : values) {
                if (null != status && status != sl.getStatus()) continue;
                ids.add(sl.getName());
            }
        }
        return ids;
    }

    List getDependents(String sharedLibraryName) {
        boolean isDependent = false;
        List depList = this.getAllComponents();
        Iterator d = depList.iterator();
        Component comp = null;
        while (d.hasNext()) {
            comp = (Component)d.next();
            List<String> sharedLibraryList = comp.getSharedLibraryNames();
            if (null == sharedLibraryList) {
                d.remove();
                continue;
            }
            Iterator<String> s = sharedLibraryList.iterator();
            String sl = null;
            while (s.hasNext()) {
                sl = s.next();
                if (!sl.equals(sharedLibraryName)) continue;
                isDependent = true;
                break;
            }
            if (!isDependent) {
                d.remove();
                continue;
            }
            isDependent = false;
        }
        return depList;
    }

    SharedLibrary getSharedLibrary(String sharedLibraryName) {
        if (null == sharedLibraryName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "sharedLibraryName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.mLog.finer("Looking up Shared Library " + sharedLibraryName + " in cache");
        SharedLibrary sl = (SharedLibrary)this.mSharedLibraryCache.get(sharedLibraryName);
        if (null != sl) {
            this.mLog.finer("Shared Library " + sharedLibraryName + " found in cache");
        } else {
            this.mLog.finer("Shared Library " + sharedLibraryName + " not found in cache");
        }
        return sl;
    }

    public ComponentState getStatus(String componentName) throws JBIException {
        Component comp = this.getComponent(componentName);
        if (null != comp) {
            return comp.getStatus();
        }
        String msg = this.mTranslator.getString("CR_COMPONENT_NOT_REGISTERED", componentName);
        this.mLog.warning(msg);
        throw new JBIException(msg);
    }

    boolean isComponentRegistered(String componentName) throws JBIException {
        if (null == componentName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "componentName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (this.mComponentCache.containsKey(componentName)) {
            this.mLog.finest("Component " + componentName + " is registered");
            return true;
        }
        this.mLog.finest("Component " + componentName + " is not registered");
        return false;
    }

    boolean isSharedLibraryRegistered(String sharedLibraryName) throws JBIException {
        if (null == sharedLibraryName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "sharedLibraryName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (this.mSharedLibraryCache.containsKey(sharedLibraryName)) {
            this.mLog.finest("Shared Library " + sharedLibraryName + " is registered");
            return true;
        }
        this.mLog.finest("Shared Library " + sharedLibraryName + " is not registered");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerComponent(Component component) throws JBIException {
        if (null == component) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "component");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.mLog.finer("Registering new component " + component.getName() + " in cache");
        HashMap hashMap = this.mComponentCache;
        synchronized (hashMap) {
            if (this.mComponentCache.containsKey(component.getName())) {
                String msg = this.mTranslator.getString("CR_COMPONENT_ALREADY_REGISTERED", component.getName());
                this.mLog.warning(msg);
                throw new JBIException(msg);
            }
            this.mComponentCache.put(component.getName(), component);
            this.mStats.incrementRegistryAdds();
            this.mLog.fine("Component " + component.getName() + " registered in cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSharedLibrary(SharedLibrary sharedLib) throws JBIException {
        if (null == sharedLib) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "sharedLib");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.mLog.finer("Registering new Shared Library " + sharedLib.getName() + " in cache");
        List installedSLs = this.mComponentQuery.getComponentIds(ComponentType.SHARED_LIBRARY);
        if (!installedSLs.contains(sharedLib.getName())) {
            HashMap hashMap = this.mSharedLibraryCache;
            synchronized (hashMap) {
                if (this.mSharedLibraryCache.containsKey(sharedLib.getName())) {
                    String msg = this.mTranslator.getString("CR_SL_ALREADY_REGISTERED", sharedLib.getName());
                    this.mLog.warning(msg);
                    throw new JBIException(msg);
                }
                this.mSharedLibraryCache.put(sharedLib.getName(), sharedLib);
            }
        } else {
            String msg = this.mTranslator.getString("CR_SL_ALREADY_REGISTERED", sharedLib.getName());
            this.mLog.warning(msg);
            throw new JBIException(msg);
        }
        this.mRegistryUpdater.addSharedLibrary(sharedLib);
        this.mStats.incrementRegistryAdds();
        this.mLog.fine("Shared Library " + sharedLib.getName() + " registered in cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeComponent(String componentName) throws JBIException {
        if (null == componentName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "componentName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        HashMap hashMap = this.mComponentCache;
        synchronized (hashMap) {
            this.mComponentCache.remove(componentName);
        }
        this.mRegistryUpdater.removeComponent(componentName);
        this.mStats.incrementRegistryDeletes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterComponent(String componentName) throws JBIException {
        if (null == componentName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "componentName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.mLog.finer("Unregistering component " + componentName);
        HashMap hashMap = this.mComponentCache;
        synchronized (hashMap) {
            if (!this.mComponentCache.containsKey(componentName)) {
                String msg = this.mTranslator.getString("CR_COMPONENT_NOT_REGISTERED", componentName);
                this.mLog.warning(msg);
                throw new JBIException(msg);
            }
            this.mComponentCache.remove(componentName);
            this.mRegistryUpdater.removeComponent(componentName);
            this.mStats.incrementRegistryDeletes();
            this.mLog.fine("Component " + componentName + " unregistered");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterSharedLibrary(String sharedLibraryName) throws JBIException {
        if (null == sharedLibraryName) {
            String msg = this.mTranslator.getString("NULL_ARGUMENT", "sharedLibraryName");
            this.mLog.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.mLog.fine("Unregistering Shared Library " + sharedLibraryName);
        HashMap hashMap = this.mSharedLibraryCache;
        synchronized (hashMap) {
            if (!this.mSharedLibraryCache.containsKey(sharedLibraryName)) {
                String msg = this.mTranslator.getString("CR_SL_NOT_REGISTERED", sharedLibraryName);
                this.mLog.warning(msg);
                throw new JBIException(msg);
            }
            this.mSharedLibraryCache.remove(sharedLibraryName);
            this.mRegistryUpdater.removeSharedLibrary(sharedLibraryName);
            this.mStats.incrementRegistryDeletes();
            this.mLog.fine("Shared Library " + sharedLibraryName + " unregistered");
        }
    }

    private synchronized void reloadRegistry() throws JBIException {
        List compList = this.mComponentQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        block6: for (String compName : compList) {
            ComponentInfo info = this.mComponentQuery.getComponentInfo(compName);
            String id = info.getName();
            switch (info.getComponentType()) {
                case BINDING: 
                case ENGINE: {
                    Component comp = new Component(info);
                    this.mComponentCache.put(id, comp);
                    this.mStats.incrementRegistryAdds();
                    this.mLog.finer(comp.getComponentTypeAsString() + " " + id + " restored to cache");
                    continue block6;
                }
            }
            this.mLog.warning(this.mTranslator.getString("CR_RELOAD_BAD_COMPONENT_TYPE", info.getComponentType().toString(), id));
        }
        List slList = this.mComponentQuery.getComponentIds(ComponentType.SHARED_LIBRARY);
        block7: for (String slName : slList) {
            ComponentInfo slInfo = this.mComponentQuery.getSharedLibraryInfo(slName);
            String id = slInfo.getName();
            switch (slInfo.getComponentType()) {
                case SHARED_LIBRARY: {
                    SharedLibrary sl = new SharedLibrary(slInfo);
                    this.mSharedLibraryCache.put(id, sl);
                    this.mStats.incrementRegistryAdds();
                    this.mLog.finer("Shared Library " + id + " restored to cache");
                    continue block7;
                }
            }
            this.mLog.warning(this.mTranslator.getString("CR_RELOAD_BAD_COMPONENT_TYPE", slInfo.getComponentType().toString(), id));
        }
    }
}

