/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.StringTranslator;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryBuilder;
import com.sun.jbi.management.registry.RegistrySpecImpl;
import com.sun.jbi.management.registry.RegistryType;
import com.sun.jbi.management.repository.Repository;
import com.sun.jbi.management.repository.RepositoryException;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.platform.PlatformContext;
import com.sun.jbi.util.jmx.MBeanUtils;
import java.io.File;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.naming.InitialContext;

public class JBIFramework {
    private EnvironmentContext mEnvironment;
    private Logger mLog;
    private long mPrepareElapsedTime;
    private long mStartupElapsedTime;
    private long mShutdownElapsedTime;
    private StringTranslator mTranslator;
    private boolean mStartFailed;
    private boolean mCfStarted;
    private boolean mCrStarted;
    private boolean mCsStarted;
    private boolean mMsStarted;
    private boolean mNmsStarted;
    private boolean mMrsStarted;
    private boolean mFrameworkReady;
    private boolean mLazyInit;

    public void init(PlatformContext platformContext, Properties initialProperties) throws JBIException {
        long startTime = System.currentTimeMillis();
        this.mEnvironment = new EnvironmentContext(platformContext, this, initialProperties);
        MBeanUtils.init(platformContext.getMBeanServer());
        this.mLog = this.mEnvironment.getLogger();
        this.mLog.finest("JBIFramework.init entered");
        this.mTranslator = (StringTranslator)this.mEnvironment.getStringTranslator("com.sun.jbi.framework");
        this.mLog.fine(this.mTranslator.getString("JBI_INITIALIZING"));
        this.initRepository();
        boolean initFailed = false;
        String serviceName = null;
        try {
            serviceName = this.mTranslator.getString("CS_NAME");
            this.mEnvironment.getConfigurationService().initService(this.mEnvironment);
            serviceName = this.mTranslator.getString("NMS_NAME");
            this.mEnvironment.getNormalizedMessageService().initService(this.mEnvironment);
            serviceName = this.mTranslator.getString("CR_NAME");
            this.mEnvironment.getComponentRegistry().initService(this.mEnvironment);
            serviceName = this.mTranslator.getString("CF_NAME");
            this.mEnvironment.getComponentFramework().initService(this.mEnvironment);
            serviceName = this.mTranslator.getString("MS_NAME");
            this.mEnvironment.getManagementService().initService(this.mEnvironment);
        }
        catch (Throwable initEx) {
            initFailed = true;
            this.logFailure(serviceName, initEx, "INIT_SERVICE_FAILED");
        }
        if (initFailed) {
            String msg = this.mTranslator.getString("INIT_FRAMEWORK_FAILED");
            this.mLog.severe(msg);
            throw new JBIException(msg);
        }
        this.mLog.fine(this.mTranslator.getString("JBI_INITIALIZED"));
        this.mLog.finest("JBIFramework.init exited");
        this.mStartupElapsedTime = System.currentTimeMillis() - startTime;
    }

    public void startup(InitialContext context, String namingprefix) throws JBIException {
        long startTime = System.currentTimeMillis();
        this.mLog.finest("JBIFramework.startup entered");
        this.mLog.fine(this.mTranslator.getString("JBI_STARTING"));
        this.mEnvironment.setNamingContext(context);
        this.mEnvironment.setNamingPrefix(namingprefix);
        try {
            this.mEnvironment.getMgmtRuntimeService().initService(this.mEnvironment);
        }
        catch (Throwable mrsEx) {
            this.mStartFailed = true;
            this.logFailure(this.mTranslator.getString("MRS_NAME"), mrsEx, "INIT_SERVICE_FAILED");
        }
        if (this.mStartFailed) {
            String msg = this.mTranslator.getString("START_FRAMEWORK_FAILED");
            this.mLog.severe(msg);
            throw new JBIException(msg);
        }
        this.mLog.info(this.mTranslator.getString("JBI_READY"));
        this.mLog.finest("JBIFramework.startup exited");
        this.mStartupElapsedTime += System.currentTimeMillis() - startTime;
    }

    public void prepare() throws JBIException {
        long startTime = System.currentTimeMillis();
        this.mLog.finest("JBIFramework.prepare entered");
        try {
            this.mEnvironment.getComponentRegistry().startService();
            this.mCrStarted = true;
        }
        catch (Throwable crEx) {
            this.mStartFailed = true;
            this.logFailure(this.mTranslator.getString("CR_NAME"), crEx, "START_SERVICE_FAILED");
            String msg = this.mTranslator.getString("INIT_FRAMEWORK_FAILED");
            this.mLog.severe(msg);
            throw new JBIException(msg);
        }
        this.mEnvironment.getComponentFramework().prepare();
        this.mLog.finest("JBIFramework.prepare exited");
        this.mPrepareElapsedTime += System.currentTimeMillis() - startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ready(boolean wait) throws JBIException {
        long startTime = System.currentTimeMillis();
        this.mLog.finest("JBIFramework.ready entered");
        if (this.mStartFailed) {
            return;
        }
        String serviceName = null;
        try {
            serviceName = this.mTranslator.getString("CS_NAME");
            this.mEnvironment.getConfigurationService().startService();
            this.mCsStarted = true;
            serviceName = this.mTranslator.getString("NMS_NAME");
            this.mEnvironment.getNormalizedMessageService().startService();
            this.mNmsStarted = true;
            serviceName = this.mTranslator.getString("CF_NAME");
            this.mEnvironment.getComponentFramework().startService();
            this.mCfStarted = true;
            serviceName = this.mTranslator.getString("MS_NAME");
            this.mEnvironment.getManagementService().startService();
            this.mMsStarted = true;
            serviceName = this.mTranslator.getString("MRS_NAME");
            this.mEnvironment.getMgmtRuntimeService().startService();
            this.mMrsStarted = true;
        }
        catch (Throwable startEx) {
            this.mStartFailed = true;
            this.logFailure(serviceName, startEx, "START_SERVICE_FAILED");
        }
        if (this.mStartFailed) {
            String msg = this.mTranslator.getString("START_FRAMEWORK_FAILED");
            this.mLog.severe(msg);
            throw new JBIException(msg);
        }
        this.mEnvironment.getFrameworkStatistics().setLastRestartTime(new Date());
        this.mEnvironment.getComponentFramework().ready(wait);
        this.mStartupElapsedTime += System.currentTimeMillis() - startTime;
        this.mLog.fine(this.mTranslator.getString("JBI_STARTUP_TIME", new Long(this.mStartupElapsedTime)));
        this.mLog.info(this.mTranslator.getString("JBI_STARTED"));
        this.mLog.finest("JBIFramework.ready exited");
        JBIFramework jBIFramework = this;
        synchronized (jBIFramework) {
            this.mFrameworkReady = true;
            this.notifyAll();
        }
    }

    public void shutdown() throws JBIException {
        long startTime = System.currentTimeMillis();
        this.mLog.finest("JBIFramework.shutdown entered");
        this.mLog.fine(this.mTranslator.getString("JBI_SHUTTING_DOWN"));
        boolean errors = false;
        if (this.mMrsStarted) {
            try {
                this.mEnvironment.getMgmtRuntimeService().stopService();
                this.mMrsStarted = false;
            }
            catch (Throwable mrsEx) {
                errors = true;
                this.logFailure(this.mTranslator.getString("MRS_NAME"), mrsEx, "STOP_SERVICE_FAILED");
            }
        }
        if (this.mCfStarted) {
            try {
                this.mEnvironment.getComponentFramework().stopService();
                this.mCfStarted = false;
            }
            catch (Throwable cfEx) {
                errors = true;
                this.logFailure(this.mTranslator.getString("CF_NAME"), cfEx, "STOP_SERVICE_FAILED");
            }
        }
        if (this.mCrStarted) {
            try {
                this.mEnvironment.getComponentRegistry().stopService();
                this.mCrStarted = false;
            }
            catch (Throwable crEx) {
                errors = true;
                this.logFailure(this.mTranslator.getString("CR_NAME"), crEx, "STOP_SERVICE_FAILED");
            }
        }
        if (this.mNmsStarted) {
            try {
                this.mEnvironment.getNormalizedMessageService().stopService();
                this.mNmsStarted = false;
            }
            catch (Throwable nmsEx) {
                errors = true;
                this.logFailure(this.mTranslator.getString("NMS_NAME"), nmsEx, "STOP_SERVICE_FAILED");
            }
        }
        if (this.mMsStarted) {
            try {
                this.mEnvironment.getManagementService().stopService();
                this.mMsStarted = false;
            }
            catch (Throwable msEx) {
                errors = true;
                this.logFailure(this.mTranslator.getString("MS_NAME"), msEx, "STOP_SERVICE_FAILED");
            }
        }
        if (this.mCsStarted) {
            try {
                this.mEnvironment.getConfigurationService().stopService();
                this.mCsStarted = false;
            }
            catch (Throwable msEx) {
                errors = true;
                this.logFailure(this.mTranslator.getString("CS_NAME"), msEx, "STOP_SERVICE_FAILED");
            }
        }
        if (!errors) {
            this.mLog.fine(this.mTranslator.getString("JBI_SHUT_DOWN"));
        } else {
            this.mLog.warning(this.mTranslator.getString("STOP_FRAMEWORK_FAILED"));
        }
        this.mLog.finest("JBIFramework.shutdown exited");
        this.mShutdownElapsedTime += System.currentTimeMillis() - startTime;
    }

    public void terminate() throws JBIException {
        long startTime = System.currentTimeMillis();
        this.mLog.finest("JBIFramework.terminate entered");
        this.mLog.fine(this.mTranslator.getString("JBI_TERMINATING"));
        this.mEnvironment.destroyInstance();
        this.mLog.info(this.mTranslator.getString("JBI_TERMINATED"));
        this.mLog.finest("JBIFramework.terminate exited");
        this.mShutdownElapsedTime += System.currentTimeMillis() - startTime;
        this.mLog.fine(this.mTranslator.getString("JBI_SHUTDOWN_TIME", new Long(this.mShutdownElapsedTime)));
    }

    public EnvironmentContext getEnvironment() {
        return this.mEnvironment;
    }

    public synchronized void enterLazyMode() {
        this.mLog.fine("JBIFramework: Enter lazy mode...");
        this.mLazyInit = true;
        this.notifyAll();
    }

    public synchronized void frameworkReady() throws RuntimeException {
        while (!this.mFrameworkReady) {
            if (this.mLazyInit) {
                try {
                    this.mLog.fine("JBIFramework: Transition to ready...");
                    this.prepare();
                    this.ready(true);
                    continue;
                }
                catch (Throwable ex) {
                    this.mFrameworkReady = false;
                    ex.printStackTrace();
                    throw new RuntimeException(ex.toString());
                }
                finally {
                    this.notifyAll();
                    continue;
                }
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized boolean isFrameworkReady() {
        return this.mFrameworkReady;
    }

    synchronized void setFrameworkReady() {
        this.mFrameworkReady = true;
    }

    private void logFailure(String service, Throwable ex, String msgKey) {
        String msg = ex.getMessage();
        msg = null != msg ? msg : this.mTranslator.getString("NO_MESSAGE");
        this.mLog.severe(this.mTranslator.getString(msgKey, service, ex.getClass().getName(), msg));
        this.mLog.severe(this.mTranslator.stackTraceToString(ex));
    }

    Registry initRegistry() throws JBIException {
        Registry registry = null;
        String regFolder = this.mEnvironment.getJbiInstanceRoot() + File.separator + "config";
        Properties props = new Properties();
        props.setProperty("com.sun.jbi.registry.folder", regFolder);
        ManagementContext mgmtCtx = new ManagementContext(this.mEnvironment);
        registry = RegistryBuilder.buildRegistry(new RegistrySpecImpl(RegistryType.XML, props, mgmtCtx));
        return registry;
    }

    private void initRepository() throws JBIException {
        try {
            ManagementContext mgmtCtx = new ManagementContext(this.mEnvironment);
            Repository repository = new Repository(mgmtCtx);
            mgmtCtx.setRepository(repository);
        }
        catch (RepositoryException repEx) {
            throw new JBIException((Throwable)((Object)repEx));
        }
    }
}

