/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework.sun;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.JMXConnectorConfig;
import com.sun.enterprise.jbi.AppServerContext;
import com.sun.enterprise.jbi.AppServerContextImpl;
import com.sun.jbi.JBIProvider;
import com.sun.jbi.framework.sun.SunASKeyStoreUtil;
import com.sun.jbi.platform.PlatformContext;
import com.sun.jbi.platform.PlatformEventListener;
import com.sun.jbi.security.KeyStoreUtil;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunASPlatformContext
implements PlatformContext,
NotificationListener {
    private Logger mLog;
    private List<PlatformEventListener> mListeners;
    private MBeanServer mMBeanServer;
    private InitialContext mInitialContext;
    private AppServerContext mASContext = new AppServerContextImpl();
    private KeyStoreUtil mKeyStoreUtil;
    private static final String SERVER = "server";
    private static final String MBS_DELEGATE_NAME = "JMImplementation:type=MBeanServerDelegate";
    private static final String INSTANCE_ROOT_KEY = "com.sun.aas.instanceRoot";
    private static final String INSTALL_ROOT_KEY = "com.sun.aas.installRoot";

    public SunASPlatformContext() {
        this.mMBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.mLog = Logger.getLogger(this.getClass().getPackage().getName());
        this.mKeyStoreUtil = new SunASKeyStoreUtil();
    }

    @Override
    public Set<String> getClusteredServerNames() {
        String[] allClusters;
        HashSet<String> clusteredServers = new HashSet<String>();
        for (String clusterName : allClusters = this.mASContext.getClusterNames()) {
            String[] serversInCluster;
            for (String server : serversInCluster = this.mASContext.getServersInCluster(clusterName)) {
                clusteredServers.add(server);
            }
        }
        this.mLog.finest("Clustered servers in the domain are " + clusteredServers.toString());
        return clusteredServers;
    }

    @Override
    public Set<String> getClusterNames() {
        try {
            String[] clusters;
            HashSet<String> clusterNames = new HashSet<String>();
            for (String cluster : clusters = this.mASContext.getClusterNames()) {
                clusterNames.add(cluster);
            }
            return clusterNames;
        }
        catch (Exception ex) {
            this.mLog.warning(ex.getMessage());
            return new HashSet<String>();
        }
    }

    @Override
    public String getJmxRmiPort() {
        String port = null;
        DomainRoot domain = ProxyFactory.getInstance((MBeanServer)this.mMBeanServer).getDomainRoot();
        Map serverConfigMap = domain.getDomainConfig().getConfigConfigMap();
        ConfigConfig config = (ConfigConfig)serverConfigMap.get("server-config");
        if (config != null) {
            JMXConnectorConfig jmxConfig = (JMXConnectorConfig)config.getAdminServiceConfig().getJMXConnectorConfigMap().get("system");
            port = jmxConfig.getPort();
        }
        return port;
    }

    @Override
    public String getInstanceName() {
        return this.mASContext.getInstanceName();
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(String instanceName) throws Exception {
        return this.mASContext.getMBeanServerConnection(instanceName);
    }

    @Override
    public Set<String> getStandaloneServerNames() {
        try {
            String[] servers;
            HashSet<String> servSet = new HashSet<String>();
            for (String server : servers = this.mASContext.getStandaloneServerNames()) {
                servSet.add(server);
            }
            return servSet;
        }
        catch (Exception ex) {
            this.mLog.warning(ex.getMessage());
            return new HashSet<String>();
        }
    }

    @Override
    public String getTargetName() {
        String targetName = null;
        try {
            targetName = this.mASContext.getTargetName();
        }
        catch (Exception ex) {
            this.mLog.warning(ex.toString());
        }
        return targetName;
    }

    @Override
    public String getTargetName(String instanceName) {
        String targetName = null;
        try {
            targetName = this.mASContext.getTargetName(instanceName);
        }
        catch (Exception ex) {
            this.mLog.warning(ex.toString());
        }
        return targetName;
    }

    @Override
    public Set<String> getServersInCluster(String clusterName) {
        try {
            String[] servers;
            HashSet<String> clusteredServers = new HashSet<String>();
            for (String server : servers = this.mASContext.getServersInCluster(clusterName)) {
                clusteredServers.add(server);
            }
            return clusteredServers;
        }
        catch (Exception ex) {
            this.mLog.warning(ex.getMessage());
            return new HashSet<String>();
        }
    }

    @Override
    public TransactionManager getTransactionManager() throws Exception {
        TransactionManager transactionManager = (TransactionManager)this.mInitialContext.lookup("java:appserver/TransactionManager");
        return transactionManager;
    }

    @Override
    public boolean isCluster(String targetName) {
        String[] clusters;
        for (String cluster : clusters = this.mASContext.getClusterNames()) {
            if (!cluster.equals(targetName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isClusteredServer(String targetName) {
        return this.getClusteredServerNames().contains(targetName);
    }

    @Override
    public String getAdminServerName() {
        return SERVER;
    }

    @Override
    public boolean isAdminServer() {
        return this.mASContext.isDAS();
    }

    @Override
    public boolean isInstanceClustered(String instanceName) {
        boolean isClustered = false;
        try {
            isClustered = this.mASContext.isInstanceClustered(instanceName);
        }
        catch (Exception ex) {
            this.mLog.warning(ex.toString());
        }
        return isClustered;
    }

    @Override
    public boolean isInstanceUp(String instanceName) {
        return this.mASContext.isInstanceUp(instanceName);
    }

    @Override
    public boolean isStandaloneServer(String targetName) {
        String[] servers;
        for (String server : servers = this.mASContext.getStandaloneServerNames()) {
            if (!server.equals(targetName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidTarget(String targetName) {
        boolean isValid = false;
        if (this.isCluster(targetName) || this.isStandaloneServer(targetName)) {
            isValid = true;
        }
        return isValid;
    }

    @Override
    public boolean supportsMultipleServers() {
        return this.mASContext.multipleServersSupported();
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mMBeanServer;
    }

    @Override
    public String getInstanceRoot() {
        return System.getProperty(INSTANCE_ROOT_KEY);
    }

    @Override
    public String getInstallRoot() {
        return System.getProperty(INSTALL_ROOT_KEY);
    }

    @Override
    public JBIProvider getProvider() {
        return JBIProvider.SUNAS;
    }

    @Override
    public KeyStoreUtil getKeyStoreUtil() {
        return this.mKeyStoreUtil;
    }

    @Override
    public void handleNotification(Notification event, Object handback) {
        if (event instanceof MBeanServerNotification) {
            MBeanServerNotification mbnEvent = (MBeanServerNotification)event;
            ObjectName mbnName = mbnEvent.getMBeanName();
            if (this.isInstanceMBean(mbnName)) {
                String instanceName = mbnName.getKeyProperty("name");
                this.broadcastInstanceEvent(mbnEvent, instanceName);
            } else if (this.isClusterMBean(mbnName)) {
                String clusterName = mbnName.getKeyProperty("name");
                this.broadcastClusterEvent(mbnEvent, clusterName);
            }
        }
    }

    @Override
    public synchronized void addListener(PlatformEventListener listener) {
        List<PlatformEventListener> listeners = this.getAdminListeners();
        if (listeners.size() == 0) {
            this.registerPlatformListener();
        }
        listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(PlatformEventListener listener) {
        List<PlatformEventListener> listeners = this.getAdminListeners();
        if (listeners.contains(listener)) {
            listeners.remove(listener);
        }
        if (listeners.size() == 0) {
            this.unregisterPlatformListener();
        }
    }

    @Override
    public InitialContext getNamingContext() {
        return this.mInitialContext;
    }

    void setNamingContext(InitialContext ctx) {
        this.mInitialContext = ctx;
    }

    private synchronized List<PlatformEventListener> getAdminListeners() {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<PlatformEventListener>();
        }
        return this.mListeners;
    }

    private boolean isInstanceMBean(ObjectName mbnName) {
        return mbnName.toString().startsWith("amx:j2eeType=J2EEServer,name=");
    }

    private boolean isClusterMBean(ObjectName mbnName) {
        return mbnName.toString().startsWith("amx:j2eeType=X-J2EECluster,name=");
    }

    private void broadcastInstanceEvent(MBeanServerNotification mbnEvent, String instanceName) {
        block7: {
            List<PlatformEventListener> listeners;
            block6: {
                listeners = this.getAdminListeners();
                if (!mbnEvent.getType().equalsIgnoreCase("JMX.mbean.registered")) break block6;
                for (PlatformEventListener listener : listeners) {
                    if (!this.isStandaloneServer(instanceName)) continue;
                    try {
                        listener.createdStandaloneInstance(instanceName);
                    }
                    catch (Exception ex) {
                        this.mLog.warning(ex.toString());
                    }
                }
                break block7;
            }
            if (!mbnEvent.getType().equalsIgnoreCase("JMX.mbean.unregistered")) break block7;
            for (PlatformEventListener listener : listeners) {
                try {
                    listener.deletedInstance(instanceName);
                }
                catch (Exception ex) {
                    this.mLog.warning(ex.toString());
                }
            }
        }
    }

    private void broadcastClusterEvent(MBeanServerNotification mbnEvent, String clusterName) {
        block7: {
            List<PlatformEventListener> listeners;
            block6: {
                listeners = this.getAdminListeners();
                if (!mbnEvent.getType().equalsIgnoreCase("JMX.mbean.registered")) break block6;
                for (PlatformEventListener listener : listeners) {
                    try {
                        listener.createdCluster(clusterName);
                    }
                    catch (Exception ex) {
                        this.mLog.warning(ex.toString());
                    }
                }
                break block7;
            }
            if (!mbnEvent.getType().equalsIgnoreCase("JMX.mbean.unregistered")) break block7;
            for (PlatformEventListener listener : listeners) {
                try {
                    listener.deletedCluster(clusterName);
                }
                catch (Exception ex) {
                    this.mLog.warning(ex.toString());
                }
            }
        }
    }

    private void registerPlatformListener() {
        if (this.mASContext.isDAS() && this.supportsMultipleServers()) {
            try {
                this.mMBeanServer.addNotificationListener(new ObjectName(MBS_DELEGATE_NAME), this, null, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void unregisterPlatformListener() {
        try {
            this.mMBeanServer.removeNotificationListener(new ObjectName(MBS_DELEGATE_NAME), this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

