/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.descriptor;

import com.sun.jbi.ComponentType;
import com.sun.jbi.management.descriptor.Component;
import com.sun.jbi.management.descriptor.Jbi;
import com.sun.jbi.management.util.StringHelper;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDescriptor {
    private Component mCompType;

    public ComponentDescriptor(Jbi jbi) throws IllegalArgumentException {
        this.mCompType = jbi.getComponent();
        if (this.mCompType == null) {
            throw new IllegalArgumentException();
        }
    }

    public String getName() {
        if (this.mCompType.getIdentification() != null) {
            return StringHelper.trim(this.mCompType.getIdentification().getName());
        }
        return "";
    }

    public String getDescription() {
        if (this.mCompType.getIdentification() != null) {
            return StringHelper.trim(this.mCompType.getIdentification().getDescription());
        }
        return "";
    }

    public ComponentType getComponentType() {
        ComponentType compType = null;
        String compTypeStr = StringHelper.trim(this.mCompType.getType());
        if (compTypeStr.equals("binding-component")) {
            compType = ComponentType.BINDING;
        } else if (compTypeStr.equals("service-engine")) {
            compType = ComponentType.ENGINE;
        }
        return compType;
    }

    public boolean isComponentClassLoaderSelfFirst() {
        return "self-first".equals(StringHelper.trim(this.mCompType.getComponentClassLoaderDelegation()));
    }

    public boolean isBootstrapClassLoaderSelfFirst() {
        return "self-first".equals(StringHelper.trim(this.mCompType.getBootstrapClassLoaderDelegation()));
    }

    public List<String> getComponentClassPathElements() {
        if (this.mCompType.getComponentClassPath() != null) {
            return StringHelper.trim(this.mCompType.getComponentClassPath().getPathElement());
        }
        return new ArrayList<String>();
    }

    public List<String> getBootstrapClassPathElements() {
        if (this.mCompType.getBootstrapClassPath() != null) {
            return StringHelper.trim(this.mCompType.getBootstrapClassPath().getPathElement());
        }
        return new ArrayList<String>();
    }

    public String getBootstrapClassName() {
        String bootClassName = StringHelper.trim(this.mCompType.getBootstrapClassName());
        return bootClassName;
    }

    public String getComponentClassName() {
        String compClassName = "";
        if (this.mCompType.getComponentClassName() != null) {
            compClassName = StringHelper.trim(this.mCompType.getComponentClassName().getContent());
        }
        return compClassName;
    }

    public List<String> getSharedLibraryIds() {
        ArrayList<String> sls = new ArrayList<String>();
        List<Component.SharedLibrary> slList = this.mCompType.getSharedLibraryList();
        for (Component.SharedLibrary sl : slList) {
            String slName = StringHelper.trim(sl.getContent());
            if ("".equals(slName)) continue;
            sls.add(slName);
        }
        return sls;
    }
}

