/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.registry.xml;

import com.sun.jbi.management.ConfigurationCategory;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryDocument {
    private Document mRegistryDocument;
    private static final String DOMAIN = "domain";

    public RegistryDocument(Document regDoc) {
        this.mRegistryDocument = regDoc;
    }

    public String getConfigurationAttribute(String target, ConfigurationCategory category, String attrName) {
        String value = null;
        value = this.isAttributeOverriden(target, category, attrName) ? this.getAttribute(target, category, attrName) : this.getAttribute(DOMAIN, category, attrName);
        return value;
    }

    public Map<String, String> getConfigurationAttributes(String target, ConfigurationCategory category) {
        Map<String, String> targetSpecificProps = this.getProperties(target, category);
        return targetSpecificProps;
    }

    private boolean isAttributeOverriden(String target, ConfigurationCategory category, String attribName) {
        return this.getConfig(target) != null;
    }

    public String getAttribute(String target, ConfigurationCategory category, String attribName) {
        String value = null;
        Map<String, String> properties = this.getProperties(target, category);
        if (properties.containsKey(attribName)) {
            value = properties.get(attribName);
        }
        return value;
    }

    private Map<String, String> getProperties(String target, ConfigurationCategory category) {
        Object nameList = null;
        Object valueList = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        Element targetConfig = this.getConfig(target);
        if (targetConfig != null) {
            NodeList configTypeList = targetConfig.getElementsByTagName("config-type");
            for (int i = 0; i < configTypeList.getLength(); ++i) {
                Element configTypeElem = (Element)configTypeList.item(i);
                if (!category.toString().equals(configTypeElem.getAttribute("category"))) continue;
                NodeList propertyList = configTypeElem.getElementsByTagName("property");
                for (int j = 0; j < propertyList.getLength(); ++j) {
                    Element propertyElem = (Element)propertyList.item(j);
                    Element nameElem = (Element)propertyElem.getElementsByTagName("name").item(0);
                    String name = ((Text)nameElem.getFirstChild()).getNodeValue();
                    Element valueElem = (Element)propertyElem.getElementsByTagName("value").item(0);
                    String value = ((Text)valueElem.getFirstChild()).getNodeValue();
                    properties.put(name, value);
                }
            }
        }
        return properties;
    }

    private Element getConfig(String target) {
        Element targetConfig = null;
        if (this.mRegistryDocument != null) {
            NodeList configs;
            Element jbi = this.mRegistryDocument.getDocumentElement();
            Element configsElem = null;
            if (jbi != null && (configs = jbi.getElementsByTagName("configs")).getLength() >= 1) {
                configsElem = (Element)configs.item(0);
            }
            if (configsElem != null) {
                NodeList configList = configsElem.getElementsByTagName("config");
                for (int i = 0; i < configList.getLength(); ++i) {
                    Element configElem = (Element)configList.item(i);
                    if (!(target + "-config").equals(configElem.getAttribute("name"))) continue;
                    targetConfig = configElem;
                }
            }
        }
        return targetConfig;
    }
}

