/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.system;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ServiceAssemblyInfo;
import com.sun.jbi.ServiceAssemblyQuery;
import com.sun.jbi.ServiceAssemblyState;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.ServiceUnitRegistration;
import com.sun.jbi.ServiceUnitState;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.framework.DeployerMBean;
import com.sun.jbi.management.ComponentMessageHolder;
import com.sun.jbi.management.DeploymentServiceMBean;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.descriptor.ServiceAssemblyDescriptor;
import com.sun.jbi.management.internal.support.DOMUtil;
import com.sun.jbi.management.internal.support.DirectoryUtil;
import com.sun.jbi.management.message.MessageBuilder;
import com.sun.jbi.management.registry.data.ServiceAssemblyInfoImpl;
import com.sun.jbi.management.repository.Archive;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.support.JbiNameInfo;
import com.sun.jbi.management.system.BuildManagementMessageImpl;
import com.sun.jbi.management.system.DeploymentContextImpl;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.system.ManagementMessageHolder;
import com.sun.jbi.management.system.ModelSystemService;
import com.sun.jbi.management.util.FileHelper;
import com.sun.jbi.messaging.ConnectionManager;
import com.sun.jbi.messaging.Link;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentService
extends ModelSystemService
implements DeploymentServiceMBean {
    private static ManagementContext sMContext = null;
    private BuildManagementMessageImpl mMImpl = null;
    private String dplyRoot = null;
    private static final String PATH_TO_DELETE_ME_FILE = ".DELETE_ME";
    private StringTranslator mTranslator;
    private final JbiNameInfo mJbiNameInfo = new JbiNameInfo("DeploymentService");

    public DeploymentService(ManagementContext anEnv) throws JBIException {
        sMContext = anEnv;
        this.mMImpl = new BuildManagementMessageImpl();
        this.initModelSystemService(anEnv.getEnvironmentContext());
        this.mTranslator = anEnv.getEnvironmentContext().getStringTranslator("com.sun.jbi.management");
        this.mInitialMBeans.register();
        this.dplyRoot = sMContext.getJbiInstallRoot() + File.separator + "service-assemblies";
    }

    protected void initModelSystemService(EnvironmentContext anEnv) {
        String loggerName = "com.sun.jbi.management.DeploymentService";
        Logger logger = Logger.getLogger(loggerName);
        super.initModelSystemService(anEnv, logger, this.mJbiNameInfo);
        this.mStartMBeans.add(this.mDeployServiceMBeanName, DeploymentServiceMBean.class, this);
    }

    public String deploy(String saZipURL) throws Exception {
        ServiceAssemblyInfo saInfo;
        String dplyRslt = null;
        ArrayList<Element> cmpTaskRslts = new ArrayList<Element>();
        boolean saDplyRslt = true;
        int numCmps = 0;
        int numScssDplyToCmps = 0;
        URL saUrl = null;
        if (saZipURL == null) {
            String errMsg = this.mTranslator.getString("DS_CANNOT_DEPLOY_SA_ZIP_URL_NULL");
            String jbiExStr = this.buildFrmwkExMsg("deploy", null, errMsg);
            throw new Exception(jbiExStr);
        }
        saUrl = this.convertToProperURL(saZipURL);
        File ar = new File(saUrl.getFile());
        Archive saArchive = new Archive(ar, false);
        ServiceAssemblyDescriptor descr = new ServiceAssemblyDescriptor(saArchive.getJbiXml());
        String saName = descr.getName();
        if (!this.mEnv.getPlatformContext().isAdminServer()) {
            saInfo = new ServiceAssemblyInfoImpl();
            ((ServiceAssemblyInfoImpl)saInfo).setName(saArchive.getJbiName());
            try {
                ServiceAssemblyQuery saQuery = this.getRegistry().getServiceAssemblyQuery();
                if (!saQuery.getServiceAssemblies().contains(saName)) {
                    this.getRegistry().getRepository().addArchive(saArchive);
                    this.getRegistry().getUpdater().addServiceAssembly(saName, saArchive.getFileName(), saArchive.getUploadTimestamp());
                    saUrl = new File(saArchive.getPath()).toURL();
                } else {
                    File existingArchive = new File(this.getRegistry().getRepository().findArchive(ArchiveType.SERVICE_ASSEMBLY, saName));
                    boolean areArchivesIdentical = FileHelper.areFilesIdentical(existingArchive, ar);
                    if (!areArchivesIdentical) {
                        String errMsg = this.mTranslator.getString("DS_SERVICE_ASSEMBLY_WITH_SAME_NAME_EXISTS", saName);
                        throw new Exception(errMsg);
                    }
                }
            }
            catch (JBIException jbiex) {
                MessageBuilder msgBuilder = new MessageBuilder(this.mTranslator);
                throw new JBIException(msgBuilder.buildExceptionMessage("deploy", jbiex));
            }
            ar.delete();
        }
        try {
            saInfo = this.getServiceAssemblyInfo(saName, "domain");
            List<ServiceUnitInfo> suList = saInfo.getServiceUnitList();
            for (ServiceUnitInfo su : suList) {
                String suName = su.getName();
                String compName = su.getTargetComponent();
                String suRootPath = su.getFilePath();
                ComponentState cmpState = ComponentState.UNKNOWN;
                this.mLogger.fine("About to deploy service unit " + suName);
                ++numCmps;
                boolean skipDeployment = false;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                String suRelPath = saName + File.separator + suName;
                String suJarAbsPath = this.getRegistry().getRepository().findArchive(ArchiveType.SERVICE_UNIT, suRelPath);
                try {
                    String errMsg;
                    cmpState = this.getComponentState(compName);
                    if (cmpState == ComponentState.UNKNOWN) {
                        errMsg = this.mTranslator.getString("DS_CANNOT_DEPLOY_SERVICE_UNIT_COMP_NOT_INSTALLED", suName, compName);
                        throw new Exception(errMsg);
                    }
                    if (cmpState == ComponentState.SHUTDOWN) {
                        errMsg = this.mTranslator.getString("DS_CANNOT_CHANGE_SU_STATE_COMP_IN_INCORRECT_STATE", suName, compName);
                        throw new Exception(errMsg);
                    }
                    boolean isSURegistered = sMContext.getServiceUnitRegistration().isServiceUnitRegistered(compName, suName);
                    if (isSURegistered) {
                        this.mLogger.finest("Service unit " + suName + " already registered.");
                        skipDeployment = true;
                    }
                    this.mLogger.fine("Checking the service unit contents for service unit " + suName);
                    ServiceUnitInfo aSUInfo = this.getServiceUnitInfo(compName, suName);
                    if (aSUInfo != null && !saName.equalsIgnoreCase(aSUInfo.getServiceAssemblyName())) {
                        String errMsg2 = this.mTranslator.getString("DS_CANNOT_DEPLOY_SERVICE_UNIT_DUPLICATE_SU_NAME", suName, compName);
                        throw new Exception(errMsg2);
                    }
                    boolean isDuplicateSUContents = this.checkSUContents(saName, compName, suName, suJarAbsPath);
                    if (isDuplicateSUContents) {
                        String errMsg3 = this.mTranslator.getString("DS_CANNOT_DEPLOY_SERVICE_UNIT_DUPLICATE_SU_CONTENTS", suName, compName);
                        throw new Exception(errMsg3);
                    }
                }
                catch (Exception e) {
                    Element elem = this.getComponentResultXmlFragment(compName, "deploy", e);
                    cmpTaskRslts.add(elem);
                    continue;
                }
                this.mLogger.finest("Invoking deploy operation for service unit " + suName + " and component " + compName);
                Object cmpTaskRslt = null;
                try {
                    if (skipDeployment) {
                        this.mLogger.fine("Skipping deployment of  " + suName);
                        ++numScssDplyToCmps;
                        String locMsg = this.mTranslator.getString("DS_SERVICE_UNIT_ALREADY_DEPLOYED", suName);
                        String scssMsg = this.buildComponentStatusMsg(compName, "deploy", suName, locMsg);
                        Document doc = db.parse(new InputSource(new StringReader(scssMsg)));
                        Element elem = DOMUtil.UTIL.getElement(doc, "component-task-result");
                        cmpTaskRslts.add(elem);
                        continue;
                    }
                    DeployerMBean deployer = this.getComponentDeployerInstance(compName);
                    if (deployer == null) {
                        String errMsg = this.mTranslator.getString("DS_CANNOT_DEPLOY_SU_DEPLOYER_INSTANCE_NULL", suName, compName, (Object)cmpState);
                        throw new Exception(errMsg);
                    }
                    dplyRslt = deployer.deploy(suName, suRootPath);
                    String suRgstrnRslt = null;
                    boolean isSUDplymntScss = this.checkSUTaskRsltStatus(dplyRslt);
                    String dplyRsltWithWarning = null;
                    Document doc = null;
                    if (isSUDplymntScss) {
                        suRgstrnRslt = this.registerServiceUnit(compName, saName, suName, suRootPath);
                        this.mLogger.finest("Registered service unit " + suName + " for component " + compName + " with result " + suRgstrnRslt);
                        if (suRgstrnRslt.equalsIgnoreCase("SUCCESS")) {
                            doc = db.parse(new InputSource(new StringReader(dplyRslt)));
                        } else {
                            dplyRsltWithWarning = this.appendWarningToCmpRslt(suRgstrnRslt, dplyRslt);
                            doc = db.parse(new InputSource(new StringReader(dplyRsltWithWarning)));
                        }
                        ++numScssDplyToCmps;
                    } else {
                        doc = db.parse(new InputSource(new StringReader(dplyRslt)));
                    }
                    Element elem = DOMUtil.UTIL.getElement(doc, "component-task-result");
                    cmpTaskRslts.add(elem);
                }
                catch (DeploymentException e) {
                    Element elem = this.getComponentResultXmlFragment(compName, "deploy", (Exception)((Object)e));
                    cmpTaskRslts.add(elem);
                }
            }
            if (numCmps > 0 && numScssDplyToCmps == 0) {
                saDplyRslt = false;
            }
        }
        catch (DeploymentException de) {
            throw new Exception(de.getMessage());
        }
        catch (Exception e) {
            String errMsg = this.mTranslator.getString("DS_CANNOT_DEPLOY_SERVICE_ASSEMBLY", saUrl);
            String jbiTaskStr = this.buildFrmwkExMsg("deploy", e, errMsg);
            throw new Exception(jbiTaskStr);
        }
        String resp = this.buildResponse(cmpTaskRslts, saDplyRslt, "deploy", saName);
        if (!saDplyRslt) {
            this.mLogger.info(this.mTranslator.getString("DS_DEPLOYMENT_FAILURE", saUrl));
            Object saUnzipDir = null;
            if (!this.mEnv.getPlatformContext().isAdminServer()) {
                try {
                    this.getRegistry().getRepository().removeArchive(ArchiveType.SERVICE_ASSEMBLY, saName);
                    this.getRegistry().getUpdater().removeServiceAssembly("domain", saName);
                }
                catch (JBIException jbiex) {
                    this.mLogger.warning(jbiex.getMessage());
                }
            }
            throw new Exception(resp);
        }
        this.mLogger.info(this.mTranslator.getString("DS_DEPLOYMENT_SUCCESS", saUrl));
        try {
            if (!this.getRegistry().getServiceAssemblyQuery().getServiceAssemblies().contains(saName)) {
                this.getRegistry().getUpdater().addServiceAssembly(saName);
                if (this.isServiceAssemblyEmpty(saName)) {
                    this.getRegistry().getUpdater().setServiceAssemblyState(ServiceAssemblyState.SHUTDOWN, saName);
                }
            }
        }
        catch (JBIException jbiex) {
            MessageBuilder msgBuilder = new MessageBuilder(this.mTranslator);
            throw new JBIException(msgBuilder.buildExceptionMessage("deploy", jbiex));
        }
        return resp;
    }

    public String undeploy(String saName) throws Exception {
        return this.undeploy(saName, false, false);
    }

    public String[] getDeployedServiceUnitList(String componentName) throws Exception {
        String[] suNameList = null;
        Element elem = null;
        try {
            MBeanServerConnection mbeanServer = this.getMBeanServerConnection();
            ObjectName resultObject = this.getDeployerMBeanObjectName(componentName);
            if (resultObject == null) {
                throw new DeploymentException("LIFECYCLE_OBJECTNAME_IS_NULL");
            }
            ObjectName dplyrObjName = resultObject;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            try {
                Object rsltObject = mbeanServer.getAttribute(dplyrObjName, "Deployments");
                suNameList = (String[])rsltObject;
            }
            catch (MBeanException mbe) {
                DeploymentException de = (DeploymentException)((Object)mbe.getTargetException());
                String exMessage = de.getMessage();
                Document doc = db.parse(new InputSource(new StringReader(exMessage)));
                elem = DOMUtil.UTIL.getElement(doc, "component-task-result");
                throw de;
            }
        }
        catch (Exception e) {
            String errMsg = this.mTranslator.getString("DS_CANNOT_GET_SERVICE_UNIT_LIST", componentName);
            String jbiTask = this.appendCmpExToFrmwkEx("getDeployedServiceUnitList", e, errMsg, elem);
            throw new Exception(jbiTask);
        }
        return suNameList;
    }

    public boolean isDeployedServiceUnit(String componentName, String serviceUnitName) throws Exception {
        return this.getServiceUnitInfo(componentName, serviceUnitName) != null;
    }

    public ServiceUnitInfo getServiceUnitInfo(String compName, String suName) {
        ServiceUnitInfo suInfo = null;
        ComponentInfo cInfo = this.getComponentQuery().getComponentInfo(compName);
        if (cInfo != null) {
            List<ServiceUnitInfo> suList = cInfo.getServiceUnitList();
            for (int i = 0; i < suList.size(); ++i) {
                ServiceUnitInfo info = suList.get(i);
                if (!info.getName().equals(suName)) continue;
                suInfo = info;
                break;
            }
        }
        return suInfo;
    }

    private String appendCmpExToFrmwkEx(String methodName, Throwable ex, String errMsg, Element elem) {
        String jbiTask = null;
        String token = null;
        try {
            ManagementMessageHolder mmHolder = new ManagementMessageHolder("EXCEPTION_MSG");
            mmHolder.setTaskName(methodName);
            mmHolder.setTaskResult("FAILED");
            mmHolder.setExceptionObject(ex);
            mmHolder.setLocToken(1, token);
            mmHolder.setLocMessage(1, errMsg);
            String jbiTaskStr = this.mMImpl.buildCompleteExceptionMessage(mmHolder);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(jbiTaskStr)));
            Element jbiTaskElem = DOMUtil.UTIL.getElement(doc, "jbi-task-result");
            Element impElem = (Element)doc.importNode(elem, true);
            jbiTaskElem.appendChild(impElem);
            StringWriter sw = new StringWriter();
            jbiTask = DOMUtil.UTIL.DOM2String(doc, sw);
        }
        catch (Exception e) {
            String statusMsg = this.mTranslator.getString("DS_DEPLOY_NO_EXCEPTION_MSG", methodName);
            this.mLogger.warning(statusMsg);
        }
        return jbiTask;
    }

    private String buildFrmwkExMsg(String methodName, Throwable ex, String errMsg) {
        String jbiTaskStr = null;
        try {
            ManagementMessageHolder mmHolder = new ManagementMessageHolder("EXCEPTION_MSG");
            mmHolder.setTaskName(methodName);
            mmHolder.setTaskResult("FAILED");
            String token = MessageBuilder.getMessageToken(errMsg);
            mmHolder.setLocToken(1, token);
            String msg = MessageBuilder.getMessageString(errMsg);
            mmHolder.setLocMessage(1, msg);
            if (ex != null) {
                mmHolder.setExceptionObject(ex);
            }
            mmHolder.setFrameworkLocale("en_US");
            jbiTaskStr = this.mMImpl.buildCompleteExceptionMessage(mmHolder);
        }
        catch (Exception e) {
            String statusMsg = this.mTranslator.getString("DS_DEPLOY_NO_EXCEPTION_MSG", methodName);
            this.mLogger.warning(statusMsg);
        }
        return jbiTaskStr;
    }

    public boolean canDeployToComponent(String componentName) {
        boolean canDeploy = false;
        try {
            ComponentState cmpStatus = this.getComponentState(componentName);
            if (cmpStatus == ComponentState.STARTED) {
                canDeploy = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return canDeploy;
    }

    private String buildResponse(List cmpTaskRslts, boolean rslt, String methodName, String saName) throws Exception {
        String respDoc = null;
        Document doc = null;
        Element rootElem = null;
        Element respElem = null;
        String taskRslt = null;
        try {
            String threadId = Thread.currentThread().getName();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
            rootElem = doc.createElement("jbi-task");
            rootElem.setAttribute("version", "1.0");
            rootElem.setAttribute("xmlns", "http://java.sun.com/xml/ns/jbi/management-message");
            rootElem.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            rootElem.setAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/jbi/management-message ./managementMessage.xsd");
            taskRslt = rslt ? "SUCCESS" : "FAILED";
            ManagementMessageHolder mmHolder = new ManagementMessageHolder("STATUS_MSG");
            mmHolder.setTaskName(methodName);
            mmHolder.setTaskResult(taskRslt);
            mmHolder.setFrameworkLocale("en_US");
            respElem = this.mMImpl.buildFrameworkTaskStatusMessage(doc, mmHolder);
            doc.appendChild(rootElem);
            rootElem.appendChild(respElem);
            for (Element importedNode : cmpTaskRslts) {
                Element elem = (Element)doc.importNode(importedNode, true);
                respElem.appendChild(elem);
            }
            if (rslt && (methodName.equalsIgnoreCase("deploy") || methodName.equalsIgnoreCase("start"))) {
                this.addTaskStatusMsg(doc, saName, this.isPartialSuccess(cmpTaskRslts), methodName);
            }
            StringWriter sw = new StringWriter();
            respDoc = DOMUtil.UTIL.DOM2String(doc, sw);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentException("UNABLE_TO_CREATE_DEPLOY_RESPONSE", (Throwable)e);
        }
        return respDoc;
    }

    private void addTaskStatusMsg(Document doc, String saName, boolean isPartialSuccess, String opName) throws Exception {
        if (!isPartialSuccess && "start".equals(opName)) {
            return;
        }
        Element jbiTaskElem = DOMUtil.UTIL.getElement(doc, "jbi-task");
        Element jbiTaskRsltElem = DOMUtil.UTIL.getElement(jbiTaskElem, "jbi-task-result");
        Element frmwkTaskRsltElem = DOMUtil.UTIL.getElement(jbiTaskRsltElem, "frmwk-task-result");
        Element frmwkTaskRsltDtlsElem = DOMUtil.UTIL.getElement(frmwkTaskRsltElem, "frmwk-task-result-details");
        Element taskRsltDtlsElem = DOMUtil.UTIL.getElement(frmwkTaskRsltDtlsElem, "task-result-details");
        Element msgTypeElem = doc.createElement("message-type");
        Element taskStatMsgElem = doc.createElement("task-status-msg");
        Element msgLocInfoElem = doc.createElement("msg-loc-info");
        Element locTokenElem = doc.createElement("loc-token");
        Element locMsgElem = doc.createElement("loc-message");
        String infoMsg = null;
        if (isPartialSuccess) {
            DOMUtil.UTIL.setTextData(msgTypeElem, "WARNING");
            if ("deploy".equalsIgnoreCase(opName)) {
                infoMsg = this.mTranslator.getString("DS_DEPLOY_SCSS_WITH_WRNING_MSG", saName);
            } else if ("start".equalsIgnoreCase(opName)) {
                infoMsg = this.mTranslator.getString("DS_START_SCSS_WITH_WRNING_MSG", saName);
            }
        } else if ("deploy".equalsIgnoreCase(opName)) {
            DOMUtil.UTIL.setTextData(msgTypeElem, "INFO");
            infoMsg = this.mTranslator.getString("DS_DEPLOY_SCSS_INFO_MSG", saName);
        }
        taskRsltDtlsElem.appendChild(msgTypeElem);
        String token = MessageBuilder.getMessageToken(infoMsg);
        String msg = MessageBuilder.getMessageString(infoMsg);
        DOMUtil.UTIL.setTextData(locTokenElem, token);
        DOMUtil.UTIL.setTextData(locMsgElem, msg);
        msgLocInfoElem.appendChild(locTokenElem);
        msgLocInfoElem.appendChild(locMsgElem);
        taskStatMsgElem.appendChild(msgLocInfoElem);
        taskRsltDtlsElem.appendChild(taskStatMsgElem);
    }

    public ObjectName getLifeCycleMBeanObjectName(String aCompName) throws Exception {
        try {
            MBeanNames mbn = sMContext.getMBeanNames();
            ObjectName adminName = mbn.getSystemServiceMBeanName("AdminService", "AdministrationService");
            MBeanServerConnection mbeanServer = this.getMBeanServerConnection();
            Object[] params = new Object[]{aCompName};
            String[] sig = new String[]{"java.lang.String"};
            Object rsltObject = mbeanServer.invoke(adminName, "getComponentByName", params, sig);
            return (ObjectName)rsltObject;
        }
        catch (Exception e) {
            String errMsg = this.mTranslator.getString("DS_UNABLE_TO_FIND_LIFECYCLE_MBEAN_OBJECT_NAME", aCompName);
            String jbiTaskStr = this.buildFrmwkExMsg("getLifeCycleMBeanObjectName", e, errMsg);
            throw new Exception(jbiTaskStr);
        }
    }

    public String[] getDeployedServiceAssemblies() throws Exception {
        try {
            ServiceAssemblyQuery saQuery = this.getRegistry().getServiceAssemblyQuery();
            List<String> saNamesList = saQuery.getServiceAssemblies();
            String[] saNames = new String[saNamesList.size()];
            saNamesList.toArray(saNames);
            return saNames;
        }
        catch (Exception e) {
            String errMsg = this.mTranslator.getString("DS_UNABLE_TO_FIND_DEPLOYED_SERVICE_ASSEMBLY_NAMES");
            String jbiTaskStr = this.buildFrmwkExMsg("getDeployedServiceAssemblies", e, errMsg);
            throw new Exception(jbiTaskStr);
        }
    }

    public String[] getDeployedServiceAssembliesForComponent(String componentName) throws Exception {
        ArrayList<String> saNameList = new ArrayList<String>();
        try {
            String[] deployedSANameArray = this.getDeployedServiceAssemblies();
            for (int i = 0; i < deployedSANameArray.length; ++i) {
                String[] compNameArr = this.getComponentsForDeployedServiceAssembly(deployedSANameArray[i]);
                for (int j = 0; j < compNameArr.length; ++j) {
                    if (!compNameArr[j].equalsIgnoreCase(componentName)) continue;
                    saNameList.add(deployedSANameArray[i]);
                }
            }
        }
        catch (DeploymentException de) {
            throw new Exception(de.getMessage());
        }
        catch (Exception e) {
            String errMsg = this.mTranslator.getString("DS_UNABLE_TO_GET_SERVICE_ASSEMBLY_NAMES_FOR_COMPONENT", componentName);
            String jbiTaskStr = this.buildFrmwkExMsg("getDeployedServiceAssembliesForComponent", e, errMsg);
            throw new Exception(jbiTaskStr);
        }
        String[] saNameArray = new String[saNameList.size()];
        saNameList.toArray(saNameArray);
        return saNameArray;
    }

    public String[] getComponentsForDeployedServiceAssembly(String saName) throws Exception {
        try {
            ArrayList<String> compNameList = new ArrayList<String>();
            ServiceAssemblyInfo saInfo = this.getServiceAssemblyInfo(saName, "domain");
            List<ServiceUnitInfo> suList = saInfo.getServiceUnitList();
            for (ServiceUnitInfo su : suList) {
                compNameList.add(su.getTargetComponent());
            }
            String[] compNameArray = new String[compNameList.size()];
            compNameList.toArray(compNameArray);
            return compNameArray;
        }
        catch (DeploymentException de) {
            de.printStackTrace();
            throw new Exception(de.getMessage());
        }
        catch (Exception e) {
            String errMsg = this.mTranslator.getString("DS_UNABLE_TO_FIND_COMPONENT_NAMES_FOR_SA", saName);
            String jbiTaskStr = this.buildFrmwkExMsg("getComponentsForDeployedServiceAssembly", e, errMsg);
            throw new Exception(jbiTaskStr);
        }
    }

    public String getServiceAssemblyDescriptor(String saName) throws Exception {
        String jbiXmlString = null;
        try {
            jbiXmlString = this.getRegistry().getGenericQuery().getServiceAssemblyDeploymentDescriptor(saName);
            return jbiXmlString;
        }
        catch (Exception e) {
            e.printStackTrace();
            String errMsg = this.mTranslator.getString("DS_SA_DESCRIPTOR_NOT_FOUND", saName);
            String jbiTaskStr = this.buildFrmwkExMsg("getServiceAssemblyDescriptor", e, errMsg);
            throw new Exception(jbiTaskStr);
        }
    }

    @Override
    public String getServiceUnitDescriptor(String saName, String suName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public ComponentState getComponentState(String compName) {
        ObjectName compLCName = this.getComponentLifeCycleMBeanName(compName);
        ComponentState cmpStatus = ComponentState.UNKNOWN;
        if (compLCName != null) {
            MBeanServer mbnServer = sMContext.getMBeanServer();
            try {
                String state = (String)mbnServer.getAttribute(compLCName, "CurrentState");
                cmpStatus = ComponentState.valueOfLifeCycleState(state);
            }
            catch (JMException infex) {
                this.mLogger.warning(infex.toString());
            }
        }
        return cmpStatus;
    }

    public ServiceUnitState getActualServiceUnitState(String compName, String suName) {
        DeployerMBean deployer;
        ServiceUnitState suState = ServiceUnitState.UNKNOWN;
        ComponentState compState = this.getComponentState(compName);
        if (compState == ComponentState.SHUTDOWN) {
            suState = ServiceUnitState.SHUTDOWN;
        } else if (compState != ComponentState.UNKNOWN && (deployer = this.getComponentDeployerInstance(compName)) != null) {
            suState = deployer.getServiceUnitState(suName);
        }
        return suState;
    }

    private Element buildComponentExMsg(String taskName, String compId, Exception e) {
        Element elem = null;
        StringBuffer sb = new StringBuffer("");
        StackTraceElement[] stckTrElem = e.getStackTrace();
        if (stckTrElem != null) {
            for (int i = 0; i < stckTrElem.length; ++i) {
                String stckTrace = stckTrElem[i].toString();
                sb.append(stckTrace);
                sb.append("\n");
            }
        }
        String[] msgParams = new String[]{""};
        ComponentMessageHolder cmpParams = new ComponentMessageHolder("EXCEPTION_MSG");
        cmpParams.setComponentName(compId);
        cmpParams.setTaskName(taskName);
        cmpParams.setTaskResult("FAILED");
        String errMsg = e.getMessage();
        if (errMsg.startsWith("JBI")) {
            cmpParams.setLocToken(1, MessageBuilder.getMessageToken(errMsg));
            String msg = MessageBuilder.getMessageString(errMsg);
            cmpParams.setLocMessage(1, msg);
        } else {
            cmpParams.setLocToken(1, "");
            cmpParams.setLocMessage(1, e.getMessage());
        }
        cmpParams.setLocParam(1, msgParams);
        cmpParams.setExceptionObject(e);
        cmpParams.setExceptionMessageType("ERROR");
        String cmpMsg = null;
        try {
            cmpMsg = this.mMImpl.buildComponentTaskExceptionMessage(cmpParams);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(cmpMsg)));
            elem = DOMUtil.UTIL.getElement(doc, "component-task-result");
        }
        catch (Exception cmpe) {
            cmpe.printStackTrace();
            String statusMsg = this.mTranslator.getString("DS_DEPLOY_NO_EXCEPTION_MSG");
            this.mLogger.warning(statusMsg);
        }
        return elem;
    }

    public String registerServiceUnit(String compName, String saName, String suName, String suRootPath) throws Exception {
        String rgstrTaskStr = "SUCCESS";
        try {
            ServiceUnitRegistration suRegistration = sMContext.getServiceUnitRegistration();
            suRegistration.registerServiceUnit(compName, saName, suName, suRootPath);
        }
        catch (Throwable t) {
            t.printStackTrace();
            ComponentMessageHolder cmpMsgHolder = new ComponentMessageHolder("STATUS_MSG");
            cmpMsgHolder.setComponentName(compName);
            cmpMsgHolder.setTaskName("deploy");
            cmpMsgHolder.setTaskResult("SUCCESS");
            cmpMsgHolder.setStatusMessageType("WARNING");
            String errMsg = this.mTranslator.getString("DS_REGISTER_SERVICE_UNIT_FAILED", suName);
            String token = MessageBuilder.getMessageToken(errMsg);
            cmpMsgHolder.setLocToken(1, token);
            String msg = MessageBuilder.getMessageString(errMsg);
            cmpMsgHolder.setLocMessage(1, msg);
            rgstrTaskStr = this.mMImpl.buildComponentMessage(cmpMsgHolder);
        }
        return rgstrTaskStr;
    }

    public String unregisterServiceUnit(String compName, String suName) throws Exception {
        String unrgstrTaskStr = "SUCCESS";
        try {
            ServiceUnitRegistration suRegistration = sMContext.getServiceUnitRegistration();
            suRegistration.unregisterServiceUnit(compName, suName);
        }
        catch (Throwable t) {
            t.printStackTrace();
            ComponentMessageHolder cmpMsgHolder = new ComponentMessageHolder("STATUS_MSG");
            cmpMsgHolder.setComponentName(compName);
            cmpMsgHolder.setTaskName("deploy");
            cmpMsgHolder.setTaskResult("SUCCESS");
            cmpMsgHolder.setStatusMessageType("WARNING");
            String errMsg = this.mTranslator.getString("DS_UNREGISTER_SERVICE_UNIT_FAILED", suName);
            String token = MessageBuilder.getMessageToken(errMsg);
            cmpMsgHolder.setLocToken(1, token);
            String msg = MessageBuilder.getMessageString(errMsg);
            cmpMsgHolder.setLocMessage(1, msg);
            unrgstrTaskStr = this.mMImpl.buildComponentMessage(cmpMsgHolder);
        }
        return unrgstrTaskStr;
    }

    @Override
    public void shutDown() throws JBIException {
        super.shutDown();
    }

    private boolean checkSUTaskRsltStatus(String suDeployRslt) throws Exception {
        boolean taskRslt = false;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(suDeployRslt)));
        Element compTaskRsltElem = DOMUtil.UTIL.getElement(doc, "component-task-result");
        Element cmpTaskRsltDtlsElem = DOMUtil.UTIL.getElement(compTaskRsltElem, "component-task-result-details");
        Element taskRsltDtlsElem = DOMUtil.UTIL.getElement(cmpTaskRsltDtlsElem, "task-result-details");
        Element rsltElem = DOMUtil.UTIL.getElement(taskRsltDtlsElem, "task-result");
        String dplyRslt = DOMUtil.UTIL.getTextData(rsltElem);
        taskRslt = dplyRslt.equalsIgnoreCase("SUCCESS");
        return taskRslt;
    }

    private String appendWarningToCmpRslt(String suRgstrnRslt, String suDplyRslt) throws Exception {
        String cmpTaskRsltStr = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(suDplyRslt)));
        Element compTaskRsltElem = DOMUtil.UTIL.getElement(doc, "component-task-result");
        Element cmpTaskRsltDtlsElem = DOMUtil.UTIL.getElement(compTaskRsltElem, "component-task-result-details");
        Element taskRsltDtlsElem = DOMUtil.UTIL.getElement(cmpTaskRsltDtlsElem, "task-result-details");
        Element mtElem = DOMUtil.UTIL.getElement(taskRsltDtlsElem, "message-type");
        Element msgTypeElem = null;
        if (mtElem == null) {
            msgTypeElem = doc.createElement("message-type");
            DOMUtil.UTIL.setTextData(msgTypeElem, "WARNING");
            taskRsltDtlsElem.appendChild(msgTypeElem);
        }
        Document suRgstrnDoc = db.parse(new InputSource(new StringReader(suRgstrnRslt)));
        Element rgstrnCmpTaskRsltElem = DOMUtil.UTIL.getElement(suRgstrnDoc, "component-task-result");
        Element rgstrnCmpTaskRsltDtlsElem = DOMUtil.UTIL.getElement(rgstrnCmpTaskRsltElem, "component-task-result-details");
        Element rgstrnTaskRsltDtlsElem = DOMUtil.UTIL.getElement(rgstrnCmpTaskRsltDtlsElem, "task-result-details");
        Element statusMsgElem = DOMUtil.UTIL.getElement(rgstrnTaskRsltDtlsElem, "task-status-msg");
        Element impElem = (Element)doc.importNode(statusMsgElem, true);
        taskRsltDtlsElem.appendChild(impElem);
        StringWriter sw = new StringWriter();
        cmpTaskRsltStr = DOMUtil.UTIL.DOM2String(doc, sw);
        return cmpTaskRsltStr;
    }

    private String buildComponentStatusMsg(String compName, String methodName, String suName) {
        String compStatusMsg = null;
        ComponentMessageHolder cmpMsgHolder = new ComponentMessageHolder("STATUS_MSG");
        cmpMsgHolder.setComponentName(compName);
        cmpMsgHolder.setTaskName(methodName);
        cmpMsgHolder.setTaskResult("SUCCESS");
        String locMsg = this.mTranslator.getString("DS_SU_LIFECYCLE_OP_SUCCESS", methodName, suName);
        cmpMsgHolder.setStatusMessageType("INFO");
        cmpMsgHolder.setLocToken(1, MessageBuilder.getMessageToken(locMsg));
        cmpMsgHolder.setLocMessage(1, MessageBuilder.getMessageString(locMsg));
        cmpMsgHolder.setLocParam(1, new String[]{methodName, suName});
        try {
            compStatusMsg = this.mMImpl.buildComponentMessage(cmpMsgHolder);
        }
        catch (Exception exObj) {
            String statusMsg = this.mTranslator.getString("DS_DEPLOY_NO_EXCEPTION_MSG");
            this.mLogger.warning(statusMsg);
        }
        return compStatusMsg;
    }

    private String buildComponentStatusMsg(String compName, String methodName, String suName, String info) {
        String compStatusMsg = null;
        ComponentMessageHolder cmpMsgHolder = new ComponentMessageHolder("STATUS_MSG");
        cmpMsgHolder.setComponentName(compName);
        cmpMsgHolder.setTaskName(methodName);
        cmpMsgHolder.setTaskResult("SUCCESS");
        cmpMsgHolder.setStatusMessageType("INFO");
        cmpMsgHolder.setLocToken(1, MessageBuilder.getMessageToken(info));
        cmpMsgHolder.setLocMessage(1, MessageBuilder.getMessageString(info));
        cmpMsgHolder.setLocParam(1, new String[]{methodName, suName});
        try {
            compStatusMsg = this.mMImpl.buildComponentMessage(cmpMsgHolder);
        }
        catch (Exception exObj) {
            String statusMsg = this.mTranslator.getString("DS_DEPLOY_NO_EXCEPTION_MSG");
            this.mLogger.warning(statusMsg);
        }
        return compStatusMsg;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return sMContext.getCentralMBeanServer();
    }

    public String start(String serviceAssemblyName) throws Exception {
        HashMap infoMsgElems = null;
        String saState = this.getState(serviceAssemblyName);
        if (!saState.equalsIgnoreCase("Started")) {
            infoMsgElems = this.activateConnections(serviceAssemblyName);
        }
        String stateChangeRslt = this.startServiceAssembly(serviceAssemblyName);
        String jbiTaskStr = this.appendMsgsToTaskRslt(stateChangeRslt, infoMsgElems, "WARNING");
        return jbiTaskStr;
    }

    public String stop(String serviceAssemblyName) throws Exception {
        Object infoMsgElems = null;
        String saState = this.getState(serviceAssemblyName);
        boolean isStarted = false;
        if (saState.equalsIgnoreCase("Started")) {
            isStarted = true;
        } else if (saState.equalsIgnoreCase("Shutdown")) {
            String errMsg = this.mTranslator.getString("DS_CANNOT_STOP_SA_SHUTDOWN_SA_STATE", serviceAssemblyName, saState);
            String jbiExStr = this.buildFrmwkExMsg("stop", null, errMsg);
            throw new Exception(jbiExStr);
        }
        return this.stopServiceAssembly(serviceAssemblyName, isStarted);
    }

    public String shutDown(String serviceAssemblyName) throws Exception {
        return this.shutDown(serviceAssemblyName, false);
    }

    public String getState(String serviceAssemblyName) throws Exception {
        String saState = null;
        try {
            ServiceAssemblyInfo saInfo = this.getServiceAssemblyInfo(serviceAssemblyName);
            if (saInfo != null) {
                ServiceAssemblyState state;
                ArrayList<ServiceUnitState> suStates = new ArrayList<ServiceUnitState>();
                List<ServiceUnitInfo> suList = saInfo.getServiceUnitList();
                for (ServiceUnitInfo suInfo : suList) {
                    String suName = suInfo.getName();
                    String targetComponent = suInfo.getTargetComponent();
                    ServiceUnitState suState = this.getActualServiceUnitState(targetComponent, suName);
                    suStates.add(suState);
                }
                if (!suStates.isEmpty()) {
                    state = ServiceAssemblyState.computeServiceAssemblyState(suStates);
                    saState = ServiceAssemblyState.convertState(state);
                } else if (this.isServiceAssemblyEmpty(serviceAssemblyName)) {
                    state = this.getServiceAssemblyInfo(serviceAssemblyName).getStatus();
                    saState = ServiceAssemblyState.convertState(state);
                }
            }
        }
        catch (Exception e) {
            if (!e.getMessage().startsWith("<?xml")) {
                String frmwkMsg = this.buildFrmwkExMsg("getState", e, e.getMessage());
                throw new Exception(frmwkMsg);
            }
            throw new Exception(e.getMessage());
        }
        if (saState == null) {
            Object[] params = new String[]{serviceAssemblyName};
            String errMsg = this.mTranslator.getString("DS_CANNOT_GET_SA_STATE", params);
            MessageBuilder msgBuilder = new MessageBuilder(this.mTranslator);
            String mgtMsg = msgBuilder.buildFrameworkMessage("getState", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new Exception(mgtMsg);
        }
        this.mLogger.finest("Deployment service returning state " + saState + " for service assembly " + serviceAssemblyName);
        return saState;
    }

    @Override
    public String getServiceUnitState(String componentName, String serviceUnitName) throws JBIException {
        ServiceUnitState suState = this.getActualServiceUnitState(componentName, serviceUnitName);
        return ServiceUnitState.convertState(suState);
    }

    @Override
    public String deployFromRepository(String serviceAssemblyName) throws JBIException {
        return serviceAssemblyName;
    }

    @Override
    public String undeploy(String serviceAssemblyName, boolean force) throws Exception {
        return this.undeploy(serviceAssemblyName, force, false);
    }

    @Override
    public String undeploy(String saName, boolean force, boolean keep) throws Exception {
        String statusMsg;
        Object jbiXmlPath = null;
        String undplyRslt = null;
        Object params = null;
        ArrayList<Element> cmpTaskRslts = new ArrayList<Element>();
        boolean saUnDplyRslt = true;
        try {
            ServiceAssemblyInfo saInfo = this.getServiceAssemblyInfo(saName);
            List<ServiceUnitInfo> suList = saInfo.getServiceUnitList();
            int numOfSUs = suList.size();
            int numOfSUsUndeployed = 0;
            for (ServiceUnitInfo su : suList) {
                Element elem;
                String suName = su.getName();
                String compName = su.getTargetComponent();
                String suRootPath = su.getFilePath();
                ComponentState cmpState = ComponentState.UNKNOWN;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                try {
                    String errMsg;
                    if (!this.isDeployedServiceUnit(compName, suName)) {
                        this.mLogger.fine("Service unit " + suName + " has not been deployed to component " + compName + " -- skipping undeploy");
                        ++numOfSUsUndeployed;
                        continue;
                    }
                    cmpState = this.getComponentState(compName);
                    if (cmpState == ComponentState.UNKNOWN) {
                        errMsg = this.mTranslator.getString("DS_CANNOT_UNDEPLOY_SERVICE_UNIT_COMP_NOT_INSTALLED", suName, compName);
                        throw new Exception(errMsg);
                    }
                    if (cmpState == ComponentState.SHUTDOWN && !force) {
                        errMsg = this.mTranslator.getString("DS_CANNOT_CHANGE_SU_STATE_COMP_IN_INCORRECT_STATE", suName, compName);
                        throw new Exception(errMsg);
                    }
                }
                catch (Exception e) {
                    this.mLogger.warning(e.getMessage());
                    elem = this.getComponentResultXmlFragment(compName, "undeploy", e);
                    cmpTaskRslts.add(elem);
                    continue;
                }
                try {
                    DeployerMBean deployer = this.getComponentDeployerInstance(compName);
                    if (deployer == null) {
                        String errMsg = this.mTranslator.getString("DS_CANNOT_UNDEPLOY_SU_DEPLOYER_INSTANCE_NULL", suName, compName, (Object)cmpState);
                        throw new Exception(errMsg);
                    }
                    undplyRslt = deployer.undeploy(suName, suRootPath, force);
                    String suUnRgstrnRslt = null;
                    boolean isSUUnDplymntScss = this.checkSUTaskRsltStatus(undplyRslt);
                    if (isSUUnDplymntScss) {
                        suUnRgstrnRslt = this.unregisterServiceUnit(compName, suName);
                        if (!suUnRgstrnRslt.equalsIgnoreCase("SUCCESS")) {
                            undplyRslt = this.appendWarningToCmpRslt(suUnRgstrnRslt, undplyRslt);
                        } else {
                            ++numOfSUsUndeployed;
                        }
                    }
                    Document doc = db.parse(new InputSource(new StringReader(undplyRslt)));
                    Element elem2 = DOMUtil.UTIL.getElement(doc, "component-task-result");
                    cmpTaskRslts.add(elem2);
                }
                catch (Exception e) {
                    elem = this.getComponentResultXmlFragment(compName, "undeply", e);
                    cmpTaskRslts.add(elem);
                }
                if (this.mEnv.getPlatformContext().isAdminServer()) continue;
                try {
                    DirectoryUtil.deleteDir((String)params[1]);
                }
                catch (Exception exObj) {
                    File deleteMe = new File(suRootPath, PATH_TO_DELETE_ME_FILE);
                    try {
                        FileOutputStream fos = new FileOutputStream(deleteMe);
                        fos.close();
                    }
                    catch (IOException ioe) {
                        String errMsg = this.mTranslator.getString("DS_DIRECTORY_NOT_MARKED", suRootPath, ioe.getMessage());
                        this.mLogger.warning(errMsg);
                    }
                    String errMsg = this.mTranslator.getString("DS_DIRECTORY_NOT_REMOVED", suRootPath);
                    this.mLogger.warning(errMsg);
                    this.moveToTrash(suRootPath);
                }
            }
            if (numOfSUsUndeployed < numOfSUs) {
                saUnDplyRslt = false;
            }
        }
        catch (DeploymentException de) {
            throw new Exception(de.getMessage());
        }
        catch (Exception e) {
            String errMsg = this.mTranslator.getString("DS_CANNOT_UNDEPLOY_SERVICE_ASSEMBLY", saName);
            String jbiTaskStr = this.buildFrmwkExMsg("undeploy", e, errMsg);
            throw new Exception(jbiTaskStr);
        }
        if (saUnDplyRslt) {
            Object mSAUnzipDir = null;
            if (!this.mEnv.getPlatformContext().isAdminServer()) {
                try {
                    this.getRegistry().getRepository().removeArchive(ArchiveType.SERVICE_ASSEMBLY, saName);
                    this.getRegistry().getUpdater().removeServiceAssembly("domain", saName);
                }
                catch (JBIException jex) {
                    this.mLogger.warning(jex.getMessage());
                }
            }
        }
        String resp = this.buildResponse(cmpTaskRslts, saUnDplyRslt, "undeploy", saName);
        if (saUnDplyRslt) {
            statusMsg = this.mTranslator.getString("DS_UNDEPLOYMENT_SUCCESS", saName);
            this.mLogger.info(statusMsg);
            try {
                this.getRegistry().getUpdater().removeServiceAssembly(saName);
            }
            catch (JBIException jbiex) {
                MessageBuilder msgBuilder = new MessageBuilder(this.mTranslator);
                throw new JBIException(msgBuilder.buildExceptionMessage("deploy", jbiex));
            }
            return resp;
        }
        statusMsg = this.mTranslator.getString("DS_UNDEPLOYMENT_FAILURE", saName);
        this.mLogger.warning(statusMsg);
        throw new Exception(resp);
    }

    @Override
    public String shutDown(String serviceAssemblyName, boolean force) throws Exception {
        String saState = this.getState(serviceAssemblyName);
        if (saState.equalsIgnoreCase("Started")) {
            this.stopServiceAssembly(serviceAssemblyName, true);
        }
        return this.stopShutDownServiceAssembly("shutDown", serviceAssemblyName, force);
    }

    private void rollbackSUInits(List<ServiceUnitInfo> susToRollBack) {
        try {
            for (ServiceUnitInfo su : susToRollBack) {
                String suName = su.getName();
                try {
                    DeployerMBean deployer = this.getComponentDeployerInstance(su.getTargetComponent());
                    deployer.shutDown(suName);
                }
                catch (Exception e) {
                    Element elem = this.getComponentResultXmlFragment(su.getTargetComponent(), "rollbackSUInits", e);
                    Document doc = this.mMImpl.createDocument();
                    doc.appendChild(elem);
                    StringWriter sw = new StringWriter();
                    String jbiExStr = DOMUtil.UTIL.DOM2String(doc, sw);
                    this.mLogger.warning(jbiExStr);
                }
            }
        }
        catch (Exception e) {
            String jbiExStr = this.buildFrmwkExMsg("rollbackSUInits", e, e.getMessage());
            this.mLogger.warning(jbiExStr);
        }
    }

    String stopShutDownServiceAssembly(String saLifecycleMthdName, String saName, boolean force) throws Exception {
        ArrayList<Element> cmpTaskRslts = new ArrayList<Element>();
        boolean saStateChangeRslt = true;
        try {
            int operationCount = 0;
            int successCount = 0;
            ServiceAssemblyInfo saInfo = this.getServiceAssemblyInfo(saName);
            List<ServiceUnitInfo> suList = saInfo.getServiceUnitList();
            if (this.isServiceAssemblyEmpty(saName)) {
                ServiceAssemblyState saState = saLifecycleMthdName.equals("stop") ? ServiceAssemblyState.STOPPED : ServiceAssemblyState.SHUTDOWN;
                this.getRegistry().getUpdater().setServiceAssemblyState(saState, saName);
                return this.buildResponse(cmpTaskRslts, saStateChangeRslt, saLifecycleMthdName, saName);
            }
            for (ServiceUnitInfo su : suList) {
                Element elem;
                DocumentBuilder db;
                String compName;
                String suName;
                block17: {
                    suName = su.getName();
                    compName = su.getTargetComponent();
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    db = dbf.newDocumentBuilder();
                    try {
                        if (!this.isDeployedServiceUnit(compName, suName)) {
                            this.mLogger.fine("Service unit " + suName + " is not deployed to component " + compName + " : ignoring command " + saLifecycleMthdName);
                            continue;
                        }
                        ComponentState cmpState = this.getComponentState(compName);
                        if (cmpState == ComponentState.UNKNOWN) {
                            String errMsg = this.mTranslator.getString("DS_CANNOT_CHANGE_SU_STATE_COMP_NOT_INSTALLED", suName, compName);
                            throw new Exception(errMsg);
                        }
                        if (cmpState == ComponentState.SHUTDOWN) {
                        }
                        break block17;
                    }
                    catch (Exception e) {
                        elem = this.getComponentResultXmlFragment(compName, saLifecycleMthdName, e);
                        cmpTaskRslts.add(elem);
                    }
                    continue;
                }
                try {
                    DeployerMBean deployer = this.getComponentDeployerInstance(compName);
                    if (this.getActualServiceUnitState(compName, suName) != ServiceUnitState.SHUTDOWN) {
                        if (saLifecycleMthdName.equalsIgnoreCase("stop")) {
                            ++operationCount;
                            deployer.stop(suName);
                            ++successCount;
                        } else if (saLifecycleMthdName.equalsIgnoreCase("shutDown")) {
                            ++operationCount;
                            deployer.shutDown(suName, force);
                            ++successCount;
                        }
                    }
                    String scssMsg = this.buildComponentStatusMsg(compName, saLifecycleMthdName, suName);
                    Document doc = db.parse(new InputSource(new StringReader(scssMsg)));
                    Element elem2 = DOMUtil.UTIL.getElement(doc, "component-task-result");
                    cmpTaskRslts.add(elem2);
                }
                catch (Exception e) {
                    elem = this.getComponentResultXmlFragment(compName, saLifecycleMthdName, e);
                    cmpTaskRslts.add(elem);
                }
            }
            if (successCount < operationCount) {
                saStateChangeRslt = false;
            }
        }
        catch (Exception e) {
            String errMsg = this.mTranslator.getString("DS_CANNOT_CHANGE_SERVICE_ASSEMBLY_STATE", saName);
            String jbiTaskStr = this.buildFrmwkExMsg(saLifecycleMthdName, e, errMsg);
            throw new Exception(jbiTaskStr);
        }
        String resp = this.buildResponse(cmpTaskRslts, saStateChangeRslt, saLifecycleMthdName, null);
        if (!saStateChangeRslt) {
            throw new Exception(resp);
        }
        return resp;
    }

    String startServiceAssembly(String saName) throws Exception {
        String saLifecycleMthdName = "start";
        ArrayList<Element> cmpTaskRslts = new ArrayList<Element>();
        boolean saStateChangeRslt = true;
        try {
            DeployerMBean deployer;
            Element elem;
            String compName;
            String suName;
            int operationCount = 0;
            int successCount = 0;
            ServiceAssemblyInfo saInfo = this.getServiceAssemblyInfo(saName);
            List<ServiceUnitInfo> suList = saInfo.getServiceUnitList();
            ArrayList<ServiceUnitInfo> susToInitialize = new ArrayList<ServiceUnitInfo>();
            ArrayList<ServiceUnitInfo> susToStart = new ArrayList<ServiceUnitInfo>();
            ArrayList<ServiceUnitInfo> susAlreadyStarted = new ArrayList<ServiceUnitInfo>();
            ArrayList<ServiceUnitInfo> susToRollBack = new ArrayList<ServiceUnitInfo>();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (this.isServiceAssemblyEmpty(saName)) {
                this.getRegistry().getUpdater().setServiceAssemblyState(ServiceAssemblyState.STARTED, saName);
                return this.buildResponse(cmpTaskRslts, saStateChangeRslt, saLifecycleMthdName, saName);
            }
            block13: for (ServiceUnitInfo su : suList) {
                suName = su.getName();
                compName = su.getTargetComponent();
                try {
                    String errMsg;
                    if (!this.isDeployedServiceUnit(compName, suName)) {
                        this.mLogger.fine("Service unit " + suName + " is not deployed to component " + compName + " : ignoring command " + saLifecycleMthdName);
                        continue;
                    }
                    ComponentState cmpState = this.getComponentState(compName);
                    if (cmpState == ComponentState.UNKNOWN) {
                        errMsg = this.mTranslator.getString("DS_CANNOT_CHANGE_SU_STATE_COMP_NOT_INSTALLED", suName, compName);
                        throw new Exception(errMsg);
                    }
                    if (cmpState == ComponentState.SHUTDOWN) {
                        ++operationCount;
                        errMsg = this.mTranslator.getString("DS_CANNOT_CHANGE_SU_STATE_COMP_IN_INCORRECT_STATE", suName, compName);
                        throw new Exception(errMsg);
                    }
                }
                catch (Exception e) {
                    elem = this.getComponentResultXmlFragment(compName, saLifecycleMthdName, e);
                    cmpTaskRslts.add(elem);
                    continue;
                }
                ServiceUnitState currSuState = this.getActualServiceUnitState(compName, suName);
                switch (currSuState) {
                    case STARTED: {
                        susAlreadyStarted.add(su);
                        ++successCount;
                        continue block13;
                    }
                    case STOPPED: {
                        susToStart.add(su);
                        continue block13;
                    }
                    case SHUTDOWN: {
                        susToInitialize.add(su);
                        continue block13;
                    }
                }
            }
            for (ServiceUnitInfo su : susToInitialize) {
                suName = su.getName();
                compName = su.getTargetComponent();
                try {
                    ++operationCount;
                    deployer = this.getComponentDeployerInstance(compName);
                    deployer.init(su.getName(), su.getFilePath());
                    susToStart.add(su);
                    susToRollBack.add(su);
                }
                catch (Exception e) {
                    elem = this.getComponentResultXmlFragment(compName, saLifecycleMthdName, e);
                    cmpTaskRslts.add(elem);
                }
            }
            for (ServiceUnitInfo su : suList) {
                suName = su.getName();
                compName = su.getTargetComponent();
                try {
                    Element elem2;
                    Document doc;
                    String scssMsg;
                    if (susToStart.contains(su)) {
                        deployer = this.getComponentDeployerInstance(compName);
                        deployer.start(suName);
                        if (susToRollBack.contains(su)) {
                            susToRollBack.remove(su);
                        }
                        ++successCount;
                        scssMsg = this.buildComponentStatusMsg(compName, saLifecycleMthdName, suName);
                        doc = db.parse(new InputSource(new StringReader(scssMsg)));
                        elem2 = DOMUtil.UTIL.getElement(doc, "component-task-result");
                        cmpTaskRslts.add(elem2);
                        continue;
                    }
                    if (!susAlreadyStarted.contains(su)) continue;
                    String locMsg = this.mTranslator.getString("DS_SERVICE_UNIT_ALREADY_STARTED", suName);
                    scssMsg = this.buildComponentStatusMsg(compName, saLifecycleMthdName, suName, locMsg);
                    doc = db.parse(new InputSource(new StringReader(scssMsg)));
                    elem2 = DOMUtil.UTIL.getElement(doc, "component-task-result");
                    cmpTaskRslts.add(elem2);
                }
                catch (Exception e) {
                    elem = this.getComponentResultXmlFragment(compName, saLifecycleMthdName, e);
                    cmpTaskRslts.add(elem);
                }
            }
            if (operationCount > 0 && successCount == 0) {
                saStateChangeRslt = false;
            }
            if (!susToRollBack.isEmpty()) {
                this.rollbackSUInits(susToRollBack);
            }
        }
        catch (Exception e) {
            String errMsg = this.mTranslator.getString("DS_CANNOT_CHANGE_SERVICE_ASSEMBLY_STATE", saName);
            String jbiTaskStr = this.buildFrmwkExMsg(saLifecycleMthdName, e, errMsg);
            throw new Exception(jbiTaskStr);
        }
        String resp = this.buildResponse(cmpTaskRslts, saStateChangeRslt, saLifecycleMthdName, saName);
        if (!saStateChangeRslt) {
            throw new Exception(resp);
        }
        return resp;
    }

    private DeploymentContextImpl buildContext(String saName) throws Exception {
        DeploymentContextImpl dc = null;
        String jbiXmlPath = null;
        try {
            dc = new DeploymentContextImpl(null, sMContext, this.mLogger);
            String auUnzipDir = this.dplyRoot + File.separator + saName;
            File fl = new File(auUnzipDir);
            if (!fl.exists()) {
                String errMsg = this.mTranslator.getString("DS_CANNOT_GET_SA_STATE_INVALID_SA_NAME", saName);
                throw new Exception(errMsg);
            }
            jbiXmlPath = auUnzipDir + File.separator + "META-INF" + File.separator + "jbi.xml";
            dc.buildDeploymentContext(jbiXmlPath, false);
        }
        catch (DeploymentException de) {
            throw new Exception(de.getMessage());
        }
        catch (Exception e) {
            String errMsg = null;
            errMsg = e.getMessage();
            if (!errMsg.startsWith("JBIMA")) {
                errMsg = this.mTranslator.getString("DS_CANNOT_BUILD_DEPLOYMENT_CONTEXT", saName);
            }
            String jbiTaskStr = this.buildFrmwkExMsg("buildContext", e, errMsg);
            throw new Exception(jbiTaskStr);
        }
        return dc;
    }

    HashMap getConnectionsInfo(Element connectionElem, String saName) throws DeploymentException {
        HashMap<String, Object> connInfo = new HashMap<String, Object>();
        try {
            QName intrfName = null;
            QName fromSvc = null;
            String fromEndpoint = null;
            QName toSvc = null;
            String toEndpoint = null;
            Element consumerElem = DOMUtil.UTIL.getElement(connectionElem, "consumer");
            Element providerElem = DOMUtil.UTIL.getElement(connectionElem, "provider");
            intrfName = DOMUtil.UTIL.getQualifiedAttributeValue(consumerElem, "interface-name");
            if (intrfName == null || intrfName.toString().equals("")) {
                fromSvc = DOMUtil.UTIL.getQualifiedAttributeValue(consumerElem, "service-name");
                fromEndpoint = DOMUtil.UTIL.getAttribute(consumerElem, "endpoint-name");
                connInfo.put("from-service", fromSvc);
                connInfo.put("from-endpoint", fromEndpoint);
            } else {
                connInfo.put("interface-name", intrfName);
            }
            toSvc = DOMUtil.UTIL.getQualifiedAttributeValue(providerElem, "service-name");
            toEndpoint = DOMUtil.UTIL.getAttribute(providerElem, "endpoint-name");
            connInfo.put("to-service", toSvc);
            connInfo.put("to-endpoint", toEndpoint);
        }
        catch (Exception e) {
            e.printStackTrace();
            String jbiExStr = null;
            String errMsg = this.mTranslator.getString("DS_UNABLE_TO_GET_CONNECTIONS_INFO", saName);
            jbiExStr = this.buildFrmwkExMsg("getConnectionsInfo", e, errMsg);
            throw new DeploymentException(jbiExStr);
        }
        return connInfo;
    }

    HashMap activateConnections(String saName) throws Exception {
        return this.activateConnections(saName, true);
    }

    public HashMap activateConnections(String saName, boolean xmlMsg) throws Exception {
        ConnectionManager connMgr = null;
        HashMap<Object, Object> infoMsgMap = new HashMap<Object, Object>();
        Element connctnsElement = this.getConnectionsElement(saName);
        if (connctnsElement == null) {
            return null;
        }
        NodeList nl = DOMUtil.UTIL.getChildElements(connctnsElement, "connection");
        if (nl.getLength() == 0) {
            return null;
        }
        String fromEndpoint = null;
        QName intrfcName = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node connNode = nl.item(i);
            if (!(connNode instanceof Element)) continue;
            try {
                HashMap connInfo = this.getConnectionsInfo((Element)connNode, saName);
                intrfcName = (QName)connInfo.get("interface-name");
                QName fromSvc = null;
                fromEndpoint = null;
                if (intrfcName == null || intrfcName.toString().equals("")) {
                    fromSvc = (QName)connInfo.get("from-service");
                    fromEndpoint = (String)connInfo.get("from-endpoint");
                }
                QName toSvc = (QName)connInfo.get("to-service");
                String toEndpoint = (String)connInfo.get("to-endpoint");
                connMgr = sMContext.getConnectionManager();
                if (intrfcName != null && !intrfcName.toString().equals("")) {
                    connMgr.addInterfaceConnection(intrfcName, toSvc, toEndpoint);
                    continue;
                }
                Link linkType = this.getLinkType(fromEndpoint, saName);
                if (linkType == null) {
                    linkType = Link.STANDARD;
                }
                connMgr.addEndpointConnection(fromSvc, fromEndpoint, toSvc, toEndpoint, linkType);
                continue;
            }
            catch (DeploymentException de) {
                de.printStackTrace();
                throw new Exception(de.getMessage());
            }
            catch (Exception exObj) {
                exObj.printStackTrace();
                String errMsg = this.mTranslator.getString("DS_UNABLE_TO_ACTIVATE_CONNECTION", saName, exObj.getMessage());
                if (xmlMsg) {
                    Element infoElem = this.buildFrmwkInfoMsg(errMsg);
                    if (fromEndpoint != null) {
                        infoMsgMap.put(fromEndpoint, infoElem);
                        continue;
                    }
                    infoMsgMap.put(intrfcName, infoElem);
                    continue;
                }
                if (fromEndpoint != null) {
                    infoMsgMap.put(fromEndpoint, errMsg);
                    continue;
                }
                infoMsgMap.put(intrfcName, errMsg);
            }
        }
        return infoMsgMap;
    }

    HashMap deactivateConnections(String saName) throws Exception {
        ConnectionManager connMgr = null;
        HashMap<Object, Element> infoMsgMap = new HashMap<Object, Element>();
        Element connctnsElement = this.getConnectionsElement(saName);
        if (connctnsElement == null) {
            return null;
        }
        NodeList nl = DOMUtil.UTIL.getChildElements(connctnsElement, "connection");
        if (nl.getLength() == 0) {
            return null;
        }
        String fromEndpoint = null;
        QName intrfcName = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node connNode = nl.item(i);
            if (!(connNode instanceof Element)) continue;
            try {
                HashMap connInfo = this.getConnectionsInfo((Element)connNode, saName);
                intrfcName = (QName)connInfo.get("interface-name");
                QName fromSvc = null;
                fromEndpoint = null;
                if (intrfcName == null || intrfcName.toString().equals("")) {
                    fromSvc = (QName)connInfo.get("from-service");
                    fromEndpoint = (String)connInfo.get("from-endpoint");
                }
                QName toSvc = (QName)connInfo.get("to-service");
                String toEndpoint = (String)connInfo.get("to-endpoint");
                connMgr = sMContext.getConnectionManager();
                if (intrfcName != null && !intrfcName.toString().equals("")) {
                    connMgr.removeInterfaceConnection(intrfcName, toSvc, toEndpoint);
                    continue;
                }
                connMgr.removeEndpointConnection(fromSvc, fromEndpoint, toSvc, toEndpoint);
                continue;
            }
            catch (DeploymentException de) {
                de.printStackTrace();
                throw new Exception(de.getMessage());
            }
            catch (Exception exObj) {
                exObj.printStackTrace();
                String errMsg = this.mTranslator.getString("DS_UNABLE_TO_DEACTIVATE_CONNECTION", saName);
                Element infoElem = this.buildFrmwkInfoMsg(errMsg);
                if (fromEndpoint != null) {
                    infoMsgMap.put(fromEndpoint, infoElem);
                    continue;
                }
                infoMsgMap.put(intrfcName, infoElem);
            }
        }
        return infoMsgMap;
    }

    private Element buildFrmwkInfoMsg(String errMsgWithToken) {
        Document doc = null;
        Element taskStatMsgElem = null;
        try {
            doc = this.mMImpl.createDocument();
            taskStatMsgElem = doc.createElement("task-status-msg");
            Element msgLocInfoElem = doc.createElement("msg-loc-info");
            Element locTokenElem = doc.createElement("loc-token");
            Element locMsgElem = doc.createElement("loc-message");
            String token = MessageBuilder.getMessageToken(errMsgWithToken);
            String errMsg = MessageBuilder.getMessageString(errMsgWithToken);
            DOMUtil.UTIL.setTextData(locTokenElem, token);
            DOMUtil.UTIL.setTextData(locMsgElem, errMsg);
            msgLocInfoElem.appendChild(locTokenElem);
            msgLocInfoElem.appendChild(locMsgElem);
            taskStatMsgElem.appendChild(msgLocInfoElem);
        }
        catch (Exception e) {
            String statusMsg = this.mTranslator.getString("DS_DEPLOY_NO_EXCEPTION_MSG", "buildFrmwkInfoMsg");
            this.mLogger.warning(statusMsg);
        }
        return taskStatMsgElem;
    }

    private String appendMsgsToTaskRslt(String stateChangeRslt, HashMap infoMsgElems, String msgType) {
        Document doc = null;
        String rsltWithInfoMsgs = null;
        try {
            if (infoMsgElems == null || infoMsgElems.size() == 0) {
                return stateChangeRslt;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource isrc = new InputSource(new CharArrayReader(stateChangeRslt.toCharArray()));
            doc = db.parse(isrc);
            Element frmwkTaskRsltElem = DOMUtil.UTIL.getElement(doc, "frmwk-task-result");
            Element frmwkTskRsltDtlsElem = DOMUtil.UTIL.getElement(frmwkTaskRsltElem, "frmwk-task-result-details");
            Element taskRsltDtlsElem = DOMUtil.UTIL.getElement(frmwkTskRsltDtlsElem, "task-result-details");
            Element msgTypeElem = doc.createElement("message-type");
            DOMUtil.UTIL.setTextData(msgTypeElem, msgType);
            taskRsltDtlsElem.appendChild(msgTypeElem);
            Set keys = infoMsgElems.keySet();
            for (Object key : keys) {
                Element elem = (Element)infoMsgElems.get(key);
                Element infoMsgElem = (Element)doc.importNode(elem, true);
                taskRsltDtlsElem.appendChild(infoMsgElem);
            }
            StringWriter sw = new StringWriter();
            rsltWithInfoMsgs = DOMUtil.UTIL.DOM2String(doc, sw);
        }
        catch (Exception e) {
            String statusMsg = this.mTranslator.getString("DS_DEPLOY_NO_EXCEPTION_MSG", "appendMsgsToTaskRslt");
            this.mLogger.warning(statusMsg);
            e.printStackTrace();
        }
        return rsltWithInfoMsgs;
    }

    private void moveToTrash(String aDir) {
        String logMessage = this.mTranslator.getString("METHOD_ENTERED", "moveToTrash", "(" + aDir + ")");
        this.mLogger.fine(logMessage);
        String jbiRoot = sMContext.getJbiInstallRoot();
        if (null == jbiRoot || "".equals(jbiRoot)) {
            logMessage = this.mTranslator.getString("DS_NO_TRASH");
            this.mLogger.warning(logMessage);
            return;
        }
        jbiRoot = jbiRoot + "/Trash";
        int dirNum = 1;
        String trashRootPath = jbiRoot + "/" + dirNum;
        File trashRoot = new File(trashRootPath);
        while (trashRoot.exists()) {
            trashRootPath = jbiRoot + "/" + ++dirNum;
            trashRoot = new File(trashRootPath);
        }
        logMessage = this.mTranslator.getString("DS_DEBUG_OUTPUT", "Creating Trash directory as " + trashRootPath);
        this.mLogger.fine(logMessage);
        if (!trashRoot.mkdirs()) {
            logMessage = this.mTranslator.getString("DS_DEBUG_OUTPUT", "Cannot create directory " + trashRootPath);
            this.mLogger.warning(logMessage);
            return;
        }
        logMessage = this.mTranslator.getString("DS_DEBUG_OUTPUT", "Now about to rename " + aDir + " to " + trashRootPath + ".");
        this.mLogger.fine(logMessage);
        File oldRoot = new File(aDir);
        if (!oldRoot.renameTo(trashRoot)) {
            logMessage = this.mTranslator.getString("DS_DEBUG_OUTPUT", "Could not rename " + aDir + " to " + trashRootPath + ".");
            this.mLogger.warning(logMessage);
        }
    }

    private void deleteSADirectory(String saName) {
        String mSAUnzipDir = null;
        try {
            mSAUnzipDir = sMContext.getJbiInstallRoot() + File.separator + "system" + File.separator + "deployment" + File.separator + saName;
            DirectoryUtil.deleteDir(mSAUnzipDir);
        }
        catch (Exception e) {
            File deleteMe = new File(mSAUnzipDir, PATH_TO_DELETE_ME_FILE);
            try {
                FileOutputStream fos = new FileOutputStream(deleteMe);
                fos.close();
            }
            catch (IOException ioe) {
                String errMsg = this.mTranslator.getString("DS_DIRECTORY_NOT_MARKED", mSAUnzipDir, ioe.getMessage());
                this.mLogger.warning(errMsg);
            }
            String errMsg = this.mTranslator.getString("DS_DIRECTORY_NOT_REMOVED", mSAUnzipDir);
            this.mLogger.warning(errMsg);
            this.moveToTrash(mSAUnzipDir);
        }
    }

    private boolean checkSUContents(String currSAName, String compName, String suName, String currSUJarAbsPath) {
        boolean isDuplicateSUContents = false;
        String[] saNames = null;
        try {
            saNames = this.getDeployedServiceAssembliesForComponent(compName);
            for (int i = 0; i < saNames.length; ++i) {
                String dplydSUJarAbsPath;
                if (currSAName.equalsIgnoreCase(saNames[i])) continue;
                String saRootDirName = this.dplyRoot + File.separator + saNames[i];
                File saDir = new File(saRootDirName);
                String[] saDirList = saDir.list();
                for (int j = 0; !(j >= saDirList.length || saDirList[j].endsWith(".zip") && (isDuplicateSUContents = this.compareBinaryContents(currSUJarAbsPath, dplydSUJarAbsPath = this.dplyRoot + File.separator + saNames[i] + File.separator + saDirList[j]))); ++j) {
                }
                if (!isDuplicateSUContents) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            String errMsg = this.mTranslator.getString("DS_CANNOT_CHECK_SU_CONTENTS", suName, currSAName);
            String jbiExStr = this.buildFrmwkExMsg("checkSUContents", e, errMsg);
            this.mLogger.warning(jbiExStr);
        }
        return isDuplicateSUContents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareBinaryContents(String suJarAbsPath, String dplydSUJarAbsPath) {
        boolean isDuplicate = false;
        InputStream isCurrSU = null;
        InputStream isDplydSU = null;
        ZipFile mCurrSUZip = null;
        ZipFile mDplydSUZip = null;
        try {
            mCurrSUZip = new ZipFile(suJarAbsPath);
            mDplydSUZip = new ZipFile(dplydSUJarAbsPath);
            Enumeration<? extends ZipEntry> eCurrSU = mCurrSUZip.entries();
            Enumeration<? extends ZipEntry> eDplydSU = mDplydSUZip.entries();
            if (mCurrSUZip.size() != mDplydSUZip.size()) {
                boolean bl = isDuplicate;
                return bl;
            }
            int numEntries = mCurrSUZip.size();
            int duplicateEntries = 0;
            while (eCurrSU.hasMoreElements()) {
                ZipEntry zeCurrSU = eCurrSU.nextElement();
                ZipEntry zeDplydSU = eDplydSU.nextElement();
                isCurrSU = mCurrSUZip.getInputStream(zeCurrSU);
                isDplydSU = mDplydSUZip.getInputStream(zeDplydSU);
                int isCurrSUByte = isCurrSU.read();
                int isDplydSUByte = isDplydSU.read();
                while (isCurrSUByte != -1 && isDplydSUByte != -1 && isCurrSUByte == isDplydSUByte) {
                    isCurrSUByte = isCurrSU.read();
                    isDplydSUByte = isDplydSU.read();
                }
                if (isCurrSUByte == -1 && isDplydSUByte == -1) {
                    ++duplicateEntries;
                }
                isCurrSU.close();
                isDplydSU.close();
            }
            if (numEntries == duplicateEntries) {
                isDuplicate = true;
            }
        }
        catch (Exception e) {
            String jbiExStr;
            try {
                if (isCurrSU != null) {
                    isCurrSU.close();
                }
                if (isDplydSU != null) {
                    isDplydSU.close();
                }
            }
            catch (Exception ex) {
                jbiExStr = this.buildFrmwkExMsg("compareBinaryContents", ex, ex.getMessage());
                this.mLogger.warning(jbiExStr);
            }
            String errMsg = this.mTranslator.getString("DS_FAILED_COMPARING_BINARY_SU_CONTENTS", suJarAbsPath, dplydSUJarAbsPath);
            jbiExStr = this.buildFrmwkExMsg("compareBinaryContents", e, errMsg);
            this.mLogger.warning(jbiExStr);
        }
        finally {
            try {
                if (mCurrSUZip != null) {
                    mCurrSUZip.close();
                }
                if (mDplydSUZip != null) {
                    mDplydSUZip.close();
                }
            }
            catch (Exception ex) {
                String jbiExStr = this.buildFrmwkExMsg("compareBinaryContents", ex, ex.getMessage());
                this.mLogger.warning(jbiExStr);
            }
        }
        return isDuplicate;
    }

    private ObjectName getDeployerMBeanObjectName(String compName) {
        ObjectName[] dmbs = sMContext.getAdminServiceHandle().getDeployerMBeanNames(compName);
        return dmbs.length <= 0 ? null : dmbs[0];
    }

    private URL convertToProperURL(String installJarURI) throws MalformedURLException {
        if (installJarURI.startsWith("file://")) {
            return new File(installJarURI.substring(7)).toURL();
        }
        if (installJarURI.startsWith("file:" + File.separator)) {
            return new File(installJarURI.substring(5)).toURL();
        }
        if (installJarURI.startsWith("file:/")) {
            return new File(installJarURI.substring(6)).toURL();
        }
        if (installJarURI.startsWith("file:")) {
            return new File(installJarURI.substring(5)).toURL();
        }
        try {
            return new URI(installJarURI.replaceAll(" ", "%20")).toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    private ServiceUnitInfo findDeploymentUnitInfo(List<ServiceUnitInfo> suInfoList, String suName) {
        ServiceUnitInfo suInfo = null;
        for (ServiceUnitInfo su : suInfoList) {
            if (!suName.equals(su.getName())) continue;
            suInfo = su;
            break;
        }
        return suInfo;
    }

    public Iterator listServiceAssemblies(String compName) {
        ComponentInfo compInfo = this.getComponentQuery().getComponentInfo(compName);
        ArrayList<String> serviceAssemblies = new ArrayList<String>();
        List<ServiceUnitInfo> suList = compInfo.getServiceUnitList();
        for (ServiceUnitInfo su : suList) {
            serviceAssemblies.add(su.getServiceAssemblyName());
        }
        return serviceAssemblies.iterator();
    }

    public void updateServiceAssemblyConnections(String compName) {
        Iterator saList = this.listServiceAssemblies(compName);
        this.mLogger.fine("Updating Service Assembly Connections for component " + compName);
        while (saList.hasNext()) {
            String saName = (String)saList.next();
            this.updateSAState(saName);
        }
    }

    public String updateSAState(String saName) {
        String fwState = "Shutdown";
        try {
            ServiceAssemblyInfo saInfo = this.getServiceAssemblyInfo(saName);
            List<ServiceUnitInfo> suList = saInfo.getServiceUnitList();
            for (ServiceUnitInfo su : suList) {
                String suName = su.getName();
                String compName = su.getTargetComponent();
                ServiceUnitState suState = ServiceUnitState.SHUTDOWN;
                suState = this.getActualServiceUnitState(compName, suName);
                if (suState == ServiceUnitState.STARTED) {
                    fwState = "Started";
                    break;
                }
                if (suState != ServiceUnitState.STOPPED) continue;
                fwState = "Stopped";
            }
            if (fwState.equals("Started")) {
                this.mLogger.fine("Activating Connections for Service Assembly " + saName);
                this.activateConnections(saName);
            } else {
                this.mLogger.fine("Deactivating Connections for Service Assembly " + saName);
                this.deactivateConnections(saName);
            }
        }
        catch (Exception ex) {
            this.mLogger.warning(this.mTranslator.getString("DS_AUTOSTART_CONNECTION_PROCESSING_FAILED", saName, ex.toString()));
        }
        return fwState;
    }

    private boolean isServiceAssemblyEmpty(String saName) throws Exception {
        ServiceAssemblyInfo saInfo = this.getServiceAssemblyInfo(saName, "domain");
        return saInfo.getServiceUnitList().isEmpty();
    }

    private ServiceAssemblyInfo getServiceAssemblyInfo(String saName, String target) throws Exception {
        ServiceAssemblyQuery saQuery = this.getRegistry().getServiceAssemblyQuery(target);
        ServiceAssemblyInfo saInfo = saQuery.getServiceAssemblyInfo(saName);
        if (saInfo == null) {
            String errMsg = this.mTranslator.getString("DS_CANNOT_GET_SA_INFO_INVALID_SA_NAME", saName);
            throw new Exception(errMsg);
        }
        return saInfo;
    }

    private ServiceAssemblyInfo getServiceAssemblyInfo(String saName) throws Exception {
        ServiceAssemblyQuery saQuery = this.getRegistry().getServiceAssemblyQuery();
        ServiceAssemblyInfo saInfo = saQuery.getServiceAssemblyInfo(saName);
        if (saInfo == null) {
            String errMsg = this.mTranslator.getString("DS_CANNOT_GET_SA_INFO_INVALID_SA_NAME", saName);
            throw new Exception(errMsg);
        }
        return saInfo;
    }

    public Element getConnectionsElement(String saName) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        String saDescriptor = this.getRegistry().getGenericQuery().getServiceAssemblyDeploymentDescriptor(saName);
        InputSource ipSrc = new InputSource(new StringReader(saDescriptor));
        Document doc = db.parse(ipSrc);
        Element saElem = DOMUtil.UTIL.getElement(doc, "service-assembly");
        return DOMUtil.UTIL.getElement(saElem, "connections");
    }

    public Link getLinkType(String fromEndpoint, String saName) throws Exception {
        Link linkType = null;
        try {
            ServiceAssemblyInfo saInfo = this.getServiceAssemblyInfo(saName, "domain");
            List<ServiceUnitInfo> suList = saInfo.getServiceUnitList();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            for (ServiceUnitInfo su : suList) {
                String suDescriptor = su.getFilePath() + File.separator + "META-INF" + File.separator + "jbi.xml";
                File jbiXmlFile = new File(suDescriptor);
                if (!jbiXmlFile.exists()) continue;
                Document doc = db.parse(jbiXmlFile);
                Element servicesElem = DOMUtil.UTIL.getElement(doc, "services");
                Element consumesElem = DOMUtil.UTIL.getElement(servicesElem, "consumes");
                if (consumesElem == null) {
                    return null;
                }
                String endpointName = DOMUtil.UTIL.getAttribute(consumesElem, "endpoint-name");
                if (!endpointName.equalsIgnoreCase(fromEndpoint)) continue;
                String linkTypeStr = DOMUtil.UTIL.getAttribute(consumesElem, "link-type");
                if (linkTypeStr.equalsIgnoreCase("HARD")) {
                    linkType = Link.HARD;
                }
                if (linkTypeStr.equalsIgnoreCase("STANDARD")) {
                    linkType = Link.STANDARD;
                }
                if (linkTypeStr.equalsIgnoreCase("SOFT")) {
                    linkType = Link.SOFT;
                }
                break;
            }
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            String errMsg = this.mTranslator.getString("DS_UNABLE_TO_GET_LINK_TYPE_FROM_SU_DESCRIPTOR", saName);
            String jbiTaskStr = this.buildFrmwkExMsg("getLinkType", e, errMsg);
            throw new DeploymentException(jbiTaskStr);
        }
        return linkType;
    }

    private ObjectName getComponentLifeCycleMBeanName(String componentName) {
        MBeanNames mbnNames = sMContext.getMBeanNames();
        ObjectName compLCMBean = null;
        ComponentType compType = this.getComponentType(componentName);
        compLCMBean = ComponentType.BINDING == compType ? mbnNames.getBindingMBeanName(componentName, "Lifecycle") : mbnNames.getEngineMBeanName(componentName, "Lifecycle");
        return compLCMBean;
    }

    private ComponentType getComponentType(String componentName) {
        ComponentType compType = null;
        ComponentInfo compInfo = this.getComponentQuery().getComponentInfo(componentName);
        if (compInfo != null) {
            compType = compInfo.getComponentType();
        }
        return compType;
    }

    private String stopServiceAssembly(String serviceAssemblyName, boolean isStarted) throws Exception {
        HashMap infoMsgElems = null;
        if (isStarted) {
            infoMsgElems = this.deactivateConnections(serviceAssemblyName);
        }
        String stateChangeRslt = this.stopShutDownServiceAssembly("stop", serviceAssemblyName, false);
        String jbiTaskStr = this.appendMsgsToTaskRslt(stateChangeRslt, infoMsgElems, "WARNING");
        return jbiTaskStr;
    }

    private DeployerMBean getComponentDeployerInstance(String compName) {
        return sMContext.getEnvironmentContext().getComponentManager().getDeployerInstance(compName);
    }

    private boolean isPartialSuccess(List<Element> cmpTaskRslts) {
        int successCount = 0;
        int numComponentResults = cmpTaskRslts.size();
        for (Element cmpResult : cmpTaskRslts) {
            Element taskResult = DOMUtil.UTIL.getElement(cmpResult, "task-result");
            String taskResultStr = DOMUtil.UTIL.getTextData(taskResult);
            if (!"SUCCESS".equalsIgnoreCase(taskResultStr)) continue;
            ++successCount;
        }
        return successCount > 0 && successCount != numComponentResults;
    }

    private Element getComponentResultXmlFragment(String compName, String taskId, Exception ex) {
        String exMessage = ex.getMessage();
        Element elem = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(exMessage)));
            elem = DOMUtil.UTIL.getElement(doc, "component-task-result");
        }
        catch (Exception e) {
            elem = this.buildComponentExMsg(taskId, compName, ex);
        }
        return elem;
    }
}

