/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.util;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.descriptor.ComponentDescriptor;
import com.sun.jbi.management.descriptor.Jbi;
import com.sun.jbi.management.message.MessageBuilder;
import com.sun.jbi.management.util.ArchiveHelper;
import com.sun.jbi.management.util.Validator;
import java.io.File;
import java.util.logging.Logger;
import javax.jbi.JBIException;

public class ComponentValidator
implements Validator {
    private Logger mLog;
    private StringTranslator mTranslator;
    private ArchiveHelper mArchHelper;
    private boolean mValidate;
    private MessageBuilder mMsgBuilder;
    private static final String EMPTY_STR = "";

    public ComponentValidator(EnvironmentContext envCtx, boolean validate) throws Exception {
        this.mTranslator = envCtx.getStringTranslator("com.sun.jbi.management");
        this.mLog = Logger.getLogger("com.sun.jbi.management");
        this.mArchHelper = new ArchiveHelper(envCtx);
        this.mValidate = validate;
        this.mMsgBuilder = new MessageBuilder(this.mTranslator);
    }

    public void validate(File archivePath) throws Exception {
        this.validateDescriptor(archivePath);
    }

    private void validateDescriptor(File archivePath) throws Exception {
        Jbi jbiXml = this.mArchHelper.loadJbiXml(archivePath, this.mValidate);
        ComponentDescriptor descr = null;
        String[] params = new String[]{archivePath.getAbsolutePath()};
        try {
            descr = new ComponentDescriptor(jbiXml);
        }
        catch (IllegalArgumentException iex) {
            String errMsg = this.mTranslator.getString("JBI_ADMIN_INVALID_COMPONENT_ARCHIVE_TYPE", archivePath);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("validateDescriptor", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
        if (EMPTY_STR.equals(descr.getComponentClassName())) {
            String errMsg = this.mTranslator.getString("JBI_ADMIN_MISSING_COMPONENT_LIFECYCLE", archivePath);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("validateDescriptor", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
        if (EMPTY_STR.equals(descr.getBootstrapClassName())) {
            String errMsg = this.mTranslator.getString("JBI_ADMIN_MISSING_COMPONENT_BOOTSTRAP", archivePath);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("validateDescriptor", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
        if (descr.getBootstrapClassPathElements().isEmpty()) {
            String errMsg = this.mTranslator.getString("JBI_ADMIN_EMPTY_BOOTSTRAP_CLASSPATH", archivePath);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("validateDescriptor", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
        if (descr.getComponentClassPathElements().isEmpty()) {
            String errMsg = this.mTranslator.getString("JBI_ADMIN_EMPTY_LIFECYCLE_CLASSPATH", archivePath);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("validateDescriptor", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
    }
}

