/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.DeliveryChannel;
import com.sun.jbi.messaging.EndpointListener;
import com.sun.jbi.messaging.EndpointRegistry;
import com.sun.jbi.messaging.ExchangeFactory;
import com.sun.jbi.messaging.ExchangeIdGenerator;
import com.sun.jbi.messaging.MessageExchange;
import com.sun.jbi.messaging.MessageExchangeProxy;
import com.sun.jbi.messaging.MessageService;
import com.sun.jbi.messaging.MessagingStatistics;
import com.sun.jbi.messaging.RegisteredEndpoint;
import com.sun.jbi.messaging.TimeoutListener;
import com.sun.jbi.messaging.util.Translator;
import com.sun.jbi.monitoring.ComponentStatisticsBase;
import java.net.URI;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.transaction.xa.XAResource;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class DeliveryChannelImpl
implements DeliveryChannel {
    public static final String REG_NOTIFICATION_TYPE = "Registration";
    private String mChannelId;
    private ClassLoader mClassLoader;
    private MessageService mMsgSvc;
    private boolean mIsClosed;
    private boolean mTransactional;
    private IdentityHashMap mActive;
    private LinkedList mQueue;
    private HashSet<RegisteredEndpoint> mInternalEndpoints;
    private HashSet<RegisteredEndpoint> mExternalEndpoints;
    private EndpointRegistry mRegistry;
    private EndpointListener mListener;
    private TimeoutListener mTimeout;
    private int mNotifyIdx = 0;
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());
    private ComponentStatisticsBase mStats;
    private MessagingStatistics mMsgStats;

    DeliveryChannelImpl(String channelId, ClassLoader classLoader, MessageService msgSvc, EndpointListener listener) {
        this.mChannelId = channelId;
        this.mClassLoader = classLoader;
        this.mMsgSvc = msgSvc;
        this.mIsClosed = false;
        this.mTransactional = true;
        this.mQueue = new LinkedList();
        this.mActive = new IdentityHashMap();
        this.mInternalEndpoints = new HashSet();
        this.mExternalEndpoints = new HashSet();
        this.mRegistry = EndpointRegistry.getInstance();
        this.mListener = listener;
        this.mStats = null;
        this.mMsgStats = null;
    }

    DeliveryChannelImpl(String channelId, ClassLoader classLoader, MessageService msgSvc, EndpointListener listener, ComponentStatisticsBase stats) {
        this.mChannelId = channelId;
        this.mClassLoader = classLoader;
        this.mMsgSvc = msgSvc;
        this.mIsClosed = false;
        this.mTransactional = true;
        this.mQueue = new LinkedList();
        this.mActive = new IdentityHashMap();
        this.mInternalEndpoints = new HashSet();
        this.mExternalEndpoints = new HashSet();
        this.mRegistry = EndpointRegistry.getInstance();
        this.mListener = listener;
        this.mStats = stats;
        this.mMsgStats = null != stats ? (MessagingStatistics)stats.getMessagingStatisticsInstance() : null;
    }

    public javax.jbi.messaging.MessageExchange accept() throws MessagingException {
        return this.accept(0L);
    }

    public javax.jbi.messaging.MessageExchange accept(long timeout) throws MessagingException {
        MessageExchangeProxy me = null;
        if (this.mIsClosed) {
            throw new MessagingException(Translator.translate("CHANNEL_CLOSED"));
        }
        me = timeout == 0L ? this.dequeueExchange() : this.dequeueExchange(timeout);
        if (me != null && me.handleAccept(this)) {
            this.removeReference(me);
            this.mLog.finer(Translator.translate("EXCHANGE_ACCEPTED", new Object[]{me.getExchangeId(), this.mChannelId}));
        }
        return me;
    }

    public void send(javax.jbi.messaging.MessageExchange exchange) throws MessagingException {
        if (this.isClosed()) {
            throw new MessagingException(Translator.translate("CHANNEL_CLOSED"));
        }
        this.mMsgSvc.doExchange(this, (MessageExchangeProxy)exchange);
    }

    public boolean sendSync(javax.jbi.messaging.MessageExchange exchange) throws MessagingException {
        if (this.isClosed()) {
            throw new MessagingException(Translator.translate("CHANNEL_CLOSED"));
        }
        return this.sendSync(exchange, 0L);
    }

    public boolean sendSync(javax.jbi.messaging.MessageExchange exchange, long timeout) throws MessagingException {
        MessageExchangeProxy mep = (MessageExchangeProxy)exchange;
        this.mLog.finer(Translator.translate("EXCHANGE_SEND", new Object[]{mep.getExchangeId(), this.mChannelId}));
        boolean available = this.mMsgSvc.doSynchExchange(this, mep, timeout);
        if (available && mep.handleAccept(this)) {
            this.removeReference(mep);
        }
        return available;
    }

    public MessageExchangeFactory createExchangeFactory() {
        return new ExchangeFactory(this.mMsgSvc, this.mMsgStats);
    }

    public MessageExchangeFactory createExchangeFactory(QName interfaceName) {
        return ExchangeFactory.newInterfaceFactory(this.mMsgSvc, this.mMsgStats, interfaceName);
    }

    public MessageExchangeFactory createExchangeFactoryForService(QName serviceName) {
        return ExchangeFactory.newServiceFactory(this.mMsgSvc, this.mMsgStats, serviceName);
    }

    public MessageExchangeFactory createExchangeFactory(ServiceEndpoint endpoint) {
        return ExchangeFactory.newEndpointFactory(this.mMsgSvc, this.mMsgStats, endpoint);
    }

    public void registerXAResource(XAResource resource) {
        this.mMsgSvc.addXAResource(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredEndpoint activateEndpoint(QName service, String endpoint) throws MessagingException {
        if (service == null || endpoint == null || endpoint.equals("")) {
            throw new MessagingException(Translator.translate("ACTIVATE_NOT_NULL"));
        }
        RegisteredEndpoint re = this.mRegistry.registerInternalEndpoint(service, endpoint, this.getChannelId());
        if (null != this.mStats && this.mStats.getStatisticsBase().isEnabled()) {
            this.mStats.incrementRegisteredServicesOrEndpoints();
        }
        HashSet<RegisteredEndpoint> hashSet = this.mInternalEndpoints;
        synchronized (hashSet) {
            this.mInternalEndpoints.add(re);
        }
        if (this.mListener != null) {
            this.mListener.activate(this, re);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateEndpoint(ServiceEndpoint ref) throws MessagingException {
        RegisteredEndpoint re = (RegisteredEndpoint)ref;
        if (!re.getOwnerId().equals(this.mChannelId)) {
            throw new MessagingException(Translator.translate("DEACTIVATE_NOT_OWNER"));
        }
        HashSet<RegisteredEndpoint> hashSet = this.mInternalEndpoints;
        synchronized (hashSet) {
            this.mInternalEndpoints.remove(ref);
        }
        this.mRegistry.removeEndpoint(re);
        if (null != this.mStats && this.mStats.getStatisticsBase().isEnabled()) {
            this.mStats.decrementRegisteredServicesOrEndpoints();
        }
        if (this.mListener != null) {
            this.mListener.deactivate(this, re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExternalEndpoint(ServiceEndpoint externalEndpoint) throws MessagingException {
        try {
            RegisteredEndpoint re = this.mRegistry.registerExternalEndpoint(externalEndpoint, this.getChannelId());
            if (null != this.mStats && this.mStats.getStatisticsBase().isEnabled()) {
                this.mStats.incrementRegisteredServicesOrEndpoints();
            }
            HashSet<RegisteredEndpoint> hashSet = this.mExternalEndpoints;
            synchronized (hashSet) {
                this.mExternalEndpoints.add(re);
            }
        }
        catch (MessagingException msgEx) {
            this.mLog.warning(msgEx.getMessage());
            throw msgEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterExternalEndpoint(ServiceEndpoint externalEndpoint) throws MessagingException {
        RegisteredEndpoint re = this.mRegistry.getExternalEndpoint(externalEndpoint.getServiceName(), externalEndpoint.getEndpointName());
        if (!re.getOwnerId().equals(this.mChannelId)) {
            throw new MessagingException(Translator.translate("DEACTIVATE_NOT_OWNER"));
        }
        HashSet<RegisteredEndpoint> hashSet = this.mExternalEndpoints;
        synchronized (hashSet) {
            this.mExternalEndpoints.remove(re);
        }
        this.mRegistry.removeEndpoint(re);
        if (null != this.mStats && this.mStats.getStatisticsBase().isEnabled()) {
            this.mStats.decrementRegisteredServicesOrEndpoints();
        }
    }

    public ServiceEndpoint getEndpoint(QName service, String name) {
        ServiceEndpoint endpoint = null;
        ServiceEndpoint[] list = this.getEndpointsForService(service);
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].getEndpointName().equals(name)) continue;
            endpoint = list[i];
            break;
        }
        return endpoint;
    }

    public Document getEndpointDescriptor(ServiceEndpoint endpoint) throws MessagingException {
        return this.mMsgSvc.queryDescriptor(endpoint);
    }

    public ServiceEndpoint[] getExternalEndpoints(QName interfaceName) {
        return this.mRegistry.getExternalEndpointsForInterface(interfaceName, this.mMsgSvc);
    }

    public ServiceEndpoint[] getEndpoints(QName interfaceName) {
        return this.mRegistry.getInternalEndpointsForInterface(interfaceName, this.mMsgSvc);
    }

    public ServiceEndpoint[] getEndpoints() {
        return this.mInternalEndpoints.toArray(new ServiceEndpoint[this.mInternalEndpoints.size()]);
    }

    public ServiceEndpoint[] getExternalEndpointsForService(QName serviceName) {
        return this.mRegistry.getExternalEndpointsForService(serviceName);
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment endpointReference) {
        return this.mMsgSvc.resolveEndpointReference(endpointReference);
    }

    public ServiceEndpoint[] getEndpointsForService(QName service) {
        return this.mRegistry.getInternalEndpointsForService(service, false);
    }

    public void setTransactional(boolean transactional) {
        this.mTransactional = transactional;
    }

    public final boolean isTransactional() {
        return this.mTransactional;
    }

    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public void close() throws MessagingException {
        if (this.mIsClosed) {
            return;
        }
        this.mIsClosed = true;
        for (RegisteredEndpoint ref : this.mInternalEndpoints) {
            this.mRegistry.removeEndpoint(ref);
        }
        for (RegisteredEndpoint ref : this.mExternalEndpoints) {
            this.mRegistry.removeEndpoint(ref);
        }
        this.cleanActive();
        this.mMsgSvc.removeChannel(this.mChannelId);
    }

    public boolean isClosed() {
        return this.mIsClosed;
    }

    String getChannelId() {
        return this.mChannelId;
    }

    synchronized void addReference(javax.jbi.messaging.MessageExchange me) {
        this.mActive.put(me, me);
    }

    synchronized void removeReference(javax.jbi.messaging.MessageExchange me) {
        this.mActive.remove(me);
    }

    public synchronized boolean activeReference(javax.jbi.messaging.MessageExchange me) {
        return this.mActive.get(me) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void queueExchange(MessageExchangeProxy mep) throws MessagingException {
        if (this.mIsClosed) {
            throw new MessagingException(Translator.translate("CHANNEL_CLOSED"));
        }
        this.mActive.put(mep, mep);
        if (mep.getSynchState() == 0) {
            mep.setSynchState(4);
            this.mQueue.addLast(mep);
            if (this.mQueue.size() == 1) {
                this.notifyAll();
            }
        } else {
            MessageExchangeProxy messageExchangeProxy = mep;
            synchronized (messageExchangeProxy) {
                if (mep.getSynchState() == 1 || mep.getSynchState() == 2) {
                    mep.setSynchState(3);
                    mep.notify();
                } else if (mep.getSynchState() == 5) {
                    this.mActive.remove(mep);
                    mep.terminate();
                    throw new MessagingException(Translator.translate("MESSAGE_TIMEOUT"));
                }
            }
        }
    }

    synchronized MessageExchangeProxy dequeueExchange() throws MessagingException {
        MessageExchangeProxy me = null;
        try {
            while (!this.mIsClosed) {
                if (this.mQueue.size() > 0) {
                    me = (MessageExchangeProxy)this.mQueue.removeFirst();
                    break;
                }
                this.wait();
            }
        }
        catch (InterruptedException intEx) {
            throw new MessagingException((Throwable)intEx);
        }
        return me;
    }

    synchronized MessageExchangeProxy dequeueExchange(long timeout) throws MessagingException {
        MessageExchangeProxy me = null;
        boolean timedOut = false;
        long endTime = System.currentTimeMillis() + timeout;
        try {
            while (!this.mIsClosed) {
                if (this.mQueue.size() > 0) {
                    me = (MessageExchangeProxy)this.mQueue.removeFirst();
                } else if (!timedOut) {
                    this.wait(timeout);
                    timeout = endTime - System.currentTimeMillis();
                    timedOut = timeout <= 0L;
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException intEx) {
            throw new MessagingException((Throwable)intEx);
        }
        return me;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanActive() {
        Iterator i;
        Set s;
        DeliveryChannelImpl deliveryChannelImpl = this;
        synchronized (deliveryChannelImpl) {
            s = this.mActive.entrySet();
            i = s.iterator();
            while (i.hasNext()) {
                MessageExchangeProxy mep = (MessageExchangeProxy)i.next().getKey();
                if (!mep.terminate()) continue;
                i.remove();
                this.mLog.warning("DeliveryChannel:Close Cleanup Exchange\n" + mep);
            }
            this.mQueue.clear();
            this.notifyAll();
        }
        i = s.iterator();
        while (i.hasNext()) {
            MessageExchangeProxy mep = (MessageExchangeProxy)i.next().getKey();
            try {
                mep.getSendChannel().queueExchange(mep.getTwin());
            }
            catch (MessagingException mEx) {
                this.mLog.warning("MessagingException Id(" + mep.getExchangeId() + ") : " + (Object)((Object)mEx));
            }
        }
    }

    DeliveryChannelImpl getChannel(String id) {
        return this.mMsgSvc.getChannel(id);
    }

    public void setEndpointListener(EndpointListener listener) {
        this.mMsgSvc.setEndpointListener(listener);
    }

    public void setTimeoutListener(TimeoutListener timeout) {
        this.mMsgSvc.setTimeoutListener(timeout == null ? null : this, timeout);
    }

    public javax.jbi.messaging.MessageExchange createExchange(URI pattern, String id) throws MessagingException {
        javax.jbi.messaging.MessageExchange me = this.createExchangeFactory().createExchange(pattern);
        ((MessageExchangeProxy)me).getMessageExchange().setExchangeId(id);
        return me;
    }

    public ServiceEndpoint createEndpoint(QName service, String endpoint) throws MessagingException {
        return this.mRegistry.registerInternalEndpoint(service, endpoint, this.mChannelId);
    }

    public void setExchangeIdGenerator(ExchangeIdGenerator generator) {
        this.mMsgSvc.setExchangeIdGenerator(generator);
    }

    public boolean isExchangeOkay(javax.jbi.messaging.MessageExchange me) {
        return this.mMsgSvc.isExchangeOkay((MessageExchange)me);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("  DeliveryChannel for Component: ");
        sb.append(this.mChannelId);
        sb.append("\n    State: ");
        sb.append(this.mIsClosed ? "CLOSED" : "OPEN");
        sb.append("  Transactional: ");
        sb.append(this.mTransactional ? "YES" : "NO");
        sb.append("\n    InternalEndpoints Count: ");
        sb.append(this.mInternalEndpoints.size());
        sb.append("\n");
        Iterator<RegisteredEndpoint> i = this.mInternalEndpoints.iterator();
        while (i.hasNext()) {
            sb.append(((Object)i.next()).toString());
        }
        sb.append("    ExternalEndpoints Count: ");
        sb.append(this.mExternalEndpoints.size());
        sb.append("\n");
        i = this.mExternalEndpoints.iterator();
        while (i.hasNext()) {
            sb.append(((Object)i.next()).toString());
            sb.append("\n");
        }
        sb.append("    Active MEP's  Count: ");
        sb.append(this.mActive.size());
        sb.append("\n");
        for (MessageExchangeProxy mep : this.mActive.values()) {
            sb.append(mep.toString());
            sb.append("\n");
        }
        sb.append("    Queued MEP's Count: ");
        sb.append(this.mQueue.size());
        sb.append("\n");
        for (MessageExchangeProxy mep : this.mQueue) {
            sb.append("      Exchange Id(");
            sb.append(mep.getExchangeId());
            sb.append(")\n");
        }
        return sb.toString();
    }
}

