/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.MessageServiceStatisticsMBean;
import com.sun.jbi.messaging.MessagingStatistics;
import com.sun.jbi.monitoring.StatisticsBase;
import com.sun.jbi.util.monitoring.StatisticsBaseImpl;
import java.util.Date;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;

public class MessageServiceStatistics
implements MessageServiceStatisticsMBean {
    private StatisticsBase mStatisticsBase;
    private Date mLastRestartTime;
    private int mRegisteredServices;
    private int mRegisteredEndpoints;
    private MessagingStatistics mMessagingStatistics;
    private static final int ONE_HUNDRED = 100;
    private static final int MILLISECONDS_PER_HOUR = 3600000;

    MessageServiceStatistics(String key) {
        this.mStatisticsBase = new StatisticsBaseImpl(key);
        this.mMessagingStatistics = new MessagingStatistics();
    }

    public boolean isEnabled() {
        return this.mStatisticsBase.isEnabled();
    }

    public void setDisabled() {
        this.mStatisticsBase.setDisabled();
    }

    public void setEnabled() {
        this.mStatisticsBase.setEnabled();
    }

    public Date getLastRestartTime() {
        return this.mLastRestartTime;
    }

    public int getRegisteredServices() {
        return this.mRegisteredServices;
    }

    public int getRegisteredEndpoints() {
        return this.mRegisteredEndpoints;
    }

    public CompositeData getMessagingStatistics() {
        CompositeData mscd = null;
        try {
            mscd = this.mMessagingStatistics.toCompositeData();
        }
        catch (OpenDataException odEx) {
            odEx.printStackTrace();
        }
        return mscd;
    }

    MessagingStatistics getMessagingStatisticsInstance() {
        return this.mMessagingStatistics;
    }

    StatisticsBase getStatisticsBase() {
        return this.mStatisticsBase;
    }

    void setLastRestartTime(Date startTime) {
        this.mLastRestartTime = startTime;
        this.mMessagingStatistics.setLastRestartTime(startTime);
    }

    void decrementRegisteredEndpoints() {
        --this.mRegisteredEndpoints;
    }

    void incrementRegisteredEndpoints() {
        ++this.mRegisteredEndpoints;
    }

    void decrementRegisteredServices() {
        --this.mRegisteredServices;
    }

    void incrementRegisteredServices() {
        ++this.mRegisteredServices;
    }

    void resetStatistics() {
        this.mRegisteredServices = 0;
        this.mRegisteredEndpoints = 0;
        this.mMessagingStatistics.resetStatistics();
    }
}

