/*
 * Decompiled with CFR 0.152.
 */
package samples.ejb.mdb.simple.client;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SimpleMessageClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        InitialContext initialContext = null;
        QueueConnectionFactory queueConnectionFactory = null;
        QueueConnection queueConnection = null;
        QueueSession queueSession = null;
        Queue queue = null;
        QueueSender queueSender = null;
        TextMessage textMessage = null;
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException namingException) {
            System.out.println("Could not create JNDI context: " + namingException.toString());
            System.exit(1);
        }
        try {
            queueConnectionFactory = (QueueConnectionFactory)initialContext.lookup("java:comp/env/jms/MyMDBQcf");
            queue = (Queue)initialContext.lookup("java:comp/env/jms/MyQueue");
        }
        catch (NamingException namingException) {
            System.out.println("JNDI lookup failed: " + namingException.toString());
            System.exit(1);
        }
        try {
            queueConnection = queueConnectionFactory.createQueueConnection();
            queueSession = queueConnection.createQueueSession(false, 1);
            queueSender = queueSession.createSender(queue);
            textMessage = queueSession.createTextMessage();
            for (int i = 0; i < 3; ++i) {
                textMessage.setText("This is message " + (i + 1));
                System.out.println("Sending message: " + textMessage.getText());
                queueSender.send((Message)textMessage);
            }
        }
        catch (Throwable throwable) {
            System.out.println("Exception occurred: " + throwable.toString());
        }
        finally {
            if (queueConnection != null) {
                try {
                    queueConnection.close();
                }
                catch (JMSException jMSException) {}
            }
            System.exit(0);
        }
    }
}

