/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ee.sfsb.store;

import com.sun.ejb.Container;
import com.sun.ejb.ee.sfsb.store.EJBModuleStatistics;
import com.sun.ejb.ee.sfsb.store.HAEjbStore;
import com.sun.ejb.ee.sfsb.store.HAEjbStoreFactory;
import com.sun.ejb.ee.sfsb.store.HASFSBStoreManagerBase;
import com.sun.ejb.spi.monitorable.sfsb.MonitorableSFSBStore;
import com.sun.ejb.spi.sfsb.store.SFSBBeanState;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManager;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManagerException;
import com.sun.ejb.spi.sfsb.store.SFSBTxStoreManager;
import com.sun.ejb.spi.stats.MonitorableSFSBStoreManager;
import com.sun.enterprise.ee.web.sessmgmt.EEHADBHealthChecker;
import com.sun.enterprise.ee.web.sessmgmt.StoreFactory;
import com.sun.enterprise.ee.web.sessmgmt.StorePool;
import com.sun.enterprise.ee.web.sessmgmt.StorePoolElement;
import java.io.IOException;
import java.util.logging.Level;

public class HASFSBStoreManager
extends HASFSBStoreManagerBase
implements SFSBStoreManager,
SFSBTxStoreManager,
MonitorableSFSBStoreManager,
MonitorableSFSBStore {
    StorePool _pool = null;

    public HASFSBStoreManager() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "HASFSBStoreManager  loaded successfully......");
        }
        HAEjbStoreFactory haStoreFactory = new HAEjbStoreFactory();
        this._pool = new StorePool(100, -1, 100, (StoreFactory)haStoreFactory);
    }

    public HASFSBStoreManager(Container container) {
        this();
        super.setContainer(container);
    }

    public StorePool getStorePool() {
        return this._pool;
    }

    public void setStorePool(StorePool pool) {
        this._pool = pool;
    }

    public void shutdown() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "HASFSBStoreManager.shutdown");
        }
        this.doShutdownCleanup();
    }

    public void passivateSave(SFSBBeanState beanState) throws SFSBStoreManagerException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        EJBModuleStatistics stats = this.getEJBModuleStatistics();
        long saveStartTime = 0L;
        if (this.isMonitoringEnabled()) {
            saveStartTime = System.currentTimeMillis();
        }
        this.passivateSave(beanState, beanState.isNew());
        if (this.isMonitoringEnabled()) {
            long saveEndTime = System.currentTimeMillis();
            stats.processPassivateSave(saveEndTime - saveStartTime);
            stats.processBeanSize(this.getBeanSize(beanState));
        }
    }

    public void passivateSave(SFSBBeanState beanState, boolean isNew) throws SFSBStoreManagerException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HASFSBStoreManager", "passivateSave", new Object[]{beanState, new Boolean(isNew)});
        }
        StorePool storePool = this.getStorePool();
        HAEjbStore store = null;
        try {
            store = this.getStore();
            store.save(beanState, this, beanState.isNew());
        }
        catch (IOException e) {
            throw new SFSBStoreManagerException("Error during passivateSave: isNew =" + isNew + ": id =" + beanState.getId().toString(), (Exception)e);
        }
        finally {
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HASFSBStoreManager", "passivateSave");
        }
    }

    private HAEjbStore getStore() {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HASFSBStoreManager", "getStore");
        }
        HAEjbStore store = null;
        try {
            store = (HAEjbStore)this._pool.take();
            store.setContainer(this.getContainer());
            store.setClusterID(this.getClusterID());
            store.setContainerId(this.getContainerID());
            store.setSFSBStoreManager(this);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HASFSBStoreManager.getStore returning   " + (Object)((Object)store));
            }
            return store;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (_logger.isLoggable(Level.FINER)) {
                _logger.exiting("HASFSBStoreManager", "getStore", (Object)store);
            }
            return store;
        }
    }

    private void putStore(HAEjbStore store) {
        store.setContainer(null);
        if (store != null) {
            try {
                StorePool storePool = this.getStorePool();
                if (storePool != null) {
                    storePool.put((StorePoolElement)store);
                }
            }
            catch (InterruptedException ex1) {
                ex1.printStackTrace();
            }
        }
    }

    public SFSBBeanState getState(Object id) throws SFSBStoreManagerException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HASFSBStoreManager", "getState", id);
        }
        SFSBBeanState sfsbState = null;
        StorePool storePool = this.getStorePool();
        HAEjbStore store = null;
        try {
            store = this.getStore();
            sfsbState = store.loadBean(id);
            if (_logger.isLoggable(Level.FINER)) {
                _logger.exiting("HASFSBStoreManager", "getStore", sfsbState);
            }
            SFSBBeanState sFSBBeanState = sfsbState;
            return sFSBBeanState;
        }
        catch (Exception e) {
            throw new SFSBStoreManagerException("Error loading SFSB state: id =" + id.toString(), e);
        }
        finally {
            this.putStore(store);
            if (_logger.isLoggable(Level.FINER)) {
                _logger.exiting("HASFSBStoreManager", "getStore", sfsbState);
            }
        }
    }

    private Long[] storeOriginalTxCheckpointDurations(SFSBBeanState[] beanStates) {
        Long[] originalTxCheckpointDurations = new Long[beanStates.length];
        for (int i = 0; i < beanStates.length; ++i) {
            SFSBBeanState nextBeanState = beanStates[i];
            originalTxCheckpointDurations[i] = new Long(nextBeanState.getTxCheckpointDuration());
        }
        return originalTxCheckpointDurations;
    }

    private void restoreOriginalTxCheckpointDurations(SFSBBeanState[] beanStates, Long[] originalTxCheckpointDurations) {
        for (int i = 0; i < beanStates.length; ++i) {
            SFSBBeanState nextBeanState = beanStates[i];
            long originalDuration = originalTxCheckpointDurations[i];
            nextBeanState.setTxCheckpointDuration(originalDuration);
        }
    }

    private void printTxCheckpointDurations(SFSBBeanState[] beanStates) {
        for (int i = 0; i < beanStates.length; ++i) {
            SFSBBeanState nextBeanState = beanStates[i];
            System.out.println("printTxCheckpointDurations for beanState[" + i + "]: " + nextBeanState.getTxCheckpointDuration());
        }
    }

    public void checkpointSave(SFSBBeanState[] beanStates) throws SFSBStoreManagerException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        if (beanStates.length == 1) {
            this.checkpointSave(beanStates[0]);
            return;
        }
        EJBModuleStatistics stats = this.getEJBModuleStatistics();
        long startTime = 0L;
        Long[] originalTxCheckpointDurations = new Long[]{new Long(0L)};
        if (this.isMonitoringEnabled()) {
            originalTxCheckpointDurations = this.storeOriginalTxCheckpointDurations(beanStates);
            startTime = System.currentTimeMillis();
        }
        StorePool storePool = this.getStorePool();
        HAEjbStore store = null;
        try {
            store = this.getStore();
            store.save(beanStates, startTime);
            if (this.isMonitoringEnabled()) {
                for (int i = 0; i < beanStates.length; ++i) {
                    SFSBBeanState nextBeanState = beanStates[i];
                    stats.processBeanSize(this.getBeanSize(nextBeanState));
                }
            }
        }
        catch (IOException e) {
            if (this.isMonitoringEnabled()) {
                this.restoreOriginalTxCheckpointDurations(beanStates, originalTxCheckpointDurations);
            }
            throw new SFSBStoreManagerException("Error during checkpointSave", (Exception)e);
        }
        finally {
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HASFSBStoreManager", "checkpointSave");
        }
    }

    public void removeAll() throws SFSBStoreManagerException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HASFSBStoreManager", "removeAll", this.containerId);
        }
        StorePool storePool = this.getStorePool();
        HAEjbStore store = null;
        try {
            store = this.getStore();
            store.undeployContainer();
            if (_logger.isLoggable(Level.FINER)) {
                _logger.exiting("HASFSBStoreManager", "removeAll");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SFSBStoreManagerException("Error during HASFSBStoreManager>>removeAll for container: " + this.containerId, e);
        }
        finally {
            EEHADBHealthChecker.removeHASFSBStoreManager(this.getContainerID());
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HASFSBStoreManager", "removeAll");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object id) {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HASFSBStoreManager", "remove", id);
        }
        HAEjbStore store = null;
        try {
            store = this.getStore();
            store.remove(id);
            if (_logger.isLoggable(Level.FINER)) {
                _logger.exiting("HASFSBStoreManager", "remove");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HASFSBStoreManager", "remove");
        }
    }

    public void checkpointSave(SFSBBeanState beanState) throws SFSBStoreManagerException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        EJBModuleStatistics stats = this.getEJBModuleStatistics();
        long saveStartTime = 0L;
        if (this.isMonitoringEnabled()) {
            saveStartTime = System.currentTimeMillis();
        }
        this.checkpointSave(beanState, beanState.isNew());
        if (this.isMonitoringEnabled()) {
            long saveEndTime = System.currentTimeMillis();
            stats.processCheckpointSave(saveEndTime - saveStartTime);
            stats.processBeanSize(this.getBeanSize(beanState));
        }
    }

    public void checkpointSave(SFSBBeanState beanState, boolean isNew) throws SFSBStoreManagerException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HASFSBStoreManager", "checkpointSave", new Object[]{beanState, new Boolean(isNew)});
        }
        StorePool storePool = this.getStorePool();
        HAEjbStore store = null;
        try {
            store = this.getStore();
            store.save(beanState, this, beanState.isNew());
        }
        catch (IOException e) {
            throw new SFSBStoreManagerException("Error during checkpointSave: isNew =" + isNew + ": id =" + beanState.getId().toString(), (Exception)e);
        }
        finally {
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HASFSBStoreManager", "passivateSave");
        }
    }

    public void updateLastAccessTime(Object sessionKey, long time) throws SFSBStoreManagerException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HASFSBStoreManager", "updateLastAccessTime", sessionKey.toString());
        }
        StorePool storePool = this.getStorePool();
        HAEjbStore store = null;
        try {
            store = this.getStore();
            store.updateLastAccessTime(sessionKey, time);
            if (_logger.isLoggable(Level.FINER)) {
                _logger.exiting("HASFSBStoreManager", "updateLastAccessTime");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SFSBStoreManagerException("Error during HASFSBStoreManager>>updateLastAccessTime for key: " + sessionKey + " errMsg: " + e.getMessage(), e);
        }
        finally {
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HASFSBStoreManager", "updateLastAccessTime");
        }
    }

    public void removeExpired() throws SFSBStoreManagerException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HASFSBStoreManager", "removeExpired", this.containerId);
        }
        this.removeExpiredSessions();
    }

    public void removeExpiredLastGood() throws SFSBStoreManagerException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HASFSBStoreManager", "removeExpired", this.containerId);
        }
        StorePool storePool = this.getStorePool();
        HAEjbStore store = null;
        try {
            store = this.getStore();
            store.removeExpired();
            if (_logger.isLoggable(Level.FINER)) {
                _logger.exiting("HASFSBStoreManager", "removeExpired");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SFSBStoreManagerException("Error during HASFSBStoreManager>>removeExpired for container: " + this.containerId, e);
        }
        finally {
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HASFSBStoreManager", "removeExpired");
        }
    }

    public int removeExpiredSessions() throws SFSBStoreManagerException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return 0;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HASFSBStoreManager", "removeExpired", this.containerId);
        }
        int result = 0;
        StorePool storePool = this.getStorePool();
        HAEjbStore store = null;
        try {
            store = this.getStore();
            result = store.removeExpiredSessions();
            if (_logger.isLoggable(Level.FINER)) {
                _logger.exiting("HASFSBStoreManager", "removeExpired");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SFSBStoreManagerException("Error during HASFSBStoreManager>>removeExpired for container: " + this.containerId, e);
        }
        finally {
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HASFSBStoreManager", "removeExpired");
        }
        return result;
    }

    public MonitorableSFSBStore getMonitorableSFSBStore() {
        return this;
    }

    public MonitorableSFSBStoreManager getMonitorableSFSBStoreManager() {
        return this;
    }

    public void appendStats(StringBuffer sb) {
        EJBModuleStatistics stats = this.getEJBModuleStatistics();
        sb.append("\nSAVE_LOW=" + stats.getSaveLow());
        sb.append("\nSAVE_HIGH=" + stats.getSaveHigh());
        sb.append("\nSAVE_AVG=" + stats.getSaveAverage());
        sb.append("\nPASSIVATE_SAVE_LOW=" + stats.getPassivateSaveLow());
        sb.append("\nPASSIVATE_SAVE_HIGH=" + stats.getPassivateSaveHigh());
        sb.append("\nPASSIVATE_SAVE_AVG=" + stats.getPassivateSaveAverage());
        sb.append("\nCHECKPOINT_SAVE_LOW=" + stats.getCheckpointSaveLow());
        sb.append("\nCHECKPOINT_SAVE_HIGH=" + stats.getCheckpointSaveHigh());
        sb.append("\nCHECKPOINT_SAVE_AVG=" + stats.getCheckpointSaveAverage());
        sb.append("\nGET_CONN_LOW=" + stats.getGetConnectionLow());
        sb.append("\nGET_CONN_HIGH=" + stats.getGetConnectionHigh());
        sb.append("\nGET_CONN_AVG=" + stats.getGetConnectionAverage());
        sb.append("\nSTMT_PREP_LOW=" + stats.getStatementPrepLow());
        sb.append("\nSTMT_PREP_HIGH=" + stats.getStatementPrepHigh());
        sb.append("\nSTMT_PREP_AVG=" + stats.getStatementPrepAverage());
        sb.append("\nEXECUTE_STMT_LOW=" + stats.getExecuteStatementLow());
        sb.append("\nEXECUTE_STMT_HIGH=" + stats.getExecuteStatementHigh());
        sb.append("\nEXECUTE_STMT_AVG=" + stats.getExecuteStatementAverage());
        sb.append("\nBEAN_SIZE_LOW=" + stats.getBeanSizeLow());
        sb.append("\nBEAN_SIZE_HIGH=" + stats.getBeanSizeHigh());
        sb.append("\nBEAN_SIZE_AVG=" + stats.getBeanSizeAverage());
        stats.resetStats();
    }

    protected long getBeanSize(SFSBBeanState beanState) {
        if (beanState == null) {
            return 0L;
        }
        byte[] bytes = beanState.getState();
        if (bytes != null) {
            return bytes.length;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentStoreSize() {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HASFSBStoreManager", "getCurrentStoreSize");
        }
        int result = 0;
        HAEjbStore store = null;
        try {
            store = this.getStore();
            result = store.getContainerSize();
            if (_logger.isLoggable(Level.FINER)) {
                _logger.exiting("HASFSBStoreManager", "getCurrentStoreSize");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HASFSBStoreManager", "getCurrentStoreSize");
        }
        return result;
    }

    public long getCurrentStoreSizePrevious() {
        HAEjbStore store = this.getStore();
        return store.getContainerSize();
    }

    public int getCurrentSize() {
        HAEjbStore store = this.getStore();
        return store.getContainerSize();
    }

    public void monitoringLevelChanged(boolean newValue) {
    }

    public int getCheckpointCount() {
        return 0;
    }

    public int getCheckpointErrorCount() {
        return 0;
    }

    public int getCheckpointSuccessCount() {
        return 0;
    }

    public int getExpiredSessionCount() {
        return 0;
    }

    public int getLoadCount() {
        return 0;
    }

    public int getLoadErrorCount() {
        return 0;
    }

    public int getLoadSuccessCount() {
        return 0;
    }

    public int getPassivationCount() {
        return 0;
    }

    public int getPassivationErrorCount() {
        return 0;
    }

    public int getPassivationSuccessCount() {
        return 0;
    }
}

