/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.authenticator;

import com.sun.enterprise.ee.web.authenticator.HASingleSignOn;
import com.sun.enterprise.ee.web.authenticator.HASingleSignOnEntry;
import com.sun.enterprise.ee.web.authenticator.SSOStorePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.ConnectionUtil;
import com.sun.enterprise.ee.web.sessmgmt.EEHADBHealthChecker;
import com.sun.enterprise.ee.web.sessmgmt.FullHASession;
import com.sun.enterprise.ee.web.sessmgmt.HADBConnectionGroup;
import com.sun.enterprise.ee.web.sessmgmt.HAErrorManager;
import com.sun.enterprise.ee.web.sessmgmt.HATimeoutException;
import com.sun.enterprise.ee.web.sessmgmt.ModifiedAttributeHASession;
import com.sun.enterprise.ee.web.sessmgmt.ModifiedHASession;
import com.sun.enterprise.ee.web.sessmgmt.StorePoolElement;
import com.sun.enterprise.security.web.SingleSignOnEntry;
import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.catalina.Container;
import org.apache.catalina.Valve;
import org.apache.catalina.session.StandardSession;

public class SSOStore
implements StorePoolElement,
SSOStorePoolElement {
    private static final String BASIC_AUTH = "BASIC";
    private static final String FORM_AUTH = "FORM";
    private static final String DIGEST_AUTH = "DIGEST";
    private static final String CLIENT_CERT_AUTH = "CLIENT-CERT";
    protected Container container = null;
    protected HASingleSignOn sso = null;
    private boolean debug = false;
    protected final String singleSignOnTable = "singlesignon";
    String sessionHeaderTable = "sessionheader";
    String blobSessionTable = "blobsessions";
    private PreparedStatement preparedLoadSSOSql = null;
    private PreparedStatement preparedInsertSSOSql = null;
    private PreparedStatement preparedUpdateSSOSql = null;
    private PreparedStatement preparedExistsSql = null;
    private PreparedStatement preparedRemoveSSOSql = null;
    private PreparedStatement preparedRemoveInactiveSql = null;
    private PreparedStatement preparedUpdateSessionTableSql = null;
    protected long timeout = 300L;
    protected HAErrorManager haErr = new HAErrorManager(this.timeout, "ssoThread");
    protected HAErrorManager haErrAssociate = new HAErrorManager(this.timeout, "ssoThread");
    protected HAErrorManager haErrRemove = new HAErrorManager(this.timeout, "ssoThread");
    protected HAErrorManager haErrRemoveInactive = new HAErrorManager(this.timeout, "ssoThread");
    protected HAErrorManager haErrLoad = new HAErrorManager(this.timeout, "ssoThread");
    protected HAErrorManager haErrExists = new HAErrorManager(this.timeout, "ssoThread");
    protected HAErrorManager haErrInsert = new HAErrorManager(this.timeout, "ssoThread");
    protected HAErrorManager haErrUpdate = new HAErrorManager(this.timeout, "ssoThread");
    protected String connString = null;
    protected Connection conn = null;
    protected String driverName = "com.sun.hadb.jdbc.Driver";
    protected ConnectionUtil connectionUtil = null;
    protected String user = null;
    protected String password = null;

    public void setContainer(Container container) {
        this.container = container;
        this.debug("   container:    " + container);
    }

    public void setSingleSignOn(HASingleSignOn haSSO) {
        this.sso = haSSO;
        this.debug("   sso:    " + (Object)((Object)this.sso));
    }

    protected ConnectionUtil getConnectionUtil() {
        if (this.connectionUtil == null) {
            this.connectionUtil = new ConnectionUtil(this.container, (Valve)this.sso);
        }
        return this.connectionUtil;
    }

    public String[] keys() throws IOException {
        String[] retValue = null;
        return retValue;
    }

    public SingleSignOnEntry loadSSO(String ssoId) throws IOException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return null;
        }
        HADBConnectionGroup connGroup = this.getConnectionsFromPool();
        Connection internalConn = connGroup._internalConn;
        Connection externalConn = connGroup._externalConn;
        SingleSignOnEntry _ssoEntry = null;
        try {
            _ssoEntry = this.loadSSO(ssoId, internalConn);
            try {
                externalConn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            externalConn = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (externalConn != null) {
                try {
                    externalConn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.debug("Loaded SSO " + ssoId);
        return _ssoEntry;
    }

    public synchronized SingleSignOnEntry loadSSO(String ssoId, Connection connection) throws IOException {
        if (ssoId == null) {
            this.debug("in load -- SSOStore, ssoId is null, returning null");
            Thread.dumpStack();
            return null;
        }
        long lastAccess = 0L;
        String authType = null;
        String userName = null;
        String realmName = null;
        ResultSet rst = null;
        String loadSSOSql = "SELECT ssoid, lastaccess, authType, userName FROM singlesignon WHERE ssoid = ?";
        try {
            this.haErrLoad.txStart();
            while (!this.haErrLoad.isTxCompleted()) {
                String authTypeAndRealmName;
                this.preparedLoadSSOSql = connection.prepareStatement(loadSSOSql);
                this.preparedLoadSSOSql.setString(1, ssoId);
                rst = this.preparedLoadSSOSql.executeQuery();
                if (rst.next()) {
                    rst.getString("ssoid");
                    lastAccess = rst.getLong("lastaccess");
                    authTypeAndRealmName = rst.getString("authType");
                    if (authTypeAndRealmName.startsWith(BASIC_AUTH)) {
                        authType = BASIC_AUTH;
                        realmName = authTypeAndRealmName.substring(BASIC_AUTH.length());
                    } else if (authTypeAndRealmName.startsWith(FORM_AUTH)) {
                        authType = FORM_AUTH;
                        realmName = authTypeAndRealmName.substring(FORM_AUTH.length());
                    } else if (authTypeAndRealmName.startsWith(DIGEST_AUTH)) {
                        authType = DIGEST_AUTH;
                        realmName = authTypeAndRealmName.substring(DIGEST_AUTH.length());
                    } else if (authTypeAndRealmName.startsWith(CLIENT_CERT_AUTH)) {
                        authType = CLIENT_CERT_AUTH;
                        realmName = authTypeAndRealmName.substring(CLIENT_CERT_AUTH.length());
                    }
                } else {
                    connection.commit();
                    if (this.preparedLoadSSOSql != null) {
                        this.preparedLoadSSOSql.close();
                        this.preparedLoadSSOSql = null;
                    }
                    authTypeAndRealmName = null;
                    return authTypeAndRealmName;
                }
                userName = rst.getString("userName");
                try {
                    this.closeResultSet(rst);
                    connection.commit();
                    this.preparedLoadSSOSql.close();
                    this.preparedLoadSSOSql = null;
                    this.haErrLoad.txEnd();
                }
                catch (SQLException e) {
                    this.closeStatement(this.preparedLoadSSOSql);
                    this.preparedLoadSSOSql = null;
                    this.haErrLoad.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from SSOStore loadSSO: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from SSOStore loadSSO: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            if (this.preparedLoadSSOSql != null) {
                try {
                    this.preparedLoadSSOSql.close();
                    this.preparedLoadSSOSql = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        Principal principal = null;
        return new HASingleSignOnEntry(principal, authType, userName, null, realmName);
    }

    public void save(String ssoId, SingleSignOnEntry ssoEntry) throws IOException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        HADBConnectionGroup connGroup = this.getConnectionsFromPool();
        Connection internalConn = connGroup._internalConn;
        Connection externalConn = connGroup._externalConn;
        try {
            this.save(ssoId, ssoEntry, internalConn);
            try {
                externalConn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            externalConn = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (externalConn != null) {
                try {
                    externalConn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.debug("Saved SSO " + ssoId + " into SSOStore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePrevious(String ssoId, SingleSignOnEntry ssoEntry, Connection connection) throws IOException {
        String existsSql = "SELECT ssoid FROM singlesignon WHERE ssoid = ?";
        ResultSet rs = null;
        boolean found = false;
        try {
            this.preparedExistsSql = connection.prepareStatement(existsSql);
            this.preparedExistsSql.setString(1, ssoId);
            rs = this.executeStatement(this.preparedExistsSql, true);
            found = rs != null && rs.next();
            connection.commit();
            this.preparedExistsSql.close();
            this.preparedExistsSql = null;
            if (!found) {
                this.insertSSO(ssoId, ssoEntry, connection);
            } else {
                this.updateSSO(ssoId, ssoEntry, connection);
            }
        }
        catch (SQLException sqe) {
            sqe.printStackTrace();
        }
        finally {
            try {
                if (this.preparedExistsSql != null) {
                    this.preparedExistsSql.close();
                    this.preparedExistsSql = null;
                }
            }
            catch (SQLException se) {}
        }
    }

    public void save(String ssoId, SingleSignOnEntry ssoEntry, Connection connection) throws IOException {
        boolean ssoEntryIsPersistent = false;
        boolean ssoEntryInStoreOk = false;
        try {
            ssoEntryIsPersistent = this.ssoEntryInStore(ssoId, connection);
            ssoEntryInStoreOk = true;
        }
        catch (IOException ex) {
            ssoEntryInStoreOk = false;
        }
        if (!ssoEntryInStoreOk) {
            return;
        }
        if (ssoEntryIsPersistent) {
            this.updateSSO(ssoId, ssoEntry, connection);
        } else {
            this.insertSSO(ssoId, ssoEntry, connection);
        }
    }

    public boolean ssoEntryInStore(String ssoId, Connection connection) throws IOException {
        String existsSql = "SELECT ssoid FROM singlesignon WHERE ssoid = ?";
        ResultSet rs = null;
        boolean found = false;
        try {
            this.haErrExists.txStart();
            while (!this.haErrExists.isTxCompleted()) {
                try {
                    this.preparedExistsSql = connection.prepareStatement(existsSql);
                    this.preparedExistsSql.setString(1, ssoId);
                    rs = this.preparedExistsSql.executeQuery();
                    found = rs != null && rs.next();
                    connection.commit();
                    this.preparedExistsSql.close();
                    this.preparedExistsSql = null;
                    this.haErrExists.txEnd();
                }
                catch (SQLException e) {
                    this.closeStatement(this.preparedExistsSql);
                    this.preparedExistsSql = null;
                    this.haErrExists.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from SSOStore-ssoEntryInStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from SSOStore-ssoEntryInStore: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            this.closeResultSet(rs);
            if (this.preparedExistsSql != null) {
                try {
                    this.preparedExistsSql.close();
                }
                catch (SQLException e) {}
                this.preparedExistsSql = null;
            }
        }
        return found;
    }

    public void insertSSO(String ssoId, SingleSignOnEntry ssoEntry, Connection connection) throws IOException {
        this.debug("in insertSSO --SSOStore");
        String insertSSOSql = "INSERT into singlesignon(ssoid, lastaccess, authType, userName) VALUES (?, ?, ?, ?)";
        this.debug("insertSSO sso id '" + ssoId + "' for user '" + ssoEntry.principal.getName() + "' with auth type '" + ssoEntry.authType + "' and realm name '" + ssoEntry.realmName + "'");
        try {
            this.haErrInsert.txStart();
            while (!this.haErrInsert.isTxCompleted()) {
                try {
                    this.preparedInsertSSOSql = connection.prepareStatement(insertSSOSql);
                    this.preparedInsertSSOSql.setString(1, ssoId);
                    this.preparedInsertSSOSql.setLong(2, ssoEntry.lastAccessTime);
                    String authTypeAndRealmName = ssoEntry.authType + ssoEntry.realmName;
                    this.preparedInsertSSOSql.setString(3, authTypeAndRealmName);
                    this.preparedInsertSSOSql.setString(4, ssoEntry.principal.getName());
                    this.preparedInsertSSOSql.executeUpdate();
                    connection.commit();
                    this.preparedInsertSSOSql.close();
                    this.preparedInsertSSOSql = null;
                    this.haErrInsert.txEnd();
                }
                catch (SQLException e) {
                    this.closeStatement(this.preparedInsertSSOSql);
                    this.preparedInsertSSOSql = null;
                    this.haErrInsert.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from SSOStore insertSSO: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from SSOStore insertSSO: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            if (this.preparedInsertSSOSql != null) {
                try {
                    this.preparedInsertSSOSql.close();
                    this.preparedInsertSSOSql = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void updateSSO(String ssoId, SingleSignOnEntry ssoEntry, Connection connection) throws IOException {
        this.debug("in updateSSO --SSOStore");
        String updateSSOSql = "UPDATE singlesignon SET lastaccess = ?, authType = ?, userName = ? WHERE ssoid = ?";
        this.debug("updateSSO sso id '" + ssoId + "' for user '" + ssoEntry.principal.getName() + "' with auth type '" + ssoEntry.authType + "' and realm name '" + ssoEntry.realmName + "'");
        try {
            this.haErrUpdate.txStart();
            while (!this.haErrUpdate.isTxCompleted()) {
                try {
                    this.preparedUpdateSSOSql = connection.prepareStatement(updateSSOSql);
                    this.preparedUpdateSSOSql.setLong(1, ssoEntry.lastAccessTime);
                    String authTypeAndRealmName = ssoEntry.authType + ssoEntry.realmName;
                    this.preparedUpdateSSOSql.setString(2, authTypeAndRealmName);
                    this.preparedUpdateSSOSql.setString(3, ssoEntry.principal.getName());
                    this.preparedUpdateSSOSql.setString(4, ssoId);
                    this.preparedUpdateSSOSql.executeUpdate();
                    connection.commit();
                    this.preparedUpdateSSOSql.close();
                    this.preparedUpdateSSOSql = null;
                    this.haErrUpdate.txEnd();
                }
                catch (SQLException e) {
                    this.closeStatement(this.preparedUpdateSSOSql);
                    this.preparedUpdateSSOSql = null;
                    this.haErrUpdate.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from SSOStore updateSSO: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from SSOStore updateSSO: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            if (this.preparedUpdateSSOSql != null) {
                try {
                    this.preparedUpdateSSOSql.close();
                    this.preparedUpdateSSOSql = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void updateLastAccessTime(String ssoId, long lat) throws IOException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        Connection conn = this.getConnection(false);
        this.updateLastAccessTime(ssoId, lat, conn);
    }

    public void updateLastAccessTime(String ssoId, long lat, Connection conn) throws IOException {
        this.debug("in updateLastAccessTime --SSOStore");
        String updateLatSql = "UPDATE singlesignon SET lastaccess = ? WHERE ssoid = ?";
        try {
            if (this.preparedUpdateSSOSql == null) {
                this.preparedUpdateSSOSql = conn.prepareStatement(updateLatSql);
            }
            this.preparedUpdateSSOSql.setLong(1, lat);
            this.debug("updateLastAccessTime sso id '" + ssoId + "' with  LastAccessTime " + lat + " ");
            this.preparedUpdateSSOSql.setString(2, ssoId);
            this.executeStatement(this.preparedUpdateSSOSql, false);
            conn.commit();
        }
        catch (SQLException e) {
            this.closeStatement(this.preparedUpdateSSOSql);
            this.preparedUpdateSSOSql = null;
            try {
                conn.rollback();
            }
            catch (SQLException ee) {
                ee.printStackTrace();
            }
            e.printStackTrace();
            IOException ex1 = (IOException)new IOException("Error from SSO Store updateLastAccessTime : " + e.getMessage()).initCause(e);
            throw ex1;
        }
    }

    public void associate(StandardSession session, String ssoId) throws IOException {
        HADBConnectionGroup connGroup = this.getConnectionsFromPool();
        Connection internalConn = connGroup._internalConn;
        Connection externalConn = connGroup._externalConn;
        try {
            this.associate(session, ssoId, internalConn);
            try {
                externalConn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            externalConn = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (externalConn != null) {
                try {
                    externalConn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.debug("Associated SSO " + ssoId + " with session " + session.getId());
    }

    public void associate(StandardSession session, String ssoId, Connection connection) throws IOException {
        String updateSql = null;
        String sessionTable = null;
        if (session instanceof FullHASession || session instanceof ModifiedHASession) {
            sessionTable = this.blobSessionTable;
        } else if (session instanceof ModifiedAttributeHASession) {
            sessionTable = this.sessionHeaderTable;
        } else {
            return;
        }
        updateSql = "UPDATE " + sessionTable + " SET ssoid = ? WHERE id = ?";
        try {
            this.haErrAssociate.txStart();
            while (!this.haErrAssociate.isTxCompleted()) {
                try {
                    this.preparedUpdateSessionTableSql = connection.prepareStatement(updateSql);
                    this.preparedUpdateSessionTableSql.setString(1, ssoId);
                    this.preparedUpdateSessionTableSql.setString(2, session.getId());
                    this.preparedUpdateSessionTableSql.executeUpdate();
                    connection.commit();
                    this.preparedUpdateSessionTableSql.close();
                    this.preparedUpdateSessionTableSql = null;
                    this.debug("Inside SSOStore.associate() : ....completed");
                    this.haErrAssociate.txEnd();
                }
                catch (SQLException e) {
                    this.closeStatement(this.preparedUpdateSessionTableSql);
                    this.preparedUpdateSessionTableSql = null;
                    this.haErrAssociate.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from SSOStore associate: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from SSOStore associate: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            if (this.preparedUpdateSessionTableSql != null) {
                try {
                    this.preparedUpdateSessionTableSql.close();
                    this.preparedUpdateSessionTableSql = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public synchronized void remove(String ssoId) throws IOException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        HADBConnectionGroup connGroup = this.getConnectionsFromPool();
        Connection internalConn = connGroup._internalConn;
        Connection externalConn = connGroup._externalConn;
        try {
            this.remove(ssoId, internalConn);
            try {
                externalConn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            externalConn = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (externalConn != null) {
                try {
                    externalConn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.debug("Removed SSO " + ssoId + " from SSOStore ");
    }

    public void remove(String ssoId, Connection connection) throws IOException {
        this.debug("in remove -- SSOStore");
        if (ssoId == null) {
            this.debug("In remove -- SSOStore, got a null id");
            return;
        }
        String removeSSOSql = "DELETE FROM singlesignon WHERE ssoid = ?";
        try {
            this.haErrRemove.txStart();
            while (!this.haErrRemove.isTxCompleted()) {
                try {
                    this.preparedRemoveSSOSql = connection.prepareStatement(removeSSOSql);
                    this.preparedRemoveSSOSql.setString(1, ssoId);
                    this.preparedRemoveSSOSql.executeUpdate();
                    connection.commit();
                    this.preparedRemoveSSOSql.close();
                    this.preparedRemoveSSOSql = null;
                    this.haErrRemove.txEnd();
                }
                catch (SQLException e) {
                    if (this.preparedRemoveSSOSql != null) {
                        try {
                            this.preparedRemoveSSOSql.close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        this.preparedRemoveSSOSql = null;
                    }
                    this.haErrRemove.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from SSOStore remove: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from SSOStore remove: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            if (this.preparedRemoveSSOSql != null) {
                try {
                    this.preparedRemoveSSOSql.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.preparedRemoveSSOSql = null;
            }
        }
    }

    public void removeInActiveSessions(String ssoId) throws IOException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        HADBConnectionGroup connGroup = this.getConnectionsFromPool();
        Connection internalConn = connGroup._internalConn;
        Connection externalConn = connGroup._externalConn;
        try {
            this.removeInActiveSessions(ssoId, internalConn);
            try {
                externalConn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            externalConn = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (externalConn != null) {
                try {
                    externalConn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.debug("Removed inactive sessions for SSO " + ssoId);
    }

    public void removeInActiveSessions(String ssoId, Connection connection) throws IOException {
        this.debug("in removeInActiveSessions");
        if (ssoId == null) {
            this.debug("In removeInActiveSessions, got a null ssoId");
            return;
        }
        String removeInactiveSql1 = "DELETE FROM " + this.blobSessionTable + " WHERE ssoid = ?";
        String removeInactiveSql2 = "DELETE FROM " + this.sessionHeaderTable + " WHERE ssoid = ?";
        try {
            this.haErrRemoveInactive.txStart();
            while (!this.haErrRemoveInactive.isTxCompleted()) {
                try {
                    this.preparedRemoveInactiveSql = connection.prepareStatement(removeInactiveSql1);
                    this.preparedRemoveInactiveSql.setString(1, ssoId);
                    this.preparedRemoveInactiveSql.executeUpdate();
                    connection.commit();
                    this.preparedRemoveInactiveSql.close();
                    this.preparedRemoveInactiveSql = null;
                    this.haErrRemoveInactive.txEnd();
                }
                catch (SQLException e) {
                    this.closeStatement(this.preparedRemoveInactiveSql);
                    this.preparedRemoveInactiveSql = null;
                    this.haErrRemoveInactive.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from SSOStore removeInActiveSessions: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from SSOStore removeInActiveSessions: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            if (this.preparedRemoveInactiveSql != null) {
                try {
                    this.preparedRemoveInactiveSql.close();
                    this.preparedRemoveInactiveSql = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    protected ResultSet executeStatement(PreparedStatement stmt, boolean isQuery) throws IOException {
        ResultSet rst = null;
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    if (isQuery) {
                        rst = stmt.executeQuery();
                    } else {
                        stmt.executeUpdate();
                    }
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, this.conn);
                    this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                    this.haErr.printRetryableMessage(e);
                }
            }
        }
        catch (SQLException e) {
            try {
                this.conn.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from SSOStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from SSOStore " + e.getMessage()).initCause(e);
            throw ex1;
        }
        return rst;
    }

    protected ResultSet executeStatementLastGood(PreparedStatement stmt, boolean isQuery) throws IOException {
        ResultSet rst = null;
        try {
            this.haErr.txStart();
            try {
                while (!this.haErr.isTxCompleted()) {
                    if (isQuery) {
                        rst = stmt.executeQuery();
                    } else {
                        stmt.executeUpdate();
                    }
                    this.haErr.txEnd();
                }
            }
            catch (SQLException e) {
                this.haErr.checkError(e, this.conn);
                this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                this.haErr.printRetryableMessage(e);
            }
        }
        catch (SQLException e) {
            IOException ex1 = (IOException)new IOException("Error from SSOStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from SSOStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        return rst;
    }

    protected void closeResultSet(ResultSet rst) {
        try {
            if (rst != null) {
                rst.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected Connection getConnection(boolean autoCommit) throws IOException {
        ConnectionUtil util = this.getConnectionUtil();
        this.conn = util.getConnection(autoCommit);
        return this.conn;
    }

    protected Connection getConnection() throws IOException {
        return this.getConnection(true);
    }

    public void debug(String s) {
        if (this.debug) {
            System.out.println("SSOStore: " + s);
        }
    }

    public void cleanup() {
        this.closeStatements();
        this.closeConnection();
    }

    protected void closeConnection() {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void closeStatements() {
        PreparedStatement[] statements = new PreparedStatement[]{this.preparedLoadSSOSql, this.preparedInsertSSOSql, this.preparedUpdateSSOSql, this.preparedExistsSql, this.preparedRemoveSSOSql, this.preparedRemoveInactiveSql, this.preparedUpdateSessionTableSql};
        for (int i = 0; i < statements.length; ++i) {
            PreparedStatement nextStatement = statements[i];
            this.closeStatement(nextStatement);
        }
    }

    protected void closeStatement(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected HADBConnectionGroup getConnectionsFromPool() throws IOException {
        ConnectionUtil util = this.getConnectionUtil();
        return util.getConnectionsFromPool();
    }
}

