/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.authenticator;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class SSOTable {
    public static final String driver = "com.sun.hadb.jdbc.Driver";
    private static boolean _verbose = true;
    private Connection con;
    private String tableName = "singlesignon";

    private static void message(String message) {
        if (_verbose) {
            System.out.println(message);
        }
    }

    public SSOTable(String url) throws SQLException {
        this.con = DriverManager.getConnection(url);
    }

    public void createTable() throws SQLException {
        SSOTable.message("createTable : singlesignon");
        String query = "CREATE TABLE " + this.tableName + " (ssoid varchar(100) not null primary key," + " lastaccess double integer," + " authType varchar(100)," + " userName varchar(100))";
        Statement stmt = this.con.createStatement();
        stmt.executeUpdate(query);
        this.con.commit();
    }

    public void dropTable() {
        try {
            SSOTable.message("dropTable : singlesignon");
            String query = "DROP TABLE " + this.tableName;
            Statement stmt = this.con.createStatement();
            stmt.executeUpdate(query);
            this.con.commit();
        }
        catch (SQLException ex) {
            SSOTable.message(ex.toString());
        }
    }

    public static void recreateTable(String url, String user, String password) throws SQLException, ClassNotFoundException {
        Class.forName(driver);
        String driverName = "jdbc:sun:hadb:" + user + "+" + password + "@" + url;
        SSOTable.message("driverName = " + driverName);
        SSOTable st = new SSOTable(driverName);
        st.dropTable();
        st.createTable();
    }

    public static void main(String[] args) {
        if (args.length != 1 && args.length != 3) {
            System.out.println("usage: java SSOTable url [user] [password]");
            System.exit(1);
        }
        try {
            if (args.length == 3) {
                SSOTable.recreateTable(args[0], args[1], args[2]);
            } else {
                SSOTable.recreateTable(args[0], "system", "super");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

