/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class BlobAttributeSession {
    public static final String driver = "com.sun.hadb.jdbc.Driver";
    private static boolean _verbose = true;
    private static Connection con;
    private static String sessionHeaderTableName;
    private static String sessionAttributeTableName;
    private static PreparedStatement preparedInsertSesHdrSql;
    private static PreparedStatement preparedInsertSesAttrSql;

    private static void message(String message) {
        if (_verbose) {
            System.out.println(message);
        }
    }

    public BlobAttributeSession(String url) throws SQLException {
        con = DriverManager.getConnection(url);
    }

    public void createHeaderTable() throws SQLException {
        BlobAttributeSession.message("createHeaderTable");
        String query = "CREATE TABLE " + sessionHeaderTableName + " (id varchar(100) not null," + "valid char(1) not null," + "maxinactive int not null," + "lastaccess double integer," + "appid varchar(100)," + "username varchar(100)," + "ssoid varchar(100)," + "primary key(id, appid))";
        Statement stmt = con.createStatement();
        stmt.executeUpdate(query);
    }

    public void createAttributeTable() throws SQLException {
        BlobAttributeSession.message("createAttributeTable");
        String query = "CREATE TABLE " + sessionAttributeTableName + " (rowid varchar(200) not null," + "sessattrdata BLOB," + "id varchar(100) not null," + "attributename varchar(100)," + "appid varchar(100)," + "primary key(rowid, appid))";
        Statement stmt = con.createStatement();
        stmt.executeUpdate(query);
        con.commit();
        BlobAttributeSession.message("Table " + sessionAttributeTableName + " created");
    }

    public void dropHeaderTable() {
        try {
            BlobAttributeSession.message("dropTable");
            String query = "DROP TABLE " + sessionHeaderTableName;
            Statement stmt = con.createStatement();
            stmt.executeUpdate(query);
        }
        catch (SQLException e) {
            BlobAttributeSession.message(e.toString());
        }
    }

    public void dropAttributeTable() {
        try {
            BlobAttributeSession.message("dropTable");
            String query = "DROP TABLE " + sessionAttributeTableName;
            Statement stmt = con.createStatement();
            stmt.executeUpdate(query);
        }
        catch (SQLException e) {
            BlobAttributeSession.message(e.toString());
        }
    }

    public void insertSessionHeader(String sessionId, Connection connection) throws IOException {
        String insertHdrSql = "INSERT into " + sessionHeaderTableName + "(" + "id, valid, maxinactive, lastaccess, appid, username ) " + "VALUES (?, ?, ?, ?, ?, ?)";
        try {
            if (preparedInsertSesHdrSql == null) {
                preparedInsertSesHdrSql = connection.prepareStatement(insertHdrSql);
            }
            preparedInsertSesHdrSql.setString(1, sessionId);
            preparedInsertSesHdrSql.setString(2, "1");
            preparedInsertSesHdrSql.setInt(3, 60);
            preparedInsertSesHdrSql.setLong(4, 1000L);
            preparedInsertSesHdrSql.setString(5, "cluster1:webapps");
            preparedInsertSesHdrSql.setString(6, "user1");
            preparedInsertSesHdrSql.executeUpdate();
            con.commit();
        }
        catch (SQLException e) {
            try {
                con.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            e.printStackTrace();
            throw new IOException("Error from HA Store: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedInputStream getInputStream(Object attribute, int length) throws IOException {
        ByteArrayOutputStream bos = null;
        ByteArrayInputStream bis = null;
        ObjectOutputStream oos = null;
        BufferedInputStream in = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            oos.writeObject(attribute);
            oos.close();
            oos = null;
            byte[] obs = bos.toByteArray();
            bis = new ByteArrayInputStream(obs, 0, obs.length);
            in = new BufferedInputStream(bis, obs.length);
            length = obs.length;
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
        return in;
    }

    public static void recreateTable(String url, String user, String password) throws SQLException, ClassNotFoundException {
        Class.forName(driver);
        String driverName = "jdbc:sun:hadb:" + user + "+" + password + "@" + url;
        BlobAttributeSession.message("driverName = " + driverName);
        BlobAttributeSession bs = new BlobAttributeSession(driverName);
        bs.dropAttributeTable();
        bs.dropHeaderTable();
        bs.createHeaderTable();
        bs.createAttributeTable();
    }

    public static void main(String[] args) {
        if (args.length != 1 && args.length != 3) {
            System.out.println("usage: java BlobSession url [user] [password]");
            System.exit(1);
        }
        try {
            if (args.length == 3) {
                BlobAttributeSession.recreateTable(args[0], args[1], args[2]);
            } else {
                BlobAttributeSession.recreateTable(args[0], "system", "super");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    static {
        sessionHeaderTableName = "sessionheader";
        sessionAttributeTableName = "sessionattribute";
        preparedInsertSesHdrSql = null;
        preparedInsertSesAttrSql = null;
    }
}

