/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.handlers.InfoRequestHandler;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.MQThread;
import com.sun.messaging.jmq.util.DiagManager;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Date;
import java.util.List;

public class BrokerStateHandler {
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    public static boolean shuttingDown = false;
    public static boolean shutdownStarted = false;
    QuiesceRunnable qrun = null;
    boolean prepared = false;
    long targetShutdownTime = 0L;
    private static int restartCode = Globals.getConfig().getIntProperty("imq.restart.code", 255);
    ClusterListener cl = new StateMonitorListener();

    public BrokerStateHandler() {
        Globals.getClusterManager().addEventListener(this.cl);
    }

    public void destroy() {
        Globals.getClusterManager().addEventListener(this.cl);
    }

    public static int getRestartCode() {
        return restartCode;
    }

    public long getShutdownRemaining() {
        if (this.targetShutdownTime == 0L) {
            return -1L;
        }
        long l = this.targetShutdownTime - System.currentTimeMillis();
        if (l < 0L) {
            l = 0L;
        }
        return l;
    }

    public void takeoverBroker(String string, boolean bl) throws BrokerException {
        ClusterManager clusterManager = Globals.getClusterManager();
        if (!clusterManager.isHA()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", (Object)"takeover only supported in HA clusters"));
        }
        HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)clusterManager.getBroker(string);
        if (hAClusteredBroker == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", (Object)("unknown broker " + string)));
        }
        if (hAClusteredBroker.isLocalBroker()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", (Object)"can not take over self"));
        }
        Globals.getHAMonitorService().takeoverBroker(hAClusteredBroker, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce() throws IllegalStateException, BrokerException {
        if (this.qrun != null) {
            throw new IllegalStateException("Already Quiescing");
        }
        BrokerStateHandler brokerStateHandler = this;
        synchronized (brokerStateHandler) {
            this.qrun = new QuiesceRunnable();
        }
        brokerStateHandler = new MQThread((Runnable)this.qrun, "quiesce thread");
        ((Thread)((Object)brokerStateHandler)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopQuiesce() throws BrokerException {
        try {
            QuiesceRunnable quiesceRunnable = null;
            BrokerStateHandler brokerStateHandler = this;
            synchronized (brokerStateHandler) {
                quiesceRunnable = this.qrun;
            }
            if (quiesceRunnable != null) {
                quiesceRunnable.breakQuiesce();
            }
            brokerStateHandler = Globals.getServiceManager();
            brokerStateHandler.startNewConnections(0);
            ClusteredBroker clusteredBroker = Globals.getClusterManager().getLocalBroker();
            clusteredBroker.setState(BrokerState.OPERATING);
            this.logger.log(8, "B1301");
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(16, "B3100", "exception during unquiesce", (Throwable)exception);
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", (Object)"unable to unquiesce"), (Throwable)exception);
        }
    }

    public void initiateShutdown(String string, long l, boolean bl, int n, boolean bl2) {
        this.initiateShutdown(string, l, bl, n, bl2, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateShutdown(String string, long l, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4) {
        BrokerStateHandler brokerStateHandler = this;
        synchronized (brokerStateHandler) {
            if (shutdownStarted) {
                if (this.targetShutdownTime > 0L) {
                    this.targetShutdownTime = l > 0L ? System.currentTimeMillis() + l : 0L;
                    this.notifyAll();
                }
                return;
            }
            shutdownStarted = true;
        }
        brokerStateHandler = Globals.getAgent();
        if (brokerStateHandler != null) {
            brokerStateHandler.notifyShutdownStart();
        }
        this.targetShutdownTime = l > 0L ? System.currentTimeMillis() + l : 0L;
        ShutdownRunnable shutdownRunnable = new ShutdownRunnable(string, this.targetShutdownTime, bl, n, bl4);
        if (bl2) {
            MQThread mQThread = new MQThread((Runnable)shutdownRunnable, "shutdown thread");
            mQThread.start();
        } else {
            int n2 = shutdownRunnable.shutdown();
            if (bl3) {
                System.exit(n2);
            }
        }
    }

    public void prepareShutdown(boolean bl) {
        this.prepared = true;
        if (Globals.getMemManager() != null) {
            Globals.getMemManager().stopManagement();
        }
        Destination.shutdown();
        Globals.getClusterBroadcast().stopClusterIO(bl);
    }

    class StateMonitorListener
    implements ClusterListener {
        StateMonitorListener() {
        }

        void notifyClients() {
            List list = Globals.getConnectionManager().getConnectionList(null);
            for (IMQConnection iMQConnection : list) {
                if (iMQConnection.isAdminConnection() || iMQConnection.getClientProtocolVersion() != 400) continue;
                InfoRequestHandler.sendInfoPacket((int)2, (IMQConnection)iMQConnection, (long)0L);
            }
        }

        public void clusterPropertyChanged(String string, String string2) {
        }

        public void brokerAdded(ClusteredBroker clusteredBroker, UID uID) {
            this.notifyClients();
        }

        public void brokerRemoved(ClusteredBroker clusteredBroker, UID uID) {
            this.notifyClients();
        }

        public void masterBrokerChanged(ClusteredBroker clusteredBroker, ClusteredBroker clusteredBroker2) {
        }

        public void brokerStatusChanged(String string, int n, int n2, UID uID, Object object) {
        }

        public void brokerStateChanged(String string, BrokerState brokerState, BrokerState brokerState2) {
        }

        public void brokerVersionChanged(String string, int n, int n2) {
        }

        public void brokerURLChanged(String string, MQAddress mQAddress, MQAddress mQAddress2) {
            this.notifyClients();
        }
    }

    public class ShutdownRunnable
    implements Runnable {
        String requestedBy = "unknown";
        long targetTime = 0L;
        int exitCode = 0;
        boolean failover = false;
        boolean cleanupJMX = false;

        public ShutdownRunnable(String string, long l, boolean bl, int n, boolean bl2) {
            BrokerStateHandler.this.logger.log(4, "Shutdown requested by " + string);
            this.requestedBy = string;
            this.targetTime = l;
            this.failover = bl;
            this.exitCode = n;
            this.cleanupJMX = bl2;
        }

        public void run() {
            int n = this.shutdown();
            Broker.getBroker().exit(n, Globals.getBrokerResources().getKString("B1199", (Object)this.requestedBy), this.exitCode == BrokerStateHandler.getRestartCode() ? 1 : 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public int shutdown() {
            BrokerState brokerState;
            ClusteredBroker clusteredBroker;
            block36: {
                ConnectionManager connectionManager;
                Object object;
                clusteredBroker = null;
                brokerState = null;
                clusteredBroker = Globals.getClusterManager().getLocalBroker();
                try {
                    brokerState = clusteredBroker.getState();
                    if (brokerState != BrokerState.FAILOVER_STARTED && brokerState != BrokerState.FAILOVER_PENDING && brokerState != BrokerState.FAILOVER_COMPLETE) {
                        clusteredBroker.setState(BrokerState.SHUTDOWN_STARTED);
                    }
                }
                catch (Throwable throwable) {
                    Globals.getLogger().logStack(16, "B3063", throwable);
                }
                if (BrokerStateHandler.this.getShutdownRemaining() > 0L) {
                    Object object2;
                    BrokerStateHandler.this.logger.log(8, "B1200", (Object)String.valueOf(BrokerStateHandler.this.getShutdownRemaining() / 1000L), String.valueOf(BrokerStateHandler.this.getShutdownRemaining()));
                    object = Globals.getConnectionManager().getConnectionList(null);
                    connectionManager = object.iterator();
                    while (connectionManager.hasNext()) {
                        object2 = (IMQConnection)connectionManager.next();
                        if (object2.isAdminConnection() || object2.getClientProtocolVersion() != 400) continue;
                        InfoRequestHandler.sendInfoPacket((int)1, (IMQConnection)object2, (long)0L);
                    }
                    object2 = BrokerStateHandler.this;
                    synchronized (object2) {
                        try {
                            BrokerStateHandler.this.logger.log(8, "B1201", new Date(BrokerStateHandler.this.targetShutdownTime).toString());
                            BrokerStateHandler.this.wait(BrokerStateHandler.this.getShutdownRemaining());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                Globals.getLogger().logToAll(8, "B1047");
                if (Broker.getBroker().getDiagInterval() == 0) {
                    Globals.getLogger().log(8, DiagManager.allToString());
                }
                shuttingDown = true;
                shutdownStarted = true;
                BrokerStateHandler.this.prepareShutdown(this.failover);
                object = Globals.getServiceManager();
                object.stopNewConnections(1);
                connectionManager = Globals.getConnectionManager();
                Globals.getLogger().logToAll(8, "B1077");
                int n = 1;
                String string = Globals.getBrokerResources().getKString("B0076", (Object)this.requestedBy);
                if (this.exitCode == BrokerStateHandler.getRestartCode()) {
                    n = 2;
                    string = Globals.getBrokerResources().getKString("B0077", (Object)this.requestedBy);
                }
                connectionManager.broadcastGoodbye(n, string);
                Globals.getLogger().logToAll(8, "B1078");
                connectionManager.flushControlMessages(1000L);
                object.stopAllActiveServices(true);
                if (this.cleanupJMX) {
                    Agent agent = Globals.getAgent();
                    if (agent != null) {
                        agent.stop();
                        agent.unloadMBeans();
                    }
                    break block36;
                }
                Globals.getLogger().log(8, "B1246");
            }
            Object var9_14 = null;
            try {
                if (clusteredBroker != null && brokerState != BrokerState.FAILOVER_STARTED && brokerState != BrokerState.FAILOVER_PENDING && brokerState != BrokerState.FAILOVER_COMPLETE) {
                    try {
                        if (this.failover) {
                            clusteredBroker.setState(BrokerState.SHUTDOWN_FAILOVER);
                        } else {
                            clusteredBroker.setState(BrokerState.SHUTDOWN_COMPLETE);
                        }
                    }
                    catch (Throwable throwable) {
                        Globals.getLogger().logStack(16, "B3063", throwable);
                    }
                }
                Globals.releaseStore();
            }
            catch (Exception exception) {
                Globals.getLogger().logStack(16, "B3063", exception);
                return 1;
            }
            {
                catch (Exception exception) {
                    Globals.getLogger().logStack(16, "B3063", exception);
                    int n = 1;
                    Object var9_15 = null;
                    try {
                        if (clusteredBroker != null && brokerState != BrokerState.FAILOVER_STARTED && brokerState != BrokerState.FAILOVER_PENDING && brokerState != BrokerState.FAILOVER_COMPLETE) {
                            try {
                                if (this.failover) {
                                    clusteredBroker.setState(BrokerState.SHUTDOWN_FAILOVER);
                                } else {
                                    clusteredBroker.setState(BrokerState.SHUTDOWN_COMPLETE);
                                }
                            }
                            catch (Throwable throwable) {
                                Globals.getLogger().logStack(16, "B3063", throwable);
                            }
                        }
                        Globals.releaseStore();
                    }
                    catch (Exception exception2) {
                        Globals.getLogger().logStack(16, "B3063", exception2);
                        return 1;
                    }
                    return n;
                }
            }
            catch (Throwable throwable) {
                Object var9_16 = null;
                try {
                    if (clusteredBroker != null && brokerState != BrokerState.FAILOVER_STARTED && brokerState != BrokerState.FAILOVER_PENDING && brokerState != BrokerState.FAILOVER_COMPLETE) {
                        try {
                            if (this.failover) {
                                clusteredBroker.setState(BrokerState.SHUTDOWN_FAILOVER);
                            } else {
                                clusteredBroker.setState(BrokerState.SHUTDOWN_COMPLETE);
                            }
                        }
                        catch (Throwable throwable2) {
                            Globals.getLogger().logStack(16, "B3063", throwable2);
                        }
                    }
                    Globals.releaseStore();
                }
                catch (Exception exception) {
                    Globals.getLogger().logStack(16, "B3063", exception);
                    return 1;
                }
                throw throwable;
            }
            Globals.getPortMapper().destroy();
            Globals.getLogger().logToAll(8, "B1048");
            if (this.exitCode == BrokerStateHandler.getRestartCode()) {
                Globals.getLogger().log(8, "B1064");
            }
            return this.exitCode;
        }
    }

    public class QuiesceRunnable
    implements Runnable {
        boolean breakQuiesce = false;

        public QuiesceRunnable() throws BrokerException {
            BrokerStateHandler.this.logger.log(8, "B1197");
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.notifyQuiesceStart();
            }
            try {
                ClusteredBroker clusteredBroker = Globals.getClusterManager().getLocalBroker();
                clusteredBroker.setState(BrokerState.QUIESCE_STARTED);
                ServiceManager serviceManager = Globals.getServiceManager();
                serviceManager.stopNewConnections(0);
            }
            catch (Exception exception) {
                throw new BrokerException("B4252", (Throwable)exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                QuiesceRunnable quiesceRunnable = this;
                synchronized (quiesceRunnable) {
                    while (!this.breakQuiesce) {
                        ServiceManager serviceManager = Globals.getServiceManager();
                        int n = serviceManager.getConnectionCount(0);
                        int n2 = Destination.totalCountNonPersist();
                        if (n == 0 && n2 == 0) break;
                        Logger logger = BrokerStateHandler.this.logger;
                        BrokerStateHandler.this.logger;
                        logger.log(8, BrokerStateHandler.this.br.getKString("B1300", (Object)n, (Object)n2));
                        this.wait(10000L);
                    }
                }
                if (!this.breakQuiesce) {
                    quiesceRunnable = Globals.getClusterManager().getLocalBroker();
                    quiesceRunnable.setState(BrokerState.QUIESCE_COMPLETED);
                }
                BrokerStateHandler.this.logger.log(8, "B1198");
                quiesceRunnable = this;
                synchronized (quiesceRunnable) {
                    BrokerStateHandler.this.qrun = null;
                }
                quiesceRunnable = Globals.getAgent();
                if (quiesceRunnable != null) {
                    quiesceRunnable.notifyQuiesceComplete();
                }
            }
            catch (Exception exception) {
                Globals.getLogger().logStack(16, "B3100", "quiescing broker ", (Throwable)exception);
            }
        }

        public synchronized void breakQuiesce() {
            this.breakQuiesce = true;
            this.notify();
        }
    }
}

