/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceForMC;
import com.sun.messaging.jms.ra.ConnectionAdapter;
import com.sun.messaging.jms.ra.ConnectionCreator;
import com.sun.messaging.jms.ra.ConnectionEventListener;
import com.sun.messaging.jms.ra.ConnectionRequestInfo;
import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.DirectLocalTransaction;
import com.sun.messaging.jms.ra.DirectXAResource;
import com.sun.messaging.jms.ra.LocalTransaction;
import com.sun.messaging.jms.ra.ManagedConnectionFactory;
import com.sun.messaging.jms.ra.ManagedConnectionMetaData;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.SessionAdapter;
import com.sun.messaging.jms.ra.Util;
import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class ManagedConnection
implements javax.resource.spi.ManagedConnection {
    private ResourceAdapter ra = null;
    private ManagedConnectionFactory mcf = null;
    private Subject subject = null;
    private ConnectionRequestInfo crInfo = null;
    private ConnectionAdapter ca = null;
    private XAResourceForMC xar = null;
    private DirectXAResource dxar = null;
    private XAConnectionImpl xac = null;
    private DirectConnection dc = null;
    private ConnectionEventListener evtlistener = null;
    private LocalTransaction localTransaction = null;
    private DirectLocalTransaction directLocalTransaction = null;
    private boolean ltActive = false;
    private ManagedConnectionMetaData mcMetaData = null;
    private PasswordCredential pwCredential = null;
    private SessionAdapter sa = null;
    private boolean isDirect = false;
    private boolean destroyed = false;
    private boolean pwcValid;
    private PrintWriter logWriter = null;
    private transient int mcId = 0;
    private static int idCounter = 0;
    private static final transient String _className = "com.sun.messaging.jms.ra.ManagedConnectionFactory";
    protected static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    protected static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_MC";
    protected static final transient String _lgrMID_EET = "MQJMSRA_MC1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_MC1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_MC2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_MC3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_MC4001: ";

    public ManagedConnection(ManagedConnectionFactory managedConnectionFactory, Subject subject, ConnectionRequestInfo connectionRequestInfo, ResourceAdapter resourceAdapter) throws ResourceException {
        String string;
        String string2;
        _loggerOC.entering(_className, "constructor()");
        this.mcId = ++idCounter;
        this.mcf = managedConnectionFactory;
        this.isDirect = managedConnectionFactory.getEnableDirect();
        this.subject = subject;
        this.crInfo = connectionRequestInfo;
        this.ra = resourceAdapter;
        this.pwCredential = Util.getPasswordCredential(managedConnectionFactory, subject, connectionRequestInfo);
        this.pwcValid = Util.isPasswordCredentialValid(subject);
        if (this.pwCredential != null) {
            if (this.pwcValid) {
                if (connectionRequestInfo != null && connectionRequestInfo.getUserName() != null) {
                    _loggerOC.warning("MQJMSRA_MC2001: createConnection API used w/ username, password for Container Auth");
                }
            } else if (connectionRequestInfo != null && connectionRequestInfo.getUserName() == null) {
                _loggerOC.warning("MQJMSRA_MC2001: createConnection API used w/o username, password for Application Auth");
            }
            string2 = this.pwCredential.getUserName();
            string = new String(this.pwCredential.getPassword());
            _loggerOC.finer("MQJMSRA_MC1101: constructor:Using pwCred:u,p=" + string2);
        } else {
            string2 = managedConnectionFactory.getUserName();
            string = managedConnectionFactory.getPassword();
            _loggerOC.finer("MQJMSRA_MC1101: constructor:Using mcfConfig:u,p=" + string2);
        }
        try {
            _loggerOC.finer("MQJMSRA_MC1101: constructor:Creating mcId=" + this.mcId + ":Using xacf config=" + managedConnectionFactory._getXACF().getCurrentConfiguration());
            ConnectionCreator connectionCreator = managedConnectionFactory.getConnectionCreator();
            if (this.isDirect) {
                this.dc = (DirectConnection)connectionCreator._createConnection(string2, string);
                this.dc.setManaged(true, this);
            } else {
                this.xac = (XAConnectionImpl)managedConnectionFactory._getXACF().createXAConnection(string2, string);
            }
        }
        catch (JMSException jMSException) {
            ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("MQJMSRA_MC4001: constructor:Aborting:JMSException on createConnection=" + jMSException.getMessage());
            resourceAdapterInternalException.initCause((Throwable)jMSException);
            _loggerOC.severe(resourceAdapterInternalException.getMessage());
            jMSException.printStackTrace();
            _loggerOC.throwing(_className, "constructor()", (Throwable)resourceAdapterInternalException);
            throw resourceAdapterInternalException;
        }
        this.evtlistener = new ConnectionEventListener(this);
        try {
            if (this.isDirect) {
                this.dc._setExceptionListener(this.evtlistener);
                this.directLocalTransaction = new DirectLocalTransaction(this, this.dc);
            } else {
                this.xac._setExceptionListenerFromRA(this.evtlistener);
                this.xac.setExtendedEventNotification(true);
                this.ca = new ConnectionAdapter(this, this.xac, resourceAdapter);
                this.mcMetaData = new ManagedConnectionMetaData(this);
                this.localTransaction = new LocalTransaction(this, this.xac);
                _loggerOC.info("MQJMSRA_MC1101: constructor:Created mcId=" + this.mcId + ":xacId=" + this.xac._getConnectionID() + ":Using xacf config=" + managedConnectionFactory._getXACF().getCurrentConfiguration());
                this.xac.setEventListener(this.evtlistener);
            }
        }
        catch (JMSException jMSException) {
            String string3 = "MQRA:MC:Constr:Exception on setExceptionListener-" + jMSException.getMessage();
            throw new ResourceAdapterInternalException("MQRA:MC:JMSException upon setExceptionListener", (Throwable)jMSException);
        }
        try {
            if (this.isDirect) {
                this.dxar = this.dc._getXAResource();
            } else {
                this.xar = new XAResourceForMC(this, this.xac, this.xac);
            }
        }
        catch (JMSException jMSException) {
            String string4 = "MQRA:MC:Constr:Exception on xar creation-" + jMSException.getMessage();
            System.err.println(string4);
            jMSException.printStackTrace();
            throw new ResourceAdapterInternalException(string4, (Throwable)jMSException);
        }
        this.logWriter = null;
        _loggerOC.exiting(_className, "constructor()");
    }

    public void addConnectionEventListener(javax.resource.spi.ConnectionEventListener connectionEventListener) {
        _loggerOC.entering(_className, "addConnectionEventListener():mcId=" + this.mcId, connectionEventListener);
        this.evtlistener.addConnectionEventListener(connectionEventListener);
    }

    public void removeConnectionEventListener(javax.resource.spi.ConnectionEventListener connectionEventListener) {
        _loggerOC.entering(_className, "removeConnectionEventListener():mcId=" + this.mcId, connectionEventListener);
        this.evtlistener.removeConnectionEventListener(connectionEventListener);
    }

    public void cleanup() throws ResourceException {
        _loggerOC.entering(_className, "cleanup():mcId=" + this.mcId);
        this.checkDestroyed();
        if (this.isDirect) {
            try {
                this.dc._cleanup();
            }
            catch (JMSException jMSException) {
                throw new ResourceException((Throwable)jMSException);
            }
        } else if (this.ca != null) {
            this.ca.cleanup();
        }
    }

    public void destroy() throws ResourceException {
        if (this.destroyed) {
            _loggerOC.warning("MQJMSRA_MC2001: destroy:Previously destroyed-mcId=" + this.mcId);
        } else {
            if (this.isDirect) {
                try {
                    this.dc._destroy();
                }
                catch (JMSException jMSException) {
                    throw new ResourceException((Throwable)jMSException);
                }
            } else if (this.ca != null) {
                this.ca.destroy();
            }
            this.destroyed = true;
        }
    }

    public XAResource getXAResource() throws ResourceException {
        _loggerOC.entering(_className, "getXAResource():mcId=" + this.mcId);
        this.checkDestroyed();
        if (this.isDirect) {
            return this.dxar;
        }
        return this.xar;
    }

    public javax.resource.spi.LocalTransaction getLocalTransaction() throws ResourceException {
        _loggerOC.entering(_className, "getLocalTransaction():mcId=" + this.mcId);
        this.checkDestroyed();
        if (this.isDirect) {
            return this.directLocalTransaction;
        }
        return this.localTransaction;
    }

    public javax.resource.spi.ManagedConnectionMetaData getMetaData() throws ResourceException {
        _loggerOC.entering(_className, "getMetaData():mcId=" + this.mcId);
        this.checkDestroyed();
        return this.mcMetaData;
    }

    public Object getConnection(Subject subject, javax.resource.spi.ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Object[] objectArray = new Object[]{subject, connectionRequestInfo};
        ConnectionRequestInfo connectionRequestInfo2 = (ConnectionRequestInfo)connectionRequestInfo;
        this.checkDestroyed();
        PasswordCredential passwordCredential = Util.getPasswordCredential(this.mcf, subject, connectionRequestInfo2);
        if (!Util.isPasswordCredentialEqual(passwordCredential, this.pwCredential)) {
            throw new SecurityException("MQRA:MC:getConnection-auth failed for Subject-" + (subject != null ? subject.toString() : "null-subject"));
        }
        String string = this.mcf.getClientId();
        if (string != null) {
            try {
                if (this.isDirect) {
                    _loggerOC.fine("MQJMSRA_MC1101: getConnection():mcId=" + this.mcId + ":xacId=" + this.dc.getConnectionId() + ":opening CA;setting ClientId:" + string);
                    this.dc._activate(string);
                }
                _loggerOC.fine("MQJMSRA_MC1101: getConnection():mcId=" + this.mcId + ":xacId=" + this.xac._getConnectionID() + ":opening CA;setting ClientId:" + string);
                this.ca.open(string);
            }
            catch (InvalidClientIDException invalidClientIDException) {
                EISSystemException eISSystemException = new EISSystemException("MQRA:MC:InvalidClientIDException-" + invalidClientIDException.getMessage());
                eISSystemException.initCause((Throwable)invalidClientIDException);
                throw eISSystemException;
            }
            catch (JMSException jMSException) {
                EISSystemException eISSystemException = new EISSystemException("MQRA:MC:JMSException-" + jMSException.getMessage());
                eISSystemException.initCause((Throwable)jMSException);
                throw eISSystemException;
            }
        } else if (this.isDirect) {
            try {
                this.dc._activate(null);
            }
            catch (InvalidClientIDException invalidClientIDException) {
                EISSystemException eISSystemException = new EISSystemException("MQRA:MC:InvalidClientIDException-" + invalidClientIDException.getMessage());
                eISSystemException.initCause((Throwable)invalidClientIDException);
                throw eISSystemException;
            }
            catch (JMSException jMSException) {
                EISSystemException eISSystemException = new EISSystemException("MQRA:MC:JMSException-" + jMSException.getMessage());
                eISSystemException.initCause((Throwable)jMSException);
                throw eISSystemException;
            }
        } else {
            _loggerOC.fine("MQJMSRA_MC1101: getConnection():mcId=" + this.mcId + ":xacId=" + this.xac._getConnectionID() + ":opening CA;NO ClientId");
            this.ca.open();
        }
        if (this.isDirect) {
            return this.dc;
        }
        return this.ca;
    }

    public void associateConnection(Object object) throws ResourceException {
        _loggerOC.entering(_className, "associateConnection():mcId=" + this.mcId, object);
        this.checkDestroyed();
        if (this.isDirect) {
            return;
        }
        if (!(object instanceof ConnectionAdapter)) {
            throw new ResourceException("MQRA:MC:associateConnection-invalid connection:class=" + object.getClass() + ":toString=" + object.toString());
        }
        ConnectionAdapter connectionAdapter = (ConnectionAdapter)object;
        connectionAdapter.associateManagedConnection(this);
        this.ca = connectionAdapter;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        _loggerOC.entering(_className, "setLogWriter():mcId=" + this.mcId, printWriter);
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        _loggerOC.entering(_className, "getLogWriter():mcId=" + this.mcId, this.logWriter);
        return this.logWriter;
    }

    public int getMCId() {
        return this.mcId;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public PasswordCredential getPasswordCredential() {
        return this.pwCredential;
    }

    public ConnectionAdapter getConnectionAdapter() {
        return this.ca;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean xaTransactionStarted() {
        if (this.ltActive) {
            if (this.isDirect) {
                return this.directLocalTransaction.started();
            }
            return this.localTransaction.started();
        }
        if (this.isDirect) {
            return this.dxar.isEnlisted();
        }
        return this.xar.started();
    }

    public boolean xaTransactionActive() {
        if (this.ltActive) {
            if (this.isDirect) {
                return this.directLocalTransaction.isActive();
            }
            return this.localTransaction.isActive();
        }
        if (this.isDirect) {
            return this.dxar.isEnlisted();
        }
        return this.xar.isActive();
    }

    public long getTransactionID() {
        if (this.ltActive) {
            if (this.isDirect) {
                return this.directLocalTransaction.getTransactionID();
            }
            return this.localTransaction.getTransactionID();
        }
        if (this.isDirect) {
            return this.dxar._getTransactionId();
        }
        return this.xar.getTransactionID();
    }

    public void setLTActive(boolean bl) {
        this.ltActive = bl;
    }

    public void sendEvent(int n, Exception exception) {
        this.evtlistener.sendEvent(n, exception, null);
    }

    public void sendEvent(int n, Exception exception, Object object) {
        this.evtlistener.sendEvent(n, exception, object);
    }

    protected void _setDirect(boolean bl) {
        this.isDirect = bl;
    }

    private void checkDestroyed() throws ResourceException {
        if (this.destroyed) {
            throw new IllegalStateException("MQRA:MC:Destroyed-Id=" + this.mcId);
        }
    }
}

