/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content.keyvalues;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.KeyValueContent;
import com.sun.org.apache.xml.internal.security.utils.I18n;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DSAKeyValue
extends SignatureElementProxy
implements KeyValueContent {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$keys$content$keyvalues$DSAKeyValue == null ? (class$com$sun$org$apache$xml$internal$security$keys$content$keyvalues$DSAKeyValue = DSAKeyValue.class$("com.sun.org.apache.xml.internal.security.keys.content.keyvalues.DSAKeyValue")) : class$com$sun$org$apache$xml$internal$security$keys$content$keyvalues$DSAKeyValue).getName());
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$keys$content$keyvalues$DSAKeyValue;

    public DSAKeyValue(Element element, String string2) throws XMLSecurityException {
        super(element, string2);
    }

    public DSAKeyValue(Document document, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        this.addBigIntegerElement(bigInteger, "P");
        this.addBigIntegerElement(bigInteger2, "Q");
        this.addBigIntegerElement(bigInteger3, "G");
        this.addBigIntegerElement(bigInteger4, "Y");
    }

    public DSAKeyValue(Document document, Key key) throws IllegalArgumentException {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        if (!(key instanceof DSAPublicKey)) {
            Object[] objectArray = new Object[]{"DSAKeyValue", key.getClass().getName()};
            throw new IllegalArgumentException(I18n.translate("KeyValue.IllegalArgument", objectArray));
        }
        this.addBigIntegerElement(((DSAPublicKey)key).getParams().getP(), "P");
        this.addBigIntegerElement(((DSAPublicKey)key).getParams().getQ(), "Q");
        this.addBigIntegerElement(((DSAPublicKey)key).getParams().getG(), "G");
        this.addBigIntegerElement(((DSAPublicKey)key).getY(), "Y");
    }

    public PublicKey getPublicKey() throws XMLSecurityException {
        try {
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(this.getBigIntegerFromChildElement("Y", "http://www.w3.org/2000/09/xmldsig#"), this.getBigIntegerFromChildElement("P", "http://www.w3.org/2000/09/xmldsig#"), this.getBigIntegerFromChildElement("Q", "http://www.w3.org/2000/09/xmldsig#"), this.getBigIntegerFromChildElement("G", "http://www.w3.org/2000/09/xmldsig#"));
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PublicKey publicKey = keyFactory.generatePublic(dSAPublicKeySpec);
            return publicKey;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLSecurityException("empty", noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new XMLSecurityException("empty", invalidKeySpecException);
        }
    }

    public String getBaseLocalName() {
        return "DSAKeyValue";
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

