/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter;

import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.Invocation;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.FilteringStateMachine;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.InvocationProcessingState;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.XmlFilteringUtils;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;

public final class MexImportFilteringStateMachine
implements FilteringStateMachine {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(MexImportFilteringStateMachine.class);
    private static final String MEX_NAMESPACE = "http://schemas.xmlsoap.org/ws/2004/09/mex";
    private static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    private static final QName WSDL_IMPORT_ELEMENT = new QName("http://schemas.xmlsoap.org/wsdl/", "import");
    private static final QName IMPORT_NAMESPACE_ATTIBUTE = new QName("http://schemas.xmlsoap.org/wsdl/", "namespace");
    private int depth;
    private StateMachineMode currentMode = StateMachineMode.INACTIVE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationProcessingState getState(Invocation invocation, XMLStreamWriter writer) {
        LOGGER.entering(invocation);
        InvocationProcessingState resultingState = InvocationProcessingState.NO_STATE_CHANGE;
        try {
            switch (invocation.getMethodType()) {
                case WRITE_START_ELEMENT: {
                    if (this.currentMode == StateMachineMode.INACTIVE) {
                        if (!this.startBuffering(invocation, writer)) break;
                        resultingState = InvocationProcessingState.START_BUFFERING;
                        this.currentMode = StateMachineMode.BUFFERING;
                        break;
                    }
                    ++this.depth;
                    break;
                }
                case WRITE_END_ELEMENT: {
                    if (this.currentMode == StateMachineMode.INACTIVE) break;
                    if (this.depth == 0) {
                        resultingState = this.currentMode == StateMachineMode.BUFFERING ? InvocationProcessingState.STOP_BUFFERING : InvocationProcessingState.STOP_FILTERING;
                        this.currentMode = StateMachineMode.INACTIVE;
                        break;
                    }
                    --this.depth;
                    break;
                }
                case WRITE_ATTRIBUTE: {
                    if (this.currentMode != StateMachineMode.BUFFERING || !this.startFiltering(invocation, writer)) break;
                    resultingState = InvocationProcessingState.START_FILTERING;
                    this.currentMode = StateMachineMode.FILTERING;
                    break;
                }
                case CLOSE: {
                    switch (this.currentMode) {
                        case BUFFERING: {
                            resultingState = InvocationProcessingState.STOP_BUFFERING;
                            break;
                        }
                        case FILTERING: {
                            resultingState = InvocationProcessingState.STOP_FILTERING;
                        }
                    }
                    this.currentMode = StateMachineMode.INACTIVE;
                    break;
                }
            }
            InvocationProcessingState invocationProcessingState = resultingState;
            return invocationProcessingState;
        }
        finally {
            LOGGER.exiting((Object)resultingState);
        }
    }

    private boolean startFiltering(Invocation invocation, XMLStreamWriter writer) {
        XmlFilteringUtils.AttributeInfo attributeInfo = XmlFilteringUtils.getAttributeNameToWrite(invocation, XmlFilteringUtils.getDefaultNamespaceURI(writer));
        return IMPORT_NAMESPACE_ATTIBUTE.equals(attributeInfo.getName()) && MEX_NAMESPACE.equals(attributeInfo.getValue());
    }

    private boolean startBuffering(Invocation invocation, XMLStreamWriter writer) {
        QName elementName = XmlFilteringUtils.getElementNameToWrite(invocation, XmlFilteringUtils.getDefaultNamespaceURI(writer));
        return WSDL_IMPORT_ELEMENT.equals(elementName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StateMachineMode {
        INACTIVE,
        BUFFERING,
        FILTERING;

    }
}

