/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.rm.BufferFullException;
import com.sun.xml.ws.rm.DuplicateMessageException;
import com.sun.xml.ws.rm.InvalidMessageNumberException;
import com.sun.xml.ws.rm.Message;
import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.Sequence;
import com.sun.xml.ws.rm.jaxws.runtime.InboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.Messages;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.jaxws.util.ProcessingFilter;
import com.sun.xml.ws.rm.protocol.AckRequestedElement;
import com.sun.xml.ws.rm.protocol.AcknowledgementHandler;
import com.sun.xml.ws.rm.protocol.SequenceAcknowledgementElement;
import com.sun.xml.ws.rm.protocol.SequenceElement;
import java.net.URI;
import java.util.logging.Logger;
import javax.xml.bind.Marshaller;

public abstract class OutboundSequence
extends Sequence {
    private static final Logger logger = Logger.getLogger(OutboundSequence.class.getName());
    protected URI destination;
    protected URI acksTo;
    protected InboundSequence inboundSequence;
    protected SequenceAcknowledgementElement sequenceAcknowledgement;
    protected SequenceConfig config;
    protected AcknowledgementHandler ackHandler;
    public boolean saveMessages = true;
    private ProcessingFilter filter = null;
    protected int bufferRemaining;

    public URI getDestination() {
        return this.destination;
    }

    public URI getAcksTo() {
        return this.acksTo;
    }

    public void setSequenceAcknowledgement(SequenceAcknowledgementElement element) {
        this.sequenceAcknowledgement = element;
    }

    public InboundSequence getInboundSequence() {
        return this.inboundSequence;
    }

    public int getBufferRemaining() {
        return this.bufferRemaining;
    }

    public void setBufferRemaining(int value) {
        this.bufferRemaining = value;
    }

    public void processOutboundMessage(Message mess, Marshaller marshaller) throws InvalidMessageNumberException, BufferFullException, DuplicateMessageException {
        if (this.saveMessages && !mess.isOneWayResponse) {
            int messageNumber = mess.getMessageNumber();
            if (messageNumber == 0) {
                messageNumber = this.set(this.getNextIndex(), mess);
            } else {
                this.set(messageNumber, mess);
            }
            SequenceElement element = new SequenceElement();
            element.setNumber(messageNumber);
            element.setId(this.getId());
            mess.setSequenceElement(element);
            if (this.isAckRequested()) {
                AckRequestedElement ack = new AckRequestedElement();
                ack.setId(this.getId());
                mess.setAckRequestedElement(ack);
            }
        }
        if (this.sequenceAcknowledgement != null) {
            mess.setSequenceAcknowledgementElement(this.sequenceAcknowledgement);
            this.sequenceAcknowledgement = null;
        }
        if (this.filter != null) {
            this.filter.handleOutboundHeaders(mess);
        }
        if (mess.getSequenceElement() != null) {
            mess.addHeader(this.createHeader(mess.getSequenceElement()));
        }
        if (mess.getAckRequestedElement() != null) {
            mess.addHeader(this.createHeader(mess.getAckRequestedElement()));
        }
        if (mess.getSequenceAcknowledgementElement() != null) {
            mess.addHeader(this.createHeader(mess.getSequenceAcknowledgementElement()));
        }
    }

    public synchronized void processAcknowledgement(Message mess, Marshaller marshaller) throws RMException {
        if (this.sequenceAcknowledgement != null) {
            mess.addHeader(this.createHeader(this.sequenceAcknowledgement));
            this.sequenceAcknowledgement = null;
        }
    }

    public synchronized void acknowledge(int i) throws InvalidMessageNumberException {
        Message mess;
        if (i >= this.nextIndex || null == (mess = this.get(i))) {
            throw new InvalidMessageNumberException();
        }
        if (!mess.isComplete()) {
            --this.storedMessages;
            if (this.storedMessages == 0) {
                this.notifyAll();
            }
            mess.complete();
        }
    }

    public void handleAckResponse(SequenceAcknowledgementElement element) throws InvalidMessageNumberException {
        if (this.ackHandler == null) {
            this.ackHandler = new AcknowledgementHandler(this.config);
        }
        this.ackHandler.handleAcknowledgement(this, element);
    }

    public synchronized void waitForAcks() {
        while (this.storedMessages != 0) {
            try {
                long timeout = this.config.getCloseTimeout();
                this.wait(timeout);
                if (this.storedMessages <= 0) continue;
                logger.severe(Messages.TIMEOUT_IN_WAITFORACKS_STRING.format(timeout / 1000L, this.storedMessages));
            }
            catch (InterruptedException e) {}
            break;
        }
    }

    protected boolean isAckRequested() {
        return this.saveMessages;
    }

    protected boolean isResendDue() {
        return true;
    }

    private SOAPVersion getVersion() {
        return this.config.getSoapVersion();
    }

    public void setProcessingFilter(ProcessingFilter filter) {
        this.filter = filter;
    }

    public void ensureAckRequested(Message mess, Marshaller marshaller) {
        if (mess.getAckRequestedElement() == null) {
            AckRequestedElement ack = new AckRequestedElement();
            ack.setId(this.getId());
            mess.setAckRequestedElement(ack);
            mess.addHeader(this.createHeader(mess.getAckRequestedElement()));
        }
    }

    protected Header createHeader(Object obj) {
        return Headers.create(this.config.getRMConstants().getJAXBRIContextHeaders(), obj);
    }
}

