/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.client;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.rm.CreateSequenceException;
import com.sun.xml.ws.rm.Message;
import com.sun.xml.ws.rm.RMConstants;
import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.TerminateSequenceException;
import com.sun.xml.ws.rm.jaxws.runtime.InboundMessageProcessor;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.client.ClientOutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.client.ProtocolMessageReceiver;
import com.sun.xml.ws.rm.protocol.AckRequestedElement;
import com.sun.xml.ws.rm.protocol.CreateSequenceElement;
import com.sun.xml.ws.rm.protocol.CreateSequenceResponseElement;
import com.sun.xml.ws.rm.protocol.SequenceElement;
import com.sun.xml.ws.rm.protocol.TerminateSequenceElement;
import java.net.URI;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ProtocolMessageSender {
    private InboundMessageProcessor processor;
    private Pipe nextPipe;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private RMConstants constants;
    private Packet packet;
    private WSDLPort port;
    private WSBinding binding;

    public ProtocolMessageSender(InboundMessageProcessor processor, Marshaller marshaller, Unmarshaller unmarshaller, WSDLPort port, WSBinding binding, Pipe nextPipe, Packet packet) {
        this.processor = processor;
        this.nextPipe = nextPipe;
        this.port = port;
        this.binding = binding;
        this.marshaller = marshaller;
        this.unmarshaller = unmarshaller;
        this.constants = RMConstants.getRMConstants(binding.getAddressingVersion());
        this.packet = packet;
    }

    public CreateSequenceResponseElement sendCreateSequence(CreateSequenceElement cs, URI destination, URI acksTo, SOAPVersion version) throws RMException {
        CreateSequenceResponseElement csrElem = null;
        if (cs != null) {
            com.sun.xml.ws.api.message.Message request = Messages.create(this.constants.getJAXBContext(), (Object)cs, version);
            Packet requestPacket = new Packet(request);
            requestPacket.proxy = this.packet.proxy;
            requestPacket.contentNegotiation = this.packet.contentNegotiation;
            requestPacket.setEndPointAddressString(destination.toString());
            this.addAddressingHeaders(requestPacket, "http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence", destination, acksTo, false);
            String messageId = null;
            Packet responsePacket = this.nextPipe.process(requestPacket);
            if (acksTo.equals(this.constants.getAnonymousURI())) {
                com.sun.xml.ws.api.message.Message response = responsePacket.getMessage();
                if (response.isFault()) {
                    throw new CreateSequenceException("CreateSequence was refused by the RMDestination \n ", response);
                }
                if (response != null) {
                    csrElem = this.unmarshallCreateSequenceResponse(response);
                }
            } else {
                csrElem = ProtocolMessageReceiver.getCreateSequenceResponse(messageId);
            }
        }
        return csrElem;
    }

    public void sendTerminateSequence(TerminateSequenceElement ts, OutboundSequence seq, SOAPVersion version) throws RMException {
        com.sun.xml.ws.api.message.Message request = Messages.create(this.constants.getJAXBContext(), (Object)ts, version);
        seq.processAcknowledgement(new Message(request), this.marshaller);
        Packet requestPacket = new Packet(request);
        requestPacket.proxy = this.packet.proxy;
        requestPacket.contentNegotiation = this.packet.contentNegotiation;
        this.addAddressingHeaders(requestPacket, "http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence", seq.getDestination(), seq.getAcksTo(), false);
        requestPacket.setEndPointAddressString(seq.getDestination().toString());
        Packet responsePacket = this.nextPipe.process(requestPacket);
        com.sun.xml.ws.api.message.Message response = responsePacket.getMessage();
        if (response != null && response.isFault()) {
            throw new TerminateSequenceException("There was an error trying to terminate the sequence ", response);
        }
    }

    public void sendLast(OutboundSequence seq, SOAPVersion version) throws RMException {
        com.sun.xml.ws.api.message.Message request = this.createEmptyMessage(version);
        SequenceElement el = this.createLastHeader(seq);
        request.getHeaders().add(this.createHeader(el));
        seq.setLast();
        Packet requestPacket = new Packet(request);
        requestPacket.proxy = this.packet.proxy;
        requestPacket.setEndPointAddressString(seq.getDestination().toString());
        requestPacket.contentNegotiation = this.packet.contentNegotiation;
        this.addAddressingHeaders(requestPacket, this.constants.getLastAction(), seq.getDestination(), seq.getAcksTo(), false);
        Packet responsePacket = this.nextPipe.process(requestPacket);
        com.sun.xml.ws.api.message.Message response = responsePacket.getMessage();
        Message msg = new Message(response);
        if (response != null && response.isFault()) {
            throw new RMException(response);
        }
        this.processor.processMessage(msg, this.marshaller, this.unmarshaller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAckRequested(OutboundSequence seq, SOAPVersion version) throws RMException {
        try {
            com.sun.xml.ws.api.message.Message request = this.createEmptyMessage(version);
            AckRequestedElement el = this.createAckRequestedElement(seq);
            request.getHeaders().add(this.createHeader(el));
            Packet requestPacket = new Packet(request);
            requestPacket.proxy = this.packet.proxy;
            requestPacket.contentNegotiation = this.packet.contentNegotiation;
            this.addAddressingHeaders(requestPacket, "http://schemas.xmlsoap.org/ws/2005/02/rm/AckRequested", seq.getDestination(), seq.getAcksTo(), false);
            requestPacket.setEndPointAddressString(seq.getDestination().toString());
            Packet responsePacket = this.nextPipe.process(requestPacket);
            com.sun.xml.ws.api.message.Message response = responsePacket.getMessage();
            if (response != null && response.isFault()) {
                ((ClientOutboundSequence)seq).resetLastActivityTime();
                throw new RMException(response);
            }
            Message msg = new Message(response);
            this.processor.processMessage(msg, this.marshaller, this.unmarshaller);
        }
        finally {
            ((ClientOutboundSequence)seq).resetLastActivityTime();
        }
    }

    private Packet addAddressingHeaders(Packet requestPacket, String action, URI destination, URI acksTo, boolean oneWay) throws RMException {
        com.sun.xml.ws.api.message.Message message = requestPacket.getMessage();
        HeaderList list = message.getHeaders();
        if (oneWay) {
            message.assertOneWay(true);
        } else {
            message.assertOneWay(false);
        }
        requestPacket.setEndPointAddressString(destination.toString());
        list.fillRequestAddressingHeaders(requestPacket, this.constants.getAddressingVersion(), this.binding.getSOAPVersion(), oneWay, action);
        return requestPacket;
    }

    private com.sun.xml.ws.api.message.Message createEmptyMessage(SOAPVersion version) {
        return Messages.createEmpty(version);
    }

    private CreateSequenceResponseElement unmarshallCreateSequenceResponse(com.sun.xml.ws.api.message.Message response) throws RMException {
        CreateSequenceResponseElement csrElement = null;
        try {
            csrElement = (CreateSequenceResponseElement)response.readPayloadAsJAXB(this.unmarshaller);
        }
        catch (JAXBException e) {
            throw new RMException(e);
        }
        return csrElement;
    }

    private SequenceElement createLastHeader(OutboundSequence seq) {
        SequenceElement sequenceElement = new SequenceElement();
        sequenceElement.setId(seq.getId());
        sequenceElement.setNumber(seq.getNextIndex());
        sequenceElement.setLastMessage(new SequenceElement.LastMessage());
        return sequenceElement;
    }

    private AckRequestedElement createAckRequestedElement(OutboundSequence seq) {
        AckRequestedElement ackRequestedElement = new AckRequestedElement();
        ackRequestedElement.setId(seq.getId());
        ackRequestedElement.setMaxMessageNumber(seq.getNextIndex() - 1);
        return ackRequestedElement;
    }

    public RMConstants getConstants() {
        return this.constants;
    }

    private Header createHeader(Object obj) {
        return Headers.create(this.constants.getJAXBRIContextHeaders(), obj);
    }
}

