/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.server;

import com.sun.xml.ws.api.rm.SequenceSettings;
import com.sun.xml.ws.api.rm.server.ServerSequence;
import com.sun.xml.ws.rm.BufferFullException;
import com.sun.xml.ws.rm.InvalidMessageNumberException;
import com.sun.xml.ws.rm.Message;
import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.jaxws.runtime.InboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.jaxws.runtime.server.Messages;
import com.sun.xml.ws.rm.jaxws.runtime.server.ServerOutboundSequence;
import com.sun.xml.ws.rm.jaxws.util.LoggingHelper;
import com.sun.xml.ws.runtime.util.Session;
import java.net.URI;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerInboundSequence
extends InboundSequence
implements ServerSequence {
    private static final Logger logger = Logger.getLogger(LoggingHelper.getLoggerName(ServerInboundSequence.class));
    private Session session;

    public ServerInboundSequence(URI acksTo, String inboundId, String outboundId, SequenceConfig config) {
        super(acksTo, config);
        this.outboundSequence = new ServerOutboundSequence(this, outboundId, config);
        if (inboundId == null) {
            String newid = "uuid:" + UUID.randomUUID();
            this.setId(newid);
        } else {
            this.setId(inboundId);
        }
        this.maxMessages = config.flowControl ? config.bufferSize : -1;
        this.allowDuplicates = config.allowDuplicates;
    }

    public Message getOriginalMessage(Message duplicate) throws InvalidMessageNumberException {
        int number = duplicate.getMessageNumber();
        return this.get(number);
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session s) {
        this.session = s;
    }

    public void releaseNextMessage(Message message) throws RMException {
        message.complete();
        --this.storedMessages;
        int num = message.getMessageNumber();
        if (num < this.nextIndex - 1 && this.get(num + 1) != null) {
            this.get(num + 1).resume();
        }
    }

    public void holdIfUndeliverable(Message message) throws BufferFullException {
        if (!this.config.ordered) {
            return;
        }
        try {
            Message mess;
            int num = message.getMessageNumber();
            if (!(num <= 1 || (mess = this.get(num - 1)) != null && mess.isComplete())) {
                message.block();
            }
        }
        catch (InvalidMessageNumberException invalidMessageNumberException) {
            // empty catch block
        }
    }

    public void resetMessage(int index, com.sun.xml.ws.api.message.Message message, boolean complete) {
        try {
            Message mess = new Message(message);
            this.set(index, mess);
            if (complete) {
                mess.complete();
            }
        }
        catch (RMException e) {
            String m = Messages.COULD_NOT_RESET_MESSAGE.format(index, this.getId());
            logger.log(Level.SEVERE, m, e);
        }
    }

    public SequenceSettings getSequenceSettings() {
        SequenceConfig settings = this.getSequenceConfig();
        settings.sequenceId = this.getId();
        OutboundSequence oseq = this.getOutboundSequence();
        settings.companionSequenceId = oseq != null ? oseq.getId() : null;
        return settings;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.getLastActivityTime() > this.config.getInactivityTimeout();
    }
}

