/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.AsymmetricBinding;
import com.sun.xml.ws.security.policy.Binding;
import com.sun.xml.ws.security.policy.Issuer;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.SupportingTokens;
import com.sun.xml.ws.security.policy.SymmetricBinding;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCTokenWrapper
extends PolicyAssertion
implements SecureConversationToken {
    private SecureConversationToken scToken = null;
    private MessagePolicy messagePolicy = null;
    private List<PolicyAssertion> tokenList = null;
    private boolean cached = false;

    public SCTokenWrapper(PolicyAssertion scToken, MessagePolicy mp) {
        super(AssertionData.createAssertionData(scToken.getName(), scToken.getValue(), scToken.getAttributes()), SCTokenWrapper.getNestedAssertions(scToken), scToken.getNestedPolicy() == null ? null : scToken.getNestedPolicy().getAssertionSet());
        this.scToken = (SecureConversationToken)((Object)scToken);
        this.messagePolicy = mp;
    }

    private static Collection<PolicyAssertion> getNestedAssertions(PolicyAssertion scToken) {
        Iterator<PolicyAssertion> itr;
        if (scToken.hasNestedAssertions() && (itr = scToken.getNestedAssertionsIterator()).hasNext()) {
            return Collections.singletonList(itr.next());
        }
        return null;
    }

    public SecureConversationToken getSecureConversationToken() {
        return this.scToken;
    }

    public void setSecureConversationToken(SecureConversationToken scToken) {
        this.scToken = scToken;
    }

    public MessagePolicy getMessagePolicy() {
        return this.messagePolicy;
    }

    public void setMessagePolicyp(MessagePolicy mp) {
        this.messagePolicy = mp;
    }

    @Override
    public boolean isRequireDerivedKeys() {
        return this.scToken.isRequireDerivedKeys();
    }

    @Override
    public String getTokenType() {
        return this.scToken.getTokenType();
    }

    @Override
    public Issuer getIssuer() {
        return this.scToken.getIssuer();
    }

    @Override
    public NestedPolicy getBootstrapPolicy() {
        return this.scToken.getBootstrapPolicy();
    }

    @Override
    public String getIncludeToken() {
        return this.scToken.getIncludeToken();
    }

    @Override
    public String getTokenId() {
        return this.scToken.getTokenId();
    }

    public List<PolicyAssertion> getIssuedTokens() {
        if (!this.cached && this.hasNestedPolicy()) {
            this.tokenList = this.getTokens(this.getNestedPolicy());
            this.cached = true;
        }
        return this.tokenList;
    }

    private ArrayList<PolicyAssertion> getTokens(NestedPolicy policy) {
        ArrayList<PolicyAssertion> tokenList = new ArrayList<PolicyAssertion>();
        AssertionSet assertionSet = policy.getAssertionSet();
        for (PolicyAssertion pa : assertionSet) {
            if (!PolicyUtil.isBootstrapPolicy(pa)) continue;
            NestedPolicy np = pa.getNestedPolicy();
            AssertionSet bpSet = np.getAssertionSet();
            for (PolicyAssertion assertion : bpSet) {
                Binding sb;
                if (PolicyUtil.isAsymmetricBinding(assertion)) {
                    sb = (AsymmetricBinding)((Object)assertion);
                    this.addToken(sb.getInitiatorToken(), tokenList);
                    this.addToken(sb.getRecipientToken(), tokenList);
                    continue;
                }
                if (PolicyUtil.isSymmetricBinding(assertion)) {
                    sb = (SymmetricBinding)((Object)assertion);
                    Token token = sb.getProtectionToken();
                    if (token != null) {
                        this.addToken(token, tokenList);
                        continue;
                    }
                    this.addToken(sb.getEncryptionToken(), tokenList);
                    this.addToken(sb.getSignatureToken(), tokenList);
                    continue;
                }
                if (!PolicyUtil.isSupportingTokens(assertion)) continue;
                SupportingTokens st = (SupportingTokens)((Object)assertion);
                Iterator itr = st.getTokens();
                while (itr.hasNext()) {
                    this.addToken((Token)itr.next(), tokenList);
                }
            }
        }
        return tokenList;
    }

    private void addToken(Token token, ArrayList<PolicyAssertion> list) {
        if (PolicyUtil.isIssuedToken((PolicyAssertion)((Object)token))) {
            list.add((PolicyAssertion)((Object)token));
        }
    }

    @Override
    public Set getTokenRefernceTypes() {
        return this.scToken.getTokenRefernceTypes();
    }

    public void addBootstrapPolicy(NestedPolicy policy) {
    }
}

