/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.io;

import com.sun.xml.ws.transport.tcp.io.DataInOutUtils;
import com.sun.xml.ws.transport.tcp.io.OutputWriter;
import com.sun.xml.ws.transport.tcp.pool.LifeCycle;
import com.sun.xml.ws.transport.tcp.util.ByteBufferFactory;
import com.sun.xml.ws.transport.tcp.util.FrameType;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FramedMessageOutputStream
extends OutputStream
implements LifeCycle {
    private static final int HEADER_BUFFER_SIZE = 10;
    private boolean useDirectBuffer;
    private ByteBuffer outputBuffer;
    private SocketChannel socketChannel;
    private int frameNumber;
    private int frameSize;
    private boolean isFlushLast;
    private int channelId;
    private int messageId;
    private int contentId;
    private Map<Integer, String> contentProps = new HashMap<Integer, String>(8);
    private int payloadlengthLength;
    private boolean isDirectMode;
    private final ByteBuffer headerBuffer;
    private final ByteBuffer[] frame = new ByteBuffer[2];
    private long sentMessageLength;

    public FramedMessageOutputStream() {
        this(4096, false);
    }

    public FramedMessageOutputStream(int frameSize) {
        this(frameSize, false);
    }

    public FramedMessageOutputStream(int frameSize, boolean useDirectBuffer) {
        this.useDirectBuffer = useDirectBuffer;
        this.headerBuffer = ByteBufferFactory.allocateView(frameSize, useDirectBuffer);
        this.setFrameSize(frameSize);
    }

    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
        this.payloadlengthLength = (int)Math.ceil(Math.log(frameSize) / Math.log(2.0));
        this.outputBuffer = ByteBufferFactory.allocateView(frameSize, this.useDirectBuffer);
        this.formFrameBufferArray();
    }

    public boolean isDirectMode() {
        return this.isDirectMode;
    }

    public void setDirectMode(boolean isDirectMode) {
        this.reset();
        this.isDirectMode = isDirectMode;
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public void setContentId(int contentId) {
        this.contentId = contentId;
    }

    public void setContentProperty(int key, String value) {
        this.contentProps.put(key, value);
    }

    public void addAllContentProperties(Map<Integer, String> properties) {
        this.contentProps.putAll(properties);
    }

    @Override
    public void write(int data) throws IOException {
        if (!this.outputBuffer.hasRemaining()) {
            this.flushFrame();
        }
        this.outputBuffer.put((byte)data);
    }

    @Override
    public void write(byte[] data, int offset, int size) throws IOException {
        while (size > 0) {
            int bytesToWrite = Math.min(size, this.outputBuffer.remaining());
            this.outputBuffer.put(data, offset, bytesToWrite);
            offset += bytesToWrite;
            if (this.outputBuffer.hasRemaining() || (size -= bytesToWrite) <= 0) continue;
            this.flushFrame();
        }
    }

    public void flushLast() throws IOException {
        if (!this.isFlushLast) {
            this.outputBuffer.flip();
            this.isFlushLast = true;
            do {
                this.flushBuffer();
            } while (this.outputBuffer.hasRemaining());
            this.outputBuffer.clear();
        }
    }

    private void flushBuffer() throws IOException {
        int payloadLength = this.outputBuffer.remaining();
        if (!this.isDirectMode) {
            this.headerBuffer.clear();
            int frameMessageIdHighValue = DataInOutUtils.writeInt4(this.headerBuffer, this.channelId, 0, false);
            int frameMessageIdPosition = this.headerBuffer.position();
            boolean isFrameWithParameters = FrameType.isFrameContainsParams(this.messageId) && this.frameNumber == 0;
            int highValue = DataInOutUtils.writeInt4(this.headerBuffer, this.messageId, frameMessageIdHighValue, !isFrameWithParameters);
            if (isFrameWithParameters) {
                int propsCount;
                highValue = DataInOutUtils.writeInt4(this.headerBuffer, this.contentId, highValue, false);
                highValue = DataInOutUtils.writeInt4(this.headerBuffer, propsCount, highValue, (propsCount = this.contentProps.size()) == 0);
                for (Map.Entry<Integer, String> entry : this.contentProps.entrySet()) {
                    String value = entry.getValue();
                    byte[] valueBytes = value.getBytes("UTF-8");
                    highValue = DataInOutUtils.writeInt4(this.headerBuffer, (int)entry.getKey(), highValue, false);
                    DataInOutUtils.writeInt4(this.headerBuffer, valueBytes.length, highValue, true);
                    this.headerBuffer.put(valueBytes);
                    highValue = 0;
                }
            }
            int readyBytesToSend = this.headerBuffer.position() + this.payloadlengthLength + payloadLength;
            if (this.messageId == 0) {
                this.updateMessageIdIfRequired(frameMessageIdPosition, frameMessageIdHighValue, this.isFlushLast && readyBytesToSend <= this.frameSize);
            }
            int sendingPayloadLength = this.calcPayloadSizeToSend(readyBytesToSend);
            DataInOutUtils.writeInt8(this.headerBuffer, sendingPayloadLength);
            this.headerBuffer.flip();
            int payloadLimit = this.outputBuffer.limit();
            if (sendingPayloadLength < payloadLength) {
                this.outputBuffer.limit(this.outputBuffer.limit() - (payloadLength - sendingPayloadLength));
            }
            OutputWriter.flushChannel(this.socketChannel, this.frame);
            this.outputBuffer.limit(payloadLimit);
            this.sentMessageLength += (long)sendingPayloadLength;
            ++this.frameNumber;
        } else {
            OutputWriter.flushChannel(this.socketChannel, this.outputBuffer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateMessageIdIfRequired(int frameMessageIdPosition, int frameMessageIdHighValue, boolean isLastFrame) {
        int frameMessageId;
        if (isLastFrame) {
            if (this.frameNumber == 0) return;
            frameMessageId = 3;
        } else {
            frameMessageId = this.frameNumber == 0 ? 1 : 2;
        }
        if (frameMessageIdHighValue != 0) {
            this.headerBuffer.put(frameMessageIdPosition, (byte)(frameMessageIdHighValue & 0x70 | frameMessageId));
            return;
        } else {
            byte value = this.headerBuffer.get(frameMessageIdPosition);
            this.headerBuffer.put(frameMessageIdPosition, (byte)(frameMessageId << 4 | value & 0xF));
        }
    }

    private int calcPayloadSizeToSend(int readyBytesToSend) throws IOException {
        int payloadLength = this.outputBuffer.remaining();
        if (readyBytesToSend > this.frameSize) {
            payloadLength -= readyBytesToSend - this.frameSize;
        }
        return payloadLength;
    }

    private void formFrameBufferArray() {
        this.frame[0] = this.headerBuffer;
        this.frame[1] = this.outputBuffer;
    }

    public void reset() {
        this.outputBuffer.clear();
        this.headerBuffer.clear();
        this.messageId = -1;
        this.contentId = -1;
        this.contentProps.clear();
        this.frameNumber = 0;
        this.isFlushLast = false;
        this.sentMessageLength = 0L;
    }

    @Override
    public void activate() {
    }

    @Override
    public void passivate() {
        this.reset();
        this.socketChannel = null;
    }

    @Override
    public void close() {
    }

    private void flushFrame() throws IOException {
        this.outputBuffer.flip();
        this.flushBuffer();
        this.outputBuffer.compact();
    }
}

