/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server.glassfish;

import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import com.sun.enterprise.webservice.JAXWSAdapterRegistry;
import com.sun.enterprise.webservice.WebServiceEjbEndpointRegistry;
import com.sun.istack.NotNull;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.server.TCPAdapter;
import com.sun.xml.ws.transport.tcp.server.WSTCPAdapterRegistry;
import com.sun.xml.ws.transport.tcp.server.glassfish.AppServWSRegistry;
import com.sun.xml.ws.transport.tcp.server.glassfish.ServletFakeArtifactSet;
import com.sun.xml.ws.transport.tcp.server.glassfish.TCP109Adapter;
import com.sun.xml.ws.transport.tcp.server.glassfish.WSEndpointDescriptor;
import com.sun.xml.ws.transport.tcp.util.WSTCPURI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WSTCPAdapterRegistryImpl
implements WSTCPAdapterRegistry {
    private static final Logger logger = Logger.getLogger("com.sun.xml.ws.transport.tcp.server");
    final Map<String, TCPAdapter> registry = new ConcurrentHashMap<String, TCPAdapter>();
    private static final WSTCPAdapterRegistryImpl instance = new WSTCPAdapterRegistryImpl();

    private WSTCPAdapterRegistryImpl() {
    }

    @NotNull
    public static WSTCPAdapterRegistryImpl getInstance() {
        return instance;
    }

    public TCPAdapter getTarget(@NotNull WSTCPURI requestURI) {
        WSEndpointDescriptor wsEndpointDescriptor = null;
        String contextRoot = "/";
        String urlPattern = "/";
        if (requestURI.path.length() > 0 && !requestURI.path.equals("/")) {
            int nextSlashIndex = requestURI.path.indexOf(47, 1);
            if (nextSlashIndex != -1) {
                contextRoot = requestURI.path.substring(0, nextSlashIndex);
                urlPattern = requestURI.path.substring(nextSlashIndex, requestURI.path.length());
                wsEndpointDescriptor = AppServWSRegistry.getInstance().get(contextRoot, urlPattern);
            }
            if (wsEndpointDescriptor == null) {
                nextSlashIndex = -1;
                do {
                    int delim = (nextSlashIndex = requestURI.path.indexOf(47, nextSlashIndex + 1)) != -1 ? nextSlashIndex : requestURI.path.length();
                    contextRoot = delim > 0 ? requestURI.path.substring(0, delim) : "/";
                    urlPattern = delim < requestURI.path.length() ? requestURI.path.substring(delim, requestURI.path.length()) : "/";
                    wsEndpointDescriptor = AppServWSRegistry.getInstance().get(contextRoot, urlPattern);
                } while (nextSlashIndex != -1 && wsEndpointDescriptor == null);
            }
        } else {
            wsEndpointDescriptor = AppServWSRegistry.getInstance().get(contextRoot, urlPattern);
        }
        if (wsEndpointDescriptor != null) {
            TCPAdapter adapter = this.registry.get(requestURI.path);
            if (adapter == null) {
                try {
                    adapter = this.createWSAdapter(wsEndpointDescriptor);
                    this.registry.put(requestURI.path, adapter);
                    logger.log(Level.FINE, "WSTCPAdapterRegistryImpl. Register adapter. Path: {0}", requestURI.path);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "WSTCPAdapterRegistryImpl. " + MessagesMessages.WSTCP_0008_ERROR_TCP_ADAPTER_CREATE(wsEndpointDescriptor.getWSServiceName()), e);
                }
            }
            return adapter;
        }
        return null;
    }

    public void deleteTargetFor(@NotNull String path) {
        logger.log(Level.FINE, "WSTCPAdapterRegistryImpl. DeRegister adapter for {0}", path);
        this.registry.remove(path);
    }

    private TCPAdapter createWSAdapter(@NotNull WSEndpointDescriptor wsEndpointDescriptor) throws Exception {
        Adapter adapter;
        if (wsEndpointDescriptor.isEJB()) {
            EjbRuntimeEndpointInfo ejbEndPtInfo = WebServiceEjbEndpointRegistry.getRegistry().getEjbWebServiceEndpoint(wsEndpointDescriptor.getURI(), "POST", null);
            adapter = (Adapter)ejbEndPtInfo.prepareInvocation(true);
        } else {
            String uri = wsEndpointDescriptor.getURI();
            adapter = JAXWSAdapterRegistry.getInstance().getAdapter(wsEndpointDescriptor.getContextRoot(), uri, uri);
        }
        TCP109Adapter tcpAdapter = new TCP109Adapter(wsEndpointDescriptor.getWSServiceName().toString(), wsEndpointDescriptor.getContextRoot(), wsEndpointDescriptor.getUrlPattern(), adapter.getEndpoint(), new ServletFakeArtifactSet(wsEndpointDescriptor.getRequestURL(), wsEndpointDescriptor.getUrlPattern()), wsEndpointDescriptor.isEJB());
        return tcpAdapter;
    }
}

