/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra;

import com.sun.genericra.GenericJMSRAProperties;
import com.sun.genericra.inbound.ActivationSpec;
import com.sun.genericra.inbound.EndpointConsumer;
import com.sun.genericra.monitoring.ConfigurationMonitor;
import com.sun.genericra.monitoring.ConfigurationMonitorMBean;
import com.sun.genericra.monitoring.ResourceMonitor;
import com.sun.genericra.monitoring.ResourceMonitorMBean;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import com.sun.genericra.util.ObjectBuilderFactory;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.resource.ResourceException;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public class GenericJMSRA
extends GenericJMSRAProperties
implements ResourceAdapter {
    private static GenericJMSRA raInstance = null;
    private static Logger logger = LogUtils.getLogger();
    private transient BootstrapContext context = null;
    private transient Hashtable consumers;
    private transient Method onMessageMethod = null;
    private transient ObjectBuilderFactory obf = null;
    private transient MBeanServer mbeanserver = null;
    private transient ObjectName monitoringbean = null;
    private transient ResourceMonitor monitor = null;
    private transient ObjectName configbean = null;
    private String logLevel = "info";

    public static GenericJMSRA getInstance() {
        logger.log(Level.FINEST, "GenericJMSRA - getInstance() orig " + raInstance);
        return raInstance;
    }

    public void stop() {
        this.obf = null;
        this.onMessageMethod = null;
        if (this.getMonitoring()) {
            this.unregisterMonitoringMBean();
        }
    }

    public void start(BootstrapContext context) throws ResourceAdapterInternalException {
        logger.log(Level.FINEST, "GenericJMSRA.start() ....");
        raInstance = this;
        this.obf = new ObjectBuilderFactory();
        this.consumers = new Hashtable();
        this.context = context;
        if (this.getMonitoring()) {
            this.registerMonitoringMBean();
        }
        try {
            Class msgListenerClass = MessageListener.class;
            Class[] paramTypes = new Class[]{Message.class};
            this.onMessageMethod = msgListenerClass.getMethod("onMessage", paramTypes);
        }
        catch (NoSuchMethodException ex) {
            throw ExceptionUtils.newResourceAdapterInternalException(ex);
        }
    }

    private void registerMonitoringMBean() {
        try {
            this.mbeanserver = MBeanServerFactory.findMBeanServer(null).get(0);
            if (this.mbeanserver == null) {
                logger.log(Level.SEVERE, "Cannot get MBean server, monitoring is disabled");
                return;
            }
            this.monitor = new ResourceMonitor();
            StandardMBean mbean = new StandardMBean(this.monitor, ResourceMonitorMBean.class);
            this.monitoringbean = new ObjectName("com.sun.genericra:name=Monitoring,category=InboundResources");
            if (this.mbeanserver.isRegistered(this.monitoringbean)) {
                this.mbeanserver.unregisterMBean(this.monitoringbean);
            }
            this.mbeanserver.registerMBean(mbean, this.monitoringbean);
            logger.log(Level.INFO, "Registered monitoring MBean with name " + this.monitoringbean);
            ConfigurationMonitor configmonitor = new ConfigurationMonitor();
            this.configbean = new ObjectName("com.sun.genericra:name=Monitoring,category=Configuration");
            StandardMBean configmbean = new StandardMBean(configmonitor, ConfigurationMonitorMBean.class);
            if (this.mbeanserver.isRegistered(this.configbean)) {
                this.mbeanserver.unregisterMBean(this.configbean);
            }
            this.mbeanserver.registerMBean(configmbean, this.configbean);
            logger.log(Level.INFO, "Registered monitoring MBean with name " + this.configbean);
        }
        catch (Throwable t) {
            t.printStackTrace();
            logger.log(Level.SEVERE, "Cannot get MBean server, monitoring is disabled");
        }
    }

    private void unregisterMonitoringMBean() {
        try {
            this.mbeanserver.unregisterMBean(this.monitoringbean);
            this.mbeanserver.unregisterMBean(this.configbean);
            logger.log(Level.INFO, "Unregistered monitoing MBean " + this.monitoringbean);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Cannot unregister monitoring mbean");
        }
    }

    public void endpointActivation(MessageEndpointFactory mef, javax.resource.spi.ActivationSpec spec) throws ResourceException {
        EndpointConsumer consumer = new EndpointConsumer(mef, spec);
        consumer.start();
        if (this.getMonitoring() && this.monitor != null) {
            if (consumer.getSpec().getApplicationName() != null) {
                this.monitor.addPool(consumer.getSpec().getApplicationName(), consumer.getPool());
            } else {
                logger.log(Level.WARNING, "Application name is not configured in activation spec config, cannot monitor this endpoint");
            }
        }
        Hashtable consumers = this.getConsumers();
        EndpointKey key = new EndpointKey(mef, spec);
        consumers.put(key, consumer);
    }

    public void endpointDeactivation(MessageEndpointFactory mef, javax.resource.spi.ActivationSpec spec) {
        EndpointKey key = new EndpointKey(mef, spec);
        EndpointConsumer consumer = (EndpointConsumer)this.getConsumers().remove(key);
        if (this.getMonitoring() && this.monitor != null) {
            this.monitor.removePool(consumer.getSpec().getApplicationName());
        }
        if (consumer != null) {
            consumer.stop();
        }
    }

    public XAResource[] getXAResources(javax.resource.spi.ActivationSpec[] specs) throws ResourceException {
        ArrayList<XAResource> xars = new ArrayList<XAResource>();
        for (int i = 0; i < specs.length; ++i) {
            ActivationSpec tmpSpec = null;
            if (!(specs[i] instanceof ActivationSpec) || !(tmpSpec = (ActivationSpec)specs[i]).getSupportsXA()) continue;
            XAConnection xacon = null;
            XASession xasess = null;
            EndpointConsumer consumer = null;
            try {
                consumer = new EndpointConsumer(tmpSpec);
                consumer.initialize(true);
                xacon = (XAConnection)consumer.getConnection();
                xasess = xacon.createXASession();
                XAResource xaRes = xasess.getXAResource();
                xars.add(xaRes);
                logger.log(Level.FINEST, "Added XA Resource : " + xaRes);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return xars.toArray(new XAResource[0]);
    }

    public WorkManager getWorkManager() {
        return GenericJMSRA.getInstance().context.getWorkManager();
    }

    public ObjectBuilderFactory getObjectBuilderFactory() {
        return GenericJMSRA.getInstance().obf;
    }

    public void setLogLevel(String level) {
        logger.log(Level.FINEST, "Setting log level:" + level);
        this.logLevel = level;
        this.setLevelInLogger(level);
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    private Hashtable getConsumers() {
        return GenericJMSRA.getInstance().consumers;
    }

    private void setLevelInLogger(String level) {
        Level l = Level.INFO;
        if (level.equalsIgnoreCase("finest")) {
            logger.log(Level.FINEST, "Setting finest as log levels");
            l = Level.FINEST;
        } else if (level.equalsIgnoreCase("finer")) {
            l = Level.FINER;
        } else if (level.equalsIgnoreCase("fine")) {
            l = Level.FINE;
        } else if (level.equalsIgnoreCase("info")) {
            l = Level.INFO;
        } else if (level.equalsIgnoreCase("warning")) {
            l = Level.WARNING;
        } else if (level.equalsIgnoreCase("severe")) {
            l = Level.SEVERE;
        }
        final Level tmp = l;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                logger.setLevel(tmp);
                return null;
            }
        });
    }

    public Method getListeningMethod() {
        return GenericJMSRA.getInstance().onMessageMethod;
    }

    class EndpointKey
    implements Serializable {
        private MessageEndpointFactory mef;
        private javax.resource.spi.ActivationSpec spec;

        public EndpointKey(MessageEndpointFactory mef, javax.resource.spi.ActivationSpec spec) {
            this.mef = mef;
            this.spec = spec;
        }

        public boolean equals(Object obj) {
            EndpointKey other = (EndpointKey)obj;
            return other.mef.equals(this.mef) && other.spec.equals(this.spec);
        }

        public int hashCode() {
            return this.mef.hashCode() + this.spec.hashCode();
        }
    }
}

