/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.enterprise.cli.commands.GenericCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.ee.cli.commands.CreateHttpLBCommand;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseHttpLBCommand
extends GenericCommand {
    static final StringManager _strMgr = StringManager.getManager(CreateHttpLBCommand.class);

    void checkConfigAndLBNameOptions(String configName, String lbName) throws CommandException {
        if (configName != null && lbName != null) {
            throw new CommandException(_strMgr.getString("InvalidOptionsConfigAndLBName"));
        }
    }

    void addToOptions(Map<String, String> mOptions, String option) {
        if (this.getOption(option) != null) {
            mOptions.put(option, this.getOption(option));
        }
    }

    Map getInstanceWeightsMap() throws CommandValidationException, CommandException {
        String lbWeights = this.getOption("lbweight");
        if (lbWeights == null) {
            return null;
        }
        Properties instanceWeightsProps = this.createPropertiesParam(lbWeights);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Enumeration<?> e = instanceWeightsProps.propertyNames();
        while (e.hasMoreElements()) {
            Integer weightInt;
            String name = (String)e.nextElement();
            String weight = instanceWeightsProps.getProperty(name);
            try {
                weightInt = Integer.valueOf(weight);
            }
            catch (NumberFormatException nfe) {
                throw new CommandException(_strMgr.getString("InvalidWeightValue"));
            }
            map.put(name, weightInt);
            CLILogger.getInstance().printDebugMessage("Instance=" + name + ", weight=" + weightInt);
        }
        return map;
    }
}

