/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration;

import com.sun.enterprise.registration.RegistrationException;
import com.sun.enterprise.registration.RegistrationLogger;
import com.sun.enterprise.registration.RepositoryManager;
import com.sun.enterprise.registration.ServiceTag;
import com.sun.enterprise.registration.StringManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysnetTransferManager {
    private Logger logger = RegistrationLogger.getLogger();
    private RepositoryManager rm;
    private static final List<STClientCommandInfo> osToSTClientCommand = SysnetTransferManager.prepareSTClientLocationMap();
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String LINE_SEP = System.getProperty("line.separator");

    public SysnetTransferManager(File repositoryFile) throws RegistrationException {
        this.rm = new RepositoryManager(repositoryFile);
    }

    public int transferServiceTags() throws RegistrationException {
        int result = -1;
        try {
            if (!this.isSTClientInstalled()) {
                this.logger.info("stclient tool not found; tag transfer to SysNet skipped");
                return result;
            }
            this.rm.updateRuntimeValues();
            List<ServiceTag> unTransferredTags = this.getUntransferredServiceTags(this.rm);
            for (ServiceTag tag : unTransferredTags) {
                this.addTagToSysNet(tag);
                this.rm.setStatus(tag, ServiceTag.Status.TRANSFERRED);
            }
            result = unTransferredTags.size();
            this.logger.info(result + " service tags successfully transferred to SysNet");
            return result;
        }
        catch (Exception e) {
            throw new RegistrationException(StringManager.getString("xfmgr.errTransTags", new Object[0]), (Throwable)e);
        }
    }

    private boolean isSTClientInstalled() {
        return this.chooseSTClientCommandForPlatform() != null;
    }

    private List<ServiceTag> getUntransferredServiceTags(RepositoryManager rm) {
        List<ServiceTag> candidateTags = rm.getServiceTags();
        Iterator<ServiceTag> it = candidateTags.iterator();
        while (it.hasNext()) {
            ServiceTag tag = it.next();
            if (!ServiceTag.Status.valueOf(tag.getSvcTag().getStatus()).equals((Object)ServiceTag.Status.TRANSFERRED)) continue;
            it.remove();
        }
        return candidateTags;
    }

    private void addTagToSysNet(ServiceTag tag) throws RegistrationException, IOException, InterruptedException {
        STClientCommand stClientCommand = new STClientCommand(tag);
        stClientCommand.run();
    }

    private static List<STClientCommandInfo> prepareSTClientLocationMap() {
        ArrayList<STClientCommandInfo> result = new ArrayList<STClientCommandInfo>();
        result.add(new STClientCommandInfo("Windows", "C:\\Program Files\\Sun\\servicetag\\stclient.exe"));
        result.add(new STClientCommandInfo("Sun", "/usr/bin/stclient"));
        result.add(new STClientCommandInfo("Linux", "/opt/sun/servicetag/bin/stclient"));
        return result;
    }

    private STClientCommandInfo chooseSTClientCommandForPlatform() {
        String stClientPath = null;
        for (STClientCommandInfo info : osToSTClientCommand) {
            if (!info.handles(SysnetTransferManager.OS_NAME)) continue;
            stClientPath = info.getToolPath();
            File stClientFile = new File(stClientPath);
            if (stClientFile.exists()) {
                this.logger.fine("Found stclient as expected at " + stClientPath);
                return info;
            }
            this.logger.fine("Looked for stclient tool but did not find it at " + stClientPath);
            return null;
        }
        this.logger.info("Platform " + OS_NAME + " is not currently supported by SysNet registration");
        return null;
    }

    private class STClientCommand {
        private static final long STCLIENT_COMMAND_TIMEOUT_MS = 25000L;
        private static final int INPUT_BUFFER_SIZE = 1024;
        private static final int PROCESS_IO_FLUSH_DELAY_MS = 500;
        private ServiceTag tag;
        private List<String> command;
        private InputStreamReader outputFromProcess;
        private InputStreamReader errorFromProcess;
        private StringBuilder outputTextFromProcess = new StringBuilder();
        private StringBuilder errorTextFromProcess = new StringBuilder();

        public STClientCommand(ServiceTag tag) throws RegistrationException {
            this.tag = tag;
            this.constructCommand();
        }

        public void run() throws IOException, InterruptedException, RegistrationException {
            ProcessBuilder pb = new ProcessBuilder(this.command);
            if (SysnetTransferManager.this.logger.isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder("Preparing to run the following command:\n");
                for (String s : this.command) {
                    sb.append(s).append(" ");
                }
                SysnetTransferManager.this.logger.fine(sb.toString());
            }
            final Process commandProcess = pb.start();
            this.outputFromProcess = new InputStreamReader(new BufferedInputStream(commandProcess.getInputStream()));
            this.errorFromProcess = new InputStreamReader(new BufferedInputStream(commandProcess.getErrorStream()));
            final AtomicInteger processExitStatus = new AtomicInteger();
            final AtomicBoolean processExitDetected = new AtomicBoolean(false);
            Thread processMonitorThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        int status = commandProcess.waitFor();
                        processExitStatus.set(status);
                        processExitDetected.set(true);
                        SysnetTransferManager.this.logger.fine("Process monitor thread detected process completion with status " + status);
                    }
                    catch (InterruptedException e) {
                        SysnetTransferManager.this.logger.fine("Process monitor thread was interrupted and is forcibly destroying the command process");
                        commandProcess.destroy();
                    }
                }
            });
            processMonitorThread.start();
            boolean isProcessDestroyRequested = false;
            long processWaitDeadline = System.currentTimeMillis() + 25000L;
            while (processMonitorThread.isAlive()) {
                if (System.currentTimeMillis() > processWaitDeadline && !isProcessDestroyRequested) {
                    SysnetTransferManager.this.logger.fine("Command process has taken too long to complete; destroying it");
                    commandProcess.destroy();
                    isProcessDestroyRequested = true;
                }
                this.flushProcessIO();
                Thread.sleep(500L);
            }
            this.flushProcessIO();
            if (SysnetTransferManager.this.logger.isLoggable(Level.FINE)) {
                SysnetTransferManager.this.logger.fine("Output stream from command process:" + LINE_SEP + this.outputTextFromProcess.toString());
                SysnetTransferManager.this.logger.fine("Error stream from command process:" + LINE_SEP + this.errorTextFromProcess.toString());
            }
            if (!processExitDetected.get()) {
                SysnetTransferManager.this.logger.fine("Command process monitoring thread stopped before the command process, so the command's state is unknown");
                throw new RegistrationException(StringManager.getString("xfmgr.unknownCmdProcResult", new Object[0]));
            }
            if (processExitStatus.get() != 0) {
                RegistrationException e = new RegistrationException(StringManager.getString("xfmgr.cmdProcFailed", this.errorTextFromProcess.toString()));
                throw e;
            }
            SysnetTransferManager.this.logger.fine("Command process seems to have completed successfully");
        }

        private void flushProcessIO() throws IOException {
            this.copyFromReader(this.outputFromProcess, this.outputTextFromProcess);
            this.copyFromReader(this.errorFromProcess, this.errorTextFromProcess);
        }

        private void copyFromReader(InputStreamReader reader, StringBuilder sb) throws IOException {
            char[] buffer = new char[1024];
            boolean eoStream = false;
            while (reader.ready() && !eoStream) {
                int charsRead = reader.read(buffer);
                if (charsRead == -1) {
                    eoStream = true;
                    continue;
                }
                sb.append(buffer, 0, charsRead);
            }
        }

        private void constructCommand() throws RegistrationException {
            this.command = new ArrayList<String>();
            STClientCommandInfo commandInfo = SysnetTransferManager.this.chooseSTClientCommandForPlatform();
            this.command.add(this.formatValue(commandInfo.getToolPath()));
            this.command.add("-a");
            this.addRequired("-p", this.tag.getProductName());
            this.addRequired("-e", this.tag.getProductVersion());
            this.addRequired("-t", this.tag.getProductURN());
            this.addOptional("-F", this.tag.getProductParentURN());
            this.addRequired("-P", this.tag.getProductParentURN());
            this.addOptional("-I", this.tag.getProductDefinedInstID());
            this.addRequired("-m", this.tag.getProductVendor());
            this.addRequired("-A", this.tag.getPlatformArch());
            this.addRequired("-z", this.tag.getContainer());
            this.addRequired("-S", this.tag.getSource());
        }

        private void addRequired(String option, String value) throws RegistrationException {
            if (value == null) {
                throw new RegistrationException(StringManager.getString("xfmgr.reqdValueNull", option));
            }
            this.command.add(option);
            this.command.add(this.formatValue(value));
        }

        private void addOptional(String option, String value) {
            if (value != null && value.length() > 0) {
                this.command.add(option);
                this.command.add(this.formatValue(value));
            }
        }

        private String formatValue(String value) {
            if (value.indexOf(32) == -1 && value.length() > 0) {
                return value;
            }
            return "\"" + value + "\"";
        }
    }

    private static class STClientCommandInfo {
        private String osNamePrefix;
        private String toolPath;

        private STClientCommandInfo(String osNamePrefix, String toolPath) {
            this.osNamePrefix = osNamePrefix;
            this.toolPath = toolPath;
        }

        private String getToolPath() {
            return this.toolPath;
        }

        private boolean handles(String osName) {
            return osName.startsWith(this.osNamePrefix);
        }
    }
}

