/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.handlers;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.LayoutViewHandler;
import com.sun.jsftemplating.layout.LayoutViewRoot;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.LayoutElementUtil;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class ComponentHandlers {
    public static void getChildren(HandlerContext context) {
        UIComponent parent = (UIComponent)context.getInputValue("parent");
        List list = parent.getChildren();
        context.setOutputValue("children", list);
        context.setOutputValue("size", new Integer(list.size()));
    }

    public static void replaceUIComponent(HandlerContext context) {
        UIComponent oldComp = (UIComponent)context.getInputValue("old");
        if (oldComp == null) {
            throw new IllegalArgumentException("You must provide a non-null value for 'component'.");
        }
        UIComponent newComp = (UIComponent)context.getInputValue("new");
        List list = oldComp.getParent().getChildren();
        if (newComp == null) {
            list.remove(oldComp);
        } else {
            int index = list.indexOf(oldComp);
            list.set(index, newComp);
        }
    }

    public static void buildUIComponentTree(HandlerContext context) {
        LayoutElement desc = (LayoutElement)context.getInputValue("layoutElement");
        Object parent = (UIComponent)context.getInputValue("parent");
        if (parent == null) {
            parent = new LayoutViewRoot();
            ((LayoutViewRoot)((Object)parent)).setViewId("fake");
        }
        FacesContext facesCtx = context.getFacesContext();
        if (desc instanceof LayoutComponent) {
            UIComponent tmpParent = ((LayoutComponent)desc).getChild(facesCtx, (UIComponent)parent);
            LayoutViewHandler.buildUIComponentTree(facesCtx, tmpParent, desc);
        } else {
            LayoutViewHandler.buildUIComponentTree(facesCtx, parent, desc);
        }
        String id = desc.getId(facesCtx, (UIComponent)parent);
        UIComponent result = parent.findComponent(id);
        if (result == null) {
            List children;
            if (desc instanceof LayoutComponent) {
                result = (UIComponent)parent.getFacets().get(id);
            }
            if (result == null && (children = parent.getChildren()).size() > 0) {
                result = (UIComponent)children.get(children.size() - 1);
            }
        }
        context.setOutputValue("result", result);
    }

    public static void createComponent(HandlerContext context) {
        String type = (String)context.getInputValue("type");
        UIComponent parent = (UIComponent)context.getInputValue("parent");
        String id = (String)context.getInputValue("id");
        if (id == null) {
            id = LayoutElementUtil.getGeneratedId(type);
        }
        LayoutComponent desc = new LayoutComponent(null, id, LayoutDefinitionManager.getGlobalComponentType(type));
        desc.setFacetChild(false);
        UIComponent component = ComponentUtil.createChildComponent(context.getFacesContext(), desc, parent);
        context.setOutputValue("component", component);
    }

    public static void setComponentProperty(HandlerContext context) {
        UIComponent component = (UIComponent)context.getInputValue("component");
        String propName = (String)context.getInputValue("property");
        Object value = context.getInputValue("value");
        component.getAttributes().put(propName, value);
    }

    public static void getUIComponent(HandlerContext context) {
        UIViewRoot viewRoot = context.getFacesContext().getViewRoot();
        String clientId = (String)context.getInputValue("clientId");
        context.setOutputValue("component", viewRoot.findComponent(clientId));
    }

    public static void getUIComponentProperty(HandlerContext context) {
        UIComponent comp = (UIComponent)context.getInputValue("component");
        String name = (String)context.getInputValue("name");
        if (comp == null || name == null) {
            throw new IllegalArgumentException("This Handler requires non-null values for 'component' and 'name'.  'component' was specified as '" + context.getHandler().getInputValue("component") + "' and evaluated to '" + comp + "'. 'name' was" + " specified as '" + context.getHandler().getInputValue("name") + "' and evaluated to '" + name + "'.");
        }
        Object value = comp.getAttributes().get(name);
        context.setOutputValue("value", value);
    }
}

