/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Collection;
import javax.faces.model.SelectItem;

public class OptionsHandlers {
    private static Class RAVE_OPTION_CLASS = null;
    private static Constructor RAVE_OPTION_CONSTRUCTOR = null;
    private static Class SUN_OPTION_CLASS = null;
    private static Constructor SUN_OPTION_CONSTRUCTOR = null;

    public static void getRaveOptions(HandlerContext context) throws Exception {
        Collection labels = (Collection)context.getInputValue("labels");
        Collection values = (Collection)context.getInputValue("values");
        if (labels.size() != values.size()) {
            throw new Exception("getRaveOptions Handler input incorrect: Input 'labels' and 'values' size must be equal. 'labels' size: " + labels.size() + " 'values' size: " + values.size());
        }
        SelectItem[] options = (SelectItem[])Array.newInstance(RAVE_OPTION_CLASS, labels.size());
        String[] labelsArray = labels.toArray(new String[labels.size()]);
        String[] valuesArray = values.toArray(new String[values.size()]);
        for (int i = 0; i < labels.size(); ++i) {
            SelectItem option;
            options[i] = option = OptionsHandlers.getRaveOption(valuesArray[i], labelsArray[i]);
        }
        context.setOutputValue("options", options);
    }

    private static SelectItem getRaveOption(String value, String label) {
        try {
            return (SelectItem)RAVE_OPTION_CONSTRUCTOR.newInstance(value, label);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void getSunOptions(HandlerContext context) throws Exception {
        Collection labels = (Collection)context.getInputValue("labels");
        Collection values = (Collection)context.getInputValue("values");
        if (labels.size() != values.size()) {
            throw new Exception("getSunOptions Handler input incorrect: Input 'labels' and 'values' size must be equal. 'labels' size: " + labels.size() + " 'values' size: " + values.size());
        }
        SelectItem[] options = (SelectItem[])Array.newInstance(SUN_OPTION_CLASS, labels.size());
        String[] labelsArray = labels.toArray(new String[labels.size()]);
        String[] valuesArray = values.toArray(new String[values.size()]);
        for (int i = 0; i < labels.size(); ++i) {
            SelectItem option;
            options[i] = option = OptionsHandlers.getSunOption(valuesArray[i], labelsArray[i]);
        }
        context.setOutputValue("options", options);
    }

    private static SelectItem getSunOption(String value, String label) {
        try {
            return (SelectItem)SUN_OPTION_CONSTRUCTOR.newInstance(value, label);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        try {
            RAVE_OPTION_CLASS = Class.forName("com.sun.rave.web.ui.model.Option");
            RAVE_OPTION_CONSTRUCTOR = RAVE_OPTION_CLASS.getConstructor(Object.class, String.class);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            SUN_OPTION_CLASS = Class.forName("com.sun.webui.jsf.model.Option");
            SUN_OPTION_CONSTRUCTOR = SUN_OPTION_CLASS.getConstructor(Object.class, String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

